/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.StaticUtils;

public class LockFileManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static HashMap<String, FileLock> exclusiveLocks = new HashMap();
    private static HashMap<String, FileLock> sharedLocks = new HashMap();
    private static HashMap<String, Integer> sharedLockReferences = new HashMap();
    private static ReentrantLock mapLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireSharedLock(String lockFile, StringBuilder failureReason) {
        mapLock.lock();
        try {
            FileLock fileLock;
            if (exclusiveLocks.containsKey(lockFile)) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_REJECTED_BY_EXCLUSIVE.get(lockFile));
                boolean bl = false;
                return bl;
            }
            FileLock sharedLock = sharedLocks.get(lockFile);
            if (sharedLock != null) {
                int numReferences = sharedLockReferences.get(lockFile);
                sharedLockReferences.put(lockFile, ++numReferences);
                boolean bl = true;
                return bl;
            }
            File f = StaticUtils.getFileForPath(lockFile);
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_FAILED_CREATE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            FileChannel channel = null;
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(lockFile, "r");
                channel = raf.getChannel();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_FAILED_OPEN.get(lockFile, StaticUtils.getExceptionMessage(e)));
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean t = false;
                mapLock.unlock();
                return t;
            }
            try {
                fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_FAILED_LOCK.get(lockFile, StaticUtils.getExceptionMessage(e)));
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            if (fileLock == null) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_SHARED_NOT_GRANTED.get(lockFile));
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean bl = false;
                return bl;
            }
            sharedLocks.put(lockFile, fileLock);
            sharedLockReferences.put(lockFile, 1);
            boolean bl = true;
            return bl;
        }
        finally {
            mapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acquireExclusiveLock(String lockFile, StringBuilder failureReason) {
        mapLock.lock();
        try {
            FileLock fileLock;
            if (exclusiveLocks.containsKey(lockFile)) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_REJECTED_BY_EXCLUSIVE.get(lockFile));
                boolean bl = false;
                return bl;
            }
            if (sharedLocks.containsKey(lockFile)) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_REJECTED_BY_SHARED.get(lockFile));
                boolean bl = false;
                return bl;
            }
            File f = StaticUtils.getFileForPath(lockFile);
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_FAILED_CREATE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            FileChannel channel = null;
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(lockFile, "rw");
                channel = raf.getChannel();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_FAILED_OPEN.get(lockFile, StaticUtils.getExceptionMessage(e)));
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean t = false;
                mapLock.unlock();
                return t;
            }
            try {
                fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_FAILED_LOCK.get(lockFile, StaticUtils.getExceptionMessage(e)));
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean bl = false;
                mapLock.unlock();
                return bl;
            }
            if (fileLock == null) {
                failureReason.append(CoreMessages.ERR_FILELOCKER_LOCK_EXCLUSIVE_NOT_GRANTED.get(lockFile));
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                boolean bl = false;
                return bl;
            }
            exclusiveLocks.put(lockFile, fileLock);
            boolean bl = true;
            return bl;
        }
        finally {
            mapLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean releaseLock(String lockFile, StringBuilder failureReason) {
        mapLock.lock();
        try {
            FileLock lock = exclusiveLocks.remove(lockFile);
            if (lock != null) {
                block21: {
                    try {
                        lock.release();
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        failureReason.append(CoreMessages.ERR_FILELOCKER_UNLOCK_EXCLUSIVE_FAILED_RELEASE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                        boolean bl = false;
                        mapLock.unlock();
                        return bl;
                    }
                    try {
                        lock.channel().close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block21;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                boolean e = true;
                return e;
            }
            lock = sharedLocks.get(lockFile);
            if (lock != null) {
                block22: {
                    int refCount = sharedLockReferences.get(lockFile);
                    if (--refCount <= 0) {
                        sharedLocks.remove(lockFile);
                        sharedLockReferences.remove(lockFile);
                        try {
                            lock.release();
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            failureReason.append(CoreMessages.ERR_FILELOCKER_UNLOCK_SHARED_FAILED_RELEASE.get(lockFile, StaticUtils.getExceptionMessage(e)));
                            boolean bl = false;
                            mapLock.unlock();
                            return bl;
                        }
                        try {
                            lock.channel().close();
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            break block22;
                        }
                    }
                    sharedLockReferences.put(lockFile, refCount);
                }
                boolean bl = true;
                return bl;
            }
            failureReason.append(CoreMessages.ERR_FILELOCKER_UNLOCK_UNKNOWN_FILE.get(lockFile));
            boolean bl = false;
            return bl;
        }
        finally {
            mapLock.unlock();
        }
    }

    public static String getLockDirectoryPath() {
        File lockDirectory = DirectoryServer.getEnvironmentConfig().getLockDirectory();
        return lockDirectory.getAbsolutePath();
    }

    public static String getServerLockFileName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LockFileManager.getLockDirectoryPath());
        buffer.append(File.separator);
        buffer.append("server");
        buffer.append(".lock");
        return buffer.toString();
    }

    public static String getBackendLockFileName(Backend backend) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LockFileManager.getLockDirectoryPath());
        buffer.append(File.separator);
        buffer.append("backend-");
        buffer.append(backend.getBackendID());
        buffer.append(".lock");
        return buffer.toString();
    }
}

