/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.KeyManagerCfgDefn;
import org.opends.server.admin.std.server.KeyManagerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManagerProviderConfigManager
implements ConfigurationChangeListener<KeyManagerCfg>,
ConfigurationAddListener<KeyManagerCfg>,
ConfigurationDeleteListener<KeyManagerCfg> {
    private ConcurrentHashMap<DN, KeyManagerProvider> providers = new ConcurrentHashMap();

    public void initializeKeyManagerProviders() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addKeyManagerAddListener(this);
        rootConfiguration.addKeyManagerDeleteListener(this);
        for (String name : rootConfiguration.listKeyManagers()) {
            KeyManagerCfg providerConfig = rootConfiguration.getKeyManager(name);
            providerConfig.addChangeListener(this);
            if (!providerConfig.isEnabled()) continue;
            String className = providerConfig.getJavaImplementationClass();
            try {
                KeyManagerProvider provider = this.loadProvider(className, providerConfig, true);
                this.providers.put(providerConfig.dn(), provider);
                DirectoryServer.registerKeyManagerProvider(providerConfig.dn(), provider);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(KeyManagerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaImplementationClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(KeyManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        KeyManagerProvider provider = null;
        String className = configuration.getJavaImplementationClass();
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerKeyManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(KeyManagerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(KeyManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServer.deregisterKeyManagerProvider(configuration.dn());
        KeyManagerProvider provider = this.providers.remove(configuration.dn());
        if (provider != null) {
            provider.finalizeKeyManagerProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(KeyManagerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaImplementationClass();
            try {
                this.loadProvider(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(KeyManagerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        KeyManagerProvider existingProvider = this.providers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingProvider != null) {
                DirectoryServer.deregisterKeyManagerProvider(configuration.dn());
                KeyManagerProvider provider = this.providers.remove(configuration.dn());
                if (provider != null) {
                    provider.finalizeKeyManagerProvider();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaImplementationClass();
        if (existingProvider != null) {
            if (!className.equals(existingProvider.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        KeyManagerProvider provider = null;
        try {
            provider = this.loadProvider(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.providers.put(configuration.dn(), provider);
            DirectoryServer.registerKeyManagerProvider(configuration.dn(), provider);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private KeyManagerProvider loadProvider(String className, KeyManagerCfg configuration, boolean initialize) throws InitializationException {
        try {
            KeyManagerCfgDefn definition = KeyManagerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaImplementationClassPropertyDefinition();
            Class<KeyManagerProvider> providerClass = propertyDefinition.loadClass(className, KeyManagerProvider.class);
            KeyManagerProvider provider = providerClass.newInstance();
            if (initialize) {
                Method method = provider.getClass().getMethod("initializeKeyManagerProvider", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)provider, configuration);
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", KeyManagerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_KEYMANAGER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return provider;
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_KEYMANAGER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

