/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.Iterator;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.util.StaticUtils;

public class IdleTimeLimitThread
extends DirectoryThread
implements ServerShutdownListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean shutdownRequested;

    public IdleTimeLimitThread() {
        super("Idle Time Limit Thread");
        this.setDaemon(true);
        this.shutdownRequested = false;
        DirectoryServer.registerShutdownListener(this);
    }

    public void run() {
        Message disconnectMessage = CoreMessages.INFO_IDLETIME_LIMIT_EXCEEDED.get();
        long sleepTime = 5000L;
        while (!this.shutdownRequested) {
            try {
                try {
                    IdleTimeLimitThread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                sleepTime = 5000L;
                Iterator<ConnectionHandler> i$ = DirectoryServer.getConnectionHandlers().iterator();
                while (i$.hasNext()) {
                    ConnectionHandler ch;
                    ConnectionHandler connHandler = ch = i$.next();
                    for (ClientConnection c : connHandler.getClientConnections()) {
                        long idleTimeLimit;
                        long idleTime = c.getIdleTime();
                        if (idleTime <= 0L || (idleTimeLimit = c.getIdleTimeLimit()) <= 0L) continue;
                        if (idleTime > idleTimeLimit) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Terminating client connection " + c.getConnectionID() + " due to the idle time limit");
                            }
                            try {
                                c.disconnect(DisconnectReason.IDLE_TIME_LIMIT_EXCEEDED, true, disconnectMessage);
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                Message message = CoreMessages.ERR_IDLETIME_DISCONNECT_ERROR.get(c.getConnectionID(), StaticUtils.stackTraceToSingleLineString(e));
                                ErrorLogger.logError(message);
                            }
                            continue;
                        }
                        long shouldSleepTime = idleTimeLimit - idleTime;
                        if (shouldSleepTime >= sleepTime) continue;
                        sleepTime = shouldSleepTime;
                    }
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = CoreMessages.ERR_IDLETIME_UNEXPECTED_ERROR.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
    }

    public String getShutdownListenerName() {
        return "Idle Time Limit Thread";
    }

    public void processServerShutdown(Message reason) {
        this.shutdownRequested = true;
    }
}

