/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.ExtendedOperationHandlerCfgDefn;
import org.opends.server.admin.std.server.ExtendedOperationHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedOperationConfigManager
implements ConfigurationChangeListener<ExtendedOperationHandlerCfg>,
ConfigurationAddListener<ExtendedOperationHandlerCfg>,
ConfigurationDeleteListener<ExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, ExtendedOperationHandler> handlers = new ConcurrentHashMap();

    public void initializeExtendedOperationHandlers() throws ConfigException, InitializationException {
        ServerManagementContext context = ServerManagementContext.getInstance();
        RootCfg root = context.getRootConfiguration();
        root.addExtendedOperationHandlerAddListener(this);
        root.addExtendedOperationHandlerDeleteListener(this);
        for (String name : root.listExtendedOperationHandlers()) {
            ExtendedOperationHandlerCfg config = root.getExtendedOperationHandler(name);
            config.addChangeListener(this);
            if (!config.isEnabled()) continue;
            ExtendedOperationHandler handler = this.getHandler(config);
            this.handlers.put(config.dn(), handler);
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ExtendedOperationHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ExtendedOperationHandler handler = this.handlers.remove(configuration.dn());
        if (handler != null) {
            handler.finalizeExtendedOperationHandler();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ExtendedOperationHandlerCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            return this.isJavaClassAcceptable(configuration, unacceptableReasons);
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ExtendedOperationHandlerCfg configuration) {
        DN dn = configuration.dn();
        ExtendedOperationHandler handler = this.handlers.get(dn);
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (handler == null) {
            if (configuration.isEnabled()) {
                try {
                    handler = this.getHandler(configuration);
                    this.handlers.put(dn, handler);
                }
                catch (ConfigException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(e.getMessageObject());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(ConfigMessages.ERR_CONFIG_EXTOP_INITIALIZATION_FAILED.get(String.valueOf(configuration.getJavaImplementationClass()), String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        } else if (configuration.isEnabled()) {
            String className = configuration.getJavaImplementationClass();
            if (!className.equals(handler.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            this.handlers.remove(dn);
            handler.finalizeExtendedOperationHandler();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAddAcceptable(ExtendedOperationHandlerCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ExtendedOperationHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            DN dn = configuration.dn();
            try {
                ExtendedOperationHandler handler = this.getHandler(configuration);
                this.handlers.put(dn, handler);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(ConfigMessages.ERR_CONFIG_EXTOP_INITIALIZATION_FAILED.get(String.valueOf(configuration.getJavaImplementationClass()), String.valueOf(dn), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(ExtendedOperationHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    private ExtendedOperationHandler getHandler(ExtendedOperationHandlerCfg config) throws ConfigException {
        ExtendedOperationHandler extendedOperationHandler;
        String className = config.getJavaImplementationClass();
        ExtendedOperationHandlerCfgDefn d = ExtendedOperationHandlerCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            Class<ExtendedOperationHandler> theClass = pd.loadClass(className, ExtendedOperationHandler.class);
            extendedOperationHandler = theClass.newInstance();
            Method method = theClass.getMethod("initializeExtendedOperationHandler", config.definition().getServerConfigurationClass());
            method.invoke((Object)extendedOperationHandler, config);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_EXTOP_INVALID_CLASS.get(String.valueOf(className), String.valueOf(config.dn()), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return extendedOperationHandler;
    }

    private boolean isJavaClassAcceptable(ExtendedOperationHandlerCfg config, List<Message> unacceptableReasons) {
        String className = config.getJavaImplementationClass();
        ExtendedOperationHandlerCfgDefn d = ExtendedOperationHandlerCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaImplementationClassPropertyDefinition();
        try {
            Class<ExtendedOperationHandler> theClass = pd.loadClass(className, ExtendedOperationHandler.class);
            ExtendedOperationHandler extOpHandler = theClass.newInstance();
            Method method = theClass.getMethod("isConfigurationAcceptable", ExtendedOperationHandlerCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)extOpHandler, config, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_EXTOP_INVALID_CLASS.get(className, String.valueOf(config.dn()), String.valueOf(e)));
            return false;
        }
        return true;
    }
}

