/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.NetworkGroup;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseCompareOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendCompareOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareOperationBasis
extends AbstractOperation
implements PreParseCompareOperation,
CompareOperation,
Runnable,
PostResponseCompareOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType attributeType;
    private ByteString assertionValue;
    private ByteString rawEntryDN;
    private CancelRequest cancelRequest;
    private DN entryDN;
    private DN proxiedAuthorizationDN;
    private List<Control> responseControls;
    private String rawAttributeType;

    public CompareOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN, String rawAttributeType, ByteString assertionValue) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.rawAttributeType = rawAttributeType;
        this.assertionValue = assertionValue;
        this.responseControls = new ArrayList<Control>();
        this.entryDN = null;
        this.attributeType = null;
        this.cancelRequest = null;
        this.proxiedAuthorizationDN = null;
    }

    public CompareOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN, AttributeType attributeType, ByteString assertionValue) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.attributeType = attributeType;
        this.assertionValue = assertionValue;
        this.responseControls = new ArrayList<Control>();
        this.rawEntryDN = new ASN1OctetString(entryDN.toString());
        this.rawAttributeType = attributeType.getNameOrOID();
        this.cancelRequest = null;
        this.proxiedAuthorizationDN = null;
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        return this.entryDN;
    }

    @Override
    public final String getRawAttributeType() {
        return this.rawAttributeType;
    }

    @Override
    public final void setRawAttributeType(String rawAttributeType) {
        this.rawAttributeType = rawAttributeType;
        this.attributeType = null;
    }

    @Override
    public final AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public final ByteString getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public final void setAssertionValue(ByteString assertionValue) {
        this.assertionValue = assertionValue;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.COMPARE;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, sendNotification, message);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}, {"compareAttribute", this.rawAttributeType}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    @Override
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final void run() {
        boolean workflowExecuted;
        block14: {
            this.setResultCode(ResultCode.UNDEFINED);
            this.setProcessingStartTime();
            if (this.cancelRequest != null) {
                this.indicateCancelled(this.cancelRequest);
                this.setProcessingStopTime();
                return;
            }
            PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
            workflowExecuted = false;
            PreParsePluginResult preParseResult = pluginConfigManager.invokePreParseComparePlugins(this);
            if (preParseResult.connectionTerminated()) {
                this.setResultCode(ResultCode.CANCELED);
                this.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREPARSE_DISCONNECT.get());
                this.setProcessingStopTime();
                AccessLogger.logCompareRequest(this);
                AccessLogger.logCompareResponse(this);
                pluginConfigManager.invokePostResponseComparePlugins(this);
                return;
            }
            if (preParseResult.sendResponseImmediately()) {
                AccessLogger.logCompareRequest(this);
            } else if (!preParseResult.skipCoreProcessing()) {
                AccessLogger.logCompareRequest(this);
                if (this.cancelRequest == null) {
                    block13: {
                        try {
                            if (this.entryDN != null) break block13;
                            this.entryDN = DN.decode(this.rawEntryDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            this.setResultCode(de.getResultCode());
                            this.appendErrorMessage(de.getMessageObject());
                            break block14;
                        }
                    }
                    NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                    Workflow workflow = ng.getWorkflowCandidate(this.entryDN);
                    if (workflow == null) {
                        this.updateOperationErrMsgAndResCode();
                    } else {
                        workflow.execute(this);
                        workflowExecuted = true;
                    }
                }
            }
        }
        if (this.getCancelResult() == CancelResult.CANCELED) {
            this.setProcessingStopTime();
            AccessLogger.logCompareResponse(this);
            return;
        }
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            AccessLogger.logCompareResponse(this);
            this.invokePostResponsePlugins(workflowExecuted);
            return;
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        this.setProcessingStopTime();
        this.clientConnection.sendResponse(this);
        AccessLogger.logCompareResponse(this);
        this.invokePostResponsePlugins(workflowExecuted);
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (Object localOp : localOperations) {
                    LocalBackendCompareOperation localOperation = (LocalBackendCompareOperation)localOp;
                    pluginConfigManager.invokePostResponseComparePlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseComparePlugins(this);
        }
    }

    private void updateOperationErrMsgAndResCode() {
        this.setResultCode(ResultCode.NO_SUCH_OBJECT);
        this.appendErrorMessage(CoreMessages.ERR_COMPARE_NO_SUCH_ENTRY.get(String.valueOf(this.getEntryDN())));
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long stopWaitingTime = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < stopWaitingTime) {
            block4: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public boolean setCancelRequest(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("CompareOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(", attr=");
        buffer.append(this.rawAttributeType);
        buffer.append(")");
    }

    @Override
    public Entry getEntryToCompare() {
        return null;
    }
}

