/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.NetworkGroup;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.Workflow;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OperationType;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendAddOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOperationBasis
extends AbstractOperation
implements PreParseAddOperation,
AddOperation,
Runnable,
PostResponseAddOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<Control> responseControls;
    private ByteString rawEntryDN;
    private CancelRequest cancelRequest;
    private DN entryDN;
    private DN proxiedAuthorizationDN;
    private List<RawAttribute> rawAttributes;
    private Map<AttributeType, List<Attribute>> operationalAttributes;
    private Map<AttributeType, List<Attribute>> userAttributes;
    private Map<ObjectClass, String> objectClasses;
    private long changeNumber;

    public AddOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, ByteString rawEntryDN, List<RawAttribute> rawAttributes) {
        super(clientConnection, operationID, messageID, requestControls);
        this.rawEntryDN = rawEntryDN;
        this.rawAttributes = rawAttributes;
        this.responseControls = new ArrayList();
        this.cancelRequest = null;
        this.entryDN = null;
        this.userAttributes = null;
        this.operationalAttributes = null;
        this.objectClasses = null;
        this.proxiedAuthorizationDN = null;
        this.changeNumber = -1L;
    }

    public AddOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, DN entryDN, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        super(clientConnection, operationID, messageID, requestControls);
        this.entryDN = entryDN;
        this.objectClasses = objectClasses;
        this.userAttributes = userAttributes;
        this.operationalAttributes = operationalAttributes;
        this.rawEntryDN = new ASN1OctetString(entryDN.toString());
        this.rawAttributes = new ArrayList<RawAttribute>();
        ArrayList<ASN1OctetString> ocValues = new ArrayList<ASN1OctetString>();
        for (String s : objectClasses.values()) {
            ocValues.add(new ASN1OctetString(s));
        }
        LDAPAttribute ocAttr = new LDAPAttribute("objectClass", ocValues);
        this.rawAttributes.add(ocAttr);
        for (List<Attribute> attrList : userAttributes.values()) {
            for (Attribute a : attrList) {
                this.rawAttributes.add(new LDAPAttribute(a));
            }
        }
        for (List<Attribute> attrList : operationalAttributes.values()) {
            for (Attribute a : attrList) {
                this.rawAttributes.add(new LDAPAttribute(a));
            }
        }
        this.responseControls = new ArrayList();
        this.proxiedAuthorizationDN = null;
        this.cancelRequest = null;
        this.changeNumber = -1L;
    }

    @Override
    public final ByteString getRawEntryDN() {
        return this.rawEntryDN;
    }

    @Override
    public final void setRawEntryDN(ByteString rawEntryDN) {
        this.rawEntryDN = rawEntryDN;
        this.entryDN = null;
    }

    @Override
    public final DN getEntryDN() {
        try {
            if (this.entryDN == null) {
                this.entryDN = DN.decode(this.rawEntryDN);
            }
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.setResultCode(de.getResultCode());
            this.appendErrorMessage(de.getMessageObject());
            this.setMatchedDN(de.getMatchedDN());
            this.setReferralURLs(de.getReferralURLs());
        }
        return this.entryDN;
    }

    @Override
    public final List<RawAttribute> getRawAttributes() {
        return this.rawAttributes;
    }

    @Override
    public final void addRawAttribute(RawAttribute rawAttribute) {
        this.rawAttributes.add(rawAttribute);
        this.objectClasses = null;
        this.userAttributes = null;
        this.operationalAttributes = null;
    }

    @Override
    public final void setRawAttributes(List<RawAttribute> rawAttributes) {
        this.rawAttributes = rawAttributes;
        this.objectClasses = null;
        this.userAttributes = null;
        this.operationalAttributes = null;
    }

    @Override
    public final Map<ObjectClass, String> getObjectClasses() {
        if (this.objectClasses == null) {
            this.computeObjectClassesAndAttributes();
        }
        return this.objectClasses;
    }

    @Override
    public final void addObjectClass(ObjectClass objectClass, String name) {
        this.objectClasses.put(objectClass, name);
    }

    @Override
    public final void removeObjectClass(ObjectClass objectClass) {
        this.objectClasses.remove(objectClass);
    }

    @Override
    public final Map<AttributeType, List<Attribute>> getUserAttributes() {
        if (this.userAttributes == null) {
            this.computeObjectClassesAndAttributes();
        }
        return this.userAttributes;
    }

    @Override
    public final Map<AttributeType, List<Attribute>> getOperationalAttributes() {
        if (this.operationalAttributes == null) {
            this.computeObjectClassesAndAttributes();
        }
        return this.operationalAttributes;
    }

    private final void computeObjectClassesAndAttributes() {
        if (this.objectClasses == null || this.userAttributes == null || this.operationalAttributes == null) {
            this.objectClasses = new HashMap<ObjectClass, String>();
            this.userAttributes = new HashMap<AttributeType, List<Attribute>>();
            this.operationalAttributes = new HashMap<AttributeType, List<Attribute>>();
            for (RawAttribute a : this.rawAttributes) {
                try {
                    List<Attribute> attrs;
                    Attribute attr = a.toAttribute();
                    AttributeType attrType = attr.getAttributeType();
                    if (attrType.isNoUserModification() && !this.isInternalOperation() && !this.isSynchronizationOperation()) {
                        this.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                        this.appendErrorMessage(CoreMessages.ERR_ADD_ATTR_IS_NO_USER_MOD.get(String.valueOf(this.entryDN), attr.getName()));
                        this.objectClasses = null;
                        this.userAttributes = null;
                        this.operationalAttributes = null;
                        return;
                    }
                    if (attrType.isObjectClassType()) {
                        for (ASN1OctetString os : a.getValues()) {
                            String ocName = ((Object)os).toString();
                            ObjectClass oc = DirectoryServer.getObjectClass(StaticUtils.toLowerCase(ocName));
                            if (oc == null) {
                                oc = DirectoryServer.getDefaultObjectClass(ocName);
                            }
                            this.objectClasses.put(oc, ocName);
                        }
                        continue;
                    }
                    if (attrType.isOperational()) {
                        attrs = this.operationalAttributes.get(attrType);
                        if (attrs == null) {
                            attrs = new ArrayList<Attribute>(1);
                            attrs.add(attr);
                            this.operationalAttributes.put(attrType, attrs);
                            continue;
                        }
                        attrs.add(attr);
                        continue;
                    }
                    attrs = this.userAttributes.get(attrType);
                    if (attrs == null) {
                        attrs = new ArrayList<Attribute>(1);
                        attrs.add(attr);
                        this.userAttributes.put(attrType, attrs);
                        continue;
                    }
                    boolean attributeSeen = false;
                    for (Attribute ea : attrs) {
                        if (!ea.optionsEqual(attr.getOptions())) continue;
                        LinkedHashSet<AttributeValue> valueSet = ea.getValues();
                        valueSet.addAll(attr.getValues());
                        attributeSeen = true;
                    }
                    if (attributeSeen) continue;
                    attrs.add(attr);
                }
                catch (LDAPException le) {
                    this.setResultCode(ResultCode.valueOf(le.getResultCode()));
                    this.appendErrorMessage(le.getMessageObject());
                    this.objectClasses = null;
                    this.userAttributes = null;
                    this.operationalAttributes = null;
                }
            }
        }
    }

    @Override
    public final void setAttribute(AttributeType attributeType, List<Attribute> attributeList) {
        if (attributeType.isOperational()) {
            if (attributeList == null || attributeList.isEmpty()) {
                this.operationalAttributes.remove(attributeType);
            } else {
                this.operationalAttributes.put(attributeType, attributeList);
            }
        } else if (attributeList == null || attributeList.isEmpty()) {
            this.userAttributes.remove(attributeType);
        } else {
            this.userAttributes.put(attributeType, attributeList);
        }
    }

    @Override
    public final void removeAttribute(AttributeType attributeType) {
        if (attributeType.isOperational()) {
            this.operationalAttributes.remove(attributeType);
        } else {
            this.userAttributes.remove(attributeType);
        }
    }

    @Override
    public final long getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public final void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.ADD;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        this.setCancelResult(CancelResult.CANCELED);
        this.clientConnection.disconnect(disconnectReason, sendNotification, message);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"entryDN", String.valueOf(this.rawEntryDN)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String referrals;
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        DN matchedDN = this.getMatchedDN();
        String matchedDNStr = matchedDN == null ? null : matchedDN.toString();
        List<String> referralURLs = this.getReferralURLs();
        if (referralURLs == null || referralURLs.isEmpty()) {
            referrals = null;
        } else {
            StringBuilder buffer = new StringBuilder();
            Iterator<String> iterator = referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            referrals = buffer.toString();
        }
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"matchedDN", matchedDNStr}, {"referralURLs", referrals}, {"processingTime", processingTime}};
    }

    @Override
    public DN getProxiedAuthorizationDN() {
        return this.proxiedAuthorizationDN;
    }

    public final ArrayList<Control> getResponseControls() {
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        CancelResult cancelResult = this.getCancelResult();
        long stopWaitingTime = System.currentTimeMillis() + 5000L;
        while (cancelResult == null && System.currentTimeMillis() < stopWaitingTime) {
            block4: {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            cancelResult = this.getCancelResult();
        }
        if (cancelResult == null) {
            cancelResult = CancelResult.CANNOT_CANCEL;
        }
        return cancelResult;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return this.cancelRequest;
    }

    @Override
    public boolean setCancelRequest(CancelRequest cancelRequest) {
        this.cancelRequest = cancelRequest;
        return true;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("AddOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", dn=");
        buffer.append(this.rawEntryDN);
        buffer.append(")");
    }

    @Override
    public void setProxiedAuthorizationDN(DN proxiedAuthorizationDN) {
        this.proxiedAuthorizationDN = proxiedAuthorizationDN;
    }

    @Override
    public final void run() {
        this.setProcessingStartTime();
        this.setResultCode(ResultCode.UNDEFINED);
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            return;
        }
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean workflowExecuted = false;
        PreParsePluginResult preParseResult = pluginConfigManager.invokePreParseAddPlugins(this);
        if (preParseResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREPARSE_DISCONNECT.get());
            this.setProcessingStopTime();
            AccessLogger.logAddRequest(this);
            AccessLogger.logAddResponse(this);
            pluginConfigManager.invokePostResponseAddPlugins(this);
            return;
        }
        if (preParseResult.sendResponseImmediately()) {
            AccessLogger.logAddRequest(this);
        } else if (!preParseResult.skipCoreProcessing()) {
            DN entryDN;
            AccessLogger.logAddRequest(this);
            if (this.cancelRequest == null && (entryDN = this.getEntryDN()) != null) {
                NetworkGroup ng = this.getClientConnection().getNetworkGroup();
                Workflow workflow = ng.getWorkflowCandidate(entryDN);
                if (workflow == null) {
                    this.updateOperationErrMsgAndResCode();
                } else {
                    workflow.execute(this);
                    workflowExecuted = true;
                }
            }
        }
        if (this.getCancelResult() == CancelResult.CANCELED) {
            this.setProcessingStopTime();
            AccessLogger.logAddResponse(this);
            return;
        }
        if (this.cancelRequest != null) {
            this.indicateCancelled(this.cancelRequest);
            this.setProcessingStopTime();
            AccessLogger.logAddResponse(this);
            this.invokePostResponsePlugins(workflowExecuted);
            return;
        }
        this.setCancelResult(CancelResult.TOO_LATE);
        this.setProcessingStopTime();
        this.clientConnection.sendResponse(this);
        AccessLogger.logAddResponse(this);
        this.notifyPersistentSearches(workflowExecuted);
        this.invokePostResponsePlugins(workflowExecuted);
    }

    private void invokePostResponsePlugins(boolean workflowExecuted) {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        if (workflowExecuted) {
            List localOperations = (List)this.getAttachment("LocalBackendOperations");
            if (localOperations != null) {
                for (Object localOp : localOperations) {
                    LocalBackendAddOperation localOperation = (LocalBackendAddOperation)localOp;
                    pluginConfigManager.invokePostResponseAddPlugins(localOperation);
                }
            }
        } else {
            pluginConfigManager.invokePostResponseAddPlugins(this);
        }
    }

    private void notifyPersistentSearches(boolean workflowExecuted) {
        if (!workflowExecuted) {
            return;
        }
        List localOperations = (List)this.getAttachment("LocalBackendOperations");
        if (localOperations != null) {
            for (Object localOp : localOperations) {
                LocalBackendAddOperation localOperation = (LocalBackendAddOperation)localOp;
                if (this.getResultCode() != ResultCode.SUCCESS || localOperation.getEntryToAdd() == null) continue;
                for (PersistentSearch persistentSearch : DirectoryServer.getPersistentSearches()) {
                    try {
                        persistentSearch.processAdd(localOperation, localOperation.getEntryToAdd());
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        Message message = CoreMessages.ERR_ADD_ERROR_NOTIFYING_PERSISTENT_SEARCH.get(String.valueOf(persistentSearch), StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(message);
                        DirectoryServer.deregisterPersistentSearch(persistentSearch);
                    }
                }
            }
        }
    }

    private void updateOperationErrMsgAndResCode() {
        DN entryDN = this.getEntryDN();
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null && !DirectoryServer.isNamingContext(entryDN)) {
            if (entryDN.isNullDN()) {
                this.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
                this.appendErrorMessage(CoreMessages.ERR_ADD_CANNOT_ADD_ROOT_DSE.get());
            } else {
                this.setResultCode(ResultCode.NO_SUCH_OBJECT);
                this.appendErrorMessage(CoreMessages.ERR_ADD_ENTRY_NOT_SUFFIX.get(String.valueOf(entryDN)));
            }
        }
    }

    @Override
    public Entry getEntryToAdd() {
        return null;
    }
}

