/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AccountStatusNotificationHandlerCfgDefn;
import org.opends.server.admin.std.server.AccountStatusNotificationHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountStatusNotificationHandlerConfigManager
implements ConfigurationChangeListener<AccountStatusNotificationHandlerCfg>,
ConfigurationAddListener<AccountStatusNotificationHandlerCfg>,
ConfigurationDeleteListener<AccountStatusNotificationHandlerCfg> {
    private ConcurrentHashMap<DN, AccountStatusNotificationHandler> notificationHandlers = new ConcurrentHashMap();

    public void initializeNotificationHandlers() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addAccountStatusNotificationHandlerAddListener(this);
        rootConfiguration.addAccountStatusNotificationHandlerDeleteListener(this);
        for (String handlerName : rootConfiguration.listAccountStatusNotificationHandlers()) {
            AccountStatusNotificationHandlerCfg config = rootConfiguration.getAccountStatusNotificationHandler(handlerName);
            config.addChangeListener(this);
            if (!config.isEnabled()) continue;
            String className = config.getNotificationHandlerClass();
            this.loadAndInstallNotificationHandler(className, config);
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AccountStatusNotificationHandlerCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        if (configuration.isEnabled()) {
            String className = configuration.getNotificationHandlerClass();
            try {
                this.loadNotificationHandler(className, configuration, true);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AccountStatusNotificationHandlerCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        DN configEntryDN = configuration.dn();
        AccountStatusNotificationHandler handler = this.notificationHandlers.get(configEntryDN);
        if (!configuration.isEnabled()) {
            if (handler != null) {
                this.uninstallNotificationHandler(configEntryDN);
            }
            return changeResult;
        }
        String newClassName = configuration.getNotificationHandlerClass();
        if (handler != null) {
            boolean classIsNew;
            String curClassName = handler.getClass().getName();
            boolean bl = classIsNew = !newClassName.equals(curClassName);
            if (classIsNew) {
                changeResult.setAdminActionRequired(true);
            }
            return changeResult;
        }
        try {
            this.loadAndInstallNotificationHandler(newClassName, configuration);
        }
        catch (InitializationException ie) {
            changeResult.addMessage(ie.getMessageObject());
            changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
            return changeResult;
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationAddAcceptable(AccountStatusNotificationHandlerCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        DN configEntryDN = configuration.dn();
        if (this.notificationHandlers.containsKey(configEntryDN)) {
            Message message = ConfigMessages.ERR_CONFIG_ACCTNOTHANDLER_EXISTS.get(String.valueOf(configEntryDN));
            unacceptableReasons.add(message);
            status = false;
        } else if (configuration.isEnabled()) {
            String className = configuration.getNotificationHandlerClass();
            try {
                this.loadNotificationHandler(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(AccountStatusNotificationHandlerCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            String className = configuration.getNotificationHandlerClass();
            try {
                this.loadAndInstallNotificationHandler(className, configuration);
            }
            catch (InitializationException ie) {
                changeResult.addMessage(ie.getMessageObject());
                changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
                return changeResult;
            }
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(AccountStatusNotificationHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(AccountStatusNotificationHandlerCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        this.uninstallNotificationHandler(configuration.dn());
        return changeResult;
    }

    private void loadAndInstallNotificationHandler(String className, AccountStatusNotificationHandlerCfg configuration) throws InitializationException {
        AccountStatusNotificationHandler<? extends AccountStatusNotificationHandlerCfg> handlerClass = this.loadNotificationHandler(className, configuration, true);
        DN configEntryDN = configuration.dn();
        this.notificationHandlers.put(configEntryDN, handlerClass);
        DirectoryServer.registerAccountStatusNotificationHandler(configEntryDN, handlerClass);
    }

    private AccountStatusNotificationHandler<? extends AccountStatusNotificationHandlerCfg> loadNotificationHandler(String className, AccountStatusNotificationHandlerCfg configuration, boolean initialize) throws InitializationException {
        try {
            AccountStatusNotificationHandlerCfgDefn definition = AccountStatusNotificationHandlerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getNotificationHandlerClassPropertyDefinition();
            Class<AccountStatusNotificationHandler> handlerClass = propertyDefinition.loadClass(className, AccountStatusNotificationHandler.class);
            AccountStatusNotificationHandler notificationHandler = handlerClass.newInstance();
            if (initialize) {
                Method method = notificationHandler.getClass().getMethod("initializeStatusNotificationHandler", configuration.definition().getServerConfigurationClass());
                method.invoke((Object)notificationHandler, configuration);
            } else {
                Method method = notificationHandler.getClass().getMethod("isConfigurationAcceptable", AccountStatusNotificationHandlerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)notificationHandler, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_ACCTNOTHANDLER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return notificationHandler;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_ACCTNOTHANDLER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    private void uninstallNotificationHandler(DN configEntryDN) {
        AccountStatusNotificationHandler handler = this.notificationHandlers.remove(configEntryDN);
        if (handler != null) {
            DirectoryServer.deregisterAccountStatusNotificationHandler(configEntryDN);
            handler.finalizeStatusNotificationHandler();
        }
    }
}

