/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationAbandonOperation;
import org.opends.server.types.operation.PreParseAbandonOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbandonOperationBasis
extends AbstractOperation
implements Runnable,
AbandonOperation,
PreParseAbandonOperation,
PostOperationAbandonOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final int idToAbandon;

    public AbandonOperationBasis(ClientConnection clientConnection, long operationID, int messageID, List<Control> requestControls, int idToAbandon) {
        super(clientConnection, operationID, messageID, requestControls);
        this.idToAbandon = idToAbandon;
    }

    @Override
    public final int getIDToAbandon() {
        return this.idToAbandon;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.ABANDON;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        this.clientConnection.disconnect(disconnectReason, sendNotification, message);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[][]{{"idToAbandon", String.valueOf(this.idToAbandon)}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        String resultCode = String.valueOf(this.getResultCode().getIntValue());
        MessageBuilder errorMessageBuffer = this.getErrorMessage();
        String errorMessage = errorMessageBuffer == null ? null : errorMessageBuffer.toString();
        String processingTime = String.valueOf(this.getProcessingTime());
        return new String[][]{{"resultCode", resultCode}, {"errorMessage", errorMessage}, {"processingTime", processingTime}};
    }

    @Override
    public final List<Control> getResponseControls() {
        return NO_RESPONSE_CONTROLS;
    }

    @Override
    public final void addResponseControl(Control control) {
    }

    @Override
    public final void removeResponseControl(Control control) {
    }

    @Override
    public final void run() {
        this.setResultCode(ResultCode.UNDEFINED);
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean skipPostOperation = false;
        this.setProcessingStartTime();
        PreParsePluginResult preParseResult = pluginConfigManager.invokePreParseAbandonPlugins(this);
        if (preParseResult.connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            this.appendErrorMessage(CoreMessages.ERR_CANCELED_BY_PREPARSE_DISCONNECT.get());
            this.setProcessingStopTime();
            AccessLogger.logAbandonRequest(this);
            AccessLogger.logAbandonResult(this);
            return;
        }
        if (preParseResult.sendResponseImmediately()) {
            skipPostOperation = true;
        } else if (preParseResult.skipCoreProcessing()) {
            skipPostOperation = false;
        } else {
            AccessLogger.logAbandonRequest(this);
            AbstractOperation operation = this.clientConnection.getOperationInProgress(this.idToAbandon);
            if (operation == null) {
                this.setResultCode(ResultCode.NO_SUCH_OPERATION);
                this.appendErrorMessage(CoreMessages.ERR_ABANDON_OP_NO_SUCH_OPERATION.get(this.idToAbandon));
            } else {
                boolean notifyRequestor = DirectoryServer.notifyAbandonedOperations();
                Message cancelReason = CoreMessages.INFO_CANCELED_BY_ABANDON_REQUEST.get(this.messageID);
                MessageBuilder cancelResponse = new MessageBuilder();
                CancelResult result = operation.cancel(new CancelRequest(notifyRequestor, cancelReason, cancelResponse));
                this.setResultCode(result.getResultCode());
                this.setErrorMessage(cancelResponse);
            }
        }
        if (!skipPostOperation) {
            pluginConfigManager.invokePostOperationAbandonPlugins(this);
        }
        this.setProcessingStopTime();
        AccessLogger.logAbandonResult(this);
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        cancelRequest.addResponseMessage(CoreMessages.ERR_CANNOT_CANCEL_ABANDON.get());
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        return null;
    }

    @Override
    public boolean setCancelRequest(CancelRequest cancelRequest) {
        return false;
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("AbandonOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(", idToAbandon=");
        buffer.append(this.idToAbandon);
        buffer.append(")");
    }
}

