/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawFilter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedValuesFilter {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final byte EQUALITY_MATCH_TYPE = -93;
    public static final byte SUBSTRINGS_TYPE = -92;
    public static final byte GREATER_OR_EQUAL_TYPE = -91;
    public static final byte LESS_OR_EQUAL_TYPE = -90;
    public static final byte PRESENT_TYPE = -121;
    public static final byte APPROXIMATE_MATCH_TYPE = -88;
    public static final byte EXTENSIBLE_MATCH_TYPE = -87;
    private ApproximateMatchingRule approximateMatchingRule;
    private ASN1OctetString normalizedSubFinal;
    private ASN1OctetString normalizedSubInitial;
    private ByteString rawAssertionValue;
    private ByteString subFinal;
    private ByteString subInitial;
    private AttributeType attributeType;
    private AttributeValue assertionValue;
    private boolean decoded;
    private byte matchType;
    private EqualityMatchingRule equalityMatchingRule;
    private List<ASN1OctetString> normalizedSubAny;
    private List<ByteString> subAny;
    private MatchingRule matchingRule;
    private OrderingMatchingRule orderingMatchingRule;
    private String matchingRuleID;
    private String rawAttributeType;
    private SubstringMatchingRule substringMatchingRule;

    private MatchedValuesFilter(byte matchType, String rawAttributeType, ByteString rawAssertionValue, ByteString subInitial, List<ByteString> subAny, ByteString subFinal, String matchingRuleID) {
        this.matchType = matchType;
        this.rawAttributeType = rawAttributeType;
        this.rawAssertionValue = rawAssertionValue;
        this.subInitial = subInitial;
        this.subAny = subAny;
        this.subFinal = subFinal;
        this.matchingRuleID = matchingRuleID;
        this.decoded = false;
        this.attributeType = null;
        this.assertionValue = null;
        this.matchingRule = null;
        this.normalizedSubInitial = null;
        this.normalizedSubAny = null;
        this.normalizedSubFinal = null;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public static MatchedValuesFilter createEqualityFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-93, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createEqualityFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ASN1OctetString rawAssertionValue = assertionValue.getValue().toASN1OctetString();
        MatchedValuesFilter filter = new MatchedValuesFilter(-93, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createSubstringsFilter(String rawAttributeType, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        Validator.ensureNotNull(rawAttributeType);
        return new MatchedValuesFilter(-92, rawAttributeType, null, subInitial, subAny, subFinal, null);
    }

    public static MatchedValuesFilter createSubstringsFilter(AttributeType attributeType, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        Validator.ensureNotNull(attributeType);
        String rawAttributeType = attributeType.getNameOrOID();
        MatchedValuesFilter filter = new MatchedValuesFilter(-92, rawAttributeType, null, subInitial, subAny, subFinal, null);
        filter.attributeType = attributeType;
        return filter;
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-91, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createGreaterOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ASN1OctetString rawAssertionValue = assertionValue.getValue().toASN1OctetString();
        MatchedValuesFilter filter = new MatchedValuesFilter(-91, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createLessOrEqualFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-90, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createLessOrEqualFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ASN1OctetString rawAssertionValue = assertionValue.getValue().toASN1OctetString();
        MatchedValuesFilter filter = new MatchedValuesFilter(-90, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createPresentFilter(String rawAttributeType) {
        Validator.ensureNotNull(rawAttributeType);
        return new MatchedValuesFilter(-121, rawAttributeType, null, null, null, null, null);
    }

    public static MatchedValuesFilter createPresentFilter(AttributeType attributeType) {
        Validator.ensureNotNull(attributeType);
        String rawAttributeType = attributeType.getNameOrOID();
        MatchedValuesFilter filter = new MatchedValuesFilter(-121, rawAttributeType, null, null, null, null, null);
        filter.attributeType = attributeType;
        return filter;
    }

    public static MatchedValuesFilter createApproximateFilter(String rawAttributeType, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, rawAssertionValue);
        return new MatchedValuesFilter(-88, rawAttributeType, rawAssertionValue, null, null, null, null);
    }

    public static MatchedValuesFilter createApproximateFilter(AttributeType attributeType, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        ASN1OctetString rawAssertionValue = assertionValue.getValue().toASN1OctetString();
        MatchedValuesFilter filter = new MatchedValuesFilter(-88, rawAttributeType, rawAssertionValue, null, null, null, null);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        return filter;
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(String rawAttributeType, String matchingRuleID, ByteString rawAssertionValue) {
        Validator.ensureNotNull(rawAttributeType, matchingRuleID, rawAssertionValue);
        return new MatchedValuesFilter(-87, rawAttributeType, rawAssertionValue, null, null, null, matchingRuleID);
    }

    public static MatchedValuesFilter createExtensibleMatchFilter(AttributeType attributeType, MatchingRule matchingRule, AttributeValue assertionValue) {
        Validator.ensureNotNull(attributeType, matchingRule, assertionValue);
        String rawAttributeType = attributeType.getNameOrOID();
        String matchingRuleID = matchingRule.getOID();
        ASN1OctetString rawAssertionValue = assertionValue.getValue().toASN1OctetString();
        MatchedValuesFilter filter = new MatchedValuesFilter(-87, rawAttributeType, rawAssertionValue, null, null, null, matchingRuleID);
        filter.attributeType = attributeType;
        filter.assertionValue = assertionValue;
        filter.matchingRule = matchingRule;
        return filter;
    }

    public static MatchedValuesFilter createFromLDAPFilter(RawFilter filter) throws LDAPException {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: 
            case NOT: {
                Message message = ProtocolMessages.ERR_MVFILTER_INVALID_LDAP_FILTER_TYPE.get(String.valueOf(filter), String.valueOf((Object)filter.getFilterType()));
                throw new LDAPException(2, message);
            }
            case EQUALITY: {
                return new MatchedValuesFilter(-93, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case SUBSTRING: {
                return new MatchedValuesFilter(-92, filter.getAttributeType(), null, filter.getSubInitialElement(), filter.getSubAnyElements(), filter.getSubFinalElement(), null);
            }
            case GREATER_OR_EQUAL: {
                return new MatchedValuesFilter(-91, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case LESS_OR_EQUAL: {
                return new MatchedValuesFilter(-90, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case PRESENT: {
                return new MatchedValuesFilter(-121, filter.getAttributeType(), null, null, null, null, null);
            }
            case APPROXIMATE_MATCH: {
                return new MatchedValuesFilter(-88, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, null);
            }
            case EXTENSIBLE_MATCH: {
                if (filter.getDNAttributes()) {
                    Message message = ProtocolMessages.ERR_MVFILTER_INVALID_DN_ATTRIBUTES_FLAG.get(String.valueOf(filter));
                    throw new LDAPException(2, message);
                }
                return new MatchedValuesFilter(-87, filter.getAttributeType(), filter.getAssertionValue(), null, null, null, filter.getMatchingRuleID());
            }
        }
        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_LDAP_FILTER_TYPE.get(String.valueOf(filter), String.valueOf((Object)filter.getFilterType()));
        throw new LDAPException(2, message);
    }

    public ASN1Element encode() {
        switch (this.matchType) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
                elements.add(new ASN1OctetString(this.rawAttributeType));
                elements.add(this.rawAssertionValue.toASN1OctetString());
                return new ASN1Sequence(this.matchType, elements);
            }
            case -92: {
                ArrayList<ASN1Element> subElements = new ArrayList<ASN1Element>();
                if (this.subInitial != null) {
                    ASN1OctetString subInitialOS = this.subInitial.toASN1OctetString();
                    subInitialOS.setType((byte)-128);
                    subElements.add(subInitialOS);
                }
                if (this.subAny != null) {
                    for (ByteString s : this.subAny) {
                        ASN1OctetString os = s.toASN1OctetString();
                        os.setType((byte)-127);
                        subElements.add(os);
                    }
                }
                if (this.subFinal != null) {
                    ASN1OctetString subFinalOS = this.subFinal.toASN1OctetString();
                    subFinalOS.setType((byte)-126);
                    subElements.add(subFinalOS);
                }
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
                elements.add(new ASN1OctetString(this.rawAttributeType));
                elements.add(new ASN1Sequence(subElements));
                return new ASN1Sequence(this.matchType, elements);
            }
            case -121: {
                return new ASN1OctetString(this.matchType, this.rawAttributeType);
            }
            case -87: {
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
                if (this.matchingRuleID != null) {
                    elements.add(new ASN1OctetString(-127, this.matchingRuleID));
                }
                if (this.rawAttributeType != null) {
                    elements.add(new ASN1OctetString(-126, this.rawAttributeType));
                }
                ASN1OctetString valueOS = this.rawAssertionValue.toASN1OctetString();
                valueOS.setType((byte)-125);
                elements.add(valueOS);
                return new ASN1Sequence(this.matchType, elements);
            }
        }
        return null;
    }

    public static MatchedValuesFilter decode(ASN1Element element) throws LDAPException {
        switch (element.getType()) {
            case -93: 
            case -91: 
            case -90: 
            case -88: {
                try {
                    ArrayList<ASN1Element> elements = element.decodeAsSequence().elements();
                    if (elements.size() != 2) {
                        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_AVA_SEQUENCE_SIZE.get(elements.size());
                        throw new LDAPException(2, message);
                    }
                    String rawAttributeType = elements.get(0).decodeAsOctetString().stringValue();
                    return new MatchedValuesFilter(element.getType(), rawAttributeType, elements.get(1).decodeAsOctetString(), null, null, null, null);
                }
                catch (LDAPException le) {
                    throw le;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_AVA.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -92: {
                try {
                    ArrayList<ASN1Element> elements = element.decodeAsSequence().elements();
                    if (elements.size() != 2) {
                        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_SUBSTRING_SEQUENCE_SIZE.get(elements.size());
                        throw new LDAPException(2, message);
                    }
                    ArrayList<ASN1Element> subElements = elements.get(1).decodeAsSequence().elements();
                    if (subElements.isEmpty()) {
                        Message message = ProtocolMessages.ERR_MVFILTER_NO_SUBSTRING_ELEMENTS.get();
                        throw new LDAPException(2, message);
                    }
                    String rawAttributeType = elements.get(0).decodeAsOctetString().stringValue();
                    ASN1OctetString subInitial = null;
                    ArrayList<ASN1OctetString> subAny = null;
                    ASN1OctetString subFinal = null;
                    block27: for (ASN1Element e : subElements) {
                        switch (e.getType()) {
                            case -128: {
                                if (subInitial == null) {
                                    subInitial = e.decodeAsOctetString();
                                    continue block27;
                                }
                                Message message = ProtocolMessages.ERR_MVFILTER_MULTIPLE_SUBINITIALS.get();
                                throw new LDAPException(2, message);
                            }
                            case -127: {
                                if (subAny == null) {
                                    subAny = new ArrayList<ASN1OctetString>();
                                }
                                subAny.add(e.decodeAsOctetString());
                                continue block27;
                            }
                            case -126: {
                                if (subFinal == null) {
                                    subFinal = e.decodeAsOctetString();
                                    continue block27;
                                }
                                Message message = ProtocolMessages.ERR_MVFILTER_MULTIPLE_SUBFINALS.get();
                                throw new LDAPException(2, message);
                            }
                        }
                        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_SUBSTRING_ELEMENT_TYPE.get(StaticUtils.byteToHex(e.getType()));
                        throw new LDAPException(2, message);
                    }
                    return new MatchedValuesFilter(element.getType(), rawAttributeType, null, subInitial, subAny, subFinal, null);
                }
                catch (LDAPException le) {
                    throw le;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_SUBSTRINGS.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -121: {
                try {
                    String rawAttributeType = element.decodeAsOctetString().stringValue();
                    return new MatchedValuesFilter(element.getType(), rawAttributeType, null, null, null, null, null);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_PRESENT_TYPE.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
            case -87: {
                try {
                    ArrayList<ASN1Element> elements = element.decodeAsSequence().elements();
                    if (elements.size() < 2 || elements.size() > 3) {
                        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_EXTENSIBLE_SEQUENCE_SIZE.get(elements.size());
                        throw new LDAPException(2, message);
                    }
                    String rawAttributeType = null;
                    String matchingRuleID = null;
                    ASN1OctetString rawAssertionValue = null;
                    block28: for (ASN1Element e : elements) {
                        switch (e.getType()) {
                            case -127: {
                                if (matchingRuleID == null) {
                                    matchingRuleID = e.decodeAsOctetString().stringValue();
                                    continue block28;
                                }
                                Message message = ProtocolMessages.ERR_MVFILTER_MULTIPLE_MATCHING_RULE_IDS.get();
                                throw new LDAPException(2, message);
                            }
                            case -126: {
                                if (rawAttributeType == null) {
                                    rawAttributeType = e.decodeAsOctetString().stringValue();
                                    continue block28;
                                }
                                Message message = ProtocolMessages.ERR_MVFILTER_MULTIPLE_ATTRIBUTE_TYPES.get();
                                throw new LDAPException(2, message);
                            }
                            case -125: {
                                if (rawAssertionValue == null) {
                                    rawAssertionValue = e.decodeAsOctetString();
                                    continue block28;
                                }
                                Message message = ProtocolMessages.ERR_MVFILTER_MULTIPLE_ASSERTION_VALUES.get();
                                throw new LDAPException(2, message);
                            }
                        }
                        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_EXTENSIBLE_ELEMENT_TYPE.get(StaticUtils.byteToHex(e.getType()));
                        throw new LDAPException(2, message);
                    }
                    return new MatchedValuesFilter(element.getType(), rawAttributeType, rawAssertionValue, null, null, null, matchingRuleID);
                }
                catch (LDAPException le) {
                    throw le;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_MVFILTER_CANNOT_DECODE_EXTENSIBLE_MATCH.get(StaticUtils.getExceptionMessage(e));
                    throw new LDAPException(2, message, e);
                }
            }
        }
        Message message = ProtocolMessages.ERR_MVFILTER_INVALID_ELEMENT_TYPE.get(StaticUtils.byteToHex(element.getType()));
        throw new LDAPException(2, message);
    }

    public byte getMatchType() {
        return this.matchType;
    }

    public String getRawAttributeType() {
        return this.rawAttributeType;
    }

    public void setRawAttributeType(String rawAttributeType) {
        this.rawAttributeType = rawAttributeType;
        this.decoded = false;
        this.attributeType = null;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public AttributeType getAttributeType() {
        if (this.attributeType == null && this.rawAttributeType != null) {
            this.attributeType = DirectoryServer.getAttributeType(StaticUtils.toLowerCase(this.rawAttributeType));
            if (this.attributeType == null) {
                this.attributeType = DirectoryServer.getDefaultAttributeType(this.rawAttributeType);
            }
        }
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.rawAttributeType = attributeType == null ? null : attributeType.getNameOrOID();
        this.decoded = false;
        this.approximateMatchingRule = null;
        this.equalityMatchingRule = null;
        this.orderingMatchingRule = null;
        this.substringMatchingRule = null;
    }

    public ByteString getRawAssertionValue() {
        return this.rawAssertionValue;
    }

    public void setRawAssertionValue(ByteString rawAssertionValue) {
        this.rawAssertionValue = rawAssertionValue;
        this.decoded = false;
        this.assertionValue = null;
    }

    public AttributeValue getAssertionValue() {
        if (this.assertionValue == null && this.rawAssertionValue != null) {
            this.assertionValue = new AttributeValue(this.getAttributeType(), this.rawAssertionValue);
        }
        return this.assertionValue;
    }

    public void setAssertionValue(AttributeValue assertionValue) {
        this.assertionValue = assertionValue;
        this.rawAssertionValue = assertionValue == null ? null : assertionValue.getValue().toASN1OctetString();
        this.decoded = false;
    }

    public ByteString getSubInitialElement() {
        return this.subInitial;
    }

    public void setSubInitialElement(ByteString subInitial) {
        this.subInitial = subInitial;
        this.decoded = false;
        this.normalizedSubInitial = null;
    }

    public ASN1OctetString getNormalizedSubInitialElement() {
        block3: {
            if (this.normalizedSubInitial == null && this.subInitial != null && this.getSubstringMatchingRule() != null) {
                try {
                    this.normalizedSubInitial = this.getSubstringMatchingRule().normalizeSubstring(this.subInitial).toASN1OctetString();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return this.normalizedSubInitial;
    }

    public List<ByteString> getSubAnyElements() {
        return this.subAny;
    }

    public void setSubAnyElements(List<ByteString> subAny) {
        this.subAny = subAny;
        this.decoded = false;
        this.normalizedSubAny = null;
    }

    public List<ASN1OctetString> getNormalizedSubAnyElements() {
        if (this.normalizedSubAny == null) {
            if (this.subAny == null || this.subAny.isEmpty()) {
                this.normalizedSubAny = new ArrayList<ASN1OctetString>(0);
            } else {
                if (this.getSubstringMatchingRule() == null) {
                    return null;
                }
                this.normalizedSubAny = new ArrayList<ASN1OctetString>();
                try {
                    for (ByteString s : this.subAny) {
                        this.normalizedSubAny.add(this.substringMatchingRule.normalizeSubstring(s).toASN1OctetString());
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.normalizedSubAny = null;
                }
            }
        }
        return this.normalizedSubAny;
    }

    public ByteString getSubFinalElement() {
        return this.subFinal;
    }

    public void setSubFinalElement(ByteString subFinal) {
        this.subFinal = subFinal;
        this.decoded = false;
        this.normalizedSubFinal = null;
    }

    public ASN1OctetString getNormalizedSubFinalElement() {
        block3: {
            if (this.normalizedSubFinal == null && this.subFinal != null && this.getSubstringMatchingRule() != null) {
                try {
                    this.normalizedSubFinal = this.getSubstringMatchingRule().normalizeSubstring(this.subFinal).toASN1OctetString();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return this.normalizedSubFinal;
    }

    public String getMatchingRuleID() {
        return this.matchingRuleID;
    }

    public void setMatchingRuleID(String matchingRuleID) {
        this.matchingRuleID = matchingRuleID;
        this.decoded = false;
        this.matchingRule = null;
    }

    public MatchingRule getMatchingRule() {
        if (this.matchingRule == null && this.matchingRuleID != null) {
            this.matchingRule = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
        }
        return this.matchingRule;
    }

    public void setMatchingRule(MatchingRule matchingRule) {
        this.matchingRule = matchingRule;
        this.matchingRuleID = matchingRule == null ? null : matchingRule.getNameOrOID();
        this.decoded = false;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        AttributeType attrType;
        if (this.approximateMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.approximateMatchingRule = attrType.getApproximateMatchingRule();
        }
        return this.approximateMatchingRule;
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        AttributeType attrType;
        if (this.equalityMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.equalityMatchingRule = attrType.getEqualityMatchingRule();
        }
        return this.equalityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        AttributeType attrType;
        if (this.orderingMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.orderingMatchingRule = attrType.getOrderingMatchingRule();
        }
        return this.orderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        AttributeType attrType;
        if (this.substringMatchingRule == null && (attrType = this.getAttributeType()) != null) {
            this.substringMatchingRule = attrType.getSubstringMatchingRule();
        }
        return this.substringMatchingRule;
    }

    private void fullyDecode() {
        if (!this.decoded) {
            this.getAttributeType();
            this.getAssertionValue();
            this.getNormalizedSubInitialElement();
            this.getNormalizedSubAnyElements();
            this.getNormalizedSubFinalElement();
            this.getMatchingRule();
            this.getApproximateMatchingRule();
            this.getEqualityMatchingRule();
            this.getOrderingMatchingRule();
            this.getSubstringMatchingRule();
            this.decoded = true;
        }
    }

    public boolean valueMatches(AttributeType type, AttributeValue value) {
        this.fullyDecode();
        switch (this.matchType) {
            case -93: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.equalityMatchingRule != null) {
                    try {
                        return this.equalityMatchingRule.areEqual(this.assertionValue.getNormalizedValue(), value.getNormalizedValue());
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -92: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.substringMatchingRule != null) {
                    try {
                        ArrayList<ByteString> normalizedSubAnyBS = new ArrayList<ByteString>(this.normalizedSubAny);
                        return this.substringMatchingRule.valueMatchesSubstring(value.getNormalizedValue(), this.normalizedSubInitial, normalizedSubAnyBS, this.normalizedSubFinal);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -91: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.orderingMatchingRule != null) {
                    try {
                        return this.orderingMatchingRule.compareValues(this.assertionValue.getNormalizedValue(), value.getNormalizedValue()) >= 0;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -90: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.orderingMatchingRule != null) {
                    try {
                        return this.orderingMatchingRule.compareValues(this.assertionValue.getNormalizedValue(), value.getNormalizedValue()) <= 0;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -121: {
                return this.attributeType != null && type != null && this.attributeType.equals(type);
            }
            case -88: {
                if (this.attributeType != null && type != null && this.attributeType.equals(type) && this.assertionValue != null && value != null && this.approximateMatchingRule != null) {
                    try {
                        ByteString nv1 = this.approximateMatchingRule.normalizeValue(this.assertionValue.getNormalizedValue());
                        ByteString nv2 = this.approximateMatchingRule.normalizeValue(value.getNormalizedValue());
                        return this.approximateMatchingRule.approximatelyMatch(nv1, nv2);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                return false;
            }
            case -87: {
                if (this.assertionValue == null || value == null) {
                    return false;
                }
                if (this.attributeType == null) {
                    if (this.matchingRule == null) {
                        return false;
                    }
                    try {
                        ASN1OctetString nv1 = this.matchingRule.normalizeValue(value.getValue()).toASN1OctetString();
                        ASN1OctetString nv2 = this.matchingRule.normalizeValue(this.assertionValue.getValue()).toASN1OctetString();
                        return this.matchingRule.valuesMatch(nv1, nv2) == ConditionResult.TRUE;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        return false;
                    }
                }
                if (!this.attributeType.equals(type) || this.equalityMatchingRule == null) {
                    return false;
                }
                try {
                    return this.equalityMatchingRule.areEqual(this.assertionValue.getNormalizedValue(), value.getNormalizedValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        switch (this.matchType) {
            case -93: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -92: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("=");
                if (this.subInitial != null) {
                    RawFilter.valueToFilterString(buffer, this.subInitial);
                }
                if (this.subAny != null) {
                    for (ByteString s : this.subAny) {
                        buffer.append("*");
                        RawFilter.valueToFilterString(buffer, s);
                    }
                }
                buffer.append("*");
                if (this.subFinal != null) {
                    RawFilter.valueToFilterString(buffer, this.subFinal);
                }
                buffer.append(")");
                break;
            }
            case -91: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append(">=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -90: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("<=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -121: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("=*)");
                break;
            }
            case -88: {
                buffer.append("(");
                buffer.append(this.rawAttributeType);
                buffer.append("~=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
                break;
            }
            case -87: {
                buffer.append("(");
                if (this.rawAttributeType != null) {
                    buffer.append(this.rawAttributeType);
                }
                if (this.matchingRuleID != null) {
                    buffer.append(":");
                    buffer.append(this.matchingRuleID);
                }
                buffer.append(":=");
                RawFilter.valueToFilterString(buffer, this.rawAssertionValue);
                buffer.append(")");
            }
        }
    }
}

