/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import java.util.HashMap;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.SortKey;

public class SortValuesSet {
    private static final int ENCODED_VALUE_SIZE = 16;
    private static final int ENCODED_VALUE_LENGTH_SIZE = SortValuesSet.encodedLengthSize(16);
    private static final int ENCODED_ATTRIBUTE_VALUE_SIZE = ENCODED_VALUE_LENGTH_SIZE + 16;
    private ID2Entry id2entry;
    private long[] entryIDs;
    private byte[] valuesBytes;
    private byte[] keyBytes;
    private HashMap<EntryID, AttributeValue[]> cachedAttributeValues;
    private VLVIndex vlvIndex;

    public SortValuesSet(VLVIndex vlvIndex, ID2Entry id2entry) {
        this.keyBytes = new byte[0];
        this.entryIDs = null;
        this.valuesBytes = null;
        this.id2entry = id2entry;
        this.vlvIndex = vlvIndex;
        this.cachedAttributeValues = new HashMap();
    }

    public SortValuesSet(byte[] keyBytes, byte[] dataBytes, VLVIndex vlvIndex, ID2Entry id2entry) {
        this.keyBytes = keyBytes;
        this.id2entry = id2entry;
        this.vlvIndex = vlvIndex;
        this.cachedAttributeValues = new HashMap();
        if (dataBytes == null) {
            this.entryIDs = new long[0];
            return;
        }
        this.entryIDs = SortValuesSet.getEncodedIDs(dataBytes, 0);
        this.valuesBytes = new byte[this.entryIDs.length * ENCODED_ATTRIBUTE_VALUE_SIZE * vlvIndex.sortOrder.getSortKeys().length];
        System.arraycopy(dataBytes, this.entryIDs.length * 8 + 4, this.valuesBytes, 0, this.valuesBytes.length);
    }

    private SortValuesSet(long[] entryIDs, byte[] keyBytes, byte[] valuesBytes, VLVIndex vlvIndex, ID2Entry id2entry) {
        this.keyBytes = keyBytes;
        this.id2entry = id2entry;
        this.entryIDs = entryIDs;
        this.valuesBytes = valuesBytes;
        this.vlvIndex = vlvIndex;
        this.cachedAttributeValues = new HashMap();
    }

    public boolean add(long entryID, AttributeValue[] values) throws JebException, DatabaseException, DirectoryException {
        if (values == null) {
            return false;
        }
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            this.entryIDs = new long[1];
            this.entryIDs[0] = entryID;
            this.valuesBytes = this.attributeValuesToDatabase(values);
            return true;
        }
        if (this.vlvIndex.comparator.compareValuesInSet(this, this.entryIDs.length - 1, entryID, values) < 0) {
            long[] updatedEntryIDs = new long[this.entryIDs.length + 1];
            System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, this.entryIDs.length);
            updatedEntryIDs[this.entryIDs.length] = entryID;
            byte[] newValuesBytes = this.attributeValuesToDatabase(values);
            byte[] updatedValuesBytes = new byte[this.valuesBytes.length + newValuesBytes.length];
            System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, this.valuesBytes.length);
            System.arraycopy(newValuesBytes, 0, updatedValuesBytes, this.valuesBytes.length, newValuesBytes.length);
            this.entryIDs = updatedEntryIDs;
            this.valuesBytes = updatedValuesBytes;
            return true;
        }
        int pos = this.binarySearch(entryID, values);
        if (pos >= 0) {
            if (this.entryIDs[pos] == entryID) {
                return false;
            }
        } else {
            pos = -(pos + 1);
        }
        long[] updatedEntryIDs = new long[this.entryIDs.length + 1];
        System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, pos);
        System.arraycopy(this.entryIDs, pos, updatedEntryIDs, pos + 1, this.entryIDs.length - pos);
        updatedEntryIDs[pos] = entryID;
        byte[] newValuesBytes = this.attributeValuesToDatabase(values);
        int valuesPos = pos * newValuesBytes.length;
        byte[] updatedValuesBytes = new byte[this.valuesBytes.length + newValuesBytes.length];
        System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, valuesPos);
        System.arraycopy(this.valuesBytes, valuesPos, updatedValuesBytes, valuesPos + newValuesBytes.length, this.valuesBytes.length - valuesPos);
        System.arraycopy(newValuesBytes, 0, updatedValuesBytes, valuesPos, newValuesBytes.length);
        this.entryIDs = updatedEntryIDs;
        this.valuesBytes = updatedValuesBytes;
        return true;
    }

    public boolean remove(long entryID, AttributeValue[] values) throws JebException, DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return false;
        }
        int pos = this.binarySearch(entryID, values);
        if (pos < 0) {
            return false;
        }
        long[] updatedEntryIDs = new long[this.entryIDs.length - 1];
        System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, pos);
        System.arraycopy(this.entryIDs, pos + 1, updatedEntryIDs, pos, this.entryIDs.length - pos - 1);
        int valuesLength = ENCODED_ATTRIBUTE_VALUE_SIZE * this.vlvIndex.sortOrder.getSortKeys().length;
        int valuesPos = pos * valuesLength;
        byte[] updatedValuesBytes = new byte[this.valuesBytes.length - valuesLength];
        System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, valuesPos);
        System.arraycopy(this.valuesBytes, valuesPos + valuesLength, updatedValuesBytes, valuesPos, this.valuesBytes.length - valuesPos - valuesLength);
        this.entryIDs = updatedEntryIDs;
        this.valuesBytes = updatedValuesBytes;
        return true;
    }

    public SortValuesSet split(int splitLength) {
        long[] splitEntryIDs = new long[splitLength];
        byte[] splitValuesBytes = new byte[splitLength * ENCODED_ATTRIBUTE_VALUE_SIZE * this.vlvIndex.sortOrder.getSortKeys().length];
        long[] updatedEntryIDs = new long[this.entryIDs.length - splitEntryIDs.length];
        System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, updatedEntryIDs.length);
        System.arraycopy(this.entryIDs, updatedEntryIDs.length, splitEntryIDs, 0, splitEntryIDs.length);
        byte[] updatedValuesBytes = new byte[this.valuesBytes.length - splitValuesBytes.length];
        System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, updatedValuesBytes.length);
        System.arraycopy(this.valuesBytes, updatedValuesBytes.length, splitValuesBytes, 0, splitValuesBytes.length);
        SortValuesSet splitValuesSet = new SortValuesSet(splitEntryIDs, this.keyBytes, splitValuesBytes, this.vlvIndex, this.id2entry);
        this.entryIDs = updatedEntryIDs;
        this.valuesBytes = updatedValuesBytes;
        this.keyBytes = null;
        return splitValuesSet;
    }

    public byte[] toDatabase() {
        byte[] entryIDBytes = JebFormat.entryIDListToDatabase(this.entryIDs);
        byte[] concatBytes = new byte[entryIDBytes.length + this.valuesBytes.length + 4];
        int v = this.entryIDs.length;
        for (int j = 3; j >= 0; --j) {
            concatBytes[j] = (byte)(v & 0xFF);
            v >>>= 8;
        }
        System.arraycopy(entryIDBytes, 0, concatBytes, 4, entryIDBytes.length);
        System.arraycopy(this.valuesBytes, 0, concatBytes, entryIDBytes.length + 4, this.valuesBytes.length);
        return concatBytes;
    }

    public static int getEncodedSize(byte[] bytes, int offset) {
        int v = 0;
        for (int i = offset; i < offset + 4; ++i) {
            v <<= 8;
            v |= bytes[i] & 0xFF;
        }
        return v;
    }

    public static long[] getEncodedIDs(byte[] bytes, int offset) {
        int length = SortValuesSet.getEncodedSize(bytes, offset);
        byte[] entryIDBytes = new byte[length * 8];
        System.arraycopy(bytes, offset + 4, entryIDBytes, 0, entryIDBytes.length);
        return JebFormat.entryIDListFromDatabase(entryIDBytes);
    }

    int binarySearch(long entryID, AttributeValue[] values) throws JebException, DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return -1;
        }
        int i = 0;
        int j = this.entryIDs.length - 1;
        while (i <= j) {
            int k = i + j >> 1;
            int l = this.vlvIndex.comparator.compareValuesInSet(this, k, entryID, values);
            if (l < 0) {
                i = k + 1;
                continue;
            }
            if (l > 0) {
                j = k - 1;
                continue;
            }
            return k;
        }
        return -(i + 1);
    }

    public int size() {
        if (this.entryIDs == null) {
            return 0;
        }
        return this.entryIDs.length;
    }

    public long[] getEntryIDs() {
        return this.entryIDs;
    }

    private static int encodedLengthSize(int length) {
        if ((length & 0xFF) == length) {
            return 1;
        }
        if ((length & 0xFFFF) == length) {
            return 2;
        }
        if ((length & 0xFFFFFF) == length) {
            return 3;
        }
        return 4;
    }

    private byte[] attributeValuesToDatabase(AttributeValue[] values) throws DirectoryException {
        byte[] valuesBytes = new byte[values.length * ENCODED_ATTRIBUTE_VALUE_SIZE];
        for (int i = 0; i < values.length; ++i) {
            int length;
            AttributeValue value = values[i];
            byte[] lengthBytes = new byte[ENCODED_VALUE_LENGTH_SIZE];
            if (value == null) {
                length = 0;
            } else {
                byte[] valueBytes = value.getNormalizedValueBytes();
                length = valueBytes.length;
                if (valueBytes.length > 16) {
                    System.arraycopy(valueBytes, 0, valuesBytes, i * ENCODED_ATTRIBUTE_VALUE_SIZE + ENCODED_VALUE_LENGTH_SIZE, 16);
                } else {
                    System.arraycopy(valueBytes, 0, valuesBytes, i * ENCODED_ATTRIBUTE_VALUE_SIZE + ENCODED_VALUE_LENGTH_SIZE, valueBytes.length);
                }
            }
            for (int j = ENCODED_VALUE_LENGTH_SIZE - 1; j >= 0; --j) {
                lengthBytes[j] = (byte)(length & 0xFF);
                length >>>= 8;
            }
            System.arraycopy(lengthBytes, 0, valuesBytes, i * ENCODED_ATTRIBUTE_VALUE_SIZE, lengthBytes.length);
        }
        return valuesBytes;
    }

    public byte[] getKeyBytes() throws JebException, DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return null;
        }
        if (this.keyBytes != null) {
            return this.keyBytes;
        }
        SortKey[] sortKeys = this.vlvIndex.sortOrder.getSortKeys();
        int numValues = sortKeys.length;
        AttributeValue[] values = new AttributeValue[numValues];
        int i = (this.entryIDs.length - 1) * numValues;
        int j = 0;
        while (i < this.entryIDs.length * numValues) {
            values[j] = new AttributeValue(sortKeys[j].getAttributeType(), (ByteString)new ASN1OctetString(this.getValue(i)));
            ++i;
            ++j;
        }
        this.keyBytes = this.vlvIndex.encodeKey(this.entryIDs[this.entryIDs.length - 1], values);
        return this.keyBytes;
    }

    public SortValues getKeySortValues() throws JebException, DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return null;
        }
        if (this.keyBytes != null && this.keyBytes.length == 0) {
            return null;
        }
        EntryID id = new EntryID(this.entryIDs[this.entryIDs.length - 1]);
        SortKey[] sortKeys = this.vlvIndex.sortOrder.getSortKeys();
        int numValues = sortKeys.length;
        AttributeValue[] values = new AttributeValue[numValues];
        int i = (this.entryIDs.length - 1) * numValues;
        int j = 0;
        while (i < this.entryIDs.length * numValues) {
            values[j] = new AttributeValue(sortKeys[j].getAttributeType(), (ByteString)new ASN1OctetString(this.getValue(i)));
            ++i;
            ++j;
        }
        return new SortValues(id, values, this.vlvIndex.sortOrder);
    }

    public SortValues getSortValues(int index) throws JebException, DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return null;
        }
        EntryID id = new EntryID(this.entryIDs[index]);
        SortKey[] sortKeys = this.vlvIndex.sortOrder.getSortKeys();
        int numValues = sortKeys.length;
        AttributeValue[] values = new AttributeValue[numValues];
        int i = index * numValues;
        int j = 0;
        while (i < (index + 1) * numValues) {
            byte[] value = this.getValue(i);
            if (value != null) {
                values[j] = new AttributeValue(sortKeys[j].getAttributeType(), (ByteString)new ASN1OctetString(value));
            }
            ++i;
            ++j;
        }
        return new SortValues(id, values, this.vlvIndex.sortOrder);
    }

    public byte[] getValue(int index) throws JebException, DatabaseException, DirectoryException {
        if (this.valuesBytes != null) {
            int pos = index * ENCODED_ATTRIBUTE_VALUE_SIZE;
            int length = 0;
            int k = 0;
            while (k < ENCODED_VALUE_LENGTH_SIZE) {
                length <<= 8;
                length |= this.valuesBytes[pos] & 0xFF;
                ++k;
                ++pos;
            }
            if (length == 0) {
                return null;
            }
            if (length <= 16 && length > 0) {
                byte[] valueBytes = new byte[length];
                System.arraycopy(this.valuesBytes, pos, valueBytes, 0, length);
                return valueBytes;
            }
        }
        if (this.id2entry == null) {
            return new byte[0];
        }
        EntryID id = new EntryID(this.entryIDs[index / this.vlvIndex.sortOrder.getSortKeys().length]);
        AttributeValue[] values = this.cachedAttributeValues.get(id);
        if (values == null) {
            values = this.vlvIndex.getSortValues(this.id2entry.get(null, id));
            this.cachedAttributeValues.put(id, values);
        }
        int offset = index % values.length;
        return values[offset].getNormalizedValueBytes();
    }
}

