/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.io.DataInputStream;
import java.io.IOException;

public class Longs {
    private long[] array = null;
    private int count = 0;

    void decode(byte[] bytes) {
        if (bytes == null) {
            this.count = 0;
            return;
        }
        int count = bytes.length / 8;
        this.resize(count);
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            long v = 0L;
            v |= ((long)bytes[pos++] & 0xFFL) << 56;
            v |= ((long)bytes[pos++] & 0xFFL) << 48;
            v |= ((long)bytes[pos++] & 0xFFL) << 40;
            v |= ((long)bytes[pos++] & 0xFFL) << 32;
            v |= ((long)bytes[pos++] & 0xFFL) << 24;
            v |= ((long)bytes[pos++] & 0xFFL) << 16;
            v |= ((long)bytes[pos++] & 0xFFL) << 8;
            this.array[i] = v |= (long)bytes[pos++] & 0xFFL;
        }
        this.count = count;
    }

    public int encodedSize() {
        return this.count * 8;
    }

    byte[] encode(byte[] bytes) {
        int encodedSize = this.encodedSize();
        if (bytes == null || bytes.length < encodedSize) {
            bytes = new byte[encodedSize];
        }
        int pos = 0;
        for (int i = 0; i < this.count; ++i) {
            long v = this.array[i];
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }

    private static int binarySearch(long[] a, int count, long key) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean add(long v) {
        this.resize(this.count + 1);
        if (this.count == 0 || v > this.array[this.count - 1]) {
            this.array[this.count++] = v;
            return true;
        }
        int pos = Longs.binarySearch(this.array, this.count, v);
        if (pos >= 0) {
            return false;
        }
        pos = -(pos + 1);
        System.arraycopy(this.array, pos, this.array, pos + 1, this.count - pos);
        this.array[pos] = v;
        ++this.count;
        return true;
    }

    public void addAll(Longs that) {
        int bRemain;
        this.resize(this.count + that.count);
        if (that.count == 0) {
            return;
        }
        if (this.count == 0 || that.array[0] > this.array[this.count - 1]) {
            System.arraycopy(that.array, 0, this.array, this.count, that.count);
            this.count += that.count;
            return;
        }
        if (this.array[0] > that.array[that.count - 1]) {
            System.arraycopy(this.array, 0, this.array, that.count, this.count);
            System.arraycopy(that.array, 0, this.array, 0, that.count);
            this.count += that.count;
            return;
        }
        int destPos = Longs.binarySearch(this.array, this.count, that.array[0]);
        if (destPos < 0) {
            destPos = -(destPos + 1);
        }
        int aCount = this.count - destPos;
        int aPos = destPos + that.count;
        int aEnd = aPos + aCount;
        System.arraycopy(this.array, destPos, this.array, aPos, aCount);
        if (this.array[aPos] > that.array[that.count - 1]) {
            System.arraycopy(that.array, 0, this.array, destPos, that.count);
            this.count += that.count;
            return;
        }
        int bPos = 0;
        while (aPos < aEnd && bPos < that.count) {
            if (this.array[aPos] < that.array[bPos]) {
                this.array[destPos++] = this.array[aPos++];
                continue;
            }
            if (this.array[aPos] > that.array[bPos]) {
                this.array[destPos++] = that.array[bPos++];
                continue;
            }
            this.array[destPos++] = this.array[aPos++];
            ++bPos;
        }
        int aRemain = aEnd - aPos;
        if (aRemain > 0) {
            System.arraycopy(this.array, aPos, this.array, destPos, aRemain);
            destPos += aRemain;
        }
        if ((bRemain = that.count - bPos) > 0) {
            System.arraycopy(that.array, bPos, this.array, destPos, bRemain);
            destPos += bRemain;
        }
        this.count = destPos;
    }

    public void deleteAll(Longs that) {
        int destPos = 0;
        int thisPos = 0;
        int thatPos = 0;
        while (thisPos < this.count && thatPos < that.count) {
            if (this.array[thisPos] < that.array[thatPos]) {
                this.array[destPos++] = this.array[thisPos++];
                continue;
            }
            if (this.array[thisPos] > that.array[thatPos]) {
                ++thatPos;
                continue;
            }
            ++thisPos;
            ++thatPos;
        }
        System.arraycopy(this.array, thisPos, this.array, destPos, this.count - thisPos);
        this.count = destPos += this.count - thisPos;
    }

    public int size() {
        return this.count;
    }

    public void decode(DataInputStream dataInputStream) throws IOException {
        int len = dataInputStream.readInt();
        int count = len / 8;
        this.resize(count);
        for (int i = 0; i < count; ++i) {
            this.array[i] = dataInputStream.readLong();
        }
        this.count = count;
    }

    private void resize(int size) {
        if (this.array == null) {
            this.array = new long[size];
        } else if (this.array.length < size) {
            int newSize;
            int n = newSize = this.array.length == 0 ? 1 : this.array.length;
            while ((newSize *= 2) < size) {
            }
            long[] newBytes = new long[newSize];
            System.arraycopy(this.array, 0, newBytes, 0, this.count);
            this.array = newBytes;
        }
    }

    public void clear() {
        this.count = 0;
    }

    public long[] toArray() {
        long[] dst = new long[this.count];
        System.arraycopy(this.array, 0, dst, 0, this.count);
        return dst;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.count);
        if (this.count > 0) {
            b.append('[');
            b.append(this.array[0]);
            if (this.count > 1) {
                b.append(':');
                b.append(this.array[this.count - 1]);
            }
            b.append(']');
        }
        return b.toString();
    }
}

