/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.DN2URI;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

public class IndexRebuildThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    EntryContainer ec = null;
    IndexType indexType = null;
    AttributeIndex attrIndex = null;
    VLVIndex vlvIndex = null;
    Index index = null;
    ID2Entry id2entry = null;
    long totalEntries = -1L;
    long processedEntries = 0L;
    long rebuiltEntries = 0L;
    long duplicatedEntries = 0L;
    long skippedEntries = 0L;

    IndexRebuildThread(EntryContainer ec, IndexType index) {
        super("Index Rebuild Thread " + ec.getDatabasePrefix() + "_" + index.toString());
        this.ec = ec;
        this.indexType = index;
        this.id2entry = ec.getID2Entry();
    }

    IndexRebuildThread(EntryContainer ec, Index index) {
        super("Index Rebuild Thread " + index.getName());
        this.ec = ec;
        this.indexType = IndexType.INDEX;
        this.index = index;
        this.id2entry = ec.getID2Entry();
    }

    IndexRebuildThread(EntryContainer ec, AttributeIndex index) {
        super("Index Rebuild Thread " + index.getName());
        this.ec = ec;
        this.indexType = IndexType.ATTRIBUTEINDEX;
        this.attrIndex = index;
        this.id2entry = ec.getID2Entry();
    }

    IndexRebuildThread(EntryContainer ec, VLVIndex vlvIndex) {
        super("Index Rebuild Thread " + vlvIndex.getName());
        this.ec = ec;
        this.indexType = IndexType.VLVINDEX;
        this.vlvIndex = vlvIndex;
        this.id2entry = ec.getID2Entry();
    }

    public void clearDatabase() throws DatabaseException {
        if (this.indexType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugError("No index type specified. Rebuild process terminated.");
            }
            return;
        }
        if (this.indexType == IndexType.ATTRIBUTEINDEX && this.attrIndex == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugError("No attribute index specified. Rebuild process terminated.");
            }
            return;
        }
        if (this.indexType == IndexType.INDEX && this.index == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugError("No index specified. Rebuild process terminated.");
            }
            return;
        }
        if (this.indexType == IndexType.VLVINDEX && this.vlvIndex == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugError("No VLV index specified. Rebuild process terminated.");
            }
            return;
        }
        switch (this.indexType) {
            case DN2ID: {
                this.ec.clearDatabase(this.ec.getDN2ID());
                break;
            }
            case DN2URI: {
                this.ec.clearDatabase(this.ec.getDN2URI());
                break;
            }
            case ID2CHILDREN: {
                this.ec.clearDatabase(this.ec.getID2Children());
                this.ec.getID2Children().setRebuildStatus(true);
                break;
            }
            case ID2SUBTREE: {
                this.ec.clearDatabase(this.ec.getID2Subtree());
                this.ec.getID2Subtree().setRebuildStatus(true);
                break;
            }
            case ATTRIBUTEINDEX: {
                this.ec.clearAttributeIndex(this.attrIndex);
                this.attrIndex.setRebuildStatus(true);
                break;
            }
            case VLVINDEX: {
                this.ec.clearDatabase(this.vlvIndex);
                this.vlvIndex.setRebuildStatus(true);
                break;
            }
            case INDEX: {
                this.ec.clearDatabase(this.index);
                this.index.setRebuildStatus(true);
            }
        }
    }

    public void run() {
        block20: {
            if (this.indexType == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("No index type specified. Rebuild process terminated.");
                }
                return;
            }
            if (this.indexType == IndexType.ATTRIBUTEINDEX && this.attrIndex == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("No attribute index specified. Rebuild process terminated.");
                }
                return;
            }
            if (this.indexType == IndexType.INDEX && this.index == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("No index specified. Rebuild process terminated.");
                }
                return;
            }
            if (this.indexType == IndexType.VLVINDEX && this.vlvIndex == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("No VLV index specified. Rebuild process terminated.");
                }
                return;
            }
            try {
                this.totalEntries = this.getTotalEntries();
                switch (this.indexType) {
                    case DN2ID: {
                        this.rebuildDN2ID();
                        break;
                    }
                    case DN2URI: {
                        this.rebuildDN2URI();
                        break;
                    }
                    case ID2CHILDREN: {
                        this.rebuildID2Children();
                        break;
                    }
                    case ID2SUBTREE: {
                        this.rebuildID2Subtree();
                        break;
                    }
                    case ATTRIBUTEINDEX: {
                        this.rebuildAttributeIndex(this.attrIndex);
                        break;
                    }
                    case VLVINDEX: {
                        this.rebuildVLVIndex(this.vlvIndex);
                        break;
                    }
                    case INDEX: {
                        this.rebuildAttributeIndex(this.index);
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("Rebuilt %d entries", this.rebuiltEntries);
                }
            }
            catch (Exception e) {
                Message message = JebMessages.ERR_JEB_REBUILD_INDEX_FAILED.get(this.getName(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                if (!DebugLogger.debugEnabled()) break block20;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildDN2ID() throws DatabaseException {
        DN2ID dn2id = this.ec.getDN2ID();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Initiating rebuild of the %s database", dn2id.getName());
            TRACER.debugVerbose("%d entries will be rebuilt", this.totalEntries);
        }
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block10: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        EntryID entryID = new EntryID(key);
                        Entry entry = JebFormat.entryFromDatabase(data.getData());
                        if (dn2id.insert(txn, entry.getDN(), entryID)) {
                            ++this.rebuiltEntries;
                        } else {
                            ++this.duplicatedEntries;
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the DN2ID database because it already exists.", entry.getDN().toString(), entryID.longValue());
                            }
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(dn2id.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildDN2URI() throws DatabaseException {
        DN2URI dn2uri = this.ec.getDN2URI();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Initiating rebuild of the %s database", dn2uri.getName());
            TRACER.debugVerbose("%d entries will be rebuilt", this.totalEntries);
        }
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block10: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        EntryID entryID = new EntryID(key);
                        Entry entry = JebFormat.entryFromDatabase(data.getData());
                        if (dn2uri.addEntry(txn, entry)) {
                            ++this.rebuiltEntries;
                        } else {
                            ++this.duplicatedEntries;
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the DN2URI database because it already exists.", entry.getDN().toString(), entryID.longValue());
                            }
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(dn2uri.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildID2Children() throws DatabaseException {
        Index id2children = this.ec.getID2Children();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Initiating rebuild of the %s index", id2children.getName());
            TRACER.debugVerbose("%d entries will be rebuilt", this.totalEntries);
        }
        DN2ID dn2id = this.ec.getDN2ID();
        DN2URI dn2uri = this.ec.getDN2URI();
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block11: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        block13: {
                            block12: {
                                EntryID entryID = new EntryID(key);
                                Entry entry = JebFormat.entryFromDatabase(data.getData());
                                DN parentDN = this.ec.getParentWithinBase(entry.getDN());
                                if (parentDN == null) break block12;
                                dn2uri.targetEntryReferrals(entry.getDN(), null);
                                EntryID parentID = dn2id.get(txn, parentDN);
                                if (parentID == null) {
                                    Message msg = JebMessages.ERR_JEB_MISSING_DN2ID_RECORD.get(parentDN.toNormalizedString());
                                    throw new JebException(msg);
                                }
                                if (id2children.insertID(txn, parentID.getDatabaseEntry(), entryID)) {
                                    ++this.rebuiltEntries;
                                    break block13;
                                } else if (DebugLogger.debugEnabled()) {
                                    ++this.duplicatedEntries;
                                    TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the DN2Subtree database because it already exists.", entry.getDN().toString(), entryID.longValue());
                                }
                                break block13;
                            }
                            ++this.skippedEntries;
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(id2children.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block11;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
            id2children.setRebuildStatus(false);
            id2children.setTrusted(null, true);
            return;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildID2Subtree() throws DatabaseException {
        Index id2subtree = this.ec.getID2Subtree();
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Initiating rebuild of the %s index", id2subtree.getName());
            TRACER.debugVerbose("%d entries will be rebuilt", this.totalEntries);
        }
        DN2ID dn2id = this.ec.getDN2ID();
        DN2URI dn2uri = this.ec.getDN2URI();
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block19: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        EntryID entryID = new EntryID(key);
                        Entry entry = JebFormat.entryFromDatabase(data.getData());
                        DN parentDN = this.ec.getParentWithinBase(entry.getDN());
                        if (parentDN != null) {
                            boolean success = true;
                            dn2uri.targetEntryReferrals(entry.getDN(), null);
                            EntryID parentID = dn2id.get(txn, parentDN);
                            if (parentID != null) {
                                if (!id2subtree.insertID(txn, parentID.getDatabaseEntry(), entryID)) {
                                    success = false;
                                }
                                DN dn = this.ec.getParentWithinBase(parentDN);
                                while (dn != null) {
                                    EntryID nodeID = dn2id.get(null, dn);
                                    if (nodeID != null) {
                                        if (!id2subtree.insertID(null, nodeID.getDatabaseEntry(), entryID)) {
                                            success = false;
                                        }
                                    } else {
                                        Message msg = JebMessages.ERR_JEB_MISSING_DN2ID_RECORD.get(dn.toNormalizedString());
                                        throw new JebException(msg);
                                    }
                                    dn = this.ec.getParentWithinBase(dn);
                                }
                            } else {
                                Message msg = JebMessages.ERR_JEB_MISSING_DN2ID_RECORD.get(parentDN.toNormalizedString());
                                throw new JebException(msg);
                            }
                            if (success) {
                                ++this.rebuiltEntries;
                            } else if (DebugLogger.debugEnabled()) {
                                ++this.duplicatedEntries;
                                TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the DN2Subtree database because it already exists.", entry.getDN().toString(), entryID.longValue());
                            }
                        } else {
                            ++this.skippedEntries;
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(id2subtree.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block19;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
            id2subtree.setRebuildStatus(false);
            id2subtree.setTrusted(null, true);
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildAttributeIndex(AttributeIndex index) throws DatabaseException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Initiating rebuild of the %s index", index.getName());
            TRACER.debugVerbose("%d entries will be rebuilt", this.totalEntries);
        }
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block10: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        EntryID entryID = new EntryID(key);
                        Entry entry = JebFormat.entryFromDatabase(data.getData());
                        if (index.addEntry(txn, entryID, entry)) {
                            ++this.rebuiltEntries;
                        } else if (DebugLogger.debugEnabled()) {
                            ++this.duplicatedEntries;
                            TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the DN2Subtree database because it already exists.", entry.getDN().toString(), entryID.longValue());
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(index.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
            index.setRebuildStatus(false);
            index.setTrusted(null, true);
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildVLVIndex(VLVIndex vlvIndex) throws DatabaseException {
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block9: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        EntryID entryID = new EntryID(key);
                        Entry entry = JebFormat.entryFromDatabase(data.getData());
                        if (vlvIndex.addEntry(txn, entryID, entry)) {
                            ++this.rebuiltEntries;
                        } else if (DebugLogger.debugEnabled()) {
                            ++this.duplicatedEntries;
                            TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the VLV index %s because it already exists.", entry.getDN().toString(), entryID.longValue(), vlvIndex.getName());
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(this.index.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block9;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
            vlvIndex.setRebuildStatus(false);
            vlvIndex.setTrusted(null, true);
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildAttributeIndex(Index index) throws DatabaseException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Initiating rebuild of the %s attribute index", index.getName());
            TRACER.debugVerbose("%d entries will be rebuilt", this.totalEntries);
        }
        Cursor cursor = this.id2entry.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                block10: {
                    Transaction txn = this.ec.beginTransaction();
                    try {
                        EntryID entryID = new EntryID(key);
                        Entry entry = JebFormat.entryFromDatabase(data.getData());
                        if (index.addEntry(txn, entryID, entry)) {
                            ++this.rebuiltEntries;
                        } else if (DebugLogger.debugEnabled()) {
                            ++this.duplicatedEntries;
                            TRACER.debugInfo("Unable to insert entry with DN %s and ID %d into the DN2Subtree database because it already exists.", entry.getDN().toString(), entryID.longValue());
                        }
                        EntryContainer.transactionCommit(txn);
                        ++this.processedEntries;
                    }
                    catch (Exception e) {
                        EntryContainer.transactionAbort(txn);
                        ++this.skippedEntries;
                        Message message = JebMessages.ERR_JEB_REBUILD_INSERT_ENTRY_FAILED.get(index.getName(), StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message);
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                status = cursor.getNext(key, data, lockMode);
            }
            index.setRebuildStatus(false);
            index.setTrusted(null, true);
        }
        finally {
            cursor.close();
        }
    }

    public long getTotalEntries() throws DatabaseException {
        if (this.totalEntries < 0L) {
            this.totalEntries = this.id2entry.getRecordCount();
        }
        return this.totalEntries;
    }

    public long getProcessedEntries() {
        return this.processedEntries;
    }

    public long getRebuiltEntries() {
        return this.rebuiltEntries;
    }

    public long getDuplicatedEntries() {
        return this.duplicatedEntries;
    }

    public long getSkippedEntries() {
        return this.skippedEntries;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IndexType {
        DN2ID,
        DN2URI,
        ID2CHILDREN,
        ID2SUBTREE,
        INDEX,
        ATTRIBUTEINDEX,
        VLVINDEX;

    }
}

