/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID2SIndexer
extends Indexer {
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();

    public String toString() {
        return "id2subtree";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction txn, Entry entry, Set<ASN1OctetString> addKeys) throws DatabaseException {
        ArrayList ids = (ArrayList)entry.getAttachment();
        Iterator iter = ids.iterator();
        iter.next();
        while (iter.hasNext()) {
            DatabaseEntry nodeIDData = ((EntryID)iter.next()).getDatabaseEntry();
            addKeys.add(new ASN1OctetString(nodeIDData.getData()));
        }
    }

    @Override
    public void replaceEntry(Transaction txn, Entry oldEntry, Entry newEntry, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
    }

    @Override
    public void modifyEntry(Transaction txn, Entry oldEntry, Entry newEntry, List<Modification> mods, Set<ASN1OctetString> addKeys, Set<ASN1OctetString> delKeys) throws DatabaseException {
    }
}

