/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.IDSetIterator;
import org.opends.server.backends.jeb.JebFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryIDSet
implements Iterable<EntryID> {
    private long[] values = null;
    private byte[] keyBytes = null;

    public EntryIDSet() {
        this.values = null;
    }

    public EntryIDSet(byte[] keyBytes, byte[] bytes) {
        this.keyBytes = keyBytes;
        if (bytes == null) {
            this.values = new long[0];
            return;
        }
        this.values = JebFormat.entryIDListFromDatabase(bytes);
    }

    EntryIDSet(long[] values, int pos, int len) {
        this.values = new long[len];
        System.arraycopy(values, pos, this.values, 0, len);
    }

    public static EntryIDSet unionOfSets(ArrayList<EntryIDSet> sets, boolean allowDuplicates) {
        boolean needSort = false;
        int count = 0;
        for (EntryIDSet l : sets) {
            if (!l.isDefined()) {
                return new EntryIDSet();
            }
            count += l.size();
        }
        long[] n = new long[count];
        int pos = 0;
        for (EntryIDSet l : sets) {
            if (l.values.length == 0) continue;
            if (!needSort && pos > 0 && l.values[0] < n[pos - 1]) {
                needSort = true;
            }
            System.arraycopy(l.values, 0, n, pos, l.values.length);
            pos += l.values.length;
        }
        if (needSort) {
            Arrays.sort(n);
        }
        if (allowDuplicates) {
            EntryIDSet ret = new EntryIDSet();
            ret.values = n;
            return ret;
        }
        long[] n1 = new long[n.length];
        long last = -1L;
        int j = 0;
        for (int i = 0; i < n.length; ++i) {
            if (n[i] == last) continue;
            int n2 = j++;
            long l = n[i];
            n1[n2] = l;
            last = l;
        }
        if (j == n1.length) {
            EntryIDSet ret = new EntryIDSet();
            ret.values = n1;
            return ret;
        }
        return new EntryIDSet(n1, 0, j);
    }

    public int size() {
        if (this.values == null) {
            return Integer.MAX_VALUE;
        }
        return this.values.length;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(16);
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        if (!this.isDefined()) {
            if (this.keyBytes != null) {
                buffer.append("[LIMIT-EXCEEDED]");
            } else {
                buffer.append("[NOT-INDEXED]");
            }
        } else {
            buffer.append("[COUNT:");
            buffer.append(this.size());
            buffer.append("]");
        }
    }

    public boolean isDefined() {
        return this.values != null;
    }

    public byte[] toDatabase() {
        return JebFormat.entryIDListToDatabase(this.values);
    }

    public boolean add(EntryID entryID) {
        if (this.values == null) {
            return false;
        }
        long id = entryID.longValue();
        if (this.values.length == 0) {
            this.values = new long[1];
            this.values[0] = id;
            return true;
        }
        if (id > this.values[this.values.length - 1]) {
            long[] updatedValues = new long[this.values.length + 1];
            System.arraycopy(this.values, 0, updatedValues, 0, this.values.length);
            updatedValues[this.values.length] = id;
            this.values = updatedValues;
        } else {
            int pos = Arrays.binarySearch(this.values, id);
            if (pos >= 0) {
                return false;
            }
            pos = -(pos + 1);
            long[] updatedValues = new long[this.values.length + 1];
            System.arraycopy(this.values, 0, updatedValues, 0, pos);
            System.arraycopy(this.values, pos, updatedValues, pos + 1, this.values.length - pos);
            updatedValues[pos] = id;
            this.values = updatedValues;
        }
        return true;
    }

    public boolean remove(EntryID entryID) {
        if (this.values == null) {
            return false;
        }
        if (this.values.length == 0) {
            return false;
        }
        long id = entryID.longValue();
        int pos = Arrays.binarySearch(this.values, id);
        if (pos < 0) {
            return false;
        }
        long[] updatedValues = new long[this.values.length - 1];
        System.arraycopy(this.values, 0, updatedValues, 0, pos);
        System.arraycopy(this.values, pos + 1, updatedValues, pos, this.values.length - pos - 1);
        this.values = updatedValues;
        return true;
    }

    public boolean contains(EntryID entryID) {
        if (this.values == null) {
            return true;
        }
        long id = entryID.longValue();
        if (this.values.length == 0) {
            return false;
        }
        if (id > this.values[this.values.length - 1]) {
            return false;
        }
        int pos = Arrays.binarySearch(this.values, id);
        return pos >= 0;
    }

    public void retainAll(EntryIDSet that) {
        if (!this.isDefined()) {
            this.values = that.values;
            return;
        }
        if (!that.isDefined()) {
            return;
        }
        long[] a = this.values;
        long[] b = that.values;
        int ai = 0;
        int bi = 0;
        int ci = 0;
        long[] c = new long[Math.min(a.length, b.length)];
        while (ai < a.length && bi < b.length) {
            if (a[ai] == b[bi]) {
                c[ci] = a[ai];
                ++ai;
                ++bi;
                ++ci;
                continue;
            }
            if (a[ai] > b[bi]) {
                ++bi;
                continue;
            }
            ++ai;
        }
        if (ci < c.length) {
            long[] results = new long[ci];
            System.arraycopy(c, 0, results, 0, ci);
            this.values = results;
        } else {
            this.values = c;
        }
    }

    public void addAll(EntryIDSet that) {
        int bRemain;
        long[] n;
        if (!this.isDefined()) {
            return;
        }
        if (!that.isDefined()) {
            this.values = null;
            return;
        }
        long[] a = this.values;
        long[] b = that.values;
        if (a.length == 0) {
            this.values = b;
            return;
        }
        if (b.length == 0) {
            return;
        }
        if (b[0] > a[a.length - 1]) {
            long[] n2 = new long[a.length + b.length];
            System.arraycopy(a, 0, n2, 0, a.length);
            System.arraycopy(b, 0, n2, a.length, b.length);
            this.values = n2;
            return;
        }
        if (a[0] > b[b.length - 1]) {
            long[] n3 = new long[a.length + b.length];
            System.arraycopy(b, 0, n3, 0, b.length);
            System.arraycopy(a, 0, n3, b.length, a.length);
            this.values = n3;
            return;
        }
        if (b.length < a.length) {
            n = a;
            a = b;
            b = n;
        }
        n = new long[a.length + b.length];
        int ni = 0;
        int ai = 0;
        int bi = 0;
        while (ai < a.length && bi < b.length) {
            if (a[ai] < b[bi]) {
                n[ni++] = a[ai++];
                continue;
            }
            if (b[bi] < a[ai]) {
                n[ni++] = b[bi++];
                continue;
            }
            n[ni++] = a[ai];
            ++ai;
            ++bi;
        }
        int aRemain = a.length - ai;
        if (aRemain > 0) {
            System.arraycopy(a, ai, n, ni, aRemain);
            ni += aRemain;
        }
        if ((bRemain = b.length - bi) > 0) {
            System.arraycopy(b, bi, n, ni, bRemain);
            ni += bRemain;
        }
        if (ni < n.length) {
            long[] results = new long[ni];
            System.arraycopy(n, 0, results, 0, ni);
            this.values = results;
        } else {
            this.values = n;
        }
    }

    public void deleteAll(EntryIDSet that) {
        if (!this.isDefined()) {
            return;
        }
        if (!that.isDefined()) {
            this.values = null;
            return;
        }
        long[] a = this.values;
        long[] b = that.values;
        if (a.length == 0 || b.length == 0) {
            return;
        }
        if (b[0] > a[a.length - 1]) {
            return;
        }
        if (a[0] > b[b.length - 1]) {
            return;
        }
        long[] n = new long[a.length];
        int ni = 0;
        int ai = 0;
        int bi = 0;
        while (ai < a.length && bi < b.length) {
            if (a[ai] < b[bi]) {
                n[ni++] = a[ai++];
                continue;
            }
            if (b[bi] < a[ai]) {
                ++bi;
                continue;
            }
            ++ai;
            ++bi;
        }
        System.arraycopy(a, ai, n, ni, a.length - ai);
        if ((ni += a.length - ai) < a.length) {
            long[] results = new long[ni];
            System.arraycopy(n, 0, results, 0, ni);
            this.values = results;
        } else {
            this.values = n;
        }
    }

    @Override
    public Iterator<EntryID> iterator() {
        if (this.values == null) {
            return new IDSetIterator(new long[0]);
        }
        return new IDSetIterator(this.values);
    }

    public Iterator<EntryID> iterator(EntryID begin) {
        if (this.values == null) {
            return new IDSetIterator(new long[0]);
        }
        return new IDSetIterator(this.values, begin);
    }
}

