/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.protocols.asn1.ASN1OctetString;

public class BufferedIndex {
    private Index index;
    private Transaction txn;
    private HashMap<ASN1OctetString, BufferedValue> values;

    public BufferedIndex(Index index, Transaction txn) {
        this.index = index;
        this.txn = txn;
        this.values = new LinkedHashMap<ASN1OctetString, BufferedValue>();
    }

    public EntryIDSet get(byte[] key) {
        return this.getCachedValue((byte[])key).value;
    }

    private BufferedValue getCachedValue(byte[] key) {
        BufferedValue bufferedValue = this.values.get(new ASN1OctetString(key));
        if (bufferedValue == null) {
            bufferedValue = new BufferedValue();
            bufferedValue.value = this.index.readKey(new DatabaseEntry(key), this.txn, LockMode.RMW);
            bufferedValue.isDirty = false;
            this.values.put(new ASN1OctetString(key), bufferedValue);
        }
        return bufferedValue;
    }

    public void insertID(int entryLimit, byte[] key, EntryID entryID) {
        BufferedValue bufferedValue = this.getCachedValue(key);
        EntryIDSet entryIDList = bufferedValue.value;
        if (entryIDList.isDefined()) {
            if (entryLimit > 0 && entryIDList.size() >= entryLimit) {
                bufferedValue.value = new EntryIDSet();
                bufferedValue.isDirty = true;
            } else {
                bufferedValue.isDirty = entryIDList.add(entryID);
            }
        }
    }

    public void removeID(byte[] key, EntryID entryID) {
        BufferedValue bufferedValue = this.getCachedValue(key);
        bufferedValue.isDirty = bufferedValue.value.remove(entryID);
    }

    public void remove(byte[] key) {
        BufferedValue bufferedValue = this.getCachedValue(key);
        bufferedValue.value = new EntryIDSet(key, null);
        bufferedValue.isDirty = true;
    }

    public void flush() throws DatabaseException {
        for (Map.Entry<ASN1OctetString, BufferedValue> hashEntry : this.values.entrySet()) {
            BufferedValue bufferedValue = hashEntry.getValue();
            if (!bufferedValue.isDirty) continue;
            this.index.writeKey(this.txn, new DatabaseEntry(hashEntry.getKey().value()), bufferedValue.value);
            bufferedValue.isDirty = false;
        }
    }

    private class BufferedValue {
        EntryIDSet value;
        boolean isDirty;

        private BufferedValue() {
        }
    }
}

