/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.RunRecoveryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.opends.messages.BackendMessages;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.JEBackendCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.BackupManager;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EnvManager;
import org.opends.server.backends.jeb.ExportJob;
import org.opends.server.backends.jeb.ImportJob;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.jeb.RebuildJob;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.backends.jeb.VerifyJob;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.DatabaseEnvironmentMonitor;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendImpl
extends Backend
implements ConfigurationChangeListener<JEBackendCfg>,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.BackendImpl";
    private JEBackendCfg cfg;
    private RootContainer rootContainer;
    private AtomicInteger threadTotalCount = new AtomicInteger(0);
    private AtomicInteger threadWriteCount = new AtomicInteger(0);
    private ArrayList<MonitorProvider> monitorProviders = new ArrayList();
    private static HashSet<String> supportedControls = new HashSet();

    private void readerBegin() {
        this.threadTotalCount.getAndIncrement();
    }

    private void readerEnd() {
        this.threadTotalCount.getAndDecrement();
    }

    private void writerBegin() {
        this.threadTotalCount.getAndIncrement();
        this.threadWriteCount.getAndIncrement();
    }

    private void writerEnd() {
        this.threadWriteCount.getAndDecrement();
        this.threadTotalCount.getAndDecrement();
    }

    private void waitUntilQuiescent() {
        while (this.threadTotalCount.get() > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checksumDbEnv() {
        File backendDirectory = StaticUtils.getFileForPath(this.cfg.getBackendDirectory());
        List<Object> jdbFiles = new ArrayList();
        if (backendDirectory.isDirectory()) {
            jdbFiles = Arrays.asList(backendDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jdb");
                }
            }));
        }
        if (!jdbFiles.isEmpty()) {
            Collections.sort(jdbFiles, Collections.reverseOrder());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(((File)jdbFiles.get(0)).toString());
                CheckedInputStream cis = new CheckedInputStream(fis, new Adler32());
                byte[] tempBuf = new byte[8192];
                while (cis.read(tempBuf) >= 0) {
                }
                long l = cis.getChecksum().getValue();
                return l;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            finally {
                block17: {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block17;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        return 0L;
    }

    public static String getContainerName(DN dn) {
        String normStr = dn.toNormalizedString();
        StringBuilder builder = new StringBuilder(normStr.length());
        for (int i = 0; i < normStr.length(); ++i) {
            char ch = normStr.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }

    @Override
    public void configureBackend(Configuration cfg) throws ConfigException {
        Validator.ensureNotNull(cfg);
        Validator.ensureTrue(cfg instanceof JEBackendCfg);
        this.cfg = (JEBackendCfg)cfg;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        DirectoryServer.registerOfflineBackendStateID(this.getBackendID(), this.checksumDbEnv());
        if (this.rootContainer == null) {
            EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
            this.initializeRootContainer(envConfig);
        }
        this.rootContainer.preload(this.cfg.getBackendPreloadTimeLimit());
        try {
            Message message = JebMessages.NOTE_JEB_BACKEND_STARTED.get(this.cfg.getBackendId(), this.rootContainer.getEntryCount());
            ErrorLogger.logError(message);
        }
        catch (DatabaseException databaseException) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, databaseException);
            }
            Message message = JebMessages.WARN_JEB_GET_ENTRY_COUNT_FAILED.get(databaseException.getMessage());
            throw new InitializationException(message, (Throwable)databaseException);
        }
        for (DN dn : this.cfg.getBackendBaseDN()) {
            try {
                DirectoryServer.registerBaseDN(dn, this, false, false);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(String.valueOf(dn), String.valueOf(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        DatabaseEnvironmentMonitor monitorProvider = this.rootContainer.getMonitorProvider();
        this.monitorProviders.add(monitorProvider);
        DirectoryServer.registerMonitorProvider(monitorProvider);
        DirectoryServer.registerAlertGenerator(this);
        this.cfg.addJEChangeListener(this);
    }

    @Override
    public void finalizeBackend() {
        this.cfg.removeJEChangeListener(this);
        for (DN dn : this.rootContainer.getBaseDNs()) {
            try {
                DirectoryServer.deregisterBaseDN(dn, false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (MonitorProvider monitor : this.monitorProviders) {
            DirectoryServer.deregisterMonitorProvider(monitor.getMonitorInstanceName().toLowerCase());
        }
        this.monitorProviders = new ArrayList();
        this.waitUntilQuiescent();
        try {
            this.rootContainer.close();
            this.rootContainer = null;
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_DATABASE_EXCEPTION.get(e.getMessage());
            ErrorLogger.logError(message);
        }
        DirectoryServer.registerOfflineBackendStateID(this.getBackendID(), this.checksumDbEnv());
        DirectoryServer.deregisterAlertGenerator(this);
        this.threadTotalCount.set(0);
        this.threadWriteCount.set(0);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public boolean supportsLDIFImport() {
        return true;
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    public HashSet<String> getSupportedFeatures() {
        return new HashSet<String>();
    }

    public HashSet<String> getSupportedControls() {
        return supportedControls;
    }

    @Override
    public DN[] getBaseDNs() {
        SortedSet<DN> dnSet = this.cfg.getBackendBaseDN();
        DN[] baseDNs = new DN[dnSet.size()];
        return dnSet.toArray(baseDNs);
    }

    @Override
    public long getEntryCount() {
        block3: {
            if (this.rootContainer != null) {
                try {
                    return this.rootContainer.getEntryCount();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return -1L;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        Entry entry;
        this.readerBegin();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            entry = ec.getEntry(entryDN);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
        return entry;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        this.writerBegin();
        DN entryDN = entry.getDN();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.addEntry(entry, addOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        this.writerBegin();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.deleteEntry(entryDN, deleteOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        this.writerBegin();
        DN entryDN = entry.getDN();
        EntryContainer ec = this.rootContainer.getEntryContainer(entryDN);
        ec.sharedLock.lock();
        try {
            ec.replaceEntry(entry, modifyOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            ec.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException, CancelledOperationException {
        this.writerBegin();
        EntryContainer currentContainer = this.rootContainer.getEntryContainer(currentDN);
        EntryContainer container = this.rootContainer.getEntryContainer(entry.getDN());
        if (currentContainer != container) {
            Message msg = JebMessages.WARN_JEB_FUNCTION_NOT_SUPPORTED.get();
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        try {
            currentContainer.sharedLock.lock();
            currentContainer.renameEntry(currentDN, entry, modifyDNOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            currentContainer.sharedLock.unlock();
            this.writerEnd();
        }
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        this.readerBegin();
        EntryContainer ec = this.rootContainer.getEntryContainer(searchOperation.getBaseDN());
        ec.sharedLock.lock();
        try {
            ec.search(searchOperation);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_DATABASE_EXCEPTION.get(e.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        finally {
            ec.sharedLock.unlock();
            this.readerEnd();
        }
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        boolean openRootContainer = this.rootContainer == null;
        try {
            if (openRootContainer) {
                EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
                envConfig.setReadOnly(true);
                envConfig.setAllowCreate(false);
                envConfig.setTransactional(false);
                envConfig.setTxnNoSync(false);
                envConfig.setConfigParam("je.env.isLocking", "true");
                envConfig.setConfigParam("je.env.runCheckpointer", "true");
                this.initializeRootContainer(envConfig);
            }
            ExportJob exportJob = new ExportJob(exportConfig);
            exportJob.exportLDIF(this.rootContainer);
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = JebMessages.ERR_JEB_IO_ERROR.get(ioe.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (JebException je) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, je);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), je.getMessageObject());
        }
        catch (DatabaseException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw this.createDirectoryException(de);
        }
        catch (LDIFException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ie.getMessageObject());
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ce.getMessageObject());
        }
        finally {
            block23: {
                if (openRootContainer && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException e) {
                        if (!DebugLogger.debugEnabled()) break block23;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        boolean openRootContainer;
        boolean bl = openRootContainer = this.rootContainer == null;
        if (!openRootContainer) {
            Message message = JebMessages.ERR_JEB_IMPORT_BACKEND_ONLINE.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
            if (importConfig.appendToExistingData()) {
                envConfig.setReadOnly(false);
                envConfig.setAllowCreate(true);
                envConfig.setTransactional(true);
                envConfig.setTxnNoSync(true);
                envConfig.setConfigParam("je.env.isLocking", "true");
                envConfig.setConfigParam("je.env.runCheckpointer", "false");
            } else if (importConfig.clearBackend() || this.cfg.getBackendBaseDN().size() <= 1) {
                File backendDirectory = StaticUtils.getFileForPath(this.cfg.getBackendDirectory());
                EnvManager.removeFiles(backendDirectory.getPath());
                envConfig.setReadOnly(false);
                envConfig.setAllowCreate(true);
                envConfig.setTransactional(false);
                envConfig.setTxnNoSync(false);
                envConfig.setConfigParam("je.env.isLocking", "false");
                envConfig.setConfigParam("je.env.runCheckpointer", "false");
            }
            this.initializeRootContainer(envConfig);
            ImportJob importJob = new ImportJob(importConfig);
            LDIFImportResult lDIFImportResult = importJob.importLDIF(this.rootContainer);
            return lDIFImportResult;
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            Message message = JebMessages.ERR_JEB_IO_ERROR.get(ioe.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        catch (JebException je) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, je);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), je.getMessageObject());
        }
        catch (DatabaseException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw this.createDirectoryException(de);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ie.getMessageObject());
        }
        catch (ConfigException ce) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ce);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), ce.getMessageObject());
        }
        finally {
            block23: {
                try {
                    this.rootContainer.close();
                    this.rootContainer = null;
                    if (DebugLogger.debugEnabled()) {
                        Message message = JebMessages.INFO_JEB_IMPORT_CLOSING_DATABASE.get();
                        TRACER.debugInfo(message.toString());
                    }
                }
                catch (DatabaseException de) {
                    if (!DebugLogger.debugEnabled()) break block23;
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
            }
        }
    }

    public long verifyBackend(VerifyConfig verifyConfig, Entry statEntry) throws InitializationException, ConfigException, DirectoryException {
        boolean openRootContainer = this.rootContainer == null;
        long errorCount = 0L;
        try {
            if (openRootContainer) {
                EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
                envConfig.setReadOnly(true);
                envConfig.setAllowCreate(false);
                envConfig.setTransactional(false);
                envConfig.setTxnNoSync(false);
                envConfig.setConfigParam("je.env.isLocking", "true");
                envConfig.setConfigParam("je.env.runCheckpointer", "true");
                this.initializeRootContainer(envConfig);
            }
            VerifyJob verifyJob = new VerifyJob(verifyConfig);
            errorCount = verifyJob.verifyBackend(this.rootContainer, statEntry);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            block15: {
                if (openRootContainer && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException e) {
                        if (!DebugLogger.debugEnabled()) break block15;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        return errorCount;
    }

    public void rebuildBackend(RebuildConfig rebuildConfig) throws InitializationException, ConfigException, DirectoryException {
        boolean openRootContainer;
        boolean bl = openRootContainer = this.rootContainer == null;
        if (!openRootContainer && rebuildConfig.includesSystemIndex()) {
            Message message = JebMessages.ERR_JEB_REBUILD_BACKEND_ONLINE.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            if (openRootContainer) {
                EnvironmentConfig envConfig = ConfigurableEnvironment.parseConfigEntry(this.cfg);
                this.initializeRootContainer(envConfig);
            }
            RebuildJob rebuildJob = new RebuildJob(rebuildConfig);
            rebuildJob.rebuildBackend(this.rootContainer);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw this.createDirectoryException(e);
        }
        catch (JebException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessageObject());
        }
        finally {
            block16: {
                if (openRootContainer && this.rootContainer != null) {
                    try {
                        this.rootContainer.close();
                        this.rootContainer = null;
                    }
                    catch (DatabaseException e) {
                        if (!DebugLogger.debugEnabled()) break block16;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.createBackup(this.cfg, backupConfig);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.removeBackup(backupDirectory, backupID);
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        BackupManager backupManager = new BackupManager(this.getBackendID());
        backupManager.restoreBackup(this.cfg, restoreConfig);
    }

    @Override
    public boolean isConfigurationAcceptable(Configuration configuration, List<Message> unacceptableReasons) {
        JEBackendCfg config = (JEBackendCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(JEBackendCfg cfg, List<Message> unacceptableReasons) {
        String loggingLevel = cfg.getDatabaseLoggingLevel();
        if (!(loggingLevel.equals("OFF") || loggingLevel.equals("SEVERE") || loggingLevel.equals("WARNING") || loggingLevel.equals("INFORMATION") || loggingLevel.equals("CONFIG") || loggingLevel.equals("FINE") || loggingLevel.equals("FINER") || loggingLevel.equals("FINEST") || loggingLevel.equals("OFF"))) {
            Message message = JebMessages.ERR_JEB_INVALID_LOGGING_LEVEL.get(String.valueOf(cfg.getDatabaseLoggingLevel()), String.valueOf(cfg.dn()));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(JEBackendCfg newCfg) {
        ResultCode resultCode = ResultCode.SUCCESS;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            if (this.rootContainer != null) {
                DN[] baseDNs = new DN[newCfg.getBackendBaseDN().size()];
                baseDNs = newCfg.getBackendBaseDN().toArray(baseDNs);
                for (DN baseDN : this.cfg.getBackendBaseDN()) {
                    boolean found = false;
                    for (DN dn : baseDNs) {
                        if (!dn.equals(baseDN)) continue;
                        found = true;
                    }
                    if (found) continue;
                    DirectoryServer.deregisterBaseDN(baseDN, false);
                    EntryContainer ec = this.rootContainer.unregisterEntryContainer(baseDN);
                    ec.delete();
                }
                for (DN baseDN : baseDNs) {
                    if (this.rootContainer.getBaseDNs().contains(baseDN)) continue;
                    try {
                        EntryContainer ec = this.rootContainer.openEntryContainer(baseDN, null);
                        this.rootContainer.registerEntryContainer(baseDN, ec);
                        DirectoryServer.registerBaseDN(baseDN, this, false, false);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        resultCode = DirectoryServer.getServerErrorResultCode();
                        messages.add(BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(String.valueOf(baseDN), String.valueOf(e)));
                        ConfigChangeResult ccr = new ConfigChangeResult(resultCode, false, messages);
                        return ccr;
                    }
                }
            }
            this.cfg = newCfg;
        }
        catch (Exception e) {
            messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(e), new Object[0]));
            ConfigChangeResult ccr = new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
            return ccr;
        }
        ConfigChangeResult ccr = new ConfigChangeResult(resultCode, false, messages);
        return ccr;
    }

    public RootContainer getRootContainer() {
        return this.rootContainer;
    }

    public void clearBackend() throws ConfigException, JebException {
        File backendDirectory = StaticUtils.getFileForPath(this.cfg.getBackendDirectory());
        EnvManager.removeFiles(backendDirectory.getPath());
    }

    DirectoryException createDirectoryException(DatabaseException e) {
        String jeMessage;
        ResultCode resultCode = DirectoryServer.getServerErrorResultCode();
        Message message = null;
        if (e instanceof RunRecoveryException) {
            message = BackendMessages.NOTE_BACKEND_ENVIRONMENT_UNUSABLE.get(this.getBackendID());
            ErrorLogger.logError(message);
            DirectoryServer.sendAlertNotification(DirectoryServer.getInstance(), "org.opends.server.BackendRunRecovery", message);
        }
        if ((jeMessage = e.getMessage()) == null) {
            jeMessage = StaticUtils.stackTraceToSingleLineString(e);
        }
        message = JebMessages.ERR_JEB_DATABASE_EXCEPTION.get(jeMessage);
        return new DirectoryException(resultCode, message, e);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.BackendRunRecovery", "This alert type will be used to provide notification that the JE backend throws a RunRecoveryException and Directory Server needs to be restarted.");
        return alerts;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.cfg.dn();
    }

    private void initializeRootContainer(EnvironmentConfig envConfig) throws ConfigException, InitializationException {
        try {
            this.rootContainer = new RootContainer(this, this.cfg);
            this.rootContainer.open(envConfig);
        }
        catch (DatabaseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = JebMessages.ERR_JEB_OPEN_ENV_FAIL.get(e.getMessage());
            throw new InitializationException(message, (Throwable)e);
        }
    }

    static {
        supportedControls.add("1.2.840.113556.1.4.805");
        supportedControls.add("1.2.840.113556.1.4.319");
        supportedControls.add("2.16.840.1.113730.3.4.2");
        supportedControls.add("1.2.840.113556.1.4.473");
        supportedControls.add("2.16.840.1.113730.3.4.9");
    }
}

