/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.ImportContext;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexBuilder;
import org.opends.server.backends.jeb.IndexMod;
import org.opends.server.backends.jeb.IndexModComparator;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

public class AttributeIndexBuilder
implements IndexBuilder {
    private ImportContext importContext;
    private Index index;
    private Indexer indexer;
    ArrayList<IndexMod> buffer;
    private int bufferSize;
    private int fileNumber = 0;
    private int entryLimit;
    private String fileNamePrefix;
    private boolean replaceExisting = false;
    private ByteArrayOutputStream addBytesStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream delBytesStream = new ByteArrayOutputStream();
    private DataOutputStream addBytesDataStream;
    private DataOutputStream delBytesDataStream;
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File d, String name) {
            return name.startsWith(AttributeIndexBuilder.this.fileNamePrefix);
        }
    };

    public AttributeIndexBuilder(ImportContext importContext, Index index, int entryLimit, long bufferSize) {
        this.importContext = importContext;
        this.index = index;
        this.indexer = index.indexer;
        this.entryLimit = entryLimit;
        this.bufferSize = (int)bufferSize / 100;
        long tid = Thread.currentThread().getId();
        this.fileNamePrefix = index.getName() + "_" + tid + "_";
        this.replaceExisting = importContext.getLDIFImportConfig().appendToExistingData() && importContext.getLDIFImportConfig().replaceExistingEntries();
        this.addBytesDataStream = new DataOutputStream(this.addBytesStream);
        this.delBytesDataStream = new DataOutputStream(this.delBytesStream);
    }

    public void startProcessing() {
        File tempDir = StaticUtils.getFileForPath(this.importContext.getConfig().getBackendImportTempDirectory());
        File[] files = tempDir.listFiles(this.filter);
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
        this.buffer = new ArrayList(this.bufferSize);
    }

    public void processEntry(Entry oldEntry, Entry newEntry, EntryID entryID) throws DatabaseException, IOException {
        Transaction txn = null;
        if (oldEntry != null) {
            HashSet<ASN1OctetString> addKeys = new HashSet<ASN1OctetString>();
            HashSet<ASN1OctetString> delKeys = new HashSet<ASN1OctetString>();
            this.indexer.replaceEntry(txn, oldEntry, newEntry, addKeys, delKeys);
            for (ASN1OctetString k : delKeys) {
                this.removeID(k.value(), entryID);
            }
            for (ASN1OctetString k : addKeys) {
                this.insertID(k.value(), entryID);
            }
        } else {
            HashSet<ASN1OctetString> addKeys = new HashSet<ASN1OctetString>();
            this.indexer.indexEntry(txn, newEntry, addKeys);
            for (ASN1OctetString k : addKeys) {
                this.insertID(k.value(), entryID);
            }
        }
    }

    public void stopProcessing() throws IOException {
        this.flushBuffer();
    }

    public int getEntryLimitExceededCount() {
        return this.index.getEntryLimitExceededCount();
    }

    private void insertID(byte[] key, EntryID entryID) throws IOException {
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
        IndexMod kav = new IndexMod(key, entryID, false);
        this.buffer.add(kav);
    }

    private void removeID(byte[] key, EntryID entryID) throws IOException {
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
        IndexMod kav = new IndexMod(key, entryID, true);
        this.buffer.add(kav);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        if (this.buffer.size() == 0) {
            return;
        }
        IndexModComparator comparator = this.replaceExisting ? new IndexModComparator(this.indexer.getComparator(), true) : new IndexModComparator(this.indexer.getComparator(), false);
        Collections.sort(this.buffer, comparator);
        ++this.fileNumber;
        String fileName = this.fileNamePrefix + String.valueOf(this.fileNumber);
        File file = new File(StaticUtils.getFileForPath(this.importContext.getConfig().getBackendImportTempDirectory()), fileName);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(new FileOutputStream(file));
        DataOutputStream dataStream = new DataOutputStream(bufferedStream);
        this.addBytesStream.reset();
        this.delBytesStream.reset();
        try {
            byte[] currentKey = null;
            for (IndexMod key : this.buffer) {
                byte[] keyString = key.key;
                if (!Arrays.equals(keyString, currentKey)) {
                    if (currentKey != null) {
                        dataStream.writeInt(currentKey.length);
                        dataStream.write(currentKey);
                        dataStream.writeInt(this.addBytesStream.size());
                        this.addBytesStream.writeTo(dataStream);
                        if (this.replaceExisting) {
                            dataStream.writeInt(this.delBytesStream.size());
                            this.delBytesStream.writeTo(dataStream);
                        }
                    }
                    currentKey = keyString;
                    this.addBytesStream.reset();
                    this.delBytesStream.reset();
                }
                if (key.isDelete) {
                    this.delBytesDataStream.writeLong(key.value.longValue());
                    continue;
                }
                this.addBytesDataStream.writeLong(key.value.longValue());
            }
            if (currentKey != null) {
                dataStream.writeInt(currentKey.length);
                dataStream.write(currentKey);
                dataStream.writeInt(this.addBytesStream.size());
                this.addBytesStream.writeTo(dataStream);
                if (this.replaceExisting) {
                    dataStream.writeInt(this.delBytesStream.size());
                    this.delBytesStream.writeTo(dataStream);
                }
            }
            this.buffer = new ArrayList(this.bufferSize);
        }
        finally {
            dataStream.close();
        }
    }

    public String toString() {
        return this.indexer.toString();
    }
}

