/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import org.opends.messages.BackendMessages;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SchemaBackendCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.schema.DITContentRuleSyntax;
import org.opends.server.schema.DITStructureRuleSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.MatchingRuleUseSyntax;
import org.opends.server.schema.NameFormSyntax;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBackend
extends Backend
implements ConfigurationChangeListener<SchemaBackendCfg>,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.backends.SchemaBackend";
    private ArrayList<Attribute> userDefinedAttributes;
    private AttributeType attributeTypesType;
    private AttributeType createTimestampType;
    private AttributeType creatorsNameType;
    private AttributeType ditContentRulesType;
    private AttributeType ditStructureRulesType;
    private AttributeType ldapSyntaxesType;
    private AttributeType matchingRulesType;
    private AttributeType matchingRuleUsesType;
    private AttributeType modifiersNameType;
    private AttributeType modifyTimestampType;
    private AttributeType objectClassesType;
    private AttributeType nameFormsType;
    private AttributeType synchronizationStateType;
    private AttributeValue creatorsName;
    private AttributeValue modifiersName;
    private AttributeValue createTimestamp;
    private AttributeValue modifyTimestamp;
    private boolean showAllAttributes;
    private DN configEntryDN;
    private SchemaBackendCfg currentConfig;
    private DN[] baseDNs;
    private HashMap<ObjectClass, String> schemaObjectClasses;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private long modifyTime;
    private String stripMinUpperBoundRegEx = "\\{\\d+\\}";

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config == null) {
            Message message = BackendMessages.ERR_SCHEMA_CONFIG_ENTRY_NULL.get();
            throw new ConfigException(message);
        }
        Validator.ensureTrue(config instanceof SchemaBackendCfg);
        SchemaBackendCfg cfg = (SchemaBackendCfg)config;
        ConfigEntry configEntry = DirectoryServer.getConfigEntry(cfg.dn());
        this.configEntryDN = configEntry.getDN();
        this.attributeTypesType = DirectoryServer.getAttributeType("attributetypes", true);
        this.objectClassesType = DirectoryServer.getAttributeType("objectclasses", true);
        this.matchingRulesType = DirectoryServer.getAttributeType("matchingrules", true);
        this.ldapSyntaxesType = DirectoryServer.getAttributeType("ldapsyntaxes", true);
        this.ditContentRulesType = DirectoryServer.getAttributeType("ditcontentrules", true);
        this.ditStructureRulesType = DirectoryServer.getAttributeType("ditstructurerules", true);
        this.matchingRuleUsesType = DirectoryServer.getAttributeType("matchingruleuse", true);
        this.nameFormsType = DirectoryServer.getAttributeType("nameforms", true);
        this.synchronizationStateType = DirectoryServer.getAttributeType("ds-sync-state", true);
        this.creatorsNameType = DirectoryServer.getAttributeType("creatorsname", true);
        this.createTimestampType = DirectoryServer.getAttributeType("createtimestamp", true);
        this.modifiersNameType = DirectoryServer.getAttributeType("modifiersname", true);
        this.modifyTimestampType = DirectoryServer.getAttributeType("modifytimestamp", true);
        this.schemaObjectClasses = new LinkedHashMap<ObjectClass, String>(3);
        this.schemaObjectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass subentryOC = DirectoryServer.getObjectClass("ldapsubentry", true);
        this.schemaObjectClasses.put(subentryOC, "ldapSubentry");
        ObjectClass subschemaOC = DirectoryServer.getObjectClass("subschema", true);
        this.schemaObjectClasses.put(subschemaOC, "subschema");
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.configEntryDN = configEntry.getDN();
        DN[] baseDNs = new DN[cfg.getBackendBaseDN().size()];
        cfg.getBackendBaseDN().toArray(baseDNs);
        this.baseDNs = baseDNs;
        this.creatorsName = new AttributeValue(this.creatorsNameType, baseDNs[0].toString());
        this.modifiersName = new AttributeValue(this.modifiersNameType, baseDNs[0].toString());
        long createTime = DirectoryServer.getSchema().getOldestModificationTime();
        this.createTimestamp = GeneralizedTimeSyntax.createGeneralizedTimeValue(createTime);
        long modifyTime = DirectoryServer.getSchema().getYoungestModificationTime();
        this.modifyTimestamp = GeneralizedTimeSyntax.createGeneralizedTimeValue(modifyTime);
        this.userDefinedAttributes = new ArrayList();
        for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isSchemaConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
            for (Attribute a : attrs) {
                if (this.isSchemaConfigAttribute(a)) continue;
                this.userDefinedAttributes.add(a);
            }
        }
        this.showAllAttributes = cfg.isShowAllAttributes();
        this.currentConfig = cfg;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        DirectoryServer.setSchemaDN(this.baseDNs[0]);
        for (int i = 0; i < this.baseDNs.length; ++i) {
            try {
                DirectoryServer.registerBaseDN(this.baseDNs[i], this, true, false);
                continue;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(this.baseDNs[i].toString(), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        try {
            String concatFilePath;
            LinkedHashSet<String> newATs = new LinkedHashSet<String>();
            LinkedHashSet<String> newOCs = new LinkedHashSet<String>();
            LinkedHashSet<String> newNFs = new LinkedHashSet<String>();
            LinkedHashSet<String> newDCRs = new LinkedHashSet<String>();
            LinkedHashSet<String> newDSRs = new LinkedHashSet<String>();
            LinkedHashSet<String> newMRUs = new LinkedHashSet<String>();
            Schema.genConcatenatedSchema(newATs, newOCs, newNFs, newDCRs, newDSRs, newMRUs);
            File configFile = new File(DirectoryServer.getConfigFile());
            File configDirectory = configFile.getParentFile();
            File upgradeDirectory = new File(configDirectory, "upgrade");
            File concatFile = new File(upgradeDirectory, "schema.ldif.current");
            if (concatFile.exists()) {
                concatFilePath = concatFile.getAbsolutePath();
            } else {
                concatFile = new File(upgradeDirectory, "schema.ldif.2794");
                if (concatFile.exists()) {
                    concatFilePath = concatFile.getAbsolutePath();
                } else {
                    String runningUnitTestsStr = System.getProperty("org.opends.server.RunningUnitTests");
                    if (runningUnitTestsStr != null && runningUnitTestsStr.equalsIgnoreCase("true")) {
                        Schema.writeConcatenatedSchema();
                        concatFile = new File(upgradeDirectory, "schema.ldif.current");
                        concatFilePath = concatFile.getAbsolutePath();
                    } else {
                        Message message = BackendMessages.ERR_SCHEMA_CANNOT_FIND_CONCAT_FILE.get(upgradeDirectory.getAbsolutePath(), "schema.ldif.current", concatFile.getName());
                        throw new InitializationException(message);
                    }
                }
            }
            LinkedHashSet<String> oldATs = new LinkedHashSet<String>();
            LinkedHashSet<String> oldOCs = new LinkedHashSet<String>();
            LinkedHashSet<String> oldNFs = new LinkedHashSet<String>();
            LinkedHashSet<String> oldDCRs = new LinkedHashSet<String>();
            LinkedHashSet<String> oldDSRs = new LinkedHashSet<String>();
            LinkedHashSet<String> oldMRUs = new LinkedHashSet<String>();
            Schema.readConcatenatedSchema(concatFilePath, oldATs, oldOCs, oldNFs, oldDCRs, oldDSRs, oldMRUs);
            LinkedList<Modification> mods = new LinkedList<Modification>();
            Schema.compareConcatenatedSchema(oldATs, newATs, this.attributeTypesType, mods);
            Schema.compareConcatenatedSchema(oldOCs, newOCs, this.objectClassesType, mods);
            Schema.compareConcatenatedSchema(oldNFs, newNFs, this.nameFormsType, mods);
            Schema.compareConcatenatedSchema(oldDCRs, newDCRs, this.ditContentRulesType, mods);
            Schema.compareConcatenatedSchema(oldDSRs, newDSRs, this.ditStructureRulesType, mods);
            Schema.compareConcatenatedSchema(oldMRUs, newMRUs, this.matchingRuleUsesType, mods);
            if (!mods.isEmpty()) {
                DirectoryServer.setOfflineSchemaChanges(mods);
                Schema.writeConcatenatedSchema();
            }
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_SCHEMA_ERROR_DETERMINING_SCHEMA_CHANGES.get(StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
        }
        this.currentConfig.addSchemaChangeListener(this);
    }

    @Override
    public void finalizeBackend() {
        this.currentConfig.removeSchemaChangeListener(this);
        for (DN baseDN : this.baseDNs) {
            try {
                DirectoryServer.deregisterBaseDN(baseDN, false);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private boolean isSchemaConfigAttribute(Attribute attribute) {
        AttributeType attrType = attribute.getAttributeType();
        return attrType.hasName("ds-cfg-schema-entry-dn".toLowerCase()) || attrType.hasName("ds-cfg-backend-enabled".toLowerCase()) || attrType.hasName("ds-cfg-backend-class".toLowerCase()) || attrType.hasName("ds-cfg-backend-id".toLowerCase()) || attrType.hasName("ds-cfg-backend-base-dn".toLowerCase()) || attrType.hasName("ds-cfg-backend-writability-mode".toLowerCase()) || attrType.hasName("ds-cfg-show-all-attributes".toLowerCase()) || attrType.hasName("cn") || attrType.hasName("creatorsname") || attrType.hasName("createtimestamp") || attrType.hasName("modifiersname") || attrType.hasName("modifytimestamp");
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        return 1L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        DN[] dnArray;
        for (DN baseDN : dnArray = this.baseDNs) {
            if (!entryDN.equals(baseDN)) continue;
            return this.getSchemaEntry(entryDN);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getSchemaEntry(DN entryDN) {
        Object attrType;
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        RDN rdn = entryDN.getRDN();
        if (rdn != null) {
            int numAVAs = rdn.getNumValues();
            for (int i = 0; i < numAVAs; ++i) {
                LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
                valueSet.add(rdn.getAttributeValue(i));
                attrType = rdn.getAttributeType(i);
                String attrName = rdn.getAttributeName(i);
                Attribute a = new Attribute((AttributeType)attrType, attrName, valueSet);
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(a);
                if (((AttributeType)attrType).isOperational()) {
                    operationalAttrs.put((AttributeType)attrType, (List<Attribute>)attrList);
                    continue;
                }
                userAttrs.put((AttributeType)attrType, (List<Attribute>)attrList);
            }
        }
        LinkedHashSet<AttributeValue> valueSet = DirectoryServer.getAttributeTypeSet();
        Attribute attr = AttributeTypeSyntax.isStripSyntaxMinimumUpperBound() ? this.stripMinUpperBoundValues(valueSet) : new Attribute(this.attributeTypesType, "attributeTypes", valueSet);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(attr);
        if (this.attributeTypesType.isOperational() && !this.showAllAttributes) {
            operationalAttrs.put(this.attributeTypesType, attrList);
        } else {
            userAttrs.put(this.attributeTypesType, attrList);
        }
        valueSet = DirectoryServer.getObjectClassSet();
        attr = new Attribute(this.objectClassesType, "objectClasses", valueSet);
        attrList = new ArrayList(1);
        attrList.add(attr);
        if (this.objectClassesType.isOperational() && !this.showAllAttributes) {
            operationalAttrs.put(this.objectClassesType, attrList);
        } else {
            userAttrs.put(this.objectClassesType, attrList);
        }
        valueSet = DirectoryServer.getMatchingRuleSet();
        attr = new Attribute(this.matchingRulesType, "matchingRules", valueSet);
        attrList = new ArrayList(1);
        attrList.add(attr);
        if (this.matchingRulesType.isOperational() && !this.showAllAttributes) {
            operationalAttrs.put(this.matchingRulesType, attrList);
        } else {
            userAttrs.put(this.matchingRulesType, attrList);
        }
        valueSet = DirectoryServer.getAttributeSyntaxSet();
        attr = new Attribute(this.ldapSyntaxesType, "ldapSyntaxes", valueSet);
        attrList = new ArrayList(1);
        attrList.add(attr);
        if (this.ldapSyntaxesType.isOperational()) {
            operationalAttrs.put(this.ldapSyntaxesType, attrList);
        } else {
            userAttrs.put(this.ldapSyntaxesType, attrList);
        }
        valueSet = DirectoryServer.getNameFormSet();
        if (!valueSet.isEmpty()) {
            attr = new Attribute(this.nameFormsType, "nameForms", valueSet);
            attrList = new ArrayList(1);
            attrList.add(attr);
            if (this.nameFormsType.isOperational()) {
                operationalAttrs.put(this.nameFormsType, attrList);
            } else {
                userAttrs.put(this.nameFormsType, attrList);
            }
        }
        if (!(valueSet = DirectoryServer.getDITContentRuleSet()).isEmpty()) {
            attr = new Attribute(this.ditContentRulesType, "dITContentRules", valueSet);
            attrList = new ArrayList(1);
            attrList.add(attr);
            if (this.ditContentRulesType.isOperational()) {
                operationalAttrs.put(this.ditContentRulesType, attrList);
            } else {
                userAttrs.put(this.ditContentRulesType, attrList);
            }
        }
        if (!(valueSet = DirectoryServer.getDITStructureRuleSet()).isEmpty()) {
            attr = new Attribute(this.ditStructureRulesType, "dITStructureRules", valueSet);
            attrList = new ArrayList(1);
            attrList.add(attr);
            if (this.ditStructureRulesType.isOperational()) {
                operationalAttrs.put(this.ditStructureRulesType, attrList);
            } else {
                userAttrs.put(this.ditStructureRulesType, attrList);
            }
        }
        if (!(valueSet = DirectoryServer.getMatchingRuleUseSet()).isEmpty()) {
            attr = new Attribute(this.matchingRuleUsesType, "matchingRuleUse", valueSet);
            attrList = new ArrayList(1);
            attrList.add(attr);
            if (this.matchingRuleUsesType.isOperational()) {
                operationalAttrs.put(this.matchingRuleUsesType, attrList);
            } else {
                userAttrs.put(this.matchingRuleUsesType, attrList);
            }
        }
        valueSet = new LinkedHashSet(1);
        valueSet.add(this.creatorsName);
        attrList = new ArrayList(1);
        attrList.add(new Attribute(this.creatorsNameType, "creatorsName", valueSet));
        operationalAttrs.put(this.creatorsNameType, attrList);
        valueSet = new LinkedHashSet(1);
        valueSet.add(this.createTimestamp);
        attrList = new ArrayList(1);
        attrList.add(new Attribute(this.createTimestampType, "createTimestamp", valueSet));
        operationalAttrs.put(this.createTimestampType, attrList);
        if (DirectoryServer.getSchema().getYoungestModificationTime() != this.modifyTime) {
            attrType = this;
            synchronized (attrType) {
                this.modifyTime = DirectoryServer.getSchema().getYoungestModificationTime();
                this.modifyTimestamp = GeneralizedTimeSyntax.createGeneralizedTimeValue(this.modifyTime);
            }
        }
        valueSet = new LinkedHashSet(1);
        valueSet.add(this.modifiersName);
        attrList = new ArrayList(1);
        attrList.add(new Attribute(this.modifiersNameType, "modifiersName", valueSet));
        operationalAttrs.put(this.modifiersNameType, attrList);
        valueSet = new LinkedHashSet(1);
        valueSet.add(this.modifyTimestamp);
        attrList = new ArrayList(1);
        attrList.add(new Attribute(this.modifyTimestampType, "modifyTimestamp", valueSet));
        operationalAttrs.put(this.modifyTimestampType, attrList);
        valueSet = DirectoryServer.getSchema().getSynchronizationState();
        attr = new Attribute(this.synchronizationStateType, "ds-sync-state", valueSet);
        attrList = new ArrayList(1);
        attrList.add(attr);
        operationalAttrs.put(this.synchronizationStateType, attrList);
        for (Attribute a : this.userDefinedAttributes) {
            List<Attribute> attrs;
            AttributeType type = a.getAttributeType();
            if (type.isOperational()) {
                attrs = operationalAttrs.get(type);
                if (attrs == null) {
                    attrs = new ArrayList<Attribute>();
                    attrs.add(a);
                    operationalAttrs.put(type, attrs);
                    continue;
                }
                attrs.add(a);
                continue;
            }
            attrs = userAttrs.get(type);
            if (attrs == null) {
                attrs = new ArrayList<Attribute>();
                attrs.add(a);
                userAttrs.put(type, attrs);
                continue;
            }
            attrs.add(a);
        }
        Entry e = new Entry(entryDN, this.schemaObjectClasses, userAttrs, operationalAttrs);
        e.processVirtualAttributes();
        return e;
    }

    @Override
    public boolean entryExists(DN entryDN) throws DirectoryException {
        DN[] baseArray;
        for (DN baseDN : baseArray = this.baseDNs) {
            if (!entryDN.equals(baseDN)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_SCHEMA_ADD_NOT_SUPPORTED.get(String.valueOf(entry.getDN()));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_SCHEMA_DELETE_NOT_SUPPORTED.get(String.valueOf(entryDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        ClientConnection clientConnection = modifyOperation.getClientConnection();
        if (!clientConnection.hasPrivilege(Privilege.UPDATE_SCHEMA, modifyOperation)) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        ArrayList<Modification> mods = new ArrayList<Modification>(modifyOperation.getModifications());
        if (mods.isEmpty()) {
            return;
        }
        Schema newSchema = DirectoryServer.getSchema().duplicate();
        TreeSet<String> modifiedSchemaFiles = new TreeSet<String>();
        int pos = -1;
        Iterator<Modification> iterator = mods.iterator();
        block34: while (iterator.hasNext()) {
            Modification m = iterator.next();
            ++pos;
            if (m.isInternal()) {
                iterator.remove();
                continue;
            }
            Attribute a = m.getAttribute();
            AttributeType at = a.getAttributeType();
            switch (m.getModificationType()) {
                case ADD: {
                    MatchingRuleUse mru;
                    DITStructureRule dsr;
                    DITContentRule dcr;
                    NameForm nf;
                    ObjectClass oc;
                    AttributeType type;
                    LinkedHashSet<AttributeValue> values = a.getValues();
                    if (values.isEmpty()) continue block34;
                    if (at.equals(this.attributeTypesType)) {
                        for (AttributeValue v : values) {
                            try {
                                type = AttributeTypeSyntax.decodeAttributeType(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_ATTRTYPE.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                            }
                            this.addAttributeType(type, newSchema, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.objectClassesType)) {
                        for (AttributeValue v : values) {
                            try {
                                oc = ObjectClassSyntax.decodeObjectClass(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_OBJECTCLASS.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                            }
                            this.addObjectClass(oc, newSchema, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.nameFormsType)) {
                        for (AttributeValue v : values) {
                            try {
                                nf = NameFormSyntax.decodeNameForm(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_NAME_FORM.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                            }
                            this.addNameForm(nf, newSchema, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.ditContentRulesType)) {
                        for (AttributeValue v : values) {
                            try {
                                dcr = DITContentRuleSyntax.decodeDITContentRule(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_DCR.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                            }
                            this.addDITContentRule(dcr, newSchema, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.ditStructureRulesType)) {
                        for (AttributeValue v : values) {
                            try {
                                dsr = DITStructureRuleSyntax.decodeDITStructureRule(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_DSR.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                            }
                            this.addDITStructureRule(dsr, newSchema, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.matchingRuleUsesType)) {
                        for (AttributeValue v : values) {
                            try {
                                mru = MatchingRuleUseSyntax.decodeMatchingRuleUse(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_MR_USE.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                            }
                            this.addMatchingRuleUse(mru, newSchema, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    Message message = BackendMessages.ERR_SCHEMA_MODIFY_UNSUPPORTED_ATTRIBUTE_TYPE.get(a.getName());
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                case DELETE: {
                    Message message;
                    MatchingRuleUse mru;
                    DITStructureRule dsr;
                    DITContentRule dcr;
                    NameForm nf;
                    ObjectClass oc;
                    AttributeType type;
                    LinkedHashSet<AttributeValue> values = a.getValues();
                    if (values.isEmpty()) {
                        message = BackendMessages.ERR_SCHEMA_MODIFY_DELETE_NO_VALUES.get(a.getName());
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                    }
                    if (at.equals(this.attributeTypesType)) {
                        for (AttributeValue v : values) {
                            try {
                                type = AttributeTypeSyntax.decodeAttributeType(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_ATTRTYPE.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message2, de);
                            }
                            this.removeAttributeType(type, newSchema, mods, pos, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.objectClassesType)) {
                        for (AttributeValue v : values) {
                            try {
                                oc = ObjectClassSyntax.decodeObjectClass(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_OBJECTCLASS.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3, de);
                            }
                            this.removeObjectClass(oc, newSchema, mods, pos, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.nameFormsType)) {
                        for (AttributeValue v : values) {
                            try {
                                nf = NameFormSyntax.decodeNameForm(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message4 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_NAME_FORM.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message4, de);
                            }
                            this.removeNameForm(nf, newSchema, mods, pos, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.ditContentRulesType)) {
                        for (AttributeValue v : values) {
                            try {
                                dcr = DITContentRuleSyntax.decodeDITContentRule(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message5 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_DCR.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message5, de);
                            }
                            this.removeDITContentRule(dcr, newSchema, mods, pos, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.ditStructureRulesType)) {
                        for (AttributeValue v : values) {
                            try {
                                dsr = DITStructureRuleSyntax.decodeDITStructureRule(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message6 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_DSR.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message6, de);
                            }
                            this.removeDITStructureRule(dsr, newSchema, mods, pos, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    if (at.equals(this.matchingRuleUsesType)) {
                        for (AttributeValue v : values) {
                            try {
                                mru = MatchingRuleUseSyntax.decodeMatchingRuleUse(v.getValue(), newSchema, false);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message7 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_MR_USE.get(v.getStringValue(), de.getMessageObject());
                                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message7, de);
                            }
                            this.removeMatchingRuleUse(mru, newSchema, mods, pos, modifiedSchemaFiles);
                        }
                        continue block34;
                    }
                    message = BackendMessages.ERR_SCHEMA_MODIFY_UNSUPPORTED_ATTRIBUTE_TYPE.get(a.getName());
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                default: {
                    Message message;
                    if (!modifyOperation.isSynchronizationOperation()) {
                        message = BackendMessages.ERR_SCHEMA_INVALID_MODIFICATION_TYPE.get(String.valueOf((Object)m.getModificationType()));
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                    }
                    if (at.equals(this.synchronizationStateType)) {
                        newSchema.setSynchronizationState(a.getValues());
                    }
                    modifiedSchemaFiles.add("99-user.ldif");
                }
            }
        }
        HashMap<String, File> tempSchemaFiles = new HashMap<String, File>();
        try {
            for (String schemaFile : modifiedSchemaFiles) {
                File tempSchemaFile = this.writeTempSchemaFile(newSchema, schemaFile);
                tempSchemaFiles.put(schemaFile, tempSchemaFile);
            }
            this.installSchemaFiles(tempSchemaFiles);
            DirectoryServer.setSchema(newSchema);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_WRITE_NEW_SCHEMA.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            this.cleanUpTempSchemaFiles(tempSchemaFiles);
        }
        Schema.writeConcatenatedSchema();
        DN authzDN = modifyOperation.getAuthorizationDN();
        if (authzDN == null) {
            authzDN = DN.nullDN();
        }
        this.modifiersName = new AttributeValue(this.modifiersNameType, authzDN.toString());
        this.modifyTimestamp = GeneralizedTimeSyntax.createGeneralizedTimeValue(System.currentTimeMillis());
    }

    private void addAttributeType(AttributeType attributeType, Schema schema, Set<String> modifiedSchemaFiles) throws DirectoryException {
        String schemaFile;
        Message message;
        MatchingRule mr;
        AttributeType existingType = schema.getAttributeType(attributeType.getOID());
        for (String name : attributeType.getNormalizedNames()) {
            AttributeType t = schema.getAttributeType(name);
            if (t == null) continue;
            if (existingType == null) {
                existingType = t;
                continue;
            }
            if (existingType == t) continue;
            Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_MULTIPLE_CONFLICTS_FOR_ADD_ATTRTYPE.get(attributeType.getNameOrOID(), existingType.getNameOrOID(), t.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
        }
        AttributeType superiorType = attributeType.getSuperiorType();
        if (superiorType != null) {
            Message message3;
            if (!schema.hasAttributeType(superiorType.getOID())) {
                message3 = BackendMessages.ERR_SCHEMA_MODIFY_UNDEFINED_SUPERIOR_ATTRIBUTE_TYPE.get(attributeType.getNameOrOID(), superiorType.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message3);
            }
            if (superiorType.isObsolete()) {
                message3 = BackendMessages.ERR_SCHEMA_MODIFY_OBSOLETE_SUPERIOR_ATTRIBUTE_TYPE.get(attributeType.getNameOrOID(), superiorType.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message3);
            }
        }
        if ((mr = attributeType.getEqualityMatchingRule()) != null && mr.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_ATTRTYPE_OBSOLETE_MR.get(attributeType.getNameOrOID(), mr.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        mr = attributeType.getOrderingMatchingRule();
        if (mr != null && mr.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_ATTRTYPE_OBSOLETE_MR.get(attributeType.getNameOrOID(), mr.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        mr = attributeType.getSubstringMatchingRule();
        if (mr != null && mr.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_ATTRTYPE_OBSOLETE_MR.get(attributeType.getNameOrOID(), mr.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        mr = attributeType.getApproximateMatchingRule();
        if (mr != null && mr.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_ATTRTYPE_OBSOLETE_MR.get(attributeType.getNameOrOID(), mr.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (existingType == null) {
            schema.registerAttributeType(attributeType, false);
            schemaFile = attributeType.getSchemaFile();
            if (schemaFile == null || schemaFile.length() == 0) {
                schemaFile = "99-user.ldif";
                attributeType.setSchemaFile(schemaFile);
            }
            modifiedSchemaFiles.add(schemaFile);
        } else {
            schema.deregisterAttributeType(existingType);
            schema.registerAttributeType(attributeType, false);
            schema.rebuildDependentElements(existingType);
            if (attributeType.getSchemaFile() == null || attributeType.getSchemaFile().length() == 0) {
                schemaFile = existingType.getSchemaFile();
                if (schemaFile == null || schemaFile.length() == 0) {
                    schemaFile = "99-user.ldif";
                }
                attributeType.setSchemaFile(schemaFile);
                modifiedSchemaFiles.add(schemaFile);
            } else {
                String newSchemaFile = attributeType.getSchemaFile();
                String oldSchemaFile = existingType.getSchemaFile();
                if (oldSchemaFile == null || oldSchemaFile.equals(newSchemaFile)) {
                    modifiedSchemaFiles.add(newSchemaFile);
                } else {
                    modifiedSchemaFiles.add(newSchemaFile);
                    modifiedSchemaFiles.add(oldSchemaFile);
                }
            }
        }
    }

    private void removeAttributeType(AttributeType attributeType, Schema schema, ArrayList<Modification> modifications, int currentPosition, Set<String> modifiedSchemaFiles) throws DirectoryException {
        Message message;
        AttributeType removeType = schema.getAttributeType(attributeType.getOID());
        if (removeType == null || !removeType.equals(attributeType)) {
            Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NO_SUCH_ATTRIBUTE_TYPE.get(attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
        }
        for (int i = currentPosition + 1; i < modifications.size(); ++i) {
            Modification m = modifications.get(i);
            Attribute a = m.getAttribute();
            if (m.getModificationType() != ModificationType.ADD || !a.getAttributeType().equals(this.attributeTypesType)) continue;
            for (AttributeValue v : a.getValues()) {
                AttributeType at;
                try {
                    at = AttributeTypeSyntax.decodeAttributeType(v.getValue(), schema, true);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_ATTRTYPE.get(v.getStringValue(), de.getMessageObject());
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3, de);
                }
                if (!attributeType.getOID().equals(at.getOID())) continue;
                return;
            }
        }
        for (AttributeType at : schema.getAttributeTypes().values()) {
            AttributeType superiorType = at.getSuperiorType();
            if (superiorType == null || !superiorType.equals(removeType)) continue;
            Message message4 = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_AT_SUPERIOR_TYPE.get(removeType.getNameOrOID(), superiorType.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message4);
        }
        for (ObjectClass oc : schema.getObjectClasses().values()) {
            if (!oc.getRequiredAttributes().contains(removeType) && !oc.getOptionalAttributes().contains(removeType)) continue;
            message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_AT_IN_OC.get(removeType.getNameOrOID(), oc.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        for (NameForm nf : schema.getNameFormsByObjectClass().values()) {
            if (!nf.getRequiredAttributes().contains(removeType) && !nf.getOptionalAttributes().contains(removeType)) continue;
            message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_AT_IN_NF.get(removeType.getNameOrOID(), nf.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        for (DITContentRule dcr : schema.getDITContentRules().values()) {
            if (!dcr.getRequiredAttributes().contains(removeType) && !dcr.getOptionalAttributes().contains(removeType) && !dcr.getProhibitedAttributes().contains(removeType)) continue;
            message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_AT_IN_DCR.get(removeType.getNameOrOID(), dcr.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        for (MatchingRuleUse mru : schema.getMatchingRuleUses().values()) {
            if (!mru.getAttributes().contains(removeType)) continue;
            message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_AT_IN_MR_USE.get(removeType.getNameOrOID(), mru.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        schema.deregisterAttributeType(removeType);
        String schemaFile = removeType.getSchemaFile();
        if (schemaFile != null) {
            modifiedSchemaFiles.add(schemaFile);
        }
    }

    private void addObjectClass(ObjectClass objectClass, Schema schema, Set<String> modifiedSchemaFiles) throws DirectoryException {
        String schemaFile;
        ObjectClass existingClass = schema.getObjectClass(objectClass.getOID());
        for (String name : objectClass.getNormalizedNames()) {
            ObjectClass oc = schema.getObjectClass(name);
            if (oc == null) continue;
            if (existingClass == null) {
                existingClass = oc;
                continue;
            }
            if (existingClass == oc) continue;
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_MULTIPLE_CONFLICTS_FOR_ADD_OBJECTCLASS.get(objectClass.getNameOrOID(), existingClass.getNameOrOID(), oc.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        ObjectClass superiorClass = objectClass.getSuperiorClass();
        if (superiorClass != null) {
            Message message;
            if (!schema.hasObjectClass(superiorClass.getOID())) {
                message = BackendMessages.ERR_SCHEMA_MODIFY_UNDEFINED_SUPERIOR_OBJECTCLASS.get(objectClass.getNameOrOID(), superiorClass.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (superiorClass.isObsolete()) {
                message = BackendMessages.ERR_SCHEMA_MODIFY_OBSOLETE_SUPERIOR_OBJECTCLASS.get(objectClass.getNameOrOID(), superiorClass.getNameOrOID());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
        }
        for (AttributeType at : objectClass.getRequiredAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message = BackendMessages.ERR_SCHEMA_MODIFY_OC_UNDEFINED_REQUIRED_ATTR.get(objectClass.getNameOrOID(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (!at.isObsolete()) continue;
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_OC_OBSOLETE_REQUIRED_ATTR.get(objectClass.getNameOrOID(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        for (AttributeType at : objectClass.getOptionalAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message = BackendMessages.ERR_SCHEMA_MODIFY_OC_UNDEFINED_OPTIONAL_ATTR.get(objectClass.getNameOrOID(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            if (!at.isObsolete()) continue;
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_OC_OBSOLETE_OPTIONAL_ATTR.get(objectClass.getNameOrOID(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (existingClass == null) {
            schema.registerObjectClass(objectClass, false);
            schemaFile = objectClass.getSchemaFile();
            if (schemaFile == null || schemaFile.length() == 0) {
                schemaFile = "99-user.ldif";
                objectClass.setSchemaFile(schemaFile);
            }
            modifiedSchemaFiles.add(schemaFile);
        } else {
            schema.deregisterObjectClass(existingClass);
            schema.registerObjectClass(objectClass, false);
            schema.rebuildDependentElements(existingClass);
            if (objectClass.getSchemaFile() == null || objectClass.getSchemaFile().length() == 0) {
                schemaFile = existingClass.getSchemaFile();
                if (schemaFile == null || schemaFile.length() == 0) {
                    schemaFile = "99-user.ldif";
                }
                objectClass.setSchemaFile(schemaFile);
                modifiedSchemaFiles.add(schemaFile);
            } else {
                String newSchemaFile = objectClass.getSchemaFile();
                String oldSchemaFile = existingClass.getSchemaFile();
                if (oldSchemaFile == null || oldSchemaFile.equals(newSchemaFile)) {
                    modifiedSchemaFiles.add(newSchemaFile);
                } else {
                    modifiedSchemaFiles.add(newSchemaFile);
                    modifiedSchemaFiles.add(oldSchemaFile);
                }
            }
        }
    }

    private void removeObjectClass(ObjectClass objectClass, Schema schema, ArrayList<Modification> modifications, int currentPosition, Set<String> modifiedSchemaFiles) throws DirectoryException {
        Message message;
        ObjectClass removeClass = schema.getObjectClass(objectClass.getOID());
        if (removeClass == null || !removeClass.equals(objectClass)) {
            Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NO_SUCH_OBJECTCLASS.get(objectClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
        }
        for (int i = currentPosition + 1; i < modifications.size(); ++i) {
            Modification m = modifications.get(i);
            Attribute a = m.getAttribute();
            if (m.getModificationType() != ModificationType.ADD || !a.getAttributeType().equals(this.objectClassesType)) continue;
            for (AttributeValue v : a.getValues()) {
                ObjectClass oc;
                try {
                    oc = ObjectClassSyntax.decodeObjectClass(v.getValue(), schema, true);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_OBJECTCLASS.get(v.getStringValue(), de.getMessageObject());
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3, de);
                }
                if (!objectClass.getOID().equals(oc.getOID())) continue;
                return;
            }
        }
        for (ObjectClass oc : schema.getObjectClasses().values()) {
            ObjectClass superiorClass = oc.getSuperiorClass();
            if (superiorClass == null || !superiorClass.equals(removeClass)) continue;
            message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_OC_SUPERIOR_CLASS.get(removeClass.getNameOrOID(), superiorClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        NameForm nf = schema.getNameForm(removeClass);
        if (nf != null) {
            Message message4 = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_OC_IN_NF.get(removeClass.getNameOrOID(), nf.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message4);
        }
        for (DITContentRule dcr : schema.getDITContentRules().values()) {
            if (!dcr.getStructuralClass().equals(removeClass) && !dcr.getAuxiliaryClasses().contains(removeClass)) continue;
            message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_OC_IN_DCR.get(removeClass.getNameOrOID(), dcr.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        schema.deregisterObjectClass(removeClass);
        String schemaFile = removeClass.getSchemaFile();
        if (schemaFile != null) {
            modifiedSchemaFiles.add(schemaFile);
        }
    }

    private void addNameForm(NameForm nameForm, Schema schema, Set<String> modifiedSchemaFiles) throws DirectoryException {
        String schemaFile;
        Message message;
        NameForm existingNF = schema.getNameForm(nameForm.getOID());
        for (String name : nameForm.getNames().keySet()) {
            NameForm nf = schema.getNameForm(name);
            if (nf == null) continue;
            if (existingNF == null) {
                existingNF = nf;
                continue;
            }
            if (existingNF == nf) continue;
            Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_MULTIPLE_CONFLICTS_FOR_ADD_NAME_FORM.get(nameForm.getNameOrOID(), existingNF.getNameOrOID(), nf.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
        }
        ObjectClass structuralClass = nameForm.getStructuralClass();
        if (!schema.hasObjectClass(structuralClass.getOID())) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_NF_UNDEFINED_STRUCTURAL_OC.get(nameForm.getNameOrOID(), structuralClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_NF_OC_NOT_STRUCTURAL.get(nameForm.getNameOrOID(), structuralClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (structuralClass.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_NF_OC_OBSOLETE.get(nameForm.getNameOrOID(), structuralClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        NameForm existingNFForClass = schema.getNameForm(structuralClass);
        if (existingNFForClass != null && existingNFForClass != existingNF) {
            Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_STRUCTURAL_OC_CONFLICT_FOR_ADD_NF.get(nameForm.getNameOrOID(), structuralClass.getNameOrOID(), existingNFForClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message3);
        }
        for (AttributeType at : nameForm.getRequiredAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message4 = BackendMessages.ERR_SCHEMA_MODIFY_NF_UNDEFINED_REQUIRED_ATTR.get(nameForm.getNameOrOID(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message4);
            }
            if (!at.isObsolete()) continue;
            Message message5 = BackendMessages.ERR_SCHEMA_MODIFY_NF_OBSOLETE_REQUIRED_ATTR.get(nameForm.getNameOrOID(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message5);
        }
        for (AttributeType at : nameForm.getOptionalAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message6 = BackendMessages.ERR_SCHEMA_MODIFY_NF_UNDEFINED_OPTIONAL_ATTR.get(nameForm.getNameOrOID(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message6);
            }
            if (!at.isObsolete()) continue;
            Message message7 = BackendMessages.ERR_SCHEMA_MODIFY_NF_OBSOLETE_OPTIONAL_ATTR.get(nameForm.getNameOrOID(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message7);
        }
        if (existingNF == null) {
            schema.registerNameForm(nameForm, false);
            schemaFile = nameForm.getSchemaFile();
            if (schemaFile == null || schemaFile.length() == 0) {
                schemaFile = "99-user.ldif";
                nameForm.setSchemaFile(schemaFile);
            }
            modifiedSchemaFiles.add(schemaFile);
        } else {
            schema.deregisterNameForm(existingNF);
            schema.registerNameForm(nameForm, false);
            schema.rebuildDependentElements(existingNF);
            if (nameForm.getSchemaFile() == null || nameForm.getSchemaFile().length() == 0) {
                schemaFile = existingNF.getSchemaFile();
                if (schemaFile == null || schemaFile.length() == 0) {
                    schemaFile = "99-user.ldif";
                }
                nameForm.setSchemaFile(schemaFile);
                modifiedSchemaFiles.add(schemaFile);
            } else {
                String newSchemaFile = nameForm.getSchemaFile();
                String oldSchemaFile = existingNF.getSchemaFile();
                if (oldSchemaFile == null || oldSchemaFile.equals(newSchemaFile)) {
                    modifiedSchemaFiles.add(newSchemaFile);
                } else {
                    modifiedSchemaFiles.add(newSchemaFile);
                    modifiedSchemaFiles.add(oldSchemaFile);
                }
            }
        }
    }

    private void removeNameForm(NameForm nameForm, Schema schema, ArrayList<Modification> modifications, int currentPosition, Set<String> modifiedSchemaFiles) throws DirectoryException {
        NameForm removeNF = schema.getNameForm(nameForm.getOID());
        if (removeNF == null || !removeNF.equals(nameForm)) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NO_SUCH_NAME_FORM.get(nameForm.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        for (int i = currentPosition + 1; i < modifications.size(); ++i) {
            Modification m = modifications.get(i);
            Attribute a = m.getAttribute();
            if (m.getModificationType() != ModificationType.ADD || !a.getAttributeType().equals(this.nameFormsType)) continue;
            for (AttributeValue v : a.getValues()) {
                NameForm nf;
                try {
                    nf = NameFormSyntax.decodeNameForm(v.getValue(), schema, true);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_NAME_FORM.get(v.getStringValue(), de.getMessageObject());
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                }
                if (!nameForm.getOID().equals(nf.getOID())) continue;
                return;
            }
        }
        DITStructureRule dsr = schema.getDITStructureRule(removeNF);
        if (dsr != null) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NF_IN_DSR.get(removeNF.getNameOrOID(), dsr.getNameOrRuleID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        schema.deregisterNameForm(removeNF);
        String schemaFile = removeNF.getSchemaFile();
        if (schemaFile != null) {
            modifiedSchemaFiles.add(schemaFile);
        }
    }

    private void addDITContentRule(DITContentRule ditContentRule, Schema schema, Set<String> modifiedSchemaFiles) throws DirectoryException {
        String schemaFile;
        Message message;
        DITContentRule existingDCR = null;
        block0: for (DITContentRule dcr : schema.getDITContentRules().values()) {
            for (String name : ditContentRule.getNames().keySet()) {
                if (!dcr.hasName(name)) continue;
                if (existingDCR == null) {
                    existingDCR = dcr;
                    continue block0;
                }
                Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_MULTIPLE_CONFLICTS_FOR_ADD_DCR.get(ditContentRule.getName(), existingDCR.getName(), dcr.getName());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
            }
        }
        ObjectClass structuralClass = ditContentRule.getStructuralClass();
        DITContentRule existingRuleForClass = schema.getDITContentRule(structuralClass);
        if (existingRuleForClass != null && existingRuleForClass != existingDCR) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_STRUCTURAL_OC_CONFLICT_FOR_ADD_DCR.get(ditContentRule.getName(), structuralClass.getNameOrOID(), existingRuleForClass.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (!schema.hasObjectClass(structuralClass.getOID())) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_DCR_UNDEFINED_STRUCTURAL_OC.get(ditContentRule.getName(), structuralClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_DCR_OC_NOT_STRUCTURAL.get(ditContentRule.getName(), structuralClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (structuralClass.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_DCR_STRUCTURAL_OC_OBSOLETE.get(ditContentRule.getName(), structuralClass.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        for (ObjectClass oc : ditContentRule.getAuxiliaryClasses()) {
            if (!schema.hasObjectClass(oc.getOID())) {
                Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_UNDEFINED_AUXILIARY_OC.get(ditContentRule.getName(), oc.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message3);
            }
            if (oc.getObjectClassType() != ObjectClassType.AUXILIARY) {
                Message message4 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_OC_NOT_AUXILIARY.get(ditContentRule.getName(), oc.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message4);
            }
            if (!oc.isObsolete()) continue;
            Message message5 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_OBSOLETE_AUXILIARY_OC.get(ditContentRule.getName(), oc.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message5);
        }
        for (AttributeType at : ditContentRule.getRequiredAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message6 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_UNDEFINED_REQUIRED_ATTR.get(ditContentRule.getName(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message6);
            }
            if (!at.isObsolete()) continue;
            Message message7 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_OBSOLETE_REQUIRED_ATTR.get(ditContentRule.getName(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message7);
        }
        for (AttributeType at : ditContentRule.getOptionalAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message8 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_UNDEFINED_OPTIONAL_ATTR.get(ditContentRule.getName(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message8);
            }
            if (!at.isObsolete()) continue;
            Message message9 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_OBSOLETE_OPTIONAL_ATTR.get(ditContentRule.getName(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message9);
        }
        for (AttributeType at : ditContentRule.getProhibitedAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message10 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_UNDEFINED_PROHIBITED_ATTR.get(ditContentRule.getName(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message10);
            }
            if (!at.isObsolete()) continue;
            Message message11 = BackendMessages.ERR_SCHEMA_MODIFY_DCR_OBSOLETE_PROHIBITED_ATTR.get(ditContentRule.getName(), at.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message11);
        }
        if (existingDCR == null) {
            schema.registerDITContentRule(ditContentRule, false);
            schemaFile = ditContentRule.getSchemaFile();
            if (schemaFile == null || schemaFile.length() == 0) {
                schemaFile = "99-user.ldif";
                ditContentRule.setSchemaFile(schemaFile);
            }
            modifiedSchemaFiles.add(schemaFile);
        } else {
            schema.deregisterDITContentRule(existingDCR);
            schema.registerDITContentRule(ditContentRule, false);
            schema.rebuildDependentElements(existingDCR);
            if (ditContentRule.getSchemaFile() == null || ditContentRule.getSchemaFile().length() == 0) {
                schemaFile = existingDCR.getSchemaFile();
                if (schemaFile == null || schemaFile.length() == 0) {
                    schemaFile = "99-user.ldif";
                }
                ditContentRule.setSchemaFile(schemaFile);
                modifiedSchemaFiles.add(schemaFile);
            } else {
                String newSchemaFile = ditContentRule.getSchemaFile();
                String oldSchemaFile = existingDCR.getSchemaFile();
                if (oldSchemaFile == null || oldSchemaFile.equals(newSchemaFile)) {
                    modifiedSchemaFiles.add(newSchemaFile);
                } else {
                    modifiedSchemaFiles.add(newSchemaFile);
                    modifiedSchemaFiles.add(oldSchemaFile);
                }
            }
        }
    }

    private void removeDITContentRule(DITContentRule ditContentRule, Schema schema, ArrayList<Modification> modifications, int currentPosition, Set<String> modifiedSchemaFiles) throws DirectoryException {
        DITContentRule removeDCR = schema.getDITContentRule(ditContentRule.getStructuralClass());
        if (removeDCR == null || !removeDCR.equals(ditContentRule)) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NO_SUCH_DCR.get(ditContentRule.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        schema.deregisterDITContentRule(removeDCR);
        String schemaFile = removeDCR.getSchemaFile();
        if (schemaFile != null) {
            modifiedSchemaFiles.add(schemaFile);
        }
    }

    private void addDITStructureRule(DITStructureRule ditStructureRule, Schema schema, Set<String> modifiedSchemaFiles) throws DirectoryException {
        String schemaFile;
        Message message;
        DITStructureRule existingDSR = schema.getDITStructureRule(ditStructureRule.getRuleID());
        for (DITStructureRule dsr : schema.getDITStructureRulesByID().values()) {
            for (String name : ditStructureRule.getNames().keySet()) {
                if (!dsr.hasName(name) || existingDSR == null || existingDSR == dsr) continue;
                Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_MULTIPLE_CONFLICTS_FOR_ADD_DSR.get(ditStructureRule.getNameOrRuleID(), existingDSR.getNameOrRuleID(), dsr.getNameOrRuleID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
            }
        }
        NameForm nameForm = ditStructureRule.getNameForm();
        DITStructureRule existingRuleForNameForm = schema.getDITStructureRule(nameForm);
        if (existingRuleForNameForm != null && existingRuleForNameForm != existingDSR) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_NAME_FORM_CONFLICT_FOR_ADD_DSR.get(ditStructureRule.getNameOrRuleID(), nameForm.getNameOrOID(), existingRuleForNameForm.getNameOrRuleID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (!schema.hasNameForm(nameForm.getOID())) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_DSR_UNDEFINED_NAME_FORM.get(ditStructureRule.getNameOrRuleID(), nameForm.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (nameForm.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_DSR_OBSOLETE_NAME_FORM.get(ditStructureRule.getNameOrRuleID(), nameForm.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        for (DITStructureRule dsr : ditStructureRule.getSuperiorRules()) {
            if (!dsr.isObsolete()) continue;
            Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_DSR_OBSOLETE_SUPERIOR_RULE.get(ditStructureRule.getNameOrRuleID(), dsr.getNameOrRuleID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message3);
        }
        if (existingDSR == null) {
            schema.registerDITStructureRule(ditStructureRule, false);
            schemaFile = ditStructureRule.getSchemaFile();
            if (schemaFile == null || schemaFile.length() == 0) {
                schemaFile = "99-user.ldif";
                ditStructureRule.setSchemaFile(schemaFile);
            }
            modifiedSchemaFiles.add(schemaFile);
        } else {
            schema.deregisterDITStructureRule(existingDSR);
            schema.registerDITStructureRule(ditStructureRule, false);
            schema.rebuildDependentElements(existingDSR);
            if (ditStructureRule.getSchemaFile() == null || ditStructureRule.getSchemaFile().length() == 0) {
                schemaFile = existingDSR.getSchemaFile();
                if (schemaFile == null || schemaFile.length() == 0) {
                    schemaFile = "99-user.ldif";
                }
                ditStructureRule.setSchemaFile(schemaFile);
                modifiedSchemaFiles.add(schemaFile);
            } else {
                String newSchemaFile = ditStructureRule.getSchemaFile();
                String oldSchemaFile = existingDSR.getSchemaFile();
                if (oldSchemaFile == null || oldSchemaFile.equals(newSchemaFile)) {
                    modifiedSchemaFiles.add(newSchemaFile);
                } else {
                    modifiedSchemaFiles.add(newSchemaFile);
                    modifiedSchemaFiles.add(oldSchemaFile);
                }
            }
        }
    }

    private void removeDITStructureRule(DITStructureRule ditStructureRule, Schema schema, ArrayList<Modification> modifications, int currentPosition, Set<String> modifiedSchemaFiles) throws DirectoryException {
        DITStructureRule removeDSR = schema.getDITStructureRule(ditStructureRule.getRuleID());
        if (removeDSR == null || !removeDSR.equals(ditStructureRule)) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NO_SUCH_DSR.get(ditStructureRule.getNameOrRuleID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        for (int i = currentPosition + 1; i < modifications.size(); ++i) {
            Modification m = modifications.get(i);
            Attribute a = m.getAttribute();
            if (m.getModificationType() != ModificationType.ADD || !a.getAttributeType().equals(this.ditStructureRulesType)) continue;
            for (AttributeValue v : a.getValues()) {
                DITStructureRule dsr;
                try {
                    dsr = DITStructureRuleSyntax.decodeDITStructureRule(v.getValue(), schema, true);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_DECODE_DSR.get(v.getStringValue(), de.getMessageObject());
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, de);
                }
                if (ditStructureRule.getRuleID() != dsr.getRuleID()) continue;
                return;
            }
        }
        for (DITStructureRule dsr : schema.getDITStructureRulesByID().values()) {
            if (!dsr.getSuperiorRules().contains(removeDSR)) continue;
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_DSR_SUPERIOR_RULE.get(removeDSR.getNameOrRuleID(), dsr.getNameOrRuleID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        schema.deregisterDITStructureRule(removeDSR);
        String schemaFile = removeDSR.getSchemaFile();
        if (schemaFile != null) {
            modifiedSchemaFiles.add(schemaFile);
        }
    }

    private void addMatchingRuleUse(MatchingRuleUse matchingRuleUse, Schema schema, Set<String> modifiedSchemaFiles) throws DirectoryException {
        String schemaFile;
        Message message;
        MatchingRuleUse existingMRU = null;
        block0: for (MatchingRuleUse mru : schema.getMatchingRuleUses().values()) {
            for (String name : matchingRuleUse.getNames().keySet()) {
                if (!mru.hasName(name)) continue;
                if (existingMRU == null) {
                    existingMRU = mru;
                    continue block0;
                }
                Message message2 = BackendMessages.ERR_SCHEMA_MODIFY_MULTIPLE_CONFLICTS_FOR_ADD_MR_USE.get(matchingRuleUse.getName(), existingMRU.getName(), mru.getName());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2);
            }
        }
        MatchingRule matchingRule = matchingRuleUse.getMatchingRule();
        MatchingRuleUse existingMRUForRule = schema.getMatchingRuleUse(matchingRule);
        if (existingMRUForRule != null && existingMRUForRule != existingMRU) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_MR_CONFLICT_FOR_ADD_MR_USE.get(matchingRuleUse.getName(), matchingRule.getNameOrOID(), existingMRUForRule.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (matchingRule.isObsolete()) {
            message = BackendMessages.ERR_SCHEMA_MODIFY_MRU_OBSOLETE_MR.get(matchingRuleUse.getName(), matchingRule.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        for (AttributeType at : matchingRuleUse.getAttributes()) {
            if (!schema.hasAttributeType(at.getOID())) {
                Message message3 = BackendMessages.ERR_SCHEMA_MODIFY_MRU_UNDEFINED_ATTR.get(matchingRuleUse.getName(), at.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message3);
            }
            if (!at.isObsolete()) continue;
            Message message4 = BackendMessages.ERR_SCHEMA_MODIFY_MRU_OBSOLETE_ATTR.get(matchingRuleUse.getName(), matchingRule.getNameOrOID());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message4);
        }
        if (existingMRU == null) {
            schema.registerMatchingRuleUse(matchingRuleUse, false);
            schemaFile = matchingRuleUse.getSchemaFile();
            if (schemaFile == null || schemaFile.length() == 0) {
                schemaFile = "99-user.ldif";
                matchingRuleUse.setSchemaFile(schemaFile);
            }
            modifiedSchemaFiles.add(schemaFile);
        } else {
            schema.deregisterMatchingRuleUse(existingMRU);
            schema.registerMatchingRuleUse(matchingRuleUse, false);
            schema.rebuildDependentElements(existingMRU);
            if (matchingRuleUse.getSchemaFile() == null || matchingRuleUse.getSchemaFile().length() == 0) {
                schemaFile = existingMRU.getSchemaFile();
                if (schemaFile == null || schemaFile.length() == 0) {
                    schemaFile = "99-user.ldif";
                }
                matchingRuleUse.setSchemaFile(schemaFile);
                modifiedSchemaFiles.add(schemaFile);
            } else {
                String newSchemaFile = matchingRuleUse.getSchemaFile();
                String oldSchemaFile = existingMRU.getSchemaFile();
                if (oldSchemaFile == null || oldSchemaFile.equals(newSchemaFile)) {
                    modifiedSchemaFiles.add(newSchemaFile);
                } else {
                    modifiedSchemaFiles.add(newSchemaFile);
                    modifiedSchemaFiles.add(oldSchemaFile);
                }
            }
        }
    }

    private void removeMatchingRuleUse(MatchingRuleUse matchingRuleUse, Schema schema, ArrayList<Modification> modifications, int currentPosition, Set<String> modifiedSchemaFiles) throws DirectoryException {
        MatchingRuleUse removeMRU = schema.getMatchingRuleUse(matchingRuleUse.getMatchingRule());
        if (removeMRU == null || !removeMRU.equals(matchingRuleUse)) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_REMOVE_NO_SUCH_MR_USE.get(matchingRuleUse.getName());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        schema.deregisterMatchingRuleUse(removeMRU);
        String schemaFile = removeMRU.getSchemaFile();
        if (schemaFile != null) {
            modifiedSchemaFiles.add(schemaFile);
        }
    }

    private Entry createEmptySchemaEntry() {
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
        objectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        objectClasses.put(DirectoryServer.getObjectClass("ldapsubentry", true), "ldapSubentry");
        objectClasses.put(DirectoryServer.getObjectClass("subschema", true), "subschema");
        LinkedHashMap<AttributeType, List<Attribute>> userAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
        DN dn = DirectoryServer.getSchemaDN();
        RDN rdn = dn.getRDN();
        for (int i = 0; i < rdn.getNumValues(); ++i) {
            AttributeType type = rdn.getAttributeType(i);
            String name = rdn.getAttributeName(i);
            LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(1);
            values.add(rdn.getAttributeValue(i));
            LinkedList<Attribute> attrList = new LinkedList<Attribute>();
            attrList.add(new Attribute(type, name, values));
            if (type.isOperational()) {
                operationalAttributes.put(type, attrList);
                continue;
            }
            userAttributes.put(type, attrList);
        }
        return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
    }

    private File writeTempSchemaFile(Schema schema, String schemaFile) throws DirectoryException, IOException, LDIFException {
        ArrayList<Attribute> attrList;
        ArrayList<Attribute> attrList2;
        Entry schemaEntry = this.createEmptySchemaEntry();
        HashSet<AttributeType> addedTypes = new HashSet<AttributeType>();
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        for (AttributeType at : schema.getAttributeTypes().values()) {
            if (!schemaFile.equals(at.getSchemaFile())) continue;
            this.addAttrTypeToSchemaFile(schema, schemaFile, at, values, addedTypes, 0);
        }
        if (!values.isEmpty()) {
            ArrayList<Attribute> attrList3 = new ArrayList<Attribute>(1);
            attrList3.add(new Attribute(this.attributeTypesType, this.attributeTypesType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.attributeTypesType, attrList3);
        }
        HashSet<ObjectClass> addedClasses = new HashSet<ObjectClass>();
        values = new LinkedHashSet();
        for (ObjectClass oc : schema.getObjectClasses().values()) {
            if (!schemaFile.equals(oc.getSchemaFile())) continue;
            this.addObjectClassToSchemaFile(schema, schemaFile, oc, values, addedClasses, 0);
        }
        if (!values.isEmpty()) {
            attrList2 = new ArrayList<Attribute>(1);
            attrList2.add(new Attribute(this.objectClassesType, this.objectClassesType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.objectClassesType, attrList2);
        }
        values = new LinkedHashSet();
        for (NameForm nf : schema.getNameFormsByObjectClass().values()) {
            if (!schemaFile.equals(nf.getSchemaFile())) continue;
            values.add(new AttributeValue(this.nameFormsType, nf.getDefinition()));
        }
        if (!values.isEmpty()) {
            attrList2 = new ArrayList(1);
            attrList2.add(new Attribute(this.nameFormsType, this.nameFormsType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.nameFormsType, attrList2);
        }
        values = new LinkedHashSet();
        for (DITContentRule dcr : schema.getDITContentRules().values()) {
            if (!schemaFile.equals(dcr.getSchemaFile())) continue;
            values.add(new AttributeValue(this.ditContentRulesType, dcr.getDefinition()));
        }
        if (!values.isEmpty()) {
            attrList2 = new ArrayList(1);
            attrList2.add(new Attribute(this.ditContentRulesType, this.ditContentRulesType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.ditContentRulesType, attrList2);
        }
        HashSet<DITStructureRule> addedDSRs = new HashSet<DITStructureRule>();
        values = new LinkedHashSet();
        for (DITStructureRule dsr : schema.getDITStructureRulesByID().values()) {
            if (!schemaFile.equals(dsr.getSchemaFile())) continue;
            this.addDITStructureRuleToSchemaFile(schema, schemaFile, dsr, values, addedDSRs, 0);
        }
        if (!values.isEmpty()) {
            attrList = new ArrayList<Attribute>(1);
            attrList.add(new Attribute(this.ditStructureRulesType, this.ditStructureRulesType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.ditStructureRulesType, attrList);
        }
        values = new LinkedHashSet();
        for (MatchingRuleUse mru : schema.getMatchingRuleUses().values()) {
            if (!schemaFile.equals(mru.getSchemaFile())) continue;
            values.add(new AttributeValue(this.matchingRuleUsesType, mru.getDefinition()));
        }
        if (!values.isEmpty()) {
            attrList = new ArrayList(1);
            attrList.add(new Attribute(this.matchingRuleUsesType, this.matchingRuleUsesType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.matchingRuleUsesType, attrList);
        }
        if (schemaFile.equals("99-user.ldif") && (values = schema.getSynchronizationState()) != null) {
            attrList = new ArrayList(1);
            attrList.add(new Attribute(this.synchronizationStateType, this.synchronizationStateType.getPrimaryName(), values));
            schemaEntry.putAttribute(this.synchronizationStateType, attrList);
        }
        File tempFile = File.createTempFile(schemaFile, "temp");
        LDIFExportConfig exportConfig = new LDIFExportConfig(tempFile.getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
        LDIFWriter ldifWriter = new LDIFWriter(exportConfig);
        ldifWriter.writeEntry(schemaEntry);
        ldifWriter.close();
        return tempFile;
    }

    private void addAttrTypeToSchemaFile(Schema schema, String schemaFile, AttributeType attributeType, LinkedHashSet<AttributeValue> values, HashSet<AttributeType> addedTypes, int depth) throws DirectoryException {
        if (depth > 20) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_CIRCULAR_REFERENCE_AT.get(attributeType.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (addedTypes.contains(attributeType)) {
            return;
        }
        AttributeType superiorType = attributeType.getSuperiorType();
        if (superiorType != null && schemaFile.equals(superiorType.getSchemaFile()) && !addedTypes.contains(superiorType)) {
            this.addAttrTypeToSchemaFile(schema, schemaFile, superiorType, values, addedTypes, depth + 1);
        }
        values.add(new AttributeValue(this.attributeTypesType, attributeType.getDefinition()));
        addedTypes.add(attributeType);
    }

    private void addObjectClassToSchemaFile(Schema schema, String schemaFile, ObjectClass objectClass, LinkedHashSet<AttributeValue> values, HashSet<ObjectClass> addedClasses, int depth) throws DirectoryException {
        if (depth > 20) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_CIRCULAR_REFERENCE_OC.get(objectClass.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (addedClasses.contains(objectClass)) {
            return;
        }
        ObjectClass superiorClass = objectClass.getSuperiorClass();
        if (superiorClass != null && schemaFile.equals(superiorClass.getSchemaFile()) && !addedClasses.contains(superiorClass)) {
            this.addObjectClassToSchemaFile(schema, schemaFile, superiorClass, values, addedClasses, depth + 1);
        }
        values.add(new AttributeValue(this.objectClassesType, objectClass.getDefinition()));
        addedClasses.add(objectClass);
    }

    private void addDITStructureRuleToSchemaFile(Schema schema, String schemaFile, DITStructureRule ditStructureRule, LinkedHashSet<AttributeValue> values, HashSet<DITStructureRule> addedDSRs, int depth) throws DirectoryException {
        if (depth > 20) {
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_CIRCULAR_REFERENCE_DSR.get(ditStructureRule.getNameOrRuleID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        if (addedDSRs.contains(ditStructureRule)) {
            return;
        }
        for (DITStructureRule dsr : ditStructureRule.getSuperiorRules()) {
            if (!schemaFile.equals(dsr.getSchemaFile()) || addedDSRs.contains(dsr)) continue;
            this.addDITStructureRuleToSchemaFile(schema, schemaFile, dsr, values, addedDSRs, depth + 1);
        }
        values.add(new AttributeValue(this.ditStructureRulesType, ditStructureRule.getDefinition()));
        addedDSRs.add(ditStructureRule);
    }

    private void installSchemaFiles(HashMap<String, File> tempSchemaFiles) throws DirectoryException {
        File installedFile;
        int i;
        ArrayList<File> installedFileList = new ArrayList<File>();
        ArrayList<File> tempFileList = new ArrayList<File>();
        ArrayList<File> origFileList = new ArrayList<File>();
        File schemaDir = new File(SchemaConfigManager.getSchemaDirectoryPath());
        for (String name : tempSchemaFiles.keySet()) {
            installedFileList.add(new File(schemaDir, name));
            tempFileList.add(tempSchemaFiles.get(name));
            origFileList.add(new File(schemaDir, name + ".orig"));
        }
        for (File f : origFileList) {
            if (!f.exists()) continue;
            f.delete();
        }
        try {
            for (i = 0; i < installedFileList.size(); ++i) {
                installedFile = (File)installedFileList.get(i);
                File origFile = (File)origFileList.get(i);
                if (!installedFile.exists()) continue;
                this.copyFile(installedFile, origFile);
            }
        }
        catch (Exception e) {
            Message message;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            boolean allCleaned = true;
            for (File f : origFileList) {
                try {
                    if (!f.exists() || f.delete()) continue;
                    allCleaned = false;
                }
                catch (Exception e2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                    allCleaned = false;
                }
            }
            if (allCleaned) {
                message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_WRITE_ORIG_FILES_CLEANED.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
            message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_WRITE_ORIG_FILES_NOT_CLEANED.get(StaticUtils.getExceptionMessage(e));
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotCopySchemaFiles", message);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            for (i = 0; i < installedFileList.size(); ++i) {
                installedFile = (File)installedFileList.get(i);
                File tempFile = (File)tempFileList.get(i);
                this.copyFile(tempFile, installedFile);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            for (File f : installedFileList) {
                try {
                    if (!f.exists()) continue;
                    f.delete();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
            boolean allRestored = true;
            for (int i2 = 0; i2 < installedFileList.size(); ++i2) {
                File installedFile2 = (File)installedFileList.get(i2);
                File origFile = (File)origFileList.get(i2);
                try {
                    if (!origFile.exists() || origFile.renameTo(installedFile2)) continue;
                    allRestored = false;
                    continue;
                }
                catch (Exception e2) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                    }
                    allRestored = false;
                }
            }
            if (allRestored) {
                Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_WRITE_NEW_FILES_RESTORED.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
            Message message = BackendMessages.ERR_SCHEMA_MODIFY_CANNOT_WRITE_NEW_FILES_NOT_RESTORED.get(StaticUtils.getExceptionMessage(e));
            DirectoryServer.sendAlertNotification(this, "org.opends.server.CannotWriteNewSchemaFiles", message);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        for (File f : origFileList) {
            try {
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (File f : tempFileList) {
            try {
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File from, File to) throws IOException {
        byte[] buffer = new byte[4096];
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(from);
            outputStream = new FileOutputStream(to, false);
            int bytesRead = inputStream.read(buffer);
            while (bytesRead > 0) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        finally {
            block11: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block11;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private void cleanUpTempSchemaFiles(HashMap<String, File> tempSchemaFiles) {
        if (tempSchemaFiles == null || tempSchemaFiles.isEmpty()) {
            return;
        }
        for (File f : tempSchemaFiles.values()) {
            try {
                if (!f.exists()) continue;
                f.delete();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_SCHEMA_MODIFY_DN_NOT_SUPPORTED.get(String.valueOf(currentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        boolean found = false;
        DN[] dnArray = this.baseDNs;
        DN matchedDN = null;
        for (DN dn : dnArray) {
            if (dn.equals(baseDN)) {
                found = true;
                break;
            }
            if (!dn.isAncestorOf(baseDN)) continue;
            matchedDN = dn;
            break;
        }
        if (!found) {
            Message message = BackendMessages.ERR_SCHEMA_INVALID_BASE.get(String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message, matchedDN, null);
        }
        SearchScope scope = searchOperation.getScope();
        if (scope == SearchScope.SINGLE_LEVEL || scope == SearchScope.SUBORDINATE_SUBTREE) {
            return;
        }
        Entry schemaEntry = this.getSchemaEntry(baseDN);
        SearchFilter filter = searchOperation.getFilter();
        if (filter.matchesEntry(schemaEntry)) {
            searchOperation.returnEntry(schemaEntry, null);
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        LDIFWriter ldifWriter;
        try {
            ldifWriter = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_SCHEMA_UNABLE_TO_CREATE_LDIF_WRITER.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            ldifWriter.writeEntry(this.getSchemaEntry(this.baseDNs[0]));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_SCHEMA_UNABLE_TO_EXPORT_BASE.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        finally {
            block14: {
                try {
                    ldifWriter.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block14;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_SCHEMA_IMPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return true;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        File[] schemaFiles;
        OutputStream outputStream;
        String backupID = backupConfig.getBackupID();
        BackupDirectory backupDirectory = backupConfig.getBackupDirectory();
        boolean compress = backupConfig.compressData();
        boolean encrypt = backupConfig.encryptData();
        boolean hash = backupConfig.hashData();
        boolean signHash = backupConfig.signHash();
        HashMap<String, String> backupProperties = new HashMap<String, String>();
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        Mac mac = null;
        MessageDigest digest = null;
        String digestAlgorithm = null;
        String macAlgorithm = null;
        if (hash) {
            if (signHash) {
                macAlgorithm = cryptoManager.getPreferredMACAlgorithm();
                backupProperties.put("mac_algorithm", macAlgorithm);
                try {
                    mac = cryptoManager.getPreferredMACProvider();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_GET_MAC.get(macAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                }
            }
            digestAlgorithm = cryptoManager.getPreferredMessageDigestAlgorithm();
            backupProperties.put("digest_algorithm", digestAlgorithm);
            try {
                digest = cryptoManager.getPreferredMessageDigest();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_GET_DIGEST.get(digestAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        String filename = null;
        try {
            filename = "schema-backup-" + backupID;
            File archiveFile = new File(backupDirectory.getPath() + File.separator + filename);
            if (archiveFile.exists()) {
                int i = 1;
                while ((archiveFile = new File(backupDirectory.getPath() + File.separator + filename + "." + i)).exists()) {
                    ++i;
                }
                filename = filename + "." + i;
            }
            outputStream = new FileOutputStream(archiveFile, false);
            backupProperties.put("archive_file", filename);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_CREATE_ARCHIVE_FILE.get(String.valueOf(filename), backupDirectory.getPath(), StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        if (encrypt) {
            Cipher cipher;
            String cipherAlgorithm = cryptoManager.getPreferredCipherAlgorithm();
            backupProperties.put("cipher_algorithm", cipherAlgorithm);
            try {
                cipher = cryptoManager.getPreferredCipher(1);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_GET_CIPHER.get(cipherAlgorithm, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
            outputStream = new CipherOutputStream(outputStream, cipher);
        }
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        Message message = BackendMessages.ERR_SCHEMA_BACKUP_ZIP_COMMENT.get("OpenDS Directory Server", backupID);
        zipStream.setComment(String.valueOf(message));
        if (compress) {
            zipStream.setLevel(-1);
        } else {
            zipStream.setLevel(0);
        }
        String schemaDirPath = SchemaConfigManager.getSchemaDirectoryPath();
        try {
            File schemaDir = new File(schemaDirPath);
            schemaFiles = schemaDir.listFiles();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_LIST_SCHEMA_FILES.get(schemaDirPath, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] buffer = new byte[8192];
        for (File schemaFile : schemaFiles) {
            if (!schemaFile.isFile()) continue;
            String baseName = schemaFile.getName();
            if (hash) {
                if (signHash) {
                    mac.update(StaticUtils.getBytes(baseName));
                } else {
                    digest.update(StaticUtils.getBytes(baseName));
                }
            }
            InputStream inputStream = null;
            try {
                int bytesRead;
                ZipEntry zipEntry = new ZipEntry(baseName);
                zipStream.putNextEntry(zipEntry);
                inputStream = new FileInputStream(schemaFile);
                while ((bytesRead = inputStream.read(buffer)) >= 0) {
                    if (hash) {
                        if (signHash) {
                            mac.update(buffer, 0, bytesRead);
                        } else {
                            digest.update(buffer, 0, bytesRead);
                        }
                    }
                    zipStream.write(buffer, 0, bytesRead);
                }
                zipStream.closeEntry();
                inputStream.close();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                try {
                    inputStream.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    zipStream.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_BACKUP_SCHEMA_FILE.get(baseName, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_CLOSE_ZIP_STREAM.get(filename, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        byte[] digestBytes = null;
        byte[] macBytes = null;
        if (hash) {
            if (signHash) {
                macBytes = mac.doFinal();
            } else {
                digestBytes = digest.digest();
            }
        }
        BackupInfo backupInfo = new BackupInfo(backupDirectory, backupID, new Date(), false, compress, encrypt, digestBytes, macBytes, null, backupProperties);
        try {
            backupDirectory.addBackup(backupInfo);
            backupDirectory.writeBackupDirectoryDescriptor();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = BackendMessages.ERR_SCHEMA_BACKUP_CANNOT_UPDATE_BACKUP_DESCRIPTOR.get(backupDirectory.getDescriptorPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        Message message = BackendMessages.ERR_SCHEMA_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsRestore() {
        return true;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message;
        Message message2;
        InputStream inputStream;
        BackupDirectory backupDirectory = restoreConfig.getBackupDirectory();
        String backupPath = backupDirectory.getPath();
        String backupID = restoreConfig.getBackupID();
        BackupInfo backupInfo = backupDirectory.getBackupInfo(backupID);
        if (backupInfo == null) {
            Message message3 = BackendMessages.ERR_SCHEMA_RESTORE_NO_SUCH_BACKUP.get(backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message3);
        }
        String backupFilename = backupInfo.getBackupProperty("archive_file");
        if (backupFilename == null) {
            Message message4 = BackendMessages.ERR_SCHEMA_RESTORE_NO_BACKUP_FILE.get(backupID, backupPath);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message4);
        }
        File backupFile = new File(backupPath + File.separator + backupFilename);
        try {
            if (!backupFile.exists()) {
                Message message5 = BackendMessages.ERR_SCHEMA_RESTORE_NO_SUCH_FILE.get(backupID, backupFile.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message5);
            }
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            Message message6 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_CHECK_FOR_ARCHIVE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message6, e);
        }
        byte[] unsignedHash = backupInfo.getUnsignedHash();
        MessageDigest digest = null;
        if (unsignedHash != null) {
            String digestAlgorithm = backupInfo.getBackupProperty("digest_algorithm");
            if (digestAlgorithm == null) {
                Message message7 = BackendMessages.ERR_SCHEMA_RESTORE_UNKNOWN_DIGEST.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message7);
            }
            try {
                digest = DirectoryServer.getCryptoManager().getMessageDigest(digestAlgorithm);
            }
            catch (Exception e) {
                Message message8 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_GET_DIGEST.get(backupID, digestAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message8, e);
            }
        }
        byte[] signedHash = backupInfo.getSignedHash();
        Mac mac = null;
        if (signedHash != null) {
            String macAlgorithm = backupInfo.getBackupProperty("mac_algorithm");
            if (macAlgorithm == null) {
                Message message9 = BackendMessages.ERR_SCHEMA_RESTORE_UNKNOWN_MAC.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message9);
            }
            try {
                mac = DirectoryServer.getCryptoManager().getMACProvider(macAlgorithm);
            }
            catch (Exception e) {
                Message message10 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_GET_MAC.get(backupID, macAlgorithm);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message10, e);
            }
        }
        try {
            inputStream = new FileInputStream(backupFile);
        }
        catch (Exception e) {
            Message message11 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_OPEN_BACKUP_FILE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message11, e);
        }
        if (backupInfo.isEncrypted()) {
            Cipher cipher;
            String cipherAlgorithm = backupInfo.getBackupProperty("cipher_algorithm");
            if (cipherAlgorithm == null) {
                Message message12 = BackendMessages.ERR_SCHEMA_RESTORE_UNKNOWN_CIPHER.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message12);
            }
            try {
                cipher = DirectoryServer.getCryptoManager().getCipher(cipherAlgorithm, 2);
            }
            catch (Exception e) {
                Message message13 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_GET_CIPHER.get(cipherAlgorithm, backupFile.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message13, e);
            }
            inputStream = new CipherInputStream(inputStream, cipher);
        }
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        String schemaDirPath = SchemaConfigManager.getSchemaDirectoryPath();
        File schemaDir = new File(schemaDirPath);
        String backupDirPath = null;
        File schemaBackupDir = null;
        boolean verifyOnly = restoreConfig.verifyOnly();
        if (!verifyOnly) {
            try {
                if (schemaDir.exists()) {
                    String schemaBackupDirPath = schemaDirPath + ".save";
                    backupDirPath = schemaBackupDirPath;
                    schemaBackupDir = new File(backupDirPath);
                    if (schemaBackupDir.exists()) {
                        int i = 2;
                        while ((schemaBackupDir = new File(backupDirPath = schemaBackupDirPath + i)).exists()) {
                            ++i;
                        }
                    }
                    schemaDir.renameTo(schemaBackupDir);
                }
            }
            catch (Exception e) {
                Message message14 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_RENAME_CURRENT_DIRECTORY.get(backupID, schemaDirPath, String.valueOf(backupDirPath), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message14, e);
            }
            try {
                schemaDir.mkdirs();
            }
            catch (Exception e) {
                if (schemaBackupDir != null) {
                    try {
                        schemaBackupDir.renameTo(schemaDir);
                        Message message15 = BackendMessages.NOTE_SCHEMA_RESTORE_RESTORED_OLD_SCHEMA.get(schemaDirPath);
                        ErrorLogger.logError(message15);
                    }
                    catch (Exception e2) {
                        Message message16 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_RESTORE_OLD_SCHEMA.get(schemaBackupDir.getPath());
                        ErrorLogger.logError(message16);
                    }
                }
                Message message17 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_CREATE_SCHEMA_DIRECTORY.get(backupID, schemaDirPath, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message17, e);
            }
        }
        byte[] buffer = new byte[8192];
        while (true) {
            ZipEntry zipEntry;
            try {
                zipEntry = zipStream.getNextEntry();
            }
            catch (Exception e) {
                Message message18;
                if (schemaBackupDir != null) {
                    message18 = BackendMessages.ERR_SCHEMA_RESTORE_OLD_SCHEMA_SAVED.get(schemaBackupDir.getPath());
                    ErrorLogger.logError(message18);
                }
                message18 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_GET_ZIP_ENTRY.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message18, e);
            }
            if (zipEntry == null) break;
            String fileName = zipEntry.getName();
            if (digest != null) {
                digest.update(StaticUtils.getBytes(fileName));
            }
            if (mac != null) {
                mac.update(StaticUtils.getBytes(fileName));
            }
            OutputStream outputStream = null;
            if (!verifyOnly) {
                String filePath = schemaDirPath + File.separator + fileName;
                try {
                    outputStream = new FileOutputStream(filePath);
                }
                catch (Exception e) {
                    Message message19;
                    if (schemaBackupDir != null) {
                        message19 = BackendMessages.ERR_SCHEMA_RESTORE_OLD_SCHEMA_SAVED.get(schemaBackupDir.getPath());
                        ErrorLogger.logError(message19);
                    }
                    message19 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_CREATE_FILE.get(backupID, filePath, StaticUtils.stackTraceToSingleLineString(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message19, e);
                }
            }
            try {
                int bytesRead;
                while ((bytesRead = zipStream.read(buffer)) >= 0) {
                    if (digest != null) {
                        digest.update(buffer, 0, bytesRead);
                    }
                    if (mac != null) {
                        mac.update(buffer, 0, bytesRead);
                    }
                    if (outputStream == null) continue;
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (outputStream == null) continue;
                outputStream.close();
            }
            catch (Exception e) {
                Message message20;
                if (schemaBackupDir != null) {
                    message20 = BackendMessages.ERR_SCHEMA_RESTORE_OLD_SCHEMA_SAVED.get(schemaBackupDir.getPath());
                    ErrorLogger.logError(message20);
                }
                message20 = BackendMessages.ERR_SCHEMA_RESTORE_CANNOT_PROCESS_ARCHIVE_FILE.get(backupID, fileName, StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message20, e);
            }
        }
        try {
            zipStream.close();
        }
        catch (Exception e) {
            message2 = BackendMessages.ERR_SCHEMA_RESTORE_ERROR_ON_ZIP_STREAM_CLOSE.get(backupID, backupFile.getPath(), StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2, e);
        }
        if (digest != null) {
            byte[] calculatedHash = digest.digest();
            if (Arrays.equals(calculatedHash, unsignedHash)) {
                message2 = BackendMessages.NOTE_SCHEMA_RESTORE_UNSIGNED_HASH_VALID.get();
                ErrorLogger.logError(message2);
            } else {
                if (schemaBackupDir != null) {
                    message2 = BackendMessages.ERR_SCHEMA_RESTORE_OLD_SCHEMA_SAVED.get(schemaBackupDir.getPath());
                    ErrorLogger.logError(message2);
                }
                message2 = BackendMessages.ERR_SCHEMA_RESTORE_UNSIGNED_HASH_INVALID.get(backupID);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2);
            }
        }
        if (mac != null) {
            byte[] calculatedSignature = mac.doFinal();
            if (Arrays.equals(calculatedSignature, signedHash)) {
                message2 = BackendMessages.NOTE_SCHEMA_RESTORE_SIGNED_HASH_VALID.get();
                ErrorLogger.logError(message2);
            } else {
                if (schemaBackupDir != null) {
                    message2 = BackendMessages.ERR_SCHEMA_RESTORE_OLD_SCHEMA_SAVED.get(schemaBackupDir.getPath());
                    ErrorLogger.logError(message2);
                }
                message2 = BackendMessages.ERR_SCHEMA_RESTORE_SIGNED_HASH_INVALID.get(schemaBackupDir.getPath());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message2);
            }
        }
        if (verifyOnly) {
            message = BackendMessages.NOTE_SCHEMA_RESTORE_VERIFY_SUCCESSFUL.get(backupID, backupPath);
            ErrorLogger.logError(message);
            return;
        }
        if (schemaBackupDir != null) {
            StaticUtils.recursiveDelete(schemaBackupDir);
        }
        message = BackendMessages.NOTE_SCHEMA_RESTORE_SUCCESSFUL.get(backupID, backupPath);
        ErrorLogger.logError(message);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SchemaBackendCfg configEntry, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SchemaBackendCfg backendCfg) {
        SortedSet<DN> newBaseDNs;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            newBaseDNs = backendCfg.getSchemaEntryDN();
            if (newBaseDNs.isEmpty()) {
                newBaseDNs.add(DN.decode("cn=schema"));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(BackendMessages.ERR_SCHEMA_CANNOT_DETERMINE_BASE_DN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            newBaseDNs = null;
        }
        boolean newShowAllAttributes = backendCfg.isShowAllAttributes();
        ArrayList<Attribute> newUserAttrs = new ArrayList<Attribute>();
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(this.configEntryDN);
            for (List<Attribute> attrs : configEntry.getEntry().getUserAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isSchemaConfigAttribute(a)) continue;
                    newUserAttrs.add(a);
                }
            }
            for (List<Attribute> attrs : configEntry.getEntry().getOperationalAttributes().values()) {
                for (Attribute a : attrs) {
                    if (this.isSchemaConfigAttribute(a)) continue;
                    newUserAttrs.add(a);
                }
            }
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(ConfigMessages.ERR_CONFIG_BACKEND_ERROR_INTERACTING_WITH_BACKEND_ENTRY.get(String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(e)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        if (resultCode == ResultCode.SUCCESS) {
            DN[] dnArray = new DN[newBaseDNs.size()];
            newBaseDNs.toArray(dnArray);
            HashSet<DN> deleteBaseDNs = new HashSet<DN>(this.baseDNs.length);
            for (DN baseDN : this.baseDNs) {
                if (newBaseDNs.remove(baseDN)) continue;
                deleteBaseDNs.add(baseDN);
            }
            for (DN dn : deleteBaseDNs) {
                try {
                    DirectoryServer.deregisterBaseDN(dn, false);
                    messages.add(BackendMessages.INFO_SCHEMA_DEREGISTERED_BASE_DN.get(String.valueOf(dn)));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(BackendMessages.ERR_SCHEMA_CANNOT_DEREGISTER_BASE_DN.get(String.valueOf(dn), StaticUtils.getExceptionMessage(e)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            this.baseDNs = dnArray;
            for (DN dn : newBaseDNs) {
                try {
                    DirectoryServer.registerBaseDN(dn, this, true, false);
                    messages.add(BackendMessages.INFO_SCHEMA_REGISTERED_BASE_DN.get(String.valueOf(dn)));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    messages.add(BackendMessages.ERR_SCHEMA_CANNOT_REGISTER_BASE_DN.get(String.valueOf(dn), StaticUtils.getExceptionMessage(e)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
            this.showAllAttributes = newShowAllAttributes;
            this.userDefinedAttributes = newUserAttrs;
            Message message = BackendMessages.INFO_SCHEMA_USING_NEW_USER_ATTRS.get();
            messages.add(message);
        }
        this.currentConfig = backendCfg;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    boolean showAllAttributes() {
        return this.showAllAttributes;
    }

    void setShowAllAttributes(boolean showAllAttributes) {
        this.showAllAttributes = showAllAttributes;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configEntryDN;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.CannotCopySchemaFiles", "This alert type will be used to notify administrators if a problem occurs while attempting to create copies of the existing schema configuration files before making a schema update, and the schema configuration is left in a potentially inconsistent state.");
        alerts.put("org.opends.server.CannotWriteNewSchemaFiles", "This alert type will be used to notify administrators if a problem occurs while attempting to write new verisons of the server schema configuration files, and the schema configuration is left in a potentially inconsistent state.");
        return alerts;
    }

    private Attribute stripMinUpperBoundValues(LinkedHashSet<AttributeValue> valueSet) {
        LinkedHashSet<AttributeValue> valueSetCopy = new LinkedHashSet<AttributeValue>();
        for (AttributeValue v : valueSet) {
            if (v.toString().indexOf(123) != -1) {
                String strippedStr = v.toString().replaceFirst(this.stripMinUpperBoundRegEx, "");
                ASN1OctetString s = new ASN1OctetString(strippedStr);
                AttributeValue strippedVal = new AttributeValue(s, (ByteString)s);
                valueSetCopy.add(strippedVal);
                continue;
            }
            valueSetCopy.add(v);
        }
        return new Attribute(this.attributeTypesType, "attributeTypes", valueSetCopy);
    }
}

