/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.authorization.dseecompat.AciHandler;
import org.opends.server.authorization.dseecompat.AciList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostResponseAddOperation;
import org.opends.server.types.operation.PostResponseDeleteOperation;
import org.opends.server.types.operation.PostResponseModifyDNOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciListenerManager
implements ChangeNotificationListener,
BackendInitializationListener,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.authorization.dseecompat.AciListenerManager";
    private DN configurationDN;
    private boolean inLockDownMode = false;
    private AciList aciList;
    private static SearchFilter aciFilter;
    private static LinkedHashSet<String> attrs;

    public AciListenerManager(AciList aciList, DN cfgDN) {
        this.aciList = aciList;
        this.configurationDN = cfgDN;
        DirectoryServer.registerChangeNotificationListener(this);
        DirectoryServer.registerBackendInitializationListener(this);
        DirectoryServer.registerAlertGenerator(this);
    }

    @Override
    public void handleDeleteOperation(PostResponseDeleteOperation deleteOperation, Entry entry) {
        boolean hasGlobalAci = false;
        boolean hasAci = entry.hasOperationalAttribute(AciHandler.aciType);
        if (hasAci || (hasGlobalAci = entry.hasAttribute(AciHandler.globalAciType))) {
            this.aciList.removeAci(entry, hasAci, hasGlobalAci);
        }
    }

    @Override
    public void handleAddOperation(PostResponseAddOperation addOperation, Entry entry) {
        boolean hasGlobalAci = false;
        LinkedList<Message> failedACIMsgs = new LinkedList<Message>();
        boolean hasAci = entry.hasOperationalAttribute(AciHandler.aciType);
        if (hasAci || (hasGlobalAci = entry.hasAttribute(AciHandler.globalAciType))) {
            this.aciList.addAci(entry, hasAci, hasGlobalAci, failedACIMsgs);
        }
    }

    @Override
    public void handleModifyOperation(PostResponseModifyOperation modOperation, Entry oldEntry, Entry newEntry) {
        boolean hasAci = false;
        boolean hasGlobalAci = false;
        List<Modification> mods = modOperation.getModifications();
        for (Modification mod : mods) {
            AttributeType attributeType = mod.getAttribute().getAttributeType();
            if (attributeType.equals(AciHandler.aciType)) {
                hasAci = true;
            } else if (attributeType.equals(AciHandler.globalAciType)) {
                hasGlobalAci = true;
            }
            if (!hasAci || !hasGlobalAci) continue;
            break;
        }
        if (hasAci || hasGlobalAci) {
            this.aciList.modAciOldNewEntry(oldEntry, newEntry, hasAci, hasGlobalAci);
        }
    }

    @Override
    public void handleModifyDNOperation(PostResponseModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry) {
        this.aciList.renameAci(oldEntry.getDN(), newEntry.getDN());
    }

    @Override
    public void performBackendInitializationProcessing(Backend backend) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        LinkedList<Message> failedACIMsgs = new LinkedList<Message>();
        ArrayList<Control> controls = new ArrayList<Control>(1);
        controls.add(new Control("2.16.840.1.113730.3.4.2", true));
        for (DN baseDN : backend.getBaseDNs()) {
            block8: {
                try {
                    if (!backend.entryExists(baseDN)) {
                    }
                    break block8;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                continue;
            }
            InternalSearchOperation internalSearch = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, aciFilter, attrs, null);
            LocalBackendSearchOperation localInternalSearch = new LocalBackendSearchOperation(internalSearch);
            try {
                backend.search(localInternalSearch);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                continue;
            }
            if (internalSearch.getSearchEntries().isEmpty()) {
                Message message = AccessControlMessages.INFO_ACI_ADD_LIST_NO_ACIS.get(String.valueOf(baseDN));
                ErrorLogger.logError(message);
                continue;
            }
            int validAcis = this.aciList.addAci(internalSearch.getSearchEntries(), failedACIMsgs);
            if (!failedACIMsgs.isEmpty()) {
                this.logMsgsSetLockDownMode(failedACIMsgs);
            }
            Message message = AccessControlMessages.INFO_ACI_ADD_LIST_ACIS.get(Integer.toString(validAcis), String.valueOf(baseDN));
            ErrorLogger.logError(message);
        }
    }

    @Override
    public void performBackendFinalizationProcessing(Backend backend) {
        this.aciList.removeAci(backend);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configurationDN;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.authentiation.dseecompat.ACIParseFailed", "This alert type will be used to notify administrators if the  dseecompat access control subsystem failed to correctly parse one or more ACI rules when the server is first started.");
        return alerts;
    }

    public void logMsgsSetLockDownMode(LinkedList<Message> failedACIMsgs) {
        for (Message msg : failedACIMsgs) {
            Message message = AccessControlMessages.WARN_ACI_SERVER_DECODE_FAILED.get(msg);
            ErrorLogger.logError(message);
        }
        if (!this.inLockDownMode) {
            this.setLockDownMode();
        }
    }

    private void setLockDownMode() {
        if (!this.inLockDownMode) {
            this.inLockDownMode = true;
            Message lockDownMsg = AccessControlMessages.WARN_ACI_ENTER_LOCKDOWN_MODE.get();
            DirectoryServer.sendAlertNotification(this, "org.opends.server.authentiation.dseecompat.ACIParseFailed", lockDownMsg);
            DirectoryServer.setLockdownMode(true);
        }
    }

    static {
        attrs = new LinkedHashSet();
        try {
            aciFilter = SearchFilter.createFilterFromString("(aci=*)");
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        attrs.add("aci");
    }
}

