/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.LinkedHashMap;
import java.util.Map;
import org.opends.server.backends.task.Task;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=true, mayInvoke=true)
public class DirectoryThread
extends Thread {
    private StackTraceElement[] creationStackTrace;
    private Task task;
    private Thread parentThread;

    public DirectoryThread(Runnable target, String threadName) {
        super(DirectoryServer.getDirectoryThreadGroup(), target, threadName);
        this.init();
    }

    protected DirectoryThread(String threadName) {
        super(DirectoryServer.getDirectoryThreadGroup(), threadName);
        this.init();
    }

    protected DirectoryThread(ThreadGroup threadGroup, String threadName) {
        super(threadGroup, threadName);
        this.init();
    }

    private void init() {
        this.parentThread = DirectoryThread.currentThread();
        this.creationStackTrace = this.parentThread.getStackTrace();
        this.task = this.parentThread instanceof DirectoryThread ? ((DirectoryThread)this.parentThread).task : null;
        if (DirectoryServer.getEnvironmentConfig().forceDaemonThreads()) {
            this.setDaemon(true);
        }
    }

    public StackTraceElement[] getCreationStackTrace() {
        return this.creationStackTrace;
    }

    public Thread getParentThread() {
        return this.parentThread;
    }

    public Task getAssociatedTask() {
        return this.task;
    }

    public void setAssociatedTask(Task task) {
        this.task = task;
    }

    public Map<String, String> getDebugProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("parentThread", this.parentThread.getName() + "(" + this.parentThread.getId() + ")");
        properties.put("isDaemon", String.valueOf(this.isDaemon()));
        return properties;
    }
}

