/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.monitors.BackendMonitor;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.LockManager;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.WritabilityMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class Backend {
    private Backend parentBackend = null;
    private Backend[] subordinateBackends = new Backend[0];
    private BackendMonitor backendMonitor = null;
    private boolean isPrivateBackend = false;
    private String backendID = null;
    private WritabilityMode writabilityMode = WritabilityMode.ENABLED;

    protected Backend() {
    }

    public abstract void configureBackend(Configuration var1) throws ConfigException;

    public boolean isConfigurationAcceptable(Configuration configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public abstract void initializeBackend() throws ConfigException, InitializationException;

    public abstract void finalizeBackend();

    public abstract DN[] getBaseDNs();

    public abstract boolean isLocal();

    public abstract Entry getEntry(DN var1) throws DirectoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(DN entryDN) throws DirectoryException {
        Lock lock = null;
        for (int i = 0; i < 3 && (lock = LockManager.lockRead(entryDN)) == null; ++i) {
        }
        if (lock == null) {
            Message message = BackendMessages.ERR_BACKEND_CANNOT_LOCK_ENTRY.get(String.valueOf(entryDN));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        try {
            boolean bl = this.getEntry(entryDN) != null;
            return bl;
        }
        finally {
            LockManager.unlock(entryDN, lock);
        }
    }

    public abstract void addEntry(Entry var1, AddOperation var2) throws DirectoryException, CancelledOperationException;

    public abstract void deleteEntry(DN var1, DeleteOperation var2) throws DirectoryException, CancelledOperationException;

    public abstract void replaceEntry(Entry var1, ModifyOperation var2) throws DirectoryException, CancelledOperationException;

    public abstract void renameEntry(DN var1, Entry var2, ModifyDNOperation var3) throws DirectoryException, CancelledOperationException;

    public abstract void search(SearchOperation var1) throws DirectoryException, CancelledOperationException;

    public abstract Set<String> getSupportedControls();

    public final boolean supportsControl(String controlOID) {
        Set<String> supportedControls = this.getSupportedControls();
        return supportedControls != null && supportedControls.contains(controlOID);
    }

    public abstract Set<String> getSupportedFeatures();

    public final boolean supportsFeature(String featureOID) {
        Set<String> supportedFeatures = this.getSupportedFeatures();
        return supportedFeatures != null && supportedFeatures.contains(featureOID);
    }

    public abstract boolean supportsLDIFExport();

    public abstract void exportLDIF(LDIFExportConfig var1) throws DirectoryException;

    public abstract boolean supportsLDIFImport();

    public abstract LDIFImportResult importLDIF(LDIFImportConfig var1) throws DirectoryException;

    public abstract boolean supportsBackup();

    public abstract boolean supportsBackup(BackupConfig var1, StringBuilder var2);

    public abstract void createBackup(BackupConfig var1) throws DirectoryException;

    public abstract void removeBackup(BackupDirectory var1, String var2) throws DirectoryException;

    public abstract boolean supportsRestore();

    public abstract void restoreBackup(RestoreConfig var1) throws DirectoryException;

    public final String getBackendID() {
        return this.backendID;
    }

    public final void setBackendID(String backendID) {
        this.backendID = backendID;
    }

    public final boolean isPrivateBackend() {
        return this.isPrivateBackend;
    }

    public final void setPrivateBackend(boolean isPrivateBackend) {
        this.isPrivateBackend = isPrivateBackend;
    }

    public final WritabilityMode getWritabilityMode() {
        return this.writabilityMode;
    }

    public final void setWritabilityMode(WritabilityMode writabilityMode) {
        this.writabilityMode = writabilityMode == null ? WritabilityMode.ENABLED : writabilityMode;
    }

    public final BackendMonitor getBackendMonitor() {
        return this.backendMonitor;
    }

    public final void setBackendMonitor(BackendMonitor backendMonitor) {
        this.backendMonitor = backendMonitor;
    }

    public abstract long getEntryCount();

    public final Backend getParentBackend() {
        return this.parentBackend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParentBackend(Backend parentBackend) {
        Backend backend = this;
        synchronized (backend) {
            this.parentBackend = parentBackend;
        }
    }

    public final Backend[] getSubordinateBackends() {
        return this.subordinateBackends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSubordinateBackends(Backend[] subordinateBackends) {
        Backend backend = this;
        synchronized (backend) {
            this.subordinateBackends = subordinateBackends;
        }
    }

    public final boolean hasSubSuffix(DN subSuffixDN) {
        Backend[] subBackends;
        for (Backend b : subBackends = this.subordinateBackends) {
            for (DN baseDN : b.getBaseDNs()) {
                if (!baseDN.equals(subSuffixDN)) continue;
                return true;
            }
            if (!b.hasSubSuffix(subSuffixDN)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSubSuffix(DN subSuffixDN, DN parentDN) throws ConfigException {
        Backend backend = this;
        synchronized (backend) {
            boolean matchFound = false;
            ArrayList<Backend> subBackendList = new ArrayList<Backend>(this.subordinateBackends.length);
            for (Backend b : this.subordinateBackends) {
                DN[] subBaseDNs;
                boolean thisMatches = false;
                for (DN dn : subBaseDNs = b.getBaseDNs()) {
                    if (!dn.equals(subSuffixDN)) continue;
                    if (subBaseDNs.length > 1) {
                        Message message = BackendMessages.ERR_BACKEND_CANNOT_REMOVE_MULTIBASE_SUB_SUFFIX.get(String.valueOf(subSuffixDN), String.valueOf(parentDN));
                        throw new ConfigException(message);
                    }
                    thisMatches = true;
                    matchFound = true;
                    break;
                }
                if (thisMatches) continue;
                if (b.hasSubSuffix(subSuffixDN)) {
                    b.removeSubSuffix(subSuffixDN, parentDN);
                    continue;
                }
                subBackendList.add(b);
            }
            if (matchFound) {
                Backend[] newSubordinateBackends = new Backend[subBackendList.size()];
                subBackendList.toArray(newSubordinateBackends);
                this.subordinateBackends = newSubordinateBackends;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSubordinateBackend(Backend subordinateBackend) {
        Backend backend = this;
        synchronized (backend) {
            LinkedHashSet<Backend> backendSet = new LinkedHashSet<Backend>();
            for (Backend b : this.subordinateBackends) {
                backendSet.add(b);
            }
            if (backendSet.add(subordinateBackend)) {
                Backend[] newSubordinateBackends = new Backend[backendSet.size()];
                backendSet.toArray(newSubordinateBackends);
                this.subordinateBackends = newSubordinateBackends;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSubordinateBackend(Backend subordinateBackend) {
        Backend backend = this;
        synchronized (backend) {
            ArrayList<Backend> backendList = new ArrayList<Backend>(this.subordinateBackends.length);
            boolean found = false;
            for (Backend b : this.subordinateBackends) {
                if (b.equals(subordinateBackend)) {
                    found = true;
                    continue;
                }
                backendList.add(b);
            }
            if (found) {
                Backend[] newSubordinateBackends = new Backend[backendList.size()];
                backendList.toArray(newSubordinateBackends);
                this.subordinateBackends = newSubordinateBackends;
            }
        }
    }

    public final boolean handlesEntry(DN entryDN) {
        DN[] baseDNs;
        for (DN dn : baseDNs = this.getBaseDNs()) {
            Backend[] subBackends;
            if (!entryDN.isDescendantOf(dn)) continue;
            for (Backend b : subBackends = this.subordinateBackends) {
                if (!b.handlesEntry(entryDN)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean handlesEntry(DN entryDN, List<DN> baseDNs, List<DN> excludeDNs) {
        for (DN baseDN : baseDNs) {
            if (!entryDN.isDescendantOf(baseDN)) continue;
            if (excludeDNs == null || excludeDNs.isEmpty()) {
                return true;
            }
            boolean isExcluded = false;
            for (DN excludeDN : excludeDNs) {
                if (!entryDN.isDescendantOf(excludeDN)) continue;
                isExcluded = true;
                break;
            }
            if (isExcluded) continue;
            return true;
        }
        return false;
    }
}

