/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.JEIndexCfgClient;
import org.opends.server.admin.std.meta.JEBackendCfgDefn;
import org.opends.server.admin.std.server.JEIndexCfg;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JEIndexCfgDefn
extends ManagedObjectDefinition<JEIndexCfgClient, JEIndexCfg> {
    private static final JEIndexCfgDefn INSTANCE = new JEIndexCfgDefn();
    private static final AttributeTypePropertyDefinition PD_INDEX_ATTRIBUTE;
    private static final IntegerPropertyDefinition PD_INDEX_ENTRY_LIMIT;
    private static final IntegerPropertyDefinition PD_INDEX_SUBSTRING_LENGTH;
    private static final EnumPropertyDefinition<IndexType> PD_INDEX_TYPE;

    public static JEIndexCfgDefn getInstance() {
        return INSTANCE;
    }

    private JEIndexCfgDefn() {
        super("je-index", null);
    }

    @Override
    public JEIndexCfgClient createClientConfiguration(ManagedObject<? extends JEIndexCfgClient> impl) {
        return new JEIndexCfgClientImpl(impl);
    }

    @Override
    public JEIndexCfg createServerConfiguration(ServerManagedObject<? extends JEIndexCfg> impl) {
        return new JEIndexCfgServerImpl(impl);
    }

    @Override
    public Class<JEIndexCfg> getServerConfigurationClass() {
        return JEIndexCfg.class;
    }

    public AttributeTypePropertyDefinition getIndexAttributePropertyDefinition() {
        return PD_INDEX_ATTRIBUTE;
    }

    public IntegerPropertyDefinition getIndexEntryLimitPropertyDefinition() {
        return PD_INDEX_ENTRY_LIMIT;
    }

    public IntegerPropertyDefinition getIndexSubstringLengthPropertyDefinition() {
        return PD_INDEX_SUBSTRING_LENGTH;
    }

    public EnumPropertyDefinition<IndexType> getIndexTypePropertyDefinition() {
        return PD_INDEX_TYPE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = AttributeTypePropertyDefinition.createBuilder(INSTANCE, "index-attribute");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "index-attribute"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_INDEX_ATTRIBUTE = (AttributeTypePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_ATTRIBUTE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-entry-limit");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-entry-limit"));
        DefaultBehaviorProvider provider = new RelativeInheritedDefaultBehaviorProvider(JEBackendCfgDefn.getInstance(), "backend-index-entry-limit", 1);
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(Integer.MAX_VALUE);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_INDEX_ENTRY_LIMIT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_ENTRY_LIMIT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "index-substring-length");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-substring-length"));
        provider = new DefinedDefaultBehaviorProvider("6");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(3);
        PD_INDEX_SUBSTRING_LENGTH = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_SUBSTRING_LENGTH);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "index-type");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.OTHER, INSTANCE, "index-type"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(IndexType.class);
        PD_INDEX_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INDEX_TYPE);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JEIndexCfgServerImpl
    implements JEIndexCfg {
        private ServerManagedObject<? extends JEIndexCfg> impl;

        private JEIndexCfgServerImpl(ServerManagedObject<? extends JEIndexCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<JEIndexCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<JEIndexCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public AttributeType getIndexAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getIndexAttributePropertyDefinition());
        }

        @Override
        public Integer getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public int getIndexSubstringLength() {
            return this.impl.getPropertyValue(INSTANCE.getIndexSubstringLengthPropertyDefinition());
        }

        @Override
        public SortedSet<IndexType> getIndexType() {
            return this.impl.getPropertyValues(INSTANCE.getIndexTypePropertyDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends JEIndexCfgClient, ? extends JEIndexCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JEIndexCfgClientImpl
    implements JEIndexCfgClient {
        private ManagedObject<? extends JEIndexCfgClient> impl;

        private JEIndexCfgClientImpl(ManagedObject<? extends JEIndexCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public AttributeType getIndexAttribute() {
            return this.impl.getPropertyValue(INSTANCE.getIndexAttributePropertyDefinition());
        }

        @Override
        public void setIndexAttribute(AttributeType value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getIndexAttributePropertyDefinition(), value);
        }

        @Override
        public Integer getIndexEntryLimit() {
            return this.impl.getPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition());
        }

        @Override
        public void setIndexEntryLimit(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexEntryLimitPropertyDefinition(), value);
        }

        @Override
        public int getIndexSubstringLength() {
            return this.impl.getPropertyValue(INSTANCE.getIndexSubstringLengthPropertyDefinition());
        }

        @Override
        public void setIndexSubstringLength(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getIndexSubstringLengthPropertyDefinition(), value);
        }

        @Override
        public SortedSet<IndexType> getIndexType() {
            return this.impl.getPropertyValues(INSTANCE.getIndexTypePropertyDefinition());
        }

        @Override
        public void setIndexType(Collection<IndexType> values) {
            this.impl.setPropertyValues(INSTANCE.getIndexTypePropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends JEIndexCfgClient, ? extends JEIndexCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        APPROXIMATE("approximate"),
        EQUALITY("equality"),
        ORDERING("ordering"),
        PRESENCE("presence"),
        SUBSTRING("substring");

        private final String name;

        private IndexType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

