/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.FileSystemEntryCacheCfgClient;
import org.opends.server.admin.std.meta.EntryCacheCfgDefn;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.FileSystemEntryCacheCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSystemEntryCacheCfgDefn
extends ManagedObjectDefinition<FileSystemEntryCacheCfgClient, FileSystemEntryCacheCfg> {
    private static final FileSystemEntryCacheCfgDefn INSTANCE = new FileSystemEntryCacheCfgDefn();
    private static final StringPropertyDefinition PD_CACHE_DIRECTORY;
    private static final EnumPropertyDefinition<CacheType> PD_CACHE_TYPE;
    private static final IntegerPropertyDefinition PD_DATABASE_CACHE_PERCENT;
    private static final SizePropertyDefinition PD_DATABASE_CACHE_SIZE;
    private static final ClassPropertyDefinition PD_ENTRY_CACHE_CLASS;
    private static final StringPropertyDefinition PD_EXCLUDE_FILTER;
    private static final StringPropertyDefinition PD_INCLUDE_FILTER;
    private static final DurationPropertyDefinition PD_LOCK_TIMEOUT;
    private static final IntegerPropertyDefinition PD_MAX_ENTRIES;
    private static final SizePropertyDefinition PD_MAX_MEMORY_SIZE;
    private static final BooleanPropertyDefinition PD_PERSISTENT_CACHE;

    public static FileSystemEntryCacheCfgDefn getInstance() {
        return INSTANCE;
    }

    private FileSystemEntryCacheCfgDefn() {
        super("file-system-entry-cache", EntryCacheCfgDefn.getInstance());
    }

    @Override
    public FileSystemEntryCacheCfgClient createClientConfiguration(ManagedObject<? extends FileSystemEntryCacheCfgClient> impl) {
        return new FileSystemEntryCacheCfgClientImpl(impl);
    }

    @Override
    public FileSystemEntryCacheCfg createServerConfiguration(ServerManagedObject<? extends FileSystemEntryCacheCfg> impl) {
        return new FileSystemEntryCacheCfgServerImpl(impl);
    }

    @Override
    public Class<FileSystemEntryCacheCfg> getServerConfigurationClass() {
        return FileSystemEntryCacheCfg.class;
    }

    public StringPropertyDefinition getCacheDirectoryPropertyDefinition() {
        return PD_CACHE_DIRECTORY;
    }

    public EnumPropertyDefinition<CacheType> getCacheTypePropertyDefinition() {
        return PD_CACHE_TYPE;
    }

    public IntegerPropertyDefinition getDatabaseCachePercentPropertyDefinition() {
        return PD_DATABASE_CACHE_PERCENT;
    }

    public SizePropertyDefinition getDatabaseCacheSizePropertyDefinition() {
        return PD_DATABASE_CACHE_SIZE;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return EntryCacheCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getEntryCacheClassPropertyDefinition() {
        return PD_ENTRY_CACHE_CLASS;
    }

    public StringPropertyDefinition getExcludeFilterPropertyDefinition() {
        return PD_EXCLUDE_FILTER;
    }

    public StringPropertyDefinition getIncludeFilterPropertyDefinition() {
        return PD_INCLUDE_FILTER;
    }

    public DurationPropertyDefinition getLockTimeoutPropertyDefinition() {
        return PD_LOCK_TIMEOUT;
    }

    public IntegerPropertyDefinition getMaxEntriesPropertyDefinition() {
        return PD_MAX_ENTRIES;
    }

    public SizePropertyDefinition getMaxMemorySizePropertyDefinition() {
        return PD_MAX_MEMORY_SIZE;
    }

    public BooleanPropertyDefinition getPersistentCachePropertyDefinition() {
        return PD_PERSISTENT_CACHE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "cache-directory");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "cache-directory"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("/tmp/OpenDS.FSCache");
        builder.setDefaultBehaviorProvider(provider);
        PD_CACHE_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CACHE_DIRECTORY);
        builder = EnumPropertyDefinition.createBuilder(INSTANCE, "cache-type");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "cache-type"));
        provider = new DefinedDefaultBehaviorProvider("fifo");
        builder.setDefaultBehaviorProvider(provider);
        ((EnumPropertyDefinition.Builder)builder).setEnumClass(CacheType.class);
        PD_CACHE_TYPE = (EnumPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CACHE_TYPE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "database-cache-percent");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-cache-percent"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setUpperLimit(100);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_DATABASE_CACHE_PERCENT = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CACHE_PERCENT);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "database-cache-size");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "database-cache-size"));
        provider = new DefinedDefaultBehaviorProvider("0b");
        builder.setDefaultBehaviorProvider(provider);
        PD_DATABASE_CACHE_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DATABASE_CACHE_SIZE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "entry-cache-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "entry-cache-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.FileSystemEntryCache");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.EntryCache");
        PD_ENTRY_CACHE_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENTRY_CACHE_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "exclude-filter");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "exclude-filter"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_EXCLUDE_FILTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_EXCLUDE_FILTER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "include-filter");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "include-filter"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_INCLUDE_FILTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INCLUDE_FILTER);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "lock-timeout");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lock-timeout"));
        provider = new DefinedDefaultBehaviorProvider("2000.0ms");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(true);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        PD_LOCK_TIMEOUT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOCK_TIMEOUT);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "max-entries");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-entries"));
        provider = new DefinedDefaultBehaviorProvider("2147483647");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_MAX_ENTRIES = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_ENTRIES);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "max-memory-size");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "max-memory-size"));
        provider = new DefinedDefaultBehaviorProvider("0b");
        builder.setDefaultBehaviorProvider(provider);
        PD_MAX_MEMORY_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_MAX_MEMORY_SIZE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "persistent-cache");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "persistent-cache"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_PERSISTENT_CACHE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_PERSISTENT_CACHE);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSystemEntryCacheCfgServerImpl
    implements FileSystemEntryCacheCfg {
        private ServerManagedObject<? extends FileSystemEntryCacheCfg> impl;

        private FileSystemEntryCacheCfgServerImpl(ServerManagedObject<? extends FileSystemEntryCacheCfg> impl) {
            this.impl = impl;
        }

        @Override
        public void addFileSystemChangeListener(ConfigurationChangeListener<FileSystemEntryCacheCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFileSystemChangeListener(ConfigurationChangeListener<FileSystemEntryCacheCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<EntryCacheCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<EntryCacheCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getCacheDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getCacheDirectoryPropertyDefinition());
        }

        @Override
        public CacheType getCacheType() {
            return this.impl.getPropertyValue(INSTANCE.getCacheTypePropertyDefinition());
        }

        @Override
        public int getDatabaseCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCachePercentPropertyDefinition());
        }

        @Override
        public long getDatabaseCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCacheSizePropertyDefinition());
        }

        @Override
        public boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public String getEntryCacheClass() {
            return this.impl.getPropertyValue(INSTANCE.getEntryCacheClassPropertyDefinition());
        }

        @Override
        public SortedSet<String> getExcludeFilter() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getExcludeFilterPropertyDefinition());
        }

        @Override
        public SortedSet<String> getIncludeFilter() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getIncludeFilterPropertyDefinition());
        }

        @Override
        public long getLockTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition());
        }

        @Override
        public int getMaxEntries() {
            return this.impl.getPropertyValue(INSTANCE.getMaxEntriesPropertyDefinition());
        }

        @Override
        public long getMaxMemorySize() {
            return this.impl.getPropertyValue(INSTANCE.getMaxMemorySizePropertyDefinition());
        }

        @Override
        public boolean isPersistentCache() {
            return this.impl.getPropertyValue(INSTANCE.getPersistentCachePropertyDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends FileSystemEntryCacheCfgClient, ? extends FileSystemEntryCacheCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSystemEntryCacheCfgClientImpl
    implements FileSystemEntryCacheCfgClient {
        private ManagedObject<? extends FileSystemEntryCacheCfgClient> impl;

        private FileSystemEntryCacheCfgClientImpl(ManagedObject<? extends FileSystemEntryCacheCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getCacheDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getCacheDirectoryPropertyDefinition());
        }

        @Override
        public void setCacheDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getCacheDirectoryPropertyDefinition(), value);
        }

        @Override
        public CacheType getCacheType() {
            return this.impl.getPropertyValue(INSTANCE.getCacheTypePropertyDefinition());
        }

        @Override
        public void setCacheType(CacheType value) {
            this.impl.setPropertyValue(INSTANCE.getCacheTypePropertyDefinition(), value);
        }

        @Override
        public int getDatabaseCachePercent() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCachePercentPropertyDefinition());
        }

        @Override
        public void setDatabaseCachePercent(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCachePercentPropertyDefinition(), value);
        }

        @Override
        public long getDatabaseCacheSize() {
            return this.impl.getPropertyValue(INSTANCE.getDatabaseCacheSizePropertyDefinition());
        }

        @Override
        public void setDatabaseCacheSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getDatabaseCacheSizePropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getEntryCacheClass() {
            return this.impl.getPropertyValue(INSTANCE.getEntryCacheClassPropertyDefinition());
        }

        @Override
        public void setEntryCacheClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getEntryCacheClassPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getExcludeFilter() {
            return this.impl.getPropertyValues(INSTANCE.getExcludeFilterPropertyDefinition());
        }

        @Override
        public void setExcludeFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getExcludeFilterPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getIncludeFilter() {
            return this.impl.getPropertyValues(INSTANCE.getIncludeFilterPropertyDefinition());
        }

        @Override
        public void setIncludeFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getIncludeFilterPropertyDefinition(), values);
        }

        @Override
        public long getLockTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition());
        }

        @Override
        public void setLockTimeout(Long value) {
            this.impl.setPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition(), value);
        }

        @Override
        public int getMaxEntries() {
            return this.impl.getPropertyValue(INSTANCE.getMaxEntriesPropertyDefinition());
        }

        @Override
        public void setMaxEntries(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getMaxEntriesPropertyDefinition(), value);
        }

        @Override
        public long getMaxMemorySize() {
            return this.impl.getPropertyValue(INSTANCE.getMaxMemorySizePropertyDefinition());
        }

        @Override
        public void setMaxMemorySize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getMaxMemorySizePropertyDefinition(), value);
        }

        @Override
        public boolean isPersistentCache() {
            return this.impl.getPropertyValue(INSTANCE.getPersistentCachePropertyDefinition());
        }

        @Override
        public void setPersistentCache(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getPersistentCachePropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends FileSystemEntryCacheCfgClient, ? extends FileSystemEntryCacheCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheType {
        FIFO("fifo"),
        LRU("lru");

        private final String name;

        private CacheType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

