/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigChangeListenerAdaptor;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependencyConfigChangeListener
implements ConfigChangeListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final DN dependentDN;
    private final ConfigChangeListenerAdaptor<?> dependentListener;

    public DependencyConfigChangeListener(DN dependentDN, ConfigChangeListenerAdaptor<?> dependentListener) {
        this.dependentDN = dependentDN;
        this.dependentListener = dependentListener;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        ConfigEntry dependentConfigEntry = this.getConfigEntry(this.dependentDN);
        if (dependentConfigEntry != null) {
            return this.dependentListener.applyConfigurationChange(dependentConfigEntry, configEntry);
        }
        configEntry.deregisterChangeListener(this);
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean configChangeIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
        ConfigEntry dependentConfigEntry = this.getConfigEntry(this.dependentDN);
        if (dependentConfigEntry != null) {
            return this.dependentListener.configChangeIsAcceptable(dependentConfigEntry, unacceptableReason, configEntry);
        }
        configEntry.deregisterChangeListener(this);
        return true;
    }

    private ConfigEntry getConfigEntry(DN dn) {
        try {
            ConfigEntry configEntry = DirectoryServer.getConfigEntry(dn);
            if (configEntry != null) {
                return configEntry;
            }
            Message message = AdminMessages.ERR_ADMIN_MANAGED_OBJECT_DOES_NOT_EXIST.get(String.valueOf(dn));
            ErrorLogger.logError(message);
        }
        catch (ConfigException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = AdminMessages.ERR_ADMIN_CANNOT_GET_MANAGED_OBJECT.get(String.valueOf(dn), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
        }
        return null;
    }
}

