/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.server.AbstractConfigListenerAdaptor;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.DNBuilder;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.config.ConfigEntry;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigAddListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigAddListener {
    private final ManagedObjectPath<?, ?> path;
    private final InstantiableRelationDefinition<?, S> instantiableRelation;
    private final OptionalRelationDefinition<?, S> optionalRelation;
    private final ConfigurationAddListener<S> listener;
    private S cachedConfiguration;

    public ConfigAddListenerAdaptor(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, S> relation, ConfigurationAddListener<S> listener) {
        this.path = path;
        this.instantiableRelation = relation;
        this.optionalRelation = null;
        this.listener = listener;
        this.cachedConfiguration = null;
    }

    public ConfigAddListenerAdaptor(ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, S> relation, ConfigurationAddListener<S> listener) {
        this.path = path;
        this.optionalRelation = relation;
        this.instantiableRelation = null;
        this.listener = listener;
        this.cachedConfiguration = null;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        if (this.optionalRelation != null) {
            ManagedObjectPath<?, S> childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!configEntry.getDN().equals(expectedDN)) {
                return new ConfigChangeResult(ResultCode.SUCCESS, false);
            }
        }
        return this.listener.applyConfigurationAdd(this.cachedConfiguration);
    }

    @Override
    public boolean configAddIsAcceptable(ConfigEntry configEntry, MessageBuilder unacceptableReason) {
        ServerManagedObject mo;
        RelationDefinition r;
        ManagedObjectPath<?, S> childPath;
        DN dn = configEntry.getDN();
        AttributeValue av = dn.getRDN().getAttributeValue(0);
        String name = av.getStringValue().trim();
        if (this.instantiableRelation != null) {
            childPath = this.path.child(this.instantiableRelation, name);
            r = this.instantiableRelation;
        } else {
            childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!dn.equals(expectedDN)) {
                return true;
            }
            r = this.optionalRelation;
        }
        try {
            mo = ServerManagedObject.decode(childPath, r.getChildDefinition(), configEntry, configEntry);
        }
        catch (DecodingException e) {
            this.generateUnacceptableReason(e, unacceptableReason);
            return false;
        }
        this.cachedConfiguration = mo.getConfiguration();
        LinkedList<Message> reasons = new LinkedList<Message>();
        if (this.listener.isConfigurationAddAcceptable(this.cachedConfiguration, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    ConfigurationAddListener<S> getConfigurationAddListener() {
        return this.listener;
    }
}

