/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.server;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOptionalConfigurationManager<C extends Configuration, T> {
    private final ClassPropertyDefinition propertyDefinition;
    private final Class<T> theClass;
    private final AddListener addListener;
    private final ChangeListener changeListener;
    private final DeleteListener deleteListener;
    private boolean listenersRegistered;
    private C currentConfig = null;
    private T instance = null;

    protected AbstractOptionalConfigurationManager(Class<T> theClass, ClassPropertyDefinition propertyDefinition) {
        this.theClass = theClass;
        this.propertyDefinition = propertyDefinition;
        this.listenersRegistered = false;
        this.addListener = new AddListener();
        this.deleteListener = new DeleteListener();
        this.changeListener = new ChangeListener();
    }

    public final void finalizeManager() {
        this.deregisterAddListener(this.addListener);
        this.deregisterDeleteListener(this.deleteListener);
        if (this.currentConfig != null) {
            this.deregisterChangeListener(this.changeListener, this.currentConfig);
        }
        if (this.instance != null) {
            this.finalizeInstance(this.instance);
        }
    }

    public final C getConfiguration() {
        return this.currentConfig;
    }

    public final T getInstance() {
        return this.instance;
    }

    public final void initialize(C config) throws ConfigException, InitializationException {
        if (!this.listenersRegistered) {
            this.registerAddListener(this.addListener);
            this.registerDeleteListener(this.deleteListener);
            this.listenersRegistered = true;
        }
        this.instance = null;
        if (config != null) {
            this.setConfiguration(config);
            if (this.isEnabled(config)) {
                this.doRegisterInstance(this.getImplementation(config));
            } else {
                this.notifyDisableInstance(config);
            }
        }
    }

    protected abstract void deregisterAddListener(ConfigurationAddListener<C> var1);

    protected abstract void deregisterChangeListener(ConfigurationChangeListener<C> var1, C var2);

    protected abstract void deregisterDeleteListener(ConfigurationDeleteListener<C> var1);

    protected abstract void finalizeInstance(T var1);

    protected abstract String getJavaImplementationClass(C var1);

    protected abstract boolean isDisableInstanceAcceptable(C var1, List<Message> var2);

    protected abstract boolean isEnabled(C var1);

    protected abstract void notifyDeleteInstance(C var1);

    protected abstract void notifyDisableInstance(C var1);

    protected abstract void registerAddListener(ConfigurationAddListener<C> var1) throws ConfigException;

    protected abstract void registerChangeListener(ConfigurationChangeListener<C> var1, C var2);

    protected abstract void registerDeleteListener(ConfigurationDeleteListener<C> var1) throws ConfigException;

    protected abstract void registerInstance(T var1) throws InitializationException;

    private void doRegisterInstance(T instance) throws InitializationException {
        this.instance = instance;
        this.registerInstance(instance);
    }

    private T getImplementation(C config) throws ConfigException {
        T instance;
        Class<T> implClass;
        String className = this.getJavaImplementationClass(config);
        try {
            implClass = this.propertyDefinition.loadClass(className, this.theClass);
            instance = implClass.newInstance();
        }
        catch (Exception e) {
            Message message = AdminMessages.ERR_ADMIN_CANNOT_INSTANTIATE_CLASS.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        try {
            String name = this.getInitializationMethodName();
            Method method = implClass.getMethod(name, config.definition().getServerConfigurationClass());
            method.invoke(instance, config);
        }
        catch (Exception e) {
            Message message = AdminMessages.ERR_ADMIN_CANNOT_INITIALIZE_COMPONENT.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return instance;
    }

    private String getInitializationMethodName() {
        return "initialize" + this.theClass.getSimpleName();
    }

    private boolean isJavaClassAcceptable(C config, List<Message> unacceptableReasons) {
        Class<T> implClass;
        String className = this.getJavaImplementationClass(config);
        try {
            implClass = this.propertyDefinition.loadClass(className, this.theClass);
            implClass.newInstance();
        }
        catch (Exception e) {
            unacceptableReasons.add(AdminMessages.ERR_ADMIN_CANNOT_INSTANTIATE_CLASS.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        try {
            String name = this.getInitializationMethodName();
            implClass.getMethod(name, config.definition().getServerConfigurationClass());
        }
        catch (Exception e) {
            unacceptableReasons.add(AdminMessages.ERR_ADMIN_CANNOT_INITIALIZE_COMPONENT.get(String.valueOf(className), String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return false;
        }
        return true;
    }

    private void setConfiguration(C config) {
        if (this.currentConfig == null && config != null) {
            this.registerChangeListener(this.changeListener, config);
        }
        this.currentConfig = config;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteListener
    implements ConfigurationDeleteListener<C> {
        private DeleteListener() {
        }

        @Override
        public ConfigChangeResult applyConfigurationDelete(C config) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            AbstractOptionalConfigurationManager.this.setConfiguration(null);
            if (AbstractOptionalConfigurationManager.this.instance != null) {
                AbstractOptionalConfigurationManager.this.finalizeInstance(AbstractOptionalConfigurationManager.this.instance);
                AbstractOptionalConfigurationManager.this.instance = null;
            }
            AbstractOptionalConfigurationManager.this.notifyDeleteInstance(config);
            return new ConfigChangeResult(resultCode, adminActionRequired);
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(C config, List<Message> unacceptableReasons) {
            if (AbstractOptionalConfigurationManager.this.isEnabled(AbstractOptionalConfigurationManager.this.getConfiguration())) {
                return AbstractOptionalConfigurationManager.this.isDisableInstanceAcceptable(config, unacceptableReasons);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangeListener
    implements ConfigurationChangeListener<C> {
        private ChangeListener() {
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(C config) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            AbstractOptionalConfigurationManager.this.setConfiguration(config);
            if (AbstractOptionalConfigurationManager.this.instance == null) {
                if (AbstractOptionalConfigurationManager.this.isEnabled(config)) {
                    try {
                        AbstractOptionalConfigurationManager.this.doRegisterInstance(AbstractOptionalConfigurationManager.this.getImplementation(config));
                    }
                    catch (ConfigException e) {
                        messages.add(e.getMessageObject());
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                    catch (InitializationException e) {
                        messages.add(e.getMessageObject());
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
            } else if (AbstractOptionalConfigurationManager.this.isEnabled(config)) {
                String className = AbstractOptionalConfigurationManager.this.getJavaImplementationClass(config);
                if (!className.equals(AbstractOptionalConfigurationManager.this.instance.getClass().getName())) {
                    adminActionRequired = true;
                }
            } else {
                if (AbstractOptionalConfigurationManager.this.instance != null) {
                    AbstractOptionalConfigurationManager.this.finalizeInstance(AbstractOptionalConfigurationManager.this.instance);
                    AbstractOptionalConfigurationManager.this.instance = null;
                }
                AbstractOptionalConfigurationManager.this.notifyDisableInstance(config);
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationChangeAcceptable(C config, List<Message> unacceptableReasons) {
            if (AbstractOptionalConfigurationManager.this.isEnabled(config)) {
                return AbstractOptionalConfigurationManager.this.isJavaClassAcceptable(config, unacceptableReasons);
            }
            if (AbstractOptionalConfigurationManager.this.isEnabled(AbstractOptionalConfigurationManager.this.getConfiguration())) {
                return AbstractOptionalConfigurationManager.this.isDisableInstanceAcceptable(config, unacceptableReasons);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddListener
    implements ConfigurationAddListener<C> {
        private AddListener() {
        }

        @Override
        public ConfigChangeResult applyConfigurationAdd(C config) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            AbstractOptionalConfigurationManager.this.setConfiguration(config);
            if (AbstractOptionalConfigurationManager.this.isEnabled(config)) {
                try {
                    AbstractOptionalConfigurationManager.this.doRegisterInstance(AbstractOptionalConfigurationManager.this.getImplementation(config));
                }
                catch (ConfigException e) {
                    messages.add(e.getMessageObject());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
                catch (InitializationException e) {
                    messages.add(e.getMessageObject());
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            } else {
                if (AbstractOptionalConfigurationManager.this.instance != null) {
                    AbstractOptionalConfigurationManager.this.finalizeInstance(AbstractOptionalConfigurationManager.this.instance);
                    AbstractOptionalConfigurationManager.this.instance = null;
                }
                AbstractOptionalConfigurationManager.this.notifyDisableInstance(config);
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationAddAcceptable(C config, List<Message> unacceptableReasons) {
            if (AbstractOptionalConfigurationManager.this.isEnabled(config)) {
                return AbstractOptionalConfigurationManager.this.isJavaClassAcceptable(config, unacceptableReasons);
            }
            return true;
        }
    }
}

