/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.ldap;

import org.opends.server.admin.LDAPProfile;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.LDAPConnection;
import org.opends.server.admin.client.ldap.LDAPManagedObject;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPManagementContext
extends ManagementContext {
    private final LDAPConnection connection;
    private final LDAPProfile profile;

    public static ManagementContext createFromContext(LDAPConnection connection) {
        Validator.ensureNotNull(connection);
        return new LDAPManagementContext(connection, LDAPProfile.getInstance());
    }

    private LDAPManagementContext(LDAPConnection connection, LDAPProfile profile) {
        this.connection = connection;
        this.profile = profile;
    }

    @Override
    public ManagedObject<RootCfgClient> getRootConfigurationManagedObject() {
        return LDAPManagedObject.getRootManagedObject(this);
    }

    LDAPConnection getLDAPConnection() {
        return this.connection;
    }

    LDAPProfile getLDAPProfile() {
        return this.profile;
    }
}

