/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinitionResource;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPProfile {
    private static final LDAPProfile INSTANCE = new LDAPProfile();
    private final LinkedList<Wrapper> profiles = new LinkedList();
    private final ManagedObjectDefinitionResource resource = ManagedObjectDefinitionResource.createForProfile("ldap");

    public static LDAPProfile getInstance() {
        return INSTANCE;
    }

    private LDAPProfile() {
    }

    public String getAttributeName(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) throws MissingResourceException {
        for (Wrapper profile : this.profiles) {
            String attributeName = profile.getAttributeName(d, pd);
            if (attributeName == null) continue;
            return attributeName;
        }
        return this.resource.getString(d, "attribute." + pd.getName());
    }

    public String getInstantiableRelationChildRDNType(InstantiableRelationDefinition<?, ?> r) throws MissingResourceException {
        if (r.getNamingPropertyDefinition() != null) {
            return this.getAttributeName(r.getChildDefinition(), r.getNamingPropertyDefinition());
        }
        for (Wrapper profile : this.profiles) {
            String rdnType = profile.getInstantiableRelationChildRDNType(r);
            if (rdnType == null) continue;
            return rdnType;
        }
        return this.resource.getString(r.getParentDefinition(), "naming-attribute." + r.getName());
    }

    public List<String> getInstantiableRelationObjectClasses(InstantiableRelationDefinition<?, ?> r) {
        return Arrays.asList("top", "ds-cfg-branch");
    }

    public String getObjectClass(AbstractManagedObjectDefinition<?, ?> d) throws MissingResourceException {
        for (Wrapper profile : this.profiles) {
            String objectClass = profile.getObjectClass(d);
            if (objectClass == null) continue;
            return objectClass;
        }
        return this.resource.getString(d, "objectclass");
    }

    public List<String> getObjectClasses(AbstractManagedObjectDefinition<?, ?> d) throws MissingResourceException {
        LinkedList<String> objectClasses = new LinkedList<String>();
        HashSet<String> s = new HashSet<String>();
        while (d != null) {
            String oc = this.getObjectClass(d);
            if (!s.contains(oc)) {
                objectClasses.addFirst(oc);
                s.add(oc);
            }
            d = d.getParent();
        }
        if (!s.contains("top")) {
            objectClasses.addFirst("top");
        }
        return objectClasses;
    }

    public String getRelationRDNSequence(RelationDefinition<?, ?> r) throws MissingResourceException {
        for (Wrapper profile : this.profiles) {
            String rdnSequence = profile.getRelationRDNSequence(r);
            if (rdnSequence == null) continue;
            return rdnSequence;
        }
        return this.resource.getString(r.getParentDefinition(), "rdn." + r.getName());
    }

    public void popWrapper() throws NoSuchElementException {
        this.profiles.removeFirst();
    }

    public void pushWrapper(Wrapper wrapper) {
        this.profiles.addFirst(wrapper);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Wrapper {
        protected Wrapper() {
        }

        public String getAttributeName(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
            return null;
        }

        public String getInstantiableRelationChildRDNType(InstantiableRelationDefinition<?, ?> r) {
            return null;
        }

        public String getObjectClass(AbstractManagedObjectDefinition<?, ?> d) {
            return null;
        }

        public String getRelationRDNSequence(RelationDefinition<?, ?> r) {
            return null;
        }
    }
}

