/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DefinitionResolver;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectDefinitionI18NResource;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedObjectDefinition<C extends ConfigurationClient, S extends Configuration> {
    private final String name;
    private final AbstractManagedObjectDefinition<? super C, ? super S> parent;
    private final Map<String, PropertyDefinition<?>> propertyDefinitions;
    private final Map<String, RelationDefinition<?, ?>> relationDefinitions;
    private final Map<String, PropertyDefinition<?>> allPropertyDefinitions;
    private final Map<String, RelationDefinition<?, ?>> allRelationDefinitions;
    private final Set<Tag> allTags;
    private final Map<String, AbstractManagedObjectDefinition<? extends C, ? extends S>> children;

    protected AbstractManagedObjectDefinition(String name, AbstractManagedObjectDefinition<? super C, ? super S> parent) {
        this.name = name;
        this.parent = parent;
        this.propertyDefinitions = new HashMap();
        this.relationDefinitions = new HashMap();
        this.allPropertyDefinitions = new HashMap();
        this.allRelationDefinitions = new HashMap();
        this.allTags = new HashSet<Tag>();
        this.children = new HashMap<String, AbstractManagedObjectDefinition<? extends C, ? extends S>>();
        if (parent != null) {
            parent.children.put(name, this);
            for (PropertyDefinition<?> propertyDefinition : parent.getAllPropertyDefinitions()) {
                this.allPropertyDefinitions.put(propertyDefinition.getName(), propertyDefinition);
            }
            for (RelationDefinition relationDefinition : parent.getAllRelationDefinitions()) {
                this.allRelationDefinitions.put(relationDefinition.getName(), relationDefinition);
            }
        }
    }

    public final Collection<AbstractManagedObjectDefinition<? extends C, ? extends S>> getAllChildren() {
        ArrayList<AbstractManagedObjectDefinition<C, S>> list = new ArrayList<AbstractManagedObjectDefinition<C, S>>(this.children.values());
        for (AbstractManagedObjectDefinition<C, S> child : this.children.values()) {
            list.addAll(child.getAllChildren());
        }
        return Collections.unmodifiableCollection(list);
    }

    public final Collection<PropertyDefinition<?>> getAllPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.allPropertyDefinitions.values());
    }

    public final Collection<RelationDefinition<?, ?>> getAllRelationDefinitions() {
        return Collections.unmodifiableCollection(this.allRelationDefinitions.values());
    }

    public final Collection<Tag> getAllTags() {
        return Collections.unmodifiableCollection(this.allTags);
    }

    public final AbstractManagedObjectDefinition<? extends C, ? extends S> getChild(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty managed object name");
        }
        AbstractManagedObjectDefinition<? extends C, ? extends S> d = this.children.get(name);
        if (d == null) {
            for (AbstractManagedObjectDefinition<C, S> child : this.children.values()) {
                try {
                    d = child.getChild(name);
                    break;
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
        if (d == null) {
            throw new IllegalArgumentException("child managed object definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<AbstractManagedObjectDefinition<? extends C, ? extends S>> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public final Message getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public final Message getDescription(Locale locale) {
        try {
            return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "description", locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final AbstractManagedObjectDefinition<? super C, ? super S> getParent() {
        return this.parent;
    }

    public final PropertyDefinition<?> getPropertyDefinition(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty property name");
        }
        PropertyDefinition<?> d = this.allPropertyDefinitions.get(name);
        if (d == null) {
            throw new IllegalArgumentException("property definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<PropertyDefinition<?>> getPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.propertyDefinitions.values());
    }

    public final RelationDefinition<?, ?> getRelationDefinition(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("null or empty relation name");
        }
        RelationDefinition<?, ?> d = this.allRelationDefinitions.get(name);
        if (d == null) {
            throw new IllegalArgumentException("relation definition \"" + name + "\" not found");
        }
        return d;
    }

    public final Collection<RelationDefinition<?, ?>> getRelationDefinitions() {
        return Collections.unmodifiableCollection(this.relationDefinitions.values());
    }

    public final Message getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final Message getSynopsis(Locale locale) {
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "synopsis", locale);
    }

    public final Message getUserFriendlyName() {
        return this.getUserFriendlyName(Locale.getDefault());
    }

    public final Message getUserFriendlyName(Locale locale) {
        return Message.raw(ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "user-friendly-name", locale), new Object[0]);
    }

    public final Message getUserFriendlyPluralName() {
        return this.getUserFriendlyPluralName(Locale.getDefault());
    }

    public final Message getUserFriendlyPluralName(Locale locale) {
        return ManagedObjectDefinitionI18NResource.getInstance().getMessage(this, "user-friendly-plural-name", locale);
    }

    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public final boolean hasTag(Tag t) {
        return this.allTags.contains(t);
    }

    public final boolean isChildOf(AbstractManagedObjectDefinition<?, ?> d) {
        AbstractManagedObjectDefinition<? super C, ? super S> i = this;
        while (i != null) {
            if (i == d) {
                return true;
            }
            i = i.parent;
        }
        return false;
    }

    public final boolean isParentOf(AbstractManagedObjectDefinition<?, ?> d) {
        return d.isChildOf(this);
    }

    public final ManagedObjectDefinition<? extends C, ? extends S> resolveManagedObjectDefinition(DefinitionResolver r) throws DefinitionDecodingException {
        AbstractManagedObjectDefinition<C, S> rd = this.resolveManagedObjectDefinitionAux(this, r);
        if (rd == null) {
            throw new DefinitionDecodingException(DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
        }
        if (rd instanceof ManagedObjectDefinition) {
            return (ManagedObjectDefinition)rd;
        }
        throw new DefinitionDecodingException(DefinitionDecodingException.Reason.ABSTRACT_TYPE_INFORMATION);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public final void toString(StringBuilder builder) {
        builder.append(this.getName());
    }

    protected final void deregisterRelationDefinition(RelationDefinition<?, ?> d) {
        String name = d.getName();
        this.relationDefinitions.remove(name);
        this.allRelationDefinitions.remove(name);
    }

    protected final void registerPropertyDefinition(PropertyDefinition<?> d) {
        String name = d.getName();
        this.propertyDefinitions.put(name, d);
        this.allPropertyDefinitions.put(name, d);
    }

    protected final void registerRelationDefinition(RelationDefinition<?, ?> d) {
        String name = d.getName();
        this.relationDefinitions.put(name, d);
        this.allRelationDefinitions.put(name, d);
    }

    protected final void registerTag(Tag t) {
        this.allTags.add(t);
    }

    private AbstractManagedObjectDefinition<? extends C, ? extends S> resolveManagedObjectDefinitionAux(AbstractManagedObjectDefinition<? extends C, ? extends S> d, DefinitionResolver r) {
        if (!r.matches(d)) {
            return null;
        }
        for (AbstractManagedObjectDefinition<C, S> abstractManagedObjectDefinition : d.getChildren()) {
            AbstractManagedObjectDefinition<C, S> rd = this.resolveManagedObjectDefinitionAux(abstractManagedObjectDefinition, r);
            if (rd == null) continue;
            return rd;
        }
        return d;
    }
}

