/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipExtractor {
    private static final Logger LOG = Logger.getLogger(ZipExtractor.class.getName());
    private static final char ZIP_ENTRY_NAME_SEP = '/';
    private InputStream is;
    private int minRatio;
    private int maxRatio;
    private int numberZipEntries;
    private String zipFileName;
    private Application application;

    public ZipExtractor(File zipFile) throws FileNotFoundException, IllegalArgumentException {
        this(zipFile, 0, 0, 1, null);
    }

    public ZipExtractor(InputStream in, String zipFileName) throws FileNotFoundException, IllegalArgumentException {
        this(in, 0, 0, 1, zipFileName, null);
    }

    public ZipExtractor(File zipFile, int minRatio, int maxRatio, int numberZipEntries, Application app) throws FileNotFoundException, IllegalArgumentException {
        this(new FileInputStream(zipFile), minRatio, maxRatio, numberZipEntries, zipFile.getName(), app);
        if (!zipFile.getName().endsWith(".zip")) {
            throw new IllegalArgumentException("File must have extension .zip");
        }
    }

    public ZipExtractor(InputStream is, int minRatio, int maxRatio, int numberZipEntries, String zipFileName, Application app) {
        this.is = is;
        this.minRatio = minRatio;
        this.maxRatio = maxRatio;
        this.numberZipEntries = numberZipEntries;
        this.zipFileName = zipFileName;
        this.application = app;
    }

    public void extract(File destination) throws ApplicationException {
        this.extract(Utils.getPath(destination));
    }

    public void extract(String destination) throws ApplicationException {
        this.extract(destination, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extract(String destDir, boolean removeFirstPath) throws ApplicationException {
        ZipInputStream zipIn = new ZipInputStream(this.is);
        int nEntries = 1;
        HashMap<String, ArrayList<String>> permissions = new HashMap<String, ArrayList<String>>();
        try {
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                int ratioBeforeCompleted = this.minRatio + (nEntries - 1) * (this.maxRatio - this.minRatio) / this.numberZipEntries;
                int ratioWhenCompleted = this.minRatio + nEntries * (this.maxRatio - this.minRatio) / this.numberZipEntries;
                String name = entry.getName();
                if (name != null && removeFirstPath) {
                    int sepPos = name.indexOf(47);
                    if (sepPos != -1) {
                        name = name.substring(sepPos + 1);
                    } else {
                        LOG.log(Level.WARNING, "zip entry name does not contain a path separator");
                    }
                }
                if (name != null && name.length() > 0) {
                    try {
                        File destination = new File(destDir, name);
                        this.copyZipEntry(entry, destination, zipIn, ratioBeforeCompleted, ratioWhenCompleted, permissions);
                    }
                    catch (IOException ioe) {
                        Message errorMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_COPYING.get(entry.getName()), ioe);
                        throw new ApplicationException(ApplicationReturnCode.ReturnCode.FILE_SYSTEM_ACCESS_ERROR, errorMsg, ioe);
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
                ++nEntries;
            }
            if (!Utils.isUnix()) return;
            for (String perm : permissions.keySet()) {
                ArrayList paths = (ArrayList)permissions.get(perm);
                try {
                    int result = Utils.setPermissionsUnix(paths, perm);
                    if (result == 0) continue;
                    throw new IOException("Could not set permissions on files " + paths + ".  The chmod error code was: " + result);
                }
                catch (InterruptedException ie) {
                    IOException ioe = new IOException("Could not set permissions on files " + paths + ".  The chmod call returned an " + "InterruptedException.");
                    ioe.initCause(ie);
                    throw ioe;
                    return;
                }
            }
        }
        catch (IOException ioe) {
            Message errorMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_ZIP_STREAM.get(this.zipFileName), ioe);
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.FILE_SYSTEM_ACCESS_ERROR, errorMsg, ioe);
        }
    }

    private void copyZipEntry(ZipEntry entry, File destination, ZipInputStream is, int ratioBeforeCompleted, int ratioWhenCompleted, Map<String, ArrayList<String>> permissions) throws IOException {
        if (this.application != null) {
            Message progressSummary = QuickSetupMessages.INFO_PROGRESS_EXTRACTING.get(Utils.getPath(destination));
            this.application.notifyListeners(ratioBeforeCompleted, progressSummary);
        }
        LOG.log(Level.INFO, "extracting " + Utils.getPath(destination));
        if (Utils.insureParentsExist(destination)) {
            String perm;
            if (entry.isDirectory()) {
                perm = this.getDirectoryFileSystemPermissions(destination);
                ArrayList<String> list = permissions.get(perm);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(Utils.getPath(destination));
                permissions.put(perm, list);
                if (!Utils.createDirectory(destination)) {
                    throw new IOException("Could not create path: " + destination);
                }
            } else {
                perm = Utils.getFileSystemPermissions(destination);
                ArrayList<String> list = permissions.get(perm);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(Utils.getPath(destination));
                permissions.put(perm, list);
                Utils.createFile(destination, (InputStream)is);
            }
        } else {
            throw new IOException("Could not create parent path: " + destination);
        }
        if (this.application != null) {
            this.application.notifyListenersDone(ratioWhenCompleted);
        }
    }

    private String getDirectoryFileSystemPermissions(File path) {
        return "755";
    }
}

