/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.UserInteraction;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.VersionCompatibilityIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VersionIssueNotifier {
    private static final Logger LOG = Logger.getLogger(VersionIssueNotifier.class.getName());
    protected UserInteraction ui;
    protected List<Directive> directives;
    protected BuildInformation currentBuildInfo;
    protected BuildInformation newBuildInfo;
    private boolean isSupported = true;
    private boolean noServerStart = false;

    public VersionIssueNotifier(UserInteraction ui, BuildInformation current, BuildInformation neu) {
        List<VersionCompatibilityIssue> compatibilityIssues;
        this.ui = ui;
        this.currentBuildInfo = current;
        this.newBuildInfo = neu;
        Set<Integer> excludeIds = current.getIncompatibilityEventIds();
        if (excludeIds != null) {
            compatibilityIssues = VersionCompatibilityIssue.getEvents(excludeIds);
        } else {
            LOG.log(Level.INFO, "Legacy method for obtaining compatibility issues");
            BuildVersion bv = new BuildVersion(current.getMajorVersion(), current.getMinorVersion(), current.getPointVersion(), current.getRevisionNumber().intValue());
            compatibilityIssues = VersionCompatibilityIssue.getEvents(bv);
        }
        this.directives = this.processEvents(compatibilityIssues);
    }

    public abstract void notifyUser() throws ApplicationException;

    public boolean isUpgrade() {
        return this.currentBuildInfo.compareTo(this.newBuildInfo) < 0;
    }

    public boolean isReversion() {
        return this.currentBuildInfo.compareTo(this.newBuildInfo) > 0;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public boolean noServerStartFollowingOperation() {
        return this.noServerStart;
    }

    protected List<Directive> getIssues() {
        return this.directives;
    }

    protected boolean hasIssues() {
        return this.directives != null && this.directives.size() > 0;
    }

    protected abstract Message getLocalizedDetailMessage(VersionCompatibilityIssue.Cause var1);

    protected abstract boolean isActionRequired(VersionCompatibilityIssue.Cause var1);

    protected abstract boolean isUnsupported(VersionCompatibilityIssue.Cause var1);

    protected abstract boolean isWarning(VersionCompatibilityIssue.Cause var1);

    protected boolean isNotification(VersionCompatibilityIssue.Cause cause) {
        Message msg;
        boolean isNotification = false;
        if (cause != null && (msg = this.getLocalizedDetailMessage(cause)) != null && !this.isWarning(cause) && !this.isActionRequired(cause)) {
            isNotification = true;
        }
        return isNotification;
    }

    protected List<Message> getExportImportInstructions() {
        ArrayList<Message> instructions = new ArrayList<Message>();
        instructions.add(QuickSetupMessages.INFO_ORACLE_EI_ACTION_STEP1.get());
        instructions.add(QuickSetupMessages.INFO_ORACLE_EI_ACTION_STEP2.get());
        instructions.add(QuickSetupMessages.INFO_ORACLE_EI_ACTION_STEP3.get());
        instructions.add(QuickSetupMessages.INFO_ORACLE_EI_ACTION_STEP4.get());
        return instructions;
    }

    private List<Directive> processEvents(List<VersionCompatibilityIssue> compatibilityIssues) {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        if (compatibilityIssues != null) {
            for (VersionCompatibilityIssue evt : compatibilityIssues) {
                VersionCompatibilityIssue.Cause cause = evt.getCause();
                Set<VersionCompatibilityIssue.Effect> effects = cause.getEffects();
                Message msg = this.getLocalizedDetailMessage(cause);
                if (this.isUnsupported(cause)) {
                    this.isSupported = false;
                    directives.add(new Directive(DirectiveType.NOT_SUPPORTED, msg));
                } else if (this.isActionRequired(cause)) {
                    directives.add(new Directive(DirectiveType.ACTION, msg));
                } else if (this.isWarning(cause)) {
                    directives.add(new Directive(DirectiveType.WARNING, msg));
                } else if (this.isNotification(cause)) {
                    directives.add(new Directive(DirectiveType.INFO, msg));
                }
                if (!effects.contains((Object)VersionCompatibilityIssue.Effect.NO_SERVER_RESTART_FOLLOWING_REVERSION) && !effects.contains((Object)VersionCompatibilityIssue.Effect.REVERSION_DATA_EXPORT_AND_REIMPORT_REQUIRED) && !effects.contains((Object)VersionCompatibilityIssue.Effect.UPGRADE_DATA_EXPORT_AND_REIMPORT_REQUIRED)) continue;
                this.noServerStart = true;
            }
        }
        return Collections.unmodifiableList(directives);
    }

    protected class Directive {
        DirectiveType type;
        Message msg;

        public Directive(DirectiveType type, Message localizedMsg) {
            this.type = type;
            this.msg = localizedMsg;
        }

        public DirectiveType getType() {
            return this.type;
        }

        public Message getMessage() {
            return this.msg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DirectiveType {
        NOT_SUPPORTED,
        ACTION,
        INFO,
        WARNING;

    }
}

