/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.HistoricalRecord;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ProgressUpdateListenerDelegate;
import org.opends.quicksetup.Status;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.upgrader.ReversionLauncher;
import org.opends.quicksetup.upgrader.ReversionProgressStep;
import org.opends.quicksetup.upgrader.ReverterUserData;
import org.opends.quicksetup.upgrader.UpgradeFileFilter;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;

public class Reverter
extends Application
implements CliApplication {
    private static final Logger LOG = Logger.getLogger(Reverter.class.getName());
    private ReversionProgressStep currentProgressStep = ReversionProgressStep.NOT_STARTED;
    private ReverterUserData userData;
    private ProgressMessageFormatter formatter;
    private ProgressUpdateListenerDelegate listenerDelegate;
    private ApplicationException runError;
    private ApplicationException runWarning;
    private Installation installation;
    private File tempBackupDir;
    private long historicalOperationId;
    private BuildInformation fromBuildInfo;
    private BuildInformation toBuildInfo;
    private boolean abort = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserData createUserData(Launcher launcher) throws UserDataException {
        ReverterUserData ud = null;
        if (!(launcher instanceof ReversionLauncher)) return ud;
        ud = new ReverterUserData();
        ReversionLauncher rl = (ReversionLauncher)launcher;
        File filesDir = null;
        if (rl.useMostRecentUpgrade()) {
            Installation install = this.getInstallation();
            File historyDir = install.getHistoryDirectory();
            if (!historyDir.exists()) throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NO_HISTORY_DIR.get());
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !"log".equals(name);
                }
            };
            Object[] childNames = historyDir.list(filter);
            if (childNames == null || childNames.length <= 0) throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_EMPTY_HISTORY_DIR.get());
            Arrays.sort(childNames);
            for (Object childName : childNames) {
                File b = new File(historyDir, (String)childName);
                File d = new File(b, "files");
                if (!this.isFilesDirectory(d)) continue;
                filesDir = d;
                break;
            }
        } else {
            filesDir = rl.getFilesDirectory();
            if (filesDir != null) {
                if (!filesDir.getName().endsWith("files")) {
                    filesDir = new File(filesDir, "files");
                }
            } else {
                StringBuilder sb = new StringBuilder().append("-").append(ReversionLauncher.DIRECTORY_OPTION_SHORT).append("/--").append("directory").append(", -").append(ReversionLauncher.MOST_RECENT_OPTION_SHORT).append("/--").append("mostRecent");
                throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NO_DIR.get(sb.toString()));
            }
        }
        if (!this.validateFilesDirectory(filesDir)) return ud;
        ud.setFilesDirectory(filesDir);
        return ud;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        if (userData instanceof ReverterUserData) {
            this.userData = (ReverterUserData)userData;
        }
    }

    public void setProgressMessageFormatter(ProgressMessageFormatter formatter) {
        this.formatter = formatter;
        this.listenerDelegate = new ProgressUpdateListenerDelegate(formatter);
    }

    public ApplicationException getRunError() {
        return this.runError;
    }

    public void addProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.addProgressUpdateListener(l);
    }

    public void removeProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.removeProgressUpdateListener(l);
    }

    public void notifyListeners(Integer ratio, Message currentPhaseSummary, Message newLogDetail) {
        this.listenerDelegate.notifyListeners(null, ratio, currentPhaseSummary, newLogDetail);
    }

    public String getInstallationPath() {
        String installationPath = null;
        String path = Utils.getInstallPathFromClasspath();
        if (path != null) {
            File f = new File(path);
            installationPath = f.getParentFile() != null && f.getParentFile().getParentFile() != null && new File(f.getParentFile().getParentFile(), "locks").exists() ? Utils.getPath(f.getParentFile().getParentFile()) : path;
        }
        return installationPath;
    }

    public ProgressStep getCurrentProgressStep() {
        return this.currentProgressStep;
    }

    public Integer getRatio(ProgressStep step) {
        Integer ratio = null;
        if (step instanceof ReversionProgressStep) {
            ratio = ((ReversionProgressStep)step).getProgress();
        }
        return ratio;
    }

    public Message getSummary(ProgressStep step) {
        Message txt = step == ReversionProgressStep.FINISHED ? this.getFinalSuccessMessage() : ((ReversionProgressStep)step).getSummaryMesssage();
        return txt;
    }

    public boolean isFinished() {
        return this.getCurrentProgressStep() == ReversionProgressStep.FINISHED || this.getCurrentProgressStep() == ReversionProgressStep.FINISHED_WITH_ERRORS || this.getCurrentProgressStep() == ReversionProgressStep.FINISHED_WITH_WARNINGS || this.getCurrentProgressStep() == ReversionProgressStep.FINISHED_CANCELED;
    }

    public boolean isCancellable() {
        return false;
    }

    public void cancel() {
    }

    public Installation getInstallation() {
        String installPath;
        if (this.installation == null && (installPath = this.getInstallationPath()) != null) {
            this.installation = new Installation(installPath);
        }
        return this.installation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.initialize();
            UserInteraction ui = this.userInteraction();
            if (ui != null) {
                Message cont = QuickSetupMessages.INFO_CONTINUE_BUTTON_LABEL.get();
                Message cancel = QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get();
                String toBuildString = null;
                BuildInformation toBi = this.getToBuildInformation();
                toBuildString = toBi != null ? toBi.toString() : QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
                if (cancel.equals(ui.confirm(Message.raw("Confirm Reversion", new Object[0]), Message.raw("This installation will be reverted to version " + toBuildString + " using the files in " + this.getFilesDirectory() + ".", new Object[0]), Message.raw("Confirm", new Object[0]), UserInteraction.MessageType.WARNING, new Message[]{cont, cancel}, cont))) {
                    throw new ApplicationException(ApplicationReturnCode.ReturnCode.CANCELLED, QuickSetupMessages.INFO_REVERSION_CANCELED.get(), null);
                }
            }
            this.stopServer();
            this.revertFiles();
        }
        catch (Throwable e) {
            this.runError = !(e instanceof ApplicationException) ? new ApplicationException(ApplicationReturnCode.ReturnCode.BUG, Message.raw(e.getLocalizedMessage(), new Object[0]), e) : (ApplicationException)e;
        }
        finally {
            this.end();
        }
    }

    private void setCurrentProgressStep(ReversionProgressStep step) {
        this.currentProgressStep = step;
        int progress = step.getProgress();
        Message msg = this.getSummary(step);
        this.notifyListeners(progress, msg, this.formatter.getFormattedProgress(msg));
    }

    private void initialize() throws ApplicationException {
        this.historicalOperationId = this.writeInitialHistoricalRecord(this.getFromBuildInformation(), this.getToBuildInformation());
    }

    private void stopServer() throws ApplicationException {
        Installation installation = this.getInstallation();
        Status status = installation.getStatus();
        if (status.isServerRunning()) {
            this.setCurrentProgressStep(ReversionProgressStep.STOPPING_SERVER);
            ServerController sc = new ServerController(installation);
            sc.stopServer(true);
        }
    }

    private void revertFiles() throws ApplicationException {
        this.backupFilesytem();
        this.revertComponents();
    }

    private void backupFilesytem() throws ApplicationException {
        try {
            File filesBackupDirectory = this.getTempBackupDirectory();
            FileManager fm = new FileManager();
            File root = this.getInstallation().getRootDirectory();
            UpgradeFileFilter filter = new UpgradeFileFilter(root);
            for (String fileName : root.list()) {
                File f = new File(root, fileName);
                fm.move(f, filesBackupDirectory, filter);
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.FILE_SYSTEM_ACCESS_ERROR, QuickSetupMessages.INFO_ERROR_BACKUP_FILESYSTEM.get(), e);
        }
    }

    private void revertComponents() throws ApplicationException {
        try {
            File stageDir = this.getFilesDirectory();
            Installation installation = this.getInstallation();
            File root = installation.getRootDirectory();
            FileManager fm = new FileManager();
            for (String fileName : stageDir.list()) {
                File f = new File(stageDir, fileName);
                fm.copyRecursively(f, root, new UpgradeFileFilter(stageDir), true);
            }
            LOG.log(Level.INFO, "reverted bits to " + installation.getBuildInformation(false));
        }
        catch (IOException e) {
            throw ApplicationException.createFileSystemException(QuickSetupMessages.INFO_ERROR_UPGRADING_COMPONENTS.get(), e);
        }
    }

    private File getFilesDirectory() throws ApplicationException, IOException {
        return this.userData.getFilesDirectory();
    }

    private boolean validateFilesDirectory(File filesDir) throws UserDataException {
        if (filesDir == null) {
            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NULL_FILES_DIR.get());
        }
        if (!filesDir.isDirectory()) {
            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NOT_DIR_FILES_DIR.get());
        }
        if (!this.isFilesDirectory(filesDir)) {
            throw new UserDataException(null, QuickSetupMessages.INFO_REVERT_ERROR_NOT_DIR_FILES_DIR.get());
        }
        return true;
    }

    private boolean isFilesDirectory(File filesDir) {
        boolean isFilesDir = false;
        if (filesDir != null && filesDir.isDirectory()) {
            String[] children = filesDir.list();
            HashSet<String> cs = new HashSet<String>(Arrays.asList(children));
            isFilesDir = cs.contains("config") && cs.contains("lib");
        }
        return isFilesDir;
    }

    private void end() {
        try {
            HistoricalRecord.Status status;
            String note = null;
            if (this.runError == null && !this.abort) {
                status = HistoricalRecord.Status.SUCCESS;
            } else {
                if (this.abort) {
                    status = HistoricalRecord.Status.CANCEL;
                } else {
                    status = HistoricalRecord.Status.FAILURE;
                    note = this.runError.getLocalizedMessage();
                }
                LOG.log(Level.INFO, "canceling reversion");
                ReversionProgressStep lastProgressStep = this.currentProgressStep;
                this.setCurrentProgressStep(ReversionProgressStep.ABORT);
                this.abort(lastProgressStep);
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
                LOG.log(Level.INFO, "cancelation complete");
            }
            LOG.log(Level.INFO, "cleaning up after reversion");
            this.setCurrentProgressStep(ReversionProgressStep.CLEANUP);
            this.cleanup();
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "clean up complete");
            LOG.log(Level.INFO, "recording history");
            this.setCurrentProgressStep(ReversionProgressStep.RECORDING_HISTORY);
            this.writeHistoricalRecord(this.historicalOperationId, this.getFromBuildInformation(), this.getToBuildInformation(), status, note);
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "history recorded");
            this.notifyListeners(new MessageBuilder(QuickSetupMessages.INFO_GENERAL_SEE_FOR_HISTORY.get(Utils.getPath(this.getInstallation().getHistoryLogFile()))).append(this.getLineBreak()).toMessage());
        }
        catch (ApplicationException e) {
            this.notifyListeners(this.getFormattedDoneWithLineBreak());
            LOG.log(Level.INFO, "Error cleaning up after upgrade.", e);
        }
        if (this.abort) {
            LOG.log(Level.INFO, "upgrade canceled by user");
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED_CANCELED);
        } else if (this.runError != null) {
            LOG.log(Level.INFO, "upgrade completed with errors", this.runError);
            this.notifyListeners(this.getFormattedErrorWithLineBreak(this.runError, true));
            this.notifyListeners(this.getLineBreak());
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED_WITH_ERRORS);
            this.notifyListeners(this.getLineBreak());
        } else if (this.runWarning != null) {
            LOG.log(Level.INFO, "upgrade completed with warnings");
            Message warningText = this.runWarning.getMessageObject();
            this.notifyListeners(this.getFormattedErrorWithLineBreak(warningText, true));
            this.notifyListeners(this.getLineBreak());
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED_WITH_WARNINGS);
            this.notifyListeners(this.formatter.getLineBreak());
        } else {
            LOG.log(Level.INFO, "reversion completed successfully");
            this.setCurrentProgressStep(ReversionProgressStep.FINISHED);
        }
    }

    private void abort(ProgressStep lastStep) throws ApplicationException {
        if ("true".equals(System.getProperty("org.opends.quicksetup.upgrader.NoAbort"))) {
            return;
        }
        ReversionProgressStep lastReversionStep = (ReversionProgressStep)lastStep;
        EnumSet<ReversionProgressStep> stepsStarted = EnumSet.range(ReversionProgressStep.NOT_STARTED, lastReversionStep);
        if (stepsStarted.contains(ReversionProgressStep.REVERTING_FILESYSTEM)) {
            File root = this.getInstallation().getRootDirectory();
            try {
                File backupDirectory = this.getTempBackupDirectory();
                FileManager fm = new FileManager();
                boolean restoreError = false;
                for (String fileName : backupDirectory.list()) {
                    File f = new File(backupDirectory, fileName);
                    try {
                        fm.move(f, root, null);
                    }
                    catch (Throwable t) {
                        restoreError = true;
                        this.notifyListeners(QuickSetupMessages.INFO_ERROR_RESTORING_FILE.get(Utils.getPath(f), Utils.getPath(root)));
                    }
                }
                if (!restoreError) {
                    fm.deleteRecursively(backupDirectory);
                }
                ServerController sc = new ServerController(this.getInstallation());
                sc.stopServer(true);
                sc.startServer(true);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Error getting backup directory", e);
            }
        }
    }

    private void cleanup() {
    }

    private File getTempBackupDirectory() throws IOException, ApplicationException {
        if (this.tempBackupDir == null) {
            this.tempBackupDir = new File(this.getInstallation().getTemporaryDirectory(), "files");
            if (this.tempBackupDir.exists()) {
                FileManager fm = new FileManager();
                fm.deleteRecursively(this.tempBackupDir);
            }
            if (!this.tempBackupDir.mkdirs()) {
                throw new IOException("error creating files backup directory");
            }
        }
        return this.tempBackupDir;
    }

    private BuildInformation getFromBuildInformation() {
        if (this.fromBuildInfo == null && this.currentProgressStep.ordinal() < ReversionProgressStep.REVERTING_FILESYSTEM.ordinal()) {
            try {
                this.fromBuildInfo = this.installation.getBuildInformation(false);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Failed to obtain 'from' build information", e);
            }
        }
        return this.fromBuildInfo;
    }

    private BuildInformation getToBuildInformation() {
        if (this.toBuildInfo == null && this.currentProgressStep.ordinal() > ReversionProgressStep.REVERTING_FILESYSTEM.ordinal()) {
            try {
                this.toBuildInfo = this.installation.getBuildInformation(false);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "Failed to obtain 'from' build information", e);
            }
        }
        return this.toBuildInfo;
    }

    private Message getFinalSuccessMessage() {
        String newVersion;
        String installPath = Utils.getPath(this.getInstallation().getRootDirectory());
        try {
            BuildInformation bi = this.getInstallation().getBuildInformation();
            newVersion = bi != null ? bi.toString() : QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        catch (ApplicationException e) {
            newVersion = QuickSetupMessages.INFO_UPGRADE_BUILD_ID_UNKNOWN.get().toString();
        }
        Message txt = QuickSetupMessages.INFO_SUMMARY_REVERT_FINISHED_SUCCESSFULLY_CLI.get(this.formatter.getFormattedText(Message.raw(installPath, new Object[0])), newVersion);
        return txt;
    }
}

