/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.upgrader.UpgradeLauncher;
import org.opends.quicksetup.upgrader.UpgradeUserData;
import org.opends.quicksetup.upgrader.UpgraderCliHelper;

public class BuildExtractorCliHelper
extends UpgraderCliHelper {
    private static final Logger LOG = Logger.getLogger(BuildExtractorCliHelper.class.getName());

    public UpgradeUserData createUserData(String[] args) throws UserDataException {
        UpgradeUserData uud;
        block6: {
            uud = super.createUserData(args);
            uud.setQuiet(true);
            if (this.localInstallPackFileNameArg.isPresent()) {
                String localInstallPackFileName = this.localInstallPackFileNameArg.getValue();
                LOG.log(Level.INFO, "file specified on command line: " + localInstallPackFileName);
                uud.setInstallPackage(this.validateInstallPackFile(localInstallPackFileName));
            } else {
                if (this.isInteractive()) {
                    LOG.log(Level.INFO, "obtaining file information interactively");
                    while (true) {
                        String fileName = this.promptForString(QuickSetupMessages.INFO_UPGRADE_FILE_PROMPT.get(), null);
                        try {
                            uud.setInstallPackage(this.validateInstallPackFile(fileName));
                            LOG.log(Level.INFO, "file specified interactively: " + fileName);
                            break block6;
                        }
                        catch (UserDataException ude) {
                            System.out.println(ude.getMessage());
                            continue;
                        }
                        break;
                    }
                }
                throw new UserDataException(null, QuickSetupMessages.INFO_ERROR_OPTION_REQUIRED_OR_INTERACTIVE.get("-" + UpgradeLauncher.FILE_OPTION_SHORT + "/--" + "file"));
            }
        }
        return uud;
    }

    private File validateInstallPackFile(String fileName) throws UserDataException {
        File f = new File(fileName);
        if (!f.exists()) {
            throw new UserDataException(null, QuickSetupMessages.INFO_BUILD_EXTRACTOR_ERROR_FILE_NO_EXIST.get(fileName));
        }
        if (f.isDirectory() || !f.getName().toLowerCase().endsWith(".zip")) {
            throw new UserDataException(null, QuickSetupMessages.INFO_BUILD_EXTRACTOR_ERROR_FILE_NOT_ZIP.get(fileName));
        }
        return f;
    }
}

