/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;

public class WebProxyDialog
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 4402474441754399992L;
    private JTextField tfHost;
    private JTextField tfPort;
    private JCheckBox chkRequiresAuth;
    private JTextField tfUserName;
    private JPasswordField tfPassword;
    private JOptionPane optionPane;

    public WebProxyDialog(Frame parent) {
        this(parent, null, null, null, null);
        this.loadSystemProperties();
    }

    public WebProxyDialog(Dialog parent) {
        this(parent, null, null, null, null);
        this.loadSystemProperties();
    }

    public WebProxyDialog(Frame parent, String host, Integer port, String user, char[] pw) {
        super(parent, true);
        this.init(host, port, user, pw);
    }

    public WebProxyDialog(Dialog parent, String host, Integer port, String user, char[] pw) {
        super(parent, true);
        this.init(host, port, user, pw);
    }

    private void init(String host, Integer port, String user, char[] pw) {
        this.setTitle(QuickSetupMessages.INFO_WEB_PROXY_DLG_TITLE.get().toString());
        this.optionPane = this.createContentPane(host, port, user, pw);
        this.optionPane.addPropertyChangeListener(this);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent ce) {
                WebProxyDialog.this.tfHost.requestFocusInWindow();
            }
        });
        Utilities.centerOnComponent(this, this.getParent());
        this.pack();
    }

    public SocketAddress getSocketAddress() {
        InetSocketAddress addr = null;
        String host = this.getHost();
        Integer port = this.getPort();
        if (host != null && port != null) {
            addr = new InetSocketAddress(host, (int)port);
        }
        return addr;
    }

    private JOptionPane createContentPane(String host, Integer port, String user, char[] pw) {
        JOptionPane pane = new JOptionPane(this.createPanel(host, port, user, pw), 1, 2);
        return pane;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (value.equals(0)) {
                if (this.validateUserData()) {
                    this.setVisible(false);
                }
            } else if (value.equals(2)) {
                this.setVisible(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.optionPane.setValue(0);
    }

    public String getHost() {
        String v = this.tfHost.getText();
        if (v != null && v.trim().length() == 0) {
            v = null;
        }
        return v;
    }

    public Integer getPort() {
        Integer i = null;
        String v = this.tfPort.getText();
        if (v != null && v.trim().length() == 0) {
            v = null;
        }
        try {
            i = Integer.parseInt(v);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    public String getUserName() {
        String v = this.tfUserName.getText();
        if (v != null && v.trim().length() == 0 || !this.chkRequiresAuth.isSelected()) {
            v = null;
        }
        return v;
    }

    public char[] getPassword() {
        char[] v = this.tfPassword.getPassword();
        if (v != null && v.length == 0 || !this.chkRequiresAuth.isSelected()) {
            v = null;
        }
        return v;
    }

    public void applySystemProperties() {
        Properties systemSettings = System.getProperties();
        String v = this.tfHost.getText();
        if (v != null && v.trim().length() == 0) {
            v = null;
        }
        systemSettings.put("http.proxyHost", v);
        systemSettings.put("https.proxyHost", v);
        v = this.tfPort.getText();
        if (v != null && v.trim().length() == 0) {
            v = null;
        }
        systemSettings.put("http.proxyPort", v);
        systemSettings.put("https.proxyPort", v);
        System.setProperties(systemSettings);
    }

    private void loadSystemProperties() {
        Properties systemSettings = System.getProperties();
        Object v = systemSettings.get("http.proxyHost");
        this.tfHost.setText(v != null ? v.toString() : "");
        v = systemSettings.get("http.proxyPort");
        this.tfPort.setText(v != null ? v.toString() : "");
    }

    private JPanel createPanel(String host, Integer port, String user, char[] pw) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        final JLabel lblUser = UIFactory.makeJLabel(null, QuickSetupMessages.INFO_WEB_PROXY_DLG_USER_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        final JLabel lblPassword = UIFactory.makeJLabel(null, QuickSetupMessages.INFO_WEB_PROXY_DLG_PASSWORD_LABEL.get(), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        gbc.fill = 0;
        p.add((Component)new JLabel(QuickSetupMessages.INFO_WEB_PROXY_DLG_HOST_LABEL.get().toString()), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.tfHost = new JTextField(host);
        p.add((Component)this.tfHost, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        p.add((Component)new JLabel(QuickSetupMessages.INFO_WEB_PROXY_DLG_PORT_LABEL.get().toString()), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.tfPort = new JTextField(port != null ? port.toString() : "");
        p.add((Component)this.tfPort, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.top = 7;
        p.add((Component)new JLabel(QuickSetupMessages.INFO_WEB_PROXY_DLG_AUTH_LABEL.get().toString()), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets.top = 0;
        this.chkRequiresAuth = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_WEB_PROXY_DLG_AUTH_REQ_LABEL.get(), Message.EMPTY, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
        p.add((Component)this.chkRequiresAuth, gbc);
        this.chkRequiresAuth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebProxyDialog.this.tfUserName.setEnabled(WebProxyDialog.this.chkRequiresAuth.isSelected());
                WebProxyDialog.this.tfPassword.setEnabled(WebProxyDialog.this.chkRequiresAuth.isSelected());
                lblUser.setEnabled(WebProxyDialog.this.chkRequiresAuth.isSelected());
                lblPassword.setEnabled(WebProxyDialog.this.chkRequiresAuth.isSelected());
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets.left = 5;
        p.add((Component)lblUser, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.insets.left = 0;
        this.tfUserName = new JTextField(user);
        p.add((Component)this.tfUserName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 0;
        gbc.insets.left = 5;
        p.add((Component)lblPassword, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.fill = 2;
        gbc.insets.left = 0;
        gbc.weighty = 1.0;
        this.tfPassword = new JPasswordField(pw != null ? new String(pw) : "");
        p.add((Component)this.tfPassword, gbc);
        this.chkRequiresAuth.setSelected(false);
        this.tfUserName.setEnabled(false);
        this.tfPassword.setEnabled(false);
        lblPassword.setEnabled(false);
        lblUser.setEnabled(false);
        this.tfHost.addActionListener(this);
        this.tfPort.addActionListener(this);
        this.tfUserName.addActionListener(this);
        this.tfPassword.addActionListener(this);
        return p;
    }

    private boolean validateUserData() {
        Message errorMsg = null;
        String portString = this.tfPort.getText();
        try {
            Integer port = Integer.parseInt(portString);
            if (port < 1 || port > 65535) {
                errorMsg = QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535));
            }
        }
        catch (NumberFormatException e) {
            errorMsg = QuickSetupMessages.INFO_INVALID_PORT_VALUE_RANGE.get(String.valueOf(1), String.valueOf(65535));
        }
        if (errorMsg != null) {
            JOptionPane.showMessageDialog(this, errorMsg);
        }
        return errorMsg == null;
    }
}

