/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;

public class CertificateDialog
extends JDialog
implements HyperlinkListener {
    private static final long serialVersionUID = -8989965057591475064L;
    private boolean isAccepted;
    private UserDataCertificateException ce;
    private JButton cancelButton;
    private JButton okButton;
    private JComponent certificateDetails;
    private JEditorPane explanationPane;
    private boolean detailsAlreadyClicked;
    private String explanationWithHideDetails;
    private String explanationWithShowDetails;
    private static final Logger LOG = Logger.getLogger(CertificateDialog.class.getName());

    public CertificateDialog(JFrame parent, UserDataCertificateException ce) {
        super(parent);
        this.ce = ce;
        this.setTitle(QuickSetupMessages.INFO_CERTIFICATE_DIALOG_TITLE.get().toString());
        this.getContentPane().add(this.createPanel());
        this.setModal(true);
        this.pack();
        if (this.getPreferredSize().width > parent.getWidth()) {
            this.setPreferredSize(new Dimension(Math.max(parent.getWidth() - 20, 400), this.getPreferredSize().height));
        }
        this.pack();
        int minWidth = (int)this.getPreferredSize().getWidth();
        int minHeight = (int)this.getPreferredSize().getHeight();
        this.addComponentListener(new MinimumSizeComponentListener(this, minWidth, minHeight));
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CertificateDialog.this.cancelClicked();
            }
        });
        this.setDefaultCloseOperation(0);
        Utilities.centerOnComponent(this, parent);
    }

    public boolean isAccepted() {
        return this.isAccepted;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            boolean detailsVisible = !this.certificateDetails.isVisible();
            this.explanationPane.setText(detailsVisible ? this.explanationWithHideDetails : this.explanationWithShowDetails);
            this.certificateDetails.setVisible(detailsVisible);
            if (detailsVisible && !this.detailsAlreadyClicked) {
                this.detailsAlreadyClicked = true;
                this.pack();
            }
        }
    }

    private JPanel createPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.anchor = 18;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        topPanel.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        topPanel.add(this.createTitlePanel(), gbc);
        gbc.insets.top = 5;
        topPanel.add(this.createTextPane(), gbc);
        this.certificateDetails = this.createCertificateDetailsPane();
        gbc.insets.top = 0;
        gbc.insets.bottom = 0;
        topPanel.add(Box.createHorizontalStrut(this.certificateDetails.getPreferredSize().width), gbc);
        gbc.insets.top = 0;
        gbc.weighty = 1.0;
        JPanel auxPanel = UIFactory.makeJPanel();
        auxPanel.setLayout(new GridBagLayout());
        gbc.weightx = 0.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        auxPanel.add(Box.createVerticalStrut(100), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        auxPanel.add((Component)this.certificateDetails, gbc);
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        gbc.insets.bottom = 10;
        topPanel.add((Component)auxPanel, gbc);
        this.certificateDetails.setVisible(false);
        gbc.weighty = 0.2;
        gbc.insets = UIFactory.getEmptyInsets();
        topPanel.add(Box.createVerticalGlue(), gbc);
        contentPanel.add((Component)topPanel, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        gbc.fill = 2;
        contentPanel.add(this.createButtonsPanel(), gbc);
        return contentPanel;
    }

    private Component createTitlePanel() {
        JPanel titlePanel = UIFactory.makeJPanel();
        titlePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        Message title = QuickSetupMessages.INFO_CERTIFICATE_TITLE.get();
        JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, title, UIFactory.TextStyle.TITLE);
        l.setOpaque(false);
        titlePanel.add((Component)l, gbc);
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        titlePanel.add(Box.createHorizontalGlue(), gbc);
        return titlePanel;
    }

    private Component createTextPane() {
        Message text = this.ce.getType() == UserDataCertificateException.Type.NOT_TRUSTED ? QuickSetupMessages.INFO_CERTIFICATE_NOT_TRUSTED_TEXT.get(this.ce.getHost(), String.valueOf(this.ce.getPort()), this.ce.getHost(), String.valueOf(this.ce.getPort())) : QuickSetupMessages.INFO_CERTIFICATE_NAME_MISMATCH_TEXT.get(this.ce.getHost(), String.valueOf(this.ce.getPort()), this.ce.getHost(), this.ce.getHost(), String.valueOf(this.ce.getPort()), this.ce.getHost(), String.valueOf(this.ce.getPort()));
        JPanel p = UIFactory.makeJPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        p.add((Component)UIFactory.makeJLabel(UIFactory.IconType.WARNING_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.insets.left = 10;
        gbc.insets.bottom = 0;
        this.explanationPane = UIFactory.makeHtmlPane(null, UIFactory.INSTRUCTIONS_FONT);
        this.explanationPane.setOpaque(false);
        this.explanationPane.setEditable(false);
        this.explanationPane.addHyperlinkListener(this);
        p.add((Component)this.explanationPane, gbc);
        if (this.ce.getChain() != null && this.ce.getChain().length > 0) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(text);
            mb.append(QuickSetupMessages.INFO_CERTIFICATE_SHOW_DETAILS_TEXT.get());
            this.explanationWithShowDetails = UIFactory.applyFontToHtml(mb.toString(), UIFactory.INSTRUCTIONS_FONT);
            MessageBuilder mb2 = new MessageBuilder();
            mb2.append(text);
            mb2.append(QuickSetupMessages.INFO_CERTIFICATE_HIDE_DETAILS_TEXT.get());
            this.explanationWithHideDetails = UIFactory.applyFontToHtml(mb2.toString(), UIFactory.INSTRUCTIONS_FONT);
            this.explanationPane.setText(this.explanationWithShowDetails);
        } else {
            this.explanationPane.setText(text.toString());
        }
        return p;
    }

    private Component createButtonsPanel() {
        JPanel buttonsPanel = UIFactory.makeJPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.insets.left = UIFactory.getCurrentStepPanelInsets().left;
        buttonsPanel.add((Component)UIFactory.makeJLabel(UIFactory.IconType.OPENDS_SMALL, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        --gbc.gridwidth;
        gbc.insets.left = 0;
        buttonsPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.okButton = UIFactory.makeJButton(QuickSetupMessages.INFO_OK_BUTTON_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_DIALOG_OK_BUTTON_TOOLTIP.get());
        buttonsPanel.add((Component)this.okButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CertificateDialog.this.okClicked();
            }
        });
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        this.cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_DIALOG_CANCEL_BUTTON_TOOLTIP.get());
        buttonsPanel.add((Component)this.cancelButton, gbc);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CertificateDialog.this.cancelClicked();
            }
        });
        return buttonsPanel;
    }

    private JComponent createCertificateDetailsPane() {
        JPanel p = UIFactory.makeJPanel();
        p.setLayout(new GridBagLayout());
        if (this.ce.getChain() != null && this.ce.getChain().length > 0) {
            final JComboBox<String> combo = new JComboBox<String>();
            combo.setToolTipText(QuickSetupMessages.INFO_CERTIFICATE_CHAIN_COMBO_TOOLTIP.get().toString());
            final CardLayout cl = new CardLayout();
            JPanel cardPanel = new JPanel(cl);
            final HashMap<String, JPanel> hmPanels = new HashMap<String, JPanel>();
            Message[] labels = new Message[]{QuickSetupMessages.INFO_CERTIFICATE_SUBJECT_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_ISSUED_BY_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_VALID_FROM_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_EXPIRES_ON_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_TYPE_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_SERIAL_NUMBER_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_SIGNATURE_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_SIGNATURE_ALGORITHM_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_VERSION_LABEL.get(), QuickSetupMessages.INFO_CERTIFICATE_PUBLIC_KEY_LABEL.get()};
            for (int i = 0; i < this.ce.getChain().length; ++i) {
                X509Certificate cert = this.ce.getChain()[i];
                JComponent[] components = new JComponent[]{this.createSubjectComponent(cert), this.createIssuedByComponent(cert), this.createValidFromComponent(cert), this.createExpiresOnComponent(cert), this.createTypeComponent(cert), this.createSerialNumberComponent(cert), this.createSignatureComponent(cert), this.createSignatureAlgorithmComponent(cert), this.createVersionComponent(cert), this.createPublicKeyComponent(cert)};
                JPanel certPanel = UIFactory.makeJPanel();
                certPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 18;
                gbc.fill = 2;
                for (int j = 0; j < labels.length; ++j) {
                    JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, labels[j], UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                    l.setLabelFor(components[j]);
                    if (j > 0) {
                        gbc.insets.top = 5;
                    }
                    gbc.gridwidth = -1;
                    gbc.weightx = 0.0;
                    gbc.insets.left = 0;
                    certPanel.add((Component)l, gbc);
                    gbc.gridwidth = 0;
                    gbc.weightx = 1.0;
                    gbc.insets.left = 5;
                    certPanel.add((Component)components[j], gbc);
                }
                String name = this.getName(cert);
                hmPanels.put(name, certPanel);
                cardPanel.add(name, certPanel);
                combo.addItem(name);
            }
            GridBagConstraints gbc = new GridBagConstraints();
            if (this.ce.getChain().length == 1) {
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                p.add((Component)cardPanel, gbc);
                gbc.weighty = 1.0;
                p.add(Box.createVerticalGlue(), gbc);
            } else {
                gbc.anchor = 17;
                gbc.gridwidth = 3;
                gbc.fill = 2;
                JPanel auxPanel = UIFactory.makeJPanel();
                auxPanel.setLayout(new GridBagLayout());
                JLabel l = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_CERTIFICATE_CHAIN_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                auxPanel.add((Component)l, gbc);
                gbc.gridwidth = -1;
                gbc.insets.left = 5;
                auxPanel.add(combo, gbc);
                l.setLabelFor(combo);
                gbc.gridwidth = 0;
                gbc.insets.left = 0;
                gbc.weightx = 1.0;
                auxPanel.add(Box.createHorizontalGlue(), gbc);
                p.add((Component)auxPanel, gbc);
                gbc.insets.top = 10;
                gbc.fill = 1;
                p.add((Component)cardPanel, gbc);
                gbc.weighty = 1.0;
                p.add(Box.createVerticalGlue(), gbc);
            }
            combo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    String selectedItem = (String)combo.getSelectedItem();
                    cl.show((Container)hmPanels.get(selectedItem), selectedItem);
                }
            });
        }
        JScrollPane scroll = new JScrollPane(p);
        scroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 175));
        return scroll;
    }

    private JComponent createSubjectComponent(X509Certificate cert) {
        Message dn = Message.raw(cert.getSubjectX500Principal().getName(), new Object[0]);
        return this.makeValueLabel(dn);
    }

    private JComponent createIssuedByComponent(X509Certificate cert) {
        Message dn = Message.raw(cert.getIssuerX500Principal().getName(), new Object[0]);
        return this.makeValueLabel(dn);
    }

    private JComponent createValidFromComponent(X509Certificate cert) {
        long t2;
        Date date = cert.getNotBefore();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        Message value = Message.raw(df.format(date), new Object[0]);
        boolean isNotValidYet = false;
        long t1 = System.currentTimeMillis();
        isNotValidYet = t1 < (t2 = date.getTime());
        JLabel c = isNotValidYet ? UIFactory.makeJLabel(UIFactory.IconType.ERROR, QuickSetupMessages.INFO_CERTIFICATE_NOT_VALID_YET.get(value), UIFactory.TextStyle.SECONDARY_FIELD_INVALID) : this.makeValueLabel(value);
        return c;
    }

    public static String getValidFrom(X509Certificate cert) {
        long t2;
        Date date = cert.getNotBefore();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        String value = df.format(date);
        boolean isNotValidYet = false;
        long t1 = System.currentTimeMillis();
        isNotValidYet = t1 < (t2 = date.getTime());
        String s = isNotValidYet ? QuickSetupMessages.INFO_CERTIFICATE_NOT_VALID_YET.get(value).toString() : value;
        return s;
    }

    private JComponent createExpiresOnComponent(X509Certificate cert) {
        long t2;
        Date date = cert.getNotAfter();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        Message value = Message.raw(df.format(date), new Object[0]);
        boolean isExpired = false;
        long t1 = System.currentTimeMillis();
        isExpired = t1 > (t2 = date.getTime());
        JLabel c = isExpired ? UIFactory.makeJLabel(UIFactory.IconType.ERROR, QuickSetupMessages.INFO_CERTIFICATE_EXPIRED.get(value), UIFactory.TextStyle.SECONDARY_FIELD_INVALID) : this.makeValueLabel(value);
        return c;
    }

    public static String getExpiresOn(X509Certificate cert) {
        long t2;
        Date date = cert.getNotAfter();
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        String value = df.format(date);
        boolean isExpired = false;
        long t1 = System.currentTimeMillis();
        isExpired = t1 > (t2 = date.getTime());
        String s = isExpired ? QuickSetupMessages.INFO_CERTIFICATE_EXPIRED.get(value).toString() : value;
        return s;
    }

    private JComponent createTypeComponent(X509Certificate cert) {
        Message type = Message.raw(cert.getType(), new Object[0]);
        return this.makeValueLabel(type);
    }

    private JComponent createSerialNumberComponent(X509Certificate cert) {
        Message serialNumber = Message.raw(String.valueOf(cert.getSerialNumber()), new Object[0]);
        return this.makeValueLabel(serialNumber);
    }

    public static Message getSignature(X509Certificate cert) {
        byte[] sig = cert.getSignature();
        MessageBuilder sb = new MessageBuilder();
        for (int i = 0; i < sig.length; ++i) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(Integer.toHexString(sig[i] & 0xFF));
        }
        return sb.toMessage();
    }

    private JComponent createSignatureComponent(X509Certificate cert) {
        return UIFactory.makeTextPane(CertificateDialog.getSignature(cert), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
    }

    private JComponent createSignatureAlgorithmComponent(X509Certificate cert) {
        Message signature = Message.raw(String.valueOf(cert.getSigAlgName()), new Object[0]);
        return this.makeValueLabel(signature);
    }

    private JComponent createVersionComponent(X509Certificate cert) {
        Message version = Message.raw(String.valueOf(cert.getVersion()), new Object[0]);
        return this.makeValueLabel(version);
    }

    private JComponent createPublicKeyComponent(X509Certificate cert) {
        return UIFactory.makeTextPane(Message.raw(cert.getPublicKey().toString(), new Object[0]), UIFactory.TextStyle.SECONDARY_FIELD_VALID);
    }

    private JLabel makeValueLabel(Message value) {
        if (value == null) {
            value = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get();
        }
        return UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, value, UIFactory.TextStyle.SECONDARY_FIELD_VALID);
    }

    private String getName(X509Certificate cert) {
        String name = cert.getSubjectX500Principal().getName();
        try {
            LdapName dn = new LdapName(name);
            Rdn rdn = dn.getRdn(0);
            name = rdn.getValue().toString();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error parsing subject dn: " + cert.getSubjectX500Principal(), t);
        }
        return name;
    }

    private void okClicked() {
        this.isAccepted = true;
        this.dispose();
    }

    private void cancelClicked() {
        this.isAccepted = false;
        this.dispose();
    }
}

