/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.LabelFieldDescriptor;
import org.opends.quicksetup.ui.ReviewPanel;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

public class InstallReviewPanel
extends ReviewPanel {
    private static final long serialVersionUID = -7356174829193265699L;
    private boolean displayServerLocation;
    private HashMap<FieldName, JLabel> hmLabels = new HashMap();
    private HashMap<FieldName, JTextComponent> hmFields = new HashMap();
    private JPanel bottomComponent;
    private JCheckBox startCheckBox;
    private JCheckBox enableWindowsServiceCheckBox;
    private JLabel warningLabel;

    public InstallReviewPanel(GuiApplication application) {
        super(application);
        this.displayServerLocation = this.isWebStart();
        this.populateLabelAndFieldsMap();
    }

    public void beginDisplay(UserData userData) {
        if (this.displayServerLocation) {
            this.setFieldValue(FieldName.SERVER_LOCATION, userData.getServerLocation());
        }
        this.setFieldValue(FieldName.HOST_NAME, String.valueOf(userData.getHostName()));
        this.setFieldValue(FieldName.SERVER_PORT, String.valueOf(userData.getServerPort()));
        this.setFieldValue(FieldName.SECURITY_OPTIONS, this.getSecurityOptionsString(userData.getSecurityOptions(), false));
        this.setFieldValue(FieldName.DIRECTORY_MANAGER_DN, userData.getDirectoryManagerDn());
        this.setFieldValue(FieldName.DATA_OPTIONS, this.getDataDisplayString(userData));
        if (userData.mustCreateAdministrator()) {
            this.setFieldValue(FieldName.GLOBAL_ADMINISTRATOR_UID, String.valueOf(userData.getGlobalAdministratorUID()));
            this.getField(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(true);
            this.getLabel(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(true);
        } else {
            this.getField(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(false);
            this.getLabel(FieldName.GLOBAL_ADMINISTRATOR_UID).setVisible(false);
        }
        if (userData.getReplicationOptions().getType() == DataReplicationOptions.Type.STANDALONE) {
            this.getField(FieldName.REPLICATION_PORT).setVisible(false);
            this.getLabel(FieldName.REPLICATION_PORT).setVisible(false);
        } else {
            this.setFieldValue(FieldName.REPLICATION_PORT, this.getReplicationPortString(userData));
            this.getField(FieldName.REPLICATION_PORT).setVisible(true);
            this.getLabel(FieldName.REPLICATION_PORT).setVisible(true);
        }
        this.checkStartWarningLabel();
    }

    public Object getFieldValue(FieldName fieldName) {
        Boolean value = null;
        if (fieldName == FieldName.SERVER_START) {
            value = this.getStartCheckBox().isSelected();
        } else if (fieldName == FieldName.ENABLE_WINDOWS_SERVICE) {
            value = this.getEnableWindowsServiceCheckBox().isSelected();
        }
        return value;
    }

    protected Message getInstructions() {
        return QuickSetupMessages.INFO_REVIEW_PANEL_INSTRUCTIONS.get();
    }

    protected Message getTitle() {
        return QuickSetupMessages.INFO_REVIEW_PANEL_TITLE.get();
    }

    private void populateLabelAndFieldsMap() {
        HashMap<FieldName, LabelFieldDescriptor> hm = new HashMap<FieldName, LabelFieldDescriptor>();
        if (this.displayServerLocation) {
            hm.put(FieldName.SERVER_LOCATION, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_LOCATION_LABEL.get(), QuickSetupMessages.INFO_SERVER_LOCATION_RELATIVE_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        }
        hm.put(FieldName.HOST_NAME, new LabelFieldDescriptor(QuickSetupMessages.INFO_HOST_NAME_LABEL.get(), QuickSetupMessages.INFO_HOST_NAME_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.SERVER_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_PORT_LABEL.get(), QuickSetupMessages.INFO_SERVER_PORT_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.SECURITY_OPTIONS, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_SECURITY_LABEL.get(), QuickSetupMessages.INFO_SERVER_SECURITY_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.DIRECTORY_MANAGER_DN, new LabelFieldDescriptor(QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_LABEL.get(), QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_TOOLTIP.get(), LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.GLOBAL_ADMINISTRATOR_UID, new LabelFieldDescriptor(QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_UID_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.DATA_OPTIONS, new LabelFieldDescriptor(QuickSetupMessages.INFO_DIRECTORY_DATA_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        hm.put(FieldName.REPLICATION_PORT, new LabelFieldDescriptor(QuickSetupMessages.INFO_REPLICATION_PORT_LABEL.get(), null, LabelFieldDescriptor.FieldType.READ_ONLY, LabelFieldDescriptor.LabelType.PRIMARY, 0));
        for (FieldName fieldName : hm.keySet()) {
            LabelFieldDescriptor desc = (LabelFieldDescriptor)hm.get((Object)fieldName);
            JTextComponent field = UIFactory.makeJTextComponent(desc, null);
            field.setOpaque(false);
            JLabel label = UIFactory.makeJLabel(desc);
            this.hmFields.put(fieldName, field);
            label.setLabelFor(field);
            this.hmLabels.put(fieldName, label);
        }
    }

    private JLabel getLabel(FieldName fieldName) {
        return this.hmLabels.get((Object)fieldName);
    }

    private JTextComponent getField(FieldName fieldName) {
        return this.hmFields.get((Object)fieldName);
    }

    private void setFieldValue(FieldName fieldName, String value) {
        this.getField(fieldName).setText(value);
    }

    private Message getDataDisplayString(UserData userInstallData) {
        Message msg;
        boolean createSuffix = false;
        DataReplicationOptions repl = userInstallData.getReplicationOptions();
        SuffixesToReplicateOptions suf = userInstallData.getSuffixesToReplicateOptions();
        boolean bl = createSuffix = repl.getType() == DataReplicationOptions.Type.FIRST_IN_TOPOLOGY || repl.getType() == DataReplicationOptions.Type.STANDALONE || suf.getType() == SuffixesToReplicateOptions.Type.NEW_SUFFIX_IN_TOPOLOGY;
        if (createSuffix) {
            Message arg2;
            NewSuffixOptions options = userInstallData.getNewSuffixOptions();
            switch (options.getType()) {
                case CREATE_BASE_ENTRY: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_CREATE_BASE_ENTRY_LABEL.get(options.getBaseDn());
                    break;
                }
                case LEAVE_DATABASE_EMPTY: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_LEAVE_DATABASE_EMPTY_LABEL.get();
                    break;
                }
                case IMPORT_FROM_LDIF_FILE: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_IMPORT_LDIF.get(options.getLDIFPath());
                    break;
                }
                case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                    arg2 = QuickSetupMessages.INFO_REVIEW_IMPORT_AUTOMATICALLY_GENERATED.get(String.valueOf(options.getNumberEntries()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknow type: " + (Object)((Object)options.getType()));
                }
            }
            msg = QuickSetupMessages.INFO_REVIEW_CREATE_SUFFIX.get(options.getBaseDn(), arg2);
        } else {
            StringBuilder buf = new StringBuilder();
            Set<SuffixDescriptor> suffixes = suf.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(suffix.getDN());
            }
            msg = QuickSetupMessages.INFO_REVIEW_REPLICATE_SUFFIX.get(buf.toString());
        }
        return msg;
    }

    private String getReplicationPortString(UserData userInstallData) {
        MessageBuilder buf = new MessageBuilder();
        DataReplicationOptions repl = userInstallData.getReplicationOptions();
        SuffixesToReplicateOptions suf = userInstallData.getSuffixesToReplicateOptions();
        Map<ServerDescriptor, Integer> remotePorts = userInstallData.getRemoteWithNoReplicationPort();
        if (repl.getType() == DataReplicationOptions.Type.IN_EXISTING_TOPOLOGY && suf.getType() == SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES && remotePorts.size() > 0) {
            buf.append(String.valueOf(userInstallData.getReplicationOptions().getReplicationPort()));
            TreeSet<Message> remoteServerLines = new TreeSet<Message>();
            for (ServerDescriptor server : remotePorts.keySet()) {
                remoteServerLines.add(QuickSetupMessages.INFO_REMOTE_SERVER_REPLICATION_PORT.get(String.valueOf(remotePorts.get(server)), server.getHostPort(true)));
            }
            for (Message line : remoteServerLines) {
                buf.append("\n").append(line);
            }
        } else {
            buf.append(userInstallData.getReplicationOptions().getReplicationPort());
        }
        return buf.toString();
    }

    protected JPanel createFieldsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        FieldName[] fieldNames = this.displayServerLocation ? new FieldName[]{FieldName.SERVER_LOCATION, FieldName.HOST_NAME, FieldName.SERVER_PORT, FieldName.SECURITY_OPTIONS, FieldName.DIRECTORY_MANAGER_DN, FieldName.GLOBAL_ADMINISTRATOR_UID, FieldName.DATA_OPTIONS, FieldName.REPLICATION_PORT} : new FieldName[]{FieldName.HOST_NAME, FieldName.SERVER_PORT, FieldName.SECURITY_OPTIONS, FieldName.DIRECTORY_MANAGER_DN, FieldName.GLOBAL_ADMINISTRATOR_UID, FieldName.DATA_OPTIONS, FieldName.REPLICATION_PORT};
        for (int i = 0; i < fieldNames.length; ++i) {
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.insets.top = i > 0 ? 10 : 0;
            gbc.insets.left = 0;
            gbc.anchor = 18;
            panel.add((Component)this.getLabel(fieldNames[i]), gbc);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets.top = i > 0 ? 10 : 0;
            gbc.insets.left = 10;
            gbc.gridwidth = 0;
            panel.add((Component)this.getField(fieldNames[i]), gbc);
        }
        return panel;
    }

    protected JComponent getBottomComponent() {
        if (this.bottomComponent == null) {
            this.bottomComponent = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            JPanel auxPanel = new JPanel(new GridBagLayout());
            gbc.gridwidth = 3;
            auxPanel.add((Component)this.getStartCheckBox(), gbc);
            gbc.insets.left = 5;
            gbc.gridwidth = -1;
            auxPanel.add((Component)this.getWarningLabel(), gbc);
            gbc.gridwidth = 0;
            gbc.insets.left = 0;
            gbc.weightx = 1.0;
            auxPanel.add(Box.createHorizontalGlue(), gbc);
            this.bottomComponent.add((Component)auxPanel, gbc);
            if (Utils.isWindows()) {
                gbc.insets.top = 10;
                this.bottomComponent.add((Component)this.getEnableWindowsServiceCheckBox(), gbc);
            }
        }
        return this.bottomComponent;
    }

    private JLabel getWarningLabel() {
        if (this.warningLabel == null) {
            this.warningLabel = UIFactory.makeJLabel(UIFactory.IconType.WARNING, QuickSetupMessages.INFO_INSTALL_SERVER_MUST_BE_TEMPORARILY_STARTED.get(), UIFactory.TextStyle.READ_ONLY);
        }
        return this.warningLabel;
    }

    private JCheckBox getStartCheckBox() {
        if (this.startCheckBox == null) {
            this.startCheckBox = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_START_SERVER_LABEL.get(), QuickSetupMessages.INFO_START_SERVER_TOOLTIP.get(), UIFactory.TextStyle.CHECKBOX);
            this.startCheckBox.setSelected(this.getApplication().getUserData().getStartServer());
            this.startCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    InstallReviewPanel.this.checkStartWarningLabel();
                }
            });
        }
        return this.startCheckBox;
    }

    private JCheckBox getEnableWindowsServiceCheckBox() {
        if (this.enableWindowsServiceCheckBox == null) {
            this.enableWindowsServiceCheckBox = UIFactory.makeJCheckBox(QuickSetupMessages.INFO_ENABLE_WINDOWS_SERVICE_LABEL.get(), QuickSetupMessages.INFO_ENABLE_WINDOWS_SERVICE_TOOLTIP.get(), UIFactory.TextStyle.CHECKBOX);
            this.enableWindowsServiceCheckBox.setSelected(this.getApplication().getUserData().getEnableWindowsService());
        }
        return this.enableWindowsServiceCheckBox;
    }

    private void checkStartWarningLabel() {
        boolean visible;
        boolean bl = visible = !this.getStartCheckBox().isSelected();
        if (visible) {
            UserData userData = this.getApplication().getUserData();
            DataReplicationOptions rep = userData.getReplicationOptions();
            visible = rep.getType() != DataReplicationOptions.Type.STANDALONE;
        }
        this.getWarningLabel().setVisible(visible);
    }
}

