/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.InstallDS;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class InstallLauncher
extends Launcher {
    public static final String LOG_FILE_PREFIX = "opends-setup-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private static final Logger LOG = Logger.getLogger(InstallLauncher.class.getName());
    private ArgumentParser argParser;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX));
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        new InstallLauncher(args).launch();
    }

    public InstallLauncher(String[] args) {
        super(args);
        String scriptName = Utils.isWindows() ? "setup.bat" : "setup";
        System.setProperty("org.opends.server.scriptName", scriptName);
        this.argParser = new ArgumentParser(this.getClass().getName(), QuickSetupMessages.INFO_SETUP_LAUNCHER_USAGE_DESCRIPTION.get(), false);
        try {
            BooleanArgument cliMode = new BooleanArgument("cli", Character.valueOf('c'), "cli", ToolMessages.INFO_INSTALLDS_DESCRIPTION_CLI.get());
            this.argParser.addArgument(cliMode);
            BooleanArgument quietInstall = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SILENT.get());
            this.argParser.addArgument(quietInstall);
            StringArgument baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "dc=example,dc=com", null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_BASEDN.get());
            this.argParser.addArgument(baseDN);
            BooleanArgument addBaseEntry = new BooleanArgument("addbase", Character.valueOf('a'), "addBaseEntry", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ADDBASE.get());
            this.argParser.addArgument(addBaseEntry);
            StringArgument importLDIF = new StringArgument("importldif", Character.valueOf('l'), "ldifFile", false, true, true, "{ldifFile}", null, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_IMPORTLDIF.get());
            this.argParser.addArgument(importLDIF);
            IntegerArgument sampleData = new IntegerArgument("sampledata", Character.valueOf('d'), "sampleData", false, false, true, "{numEntries}", 0, null, true, 0, false, 0, ToolMessages.INFO_INSTALLDS_DESCRIPTION_SAMPLE_DATA.get());
            this.argParser.addArgument(sampleData);
            IntegerArgument ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, "{port}", 389, null, true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_LDAPPORT.get());
            this.argParser.addArgument(ldapPort);
            IntegerArgument jmxPort = new IntegerArgument("jmxport", Character.valueOf('x'), "jmxPort", false, false, true, "{jmxPort}", SetupUtils.getDefaultJMXPort(), null, true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_JMXPORT.get());
            this.argParser.addArgument(jmxPort);
            BooleanArgument skipPortCheck = new BooleanArgument("skipportcheck", Character.valueOf('S'), "skipPortCheck", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SKIPPORT.get());
            this.argParser.addArgument(skipPortCheck);
            StringArgument rootDN = new StringArgument("rootdn", Character.valueOf('D'), "rootUserDN", false, true, true, "{rootUserDN}", "cn=Directory Manager", null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTDN.get());
            this.argParser.addArgument(rootDN);
            StringArgument rootPWString = new StringArgument("rootpwstring", Character.valueOf('w'), "rootUserPassword", false, false, true, "{password}", null, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTPW.get());
            this.argParser.addArgument(rootPWString);
            FileBasedArgument rootPWFile = new FileBasedArgument("rootpwfile", Character.valueOf('j'), "rootUserPasswordFile", false, false, "{bindPasswordFile}", null, null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTPWFILE.get());
            this.argParser.addArgument(rootPWFile);
            BooleanArgument enableWindowsService = new BooleanArgument("enablewindowsservice", Character.valueOf('e'), "enableWindowsService", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ENABLE_WINDOWS_SERVICE.get());
            if (SetupUtils.isWindows()) {
                this.argParser.addArgument(enableWindowsService);
            }
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_INSTALLDS_DESCRIPTION_HELP.get());
            this.argParser.addArgument(showUsage);
            this.argParser.setUsageArgument(showUsage);
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t);
            t.printStackTrace();
        }
    }

    protected void guiLaunchFailed(String logFileName) {
        if (logFileName != null) {
            System.err.println(QuickSetupMessages.INFO_SETUP_LAUNCHER_GUI_LAUNCHED_FAILED_DETAILS.get(logFileName));
        } else {
            System.err.println(QuickSetupMessages.INFO_SETUP_LAUNCHER_GUI_LAUNCHED_FAILED.get());
        }
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }

    protected void willLaunchGui() {
        System.out.println(QuickSetupMessages.INFO_SETUP_LAUNCHER_LAUNCHING_GUI.get());
        System.setProperty("org.opends.quicksetup.Application.class", "org.opends.quicksetup.installer.offline.OfflineInstaller");
    }

    protected Message getFrameTitle() {
        return QuickSetupMessages.INFO_FRAME_INSTALL_TITLE.get();
    }

    protected CliApplication createCliApplication() {
        return null;
    }

    protected int launchCli(CliApplication cliApp) {
        System.setProperty("org.opends.quicksetup.cli", "true");
        if (Utils.isWindows()) {
            System.setProperty("org.opends.server.scriptName", "setup.bat");
        } else {
            System.setProperty("org.opends.server.scriptName", "setup");
        }
        ArrayList<String> newArgList = new ArrayList<String>();
        if (this.args != null) {
            for (String arg : this.args) {
                if (arg.equalsIgnoreCase("--cli") || arg.equalsIgnoreCase("-c")) continue;
                newArgList.add(arg);
            }
        }
        newArgList.add("--configClass");
        newArgList.add("org.opends.server.extensions.ConfigFileHandler");
        newArgList.add("--configFile");
        Installation installation = Installation.getLocal();
        newArgList.add(Utils.getPath(installation.getCurrentConfigurationFile()));
        String[] newArgs = new String[newArgList.size()];
        newArgList.toArray(newArgs);
        LOG.log(Level.INFO, "Launching 'installMain' with args " + Utils.listToString(newArgList, " "));
        return InstallDS.installMain(newArgs);
    }
}

