/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.installer.AuthenticationData;
import org.opends.quicksetup.installer.DataReplicationOptions;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.SuffixesToReplicateOptions;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.SetupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserData {
    private String serverLocation;
    private String hostName;
    private int serverPort;
    private String directoryManagerDn;
    private String directoryManagerPwd;
    private String globalAdministratorUID;
    private String globalAdministratorPassword;
    private SecurityOptions securityOptions;
    private int serverJMXPort;
    private boolean startServer = true;
    private boolean stopServer;
    private boolean enableWindowsService = false;
    private NewSuffixOptions newSuffixOptions;
    private DataReplicationOptions replicationOptions;
    private boolean createAdministrator;
    private SuffixesToReplicateOptions suffixesToReplicateOptions;
    private Map<ServerDescriptor, Integer> remoteWithNoReplicationPort;
    private boolean quiet;
    private boolean interactive;
    private boolean forceOnError = true;

    public UserData() {
        NewSuffixOptions defaultNewSuffixOptions = new NewSuffixOptions(NewSuffixOptions.Type.CREATE_BASE_ENTRY, "dc=example,dc=com");
        this.setNewSuffixOptions(defaultNewSuffixOptions);
        int defaultPort = UserData.getDefaultPort();
        if (defaultPort != -1) {
            this.setServerPort(defaultPort);
        }
        this.setHostName(this.getDefaultHostName());
        this.setDirectoryManagerDn("cn=Directory Manager");
        this.setNewSuffixOptions(defaultNewSuffixOptions);
        AuthenticationData data = new AuthenticationData();
        data.setDn("cn=Directory Manager");
        data.setPort(389);
        DataReplicationOptions repl = new DataReplicationOptions(DataReplicationOptions.Type.STANDALONE, data, UserData.getDefaultReplicationPort());
        this.setReplicationOptions(repl);
        this.setGlobalAdministratorUID("admin");
        SuffixesToReplicateOptions suffixes = new SuffixesToReplicateOptions(SuffixesToReplicateOptions.Type.REPLICATE_WITH_EXISTING_SUFFIXES, new HashSet(), new HashSet());
        this.setSuffixesToReplicateOptions(suffixes);
        SecurityOptions sec = SecurityOptions.createNoCertificateOptions();
        sec.setSslPort(UserData.getDefaultSslPort());
        this.setSecurityOptions(sec);
        this.remoteWithNoReplicationPort = new HashMap<ServerDescriptor, Integer>();
    }

    public void setServerLocation(String serverLocation) {
        this.serverLocation = serverLocation;
    }

    public String getServerLocation() {
        return this.serverLocation;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerJMXPort(int serverJMXPort) {
        this.serverJMXPort = serverJMXPort;
    }

    public int getServerJMXPort() {
        return this.serverJMXPort;
    }

    public String getDirectoryManagerDn() {
        return this.directoryManagerDn;
    }

    public void setDirectoryManagerDn(String directoryManagerDn) {
        this.directoryManagerDn = directoryManagerDn;
    }

    public String getDirectoryManagerPwd() {
        return this.directoryManagerPwd;
    }

    public void setDirectoryManagerPwd(String directoryManagerPwd) {
        this.directoryManagerPwd = directoryManagerPwd;
    }

    public boolean getStartServer() {
        return this.startServer;
    }

    public void setStartServer(boolean startServer) {
        this.startServer = startServer;
    }

    public void setStopServer(boolean stopServer) {
        this.stopServer = stopServer;
    }

    public boolean getStopServer() {
        return this.stopServer;
    }

    public boolean getEnableWindowsService() {
        return this.enableWindowsService;
    }

    public void setEnableWindowsService(boolean enableWindowsService) {
        this.enableWindowsService = enableWindowsService;
    }

    public NewSuffixOptions getNewSuffixOptions() {
        return this.newSuffixOptions;
    }

    public void setNewSuffixOptions(NewSuffixOptions newSuffixOptions) {
        this.newSuffixOptions = newSuffixOptions;
    }

    public DataReplicationOptions getReplicationOptions() {
        return this.replicationOptions;
    }

    public void setReplicationOptions(DataReplicationOptions replicationOptions) {
        this.replicationOptions = replicationOptions;
    }

    public boolean mustCreateAdministrator() {
        return this.createAdministrator;
    }

    public void createAdministrator(boolean createAdministrator) {
        this.createAdministrator = createAdministrator;
    }

    public String getGlobalAdministratorUID() {
        return this.globalAdministratorUID;
    }

    public void setGlobalAdministratorUID(String globalAdministratorUID) {
        this.globalAdministratorUID = globalAdministratorUID;
    }

    public String getGlobalAdministratorPassword() {
        return this.globalAdministratorPassword;
    }

    public void setGlobalAdministratorPassword(String globalAdministratorPwd) {
        this.globalAdministratorPassword = globalAdministratorPwd;
    }

    public void setSuffixesToReplicateOptions(SuffixesToReplicateOptions suffixesToReplicateOptions) {
        this.suffixesToReplicateOptions = suffixesToReplicateOptions;
    }

    public SuffixesToReplicateOptions getSuffixesToReplicateOptions() {
        return this.suffixesToReplicateOptions;
    }

    public SecurityOptions getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(SecurityOptions securityOptions) {
        this.securityOptions = securityOptions;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setForceOnError(boolean forceOnError) {
        this.forceOnError = forceOnError;
    }

    public boolean isForceOnError() {
        return this.forceOnError;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean isInteractive() {
        return !this.quiet && this.interactive;
    }

    public static int getDefaultPort() {
        int defaultPort = -1;
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            int port = i + 389;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    static int getDefaultSslPort() {
        int defaultPort = -1;
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            int port = i + 636;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    public static int getDefaultJMXPort(int[] forbiddenPorts) {
        int defaultJMXPort = -1;
        for (int i = 0; i < 65000 && defaultJMXPort == -1; i += 1000) {
            int port = i + SetupUtils.getDefaultJMXPort();
            boolean isForbidden = false;
            if (forbiddenPorts != null) {
                for (int j = 0; j < forbiddenPorts.length && !isForbidden; ++j) {
                    isForbidden = forbiddenPorts[j] == port;
                }
            }
            if (isForbidden || !Utils.canUseAsPort(port)) continue;
            defaultJMXPort = port;
        }
        return defaultJMXPort;
    }

    static int getDefaultReplicationPort() {
        int defaultPort = -1;
        for (int i = 0; i < 10000 && defaultPort == -1; i += 1000) {
            int port = i + 8989;
            if (!Utils.canUseAsPort(port)) continue;
            defaultPort = port;
        }
        return defaultPort;
    }

    private String getDefaultHostName() {
        String name = "";
        try {
            name = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return name;
    }

    public Map<ServerDescriptor, Integer> getRemoteWithNoReplicationPort() {
        HashMap<ServerDescriptor, Integer> copy = new HashMap<ServerDescriptor, Integer>();
        copy.putAll(this.remoteWithNoReplicationPort);
        return copy;
    }

    public void setRemoteWithNoReplicationPort(Map<ServerDescriptor, Integer> remoteWithNoReplicationPort) {
        this.remoteWithNoReplicationPort.clear();
        this.remoteWithNoReplicationPort.putAll(remoteWithNoReplicationPort);
    }
}

