/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.util.HashSet;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.util.ProgressMessageFormatter;

public class ProgressUpdateListenerDelegate {
    private HashSet<ProgressUpdateListener> listeners = new HashSet();
    private ProgressMessageFormatter formatter;

    public ProgressUpdateListenerDelegate(ProgressMessageFormatter formatter) {
        this.formatter = formatter;
    }

    public void addProgressUpdateListener(ProgressUpdateListener l) {
        this.listeners.add(l);
    }

    public void removeProgressUpdateListener(ProgressUpdateListener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners(ProgressStep current, Integer ratio, Message currentPhaseSummary, Message newLogDetail) {
        ProgressUpdateEvent ev = new ProgressUpdateEvent(current, ratio, currentPhaseSummary, newLogDetail);
        for (ProgressUpdateListener l : this.listeners) {
            l.progressUpdate(ev);
        }
    }

    public void notifyListenersOfLog() {
        File logFile = QuickSetupLog.getLogFile();
        if (logFile != null) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(this.formatter.getFormattedProgress(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath())));
            mb.append(this.formatter.getLineBreak());
            this.notifyListeners(mb.toMessage());
        }
    }

    protected void notifyListeners(Message msg) {
        this.notifyListeners(null, null, null, msg);
    }
}

