/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.Status;
import org.opends.quicksetup.util.Utils;

public class Installation {
    public static final String[] OPEN_DS_JAR_RELATIVE_PATHS = new String[]{"lib/quicksetup.jar", "lib/OpenDS.jar", "lib/je.jar"};
    public static final String WINDOWS_BINARIES_PATH_RELATIVE = "bat";
    public static final String UNIX_BINARIES_PATH_RELATIVE = "bin";
    public static final String LIBRARIES_PATH_RELATIVE = "lib";
    public static final String DATABASES_PATH_RELATIVE = "db";
    public static final String LOGS_PATH_RELATIVE = "logs";
    public static final String LDIFS_PATH_RELATIVE = "ldif";
    public static final String BACKUPS_PATH_RELATIVE = "bak";
    public static final String CONFIG_PATH_RELATIVE = "config";
    public static final String HISTORY_PATH_RELATIVE = "history";
    public static final String UPGRADE_PATH = "upgrade";
    public static final String CHANGELOG_PATH_RELATIVE = "changelogDb";
    public static final String LOCKS_PATH_RELATIVE = "locks";
    public static final String TMP_PATH_RELATIVE = "tmp";
    public static final String CURRENT_CONFIG_FILE_NAME = "config.ldif";
    public static final String BASE_CONFIG_FILE_PREFIX = "config.ldif.";
    public static final String UNIX_SETUP_FILE_NAME = "setup";
    public static final String WINDOWS_SETUP_FILE_NAME = "setup.bat";
    public static final String UNIX_UNINSTALL_FILE_NAME = "uninstall";
    public static final String WINDOWS_UNINSTALL_FILE_NAME = "uninstall.bat";
    public static final String UNIX_UNINSTALL_GUI_FILE_NAME = "uninstall-gui";
    public static final String WINDOWS_UNINSTALL_GUI_FILE_NAME = "uninstall-gui.bat";
    public static final String UNIX_UPGRADE_FILE_NAME = "upgrade";
    public static final String WINDOWS_UPGRADE_FILE_NAME = "upgrade.bat";
    public static final String UNIX_REVERT_FILE_NAME = "revert";
    public static final String WINDOWS_REVERT_FILE_NAME = "revert.bat";
    public static final String UNIX_START_FILE_NAME = "start-ds";
    public static final String WINDOWS_START_FILE_NAME = "start-ds.bat";
    public static final String UNIX_STOP_FILE_NAME = "stop-ds";
    public static final String WINDOWS_STOP_FILE_NAME = "stop-ds.bat";
    public static final String UNIX_STATUSPANEL_FILE_NAME = "status-panel";
    public static final String WINDOWS_STATUSPANEL_FILE_NAME = "status-panel.bat";
    public static final String UNIX_STATUSCLI_FILE_NAME = "status";
    public static final String WINDOWS_STATUSCLI_FILE_NAME = "status.bat";
    public static final String HISTORY_LOG_FILE_NAME = "log";
    public static final String HISTORY_BACKUP_FILES_DIR_NAME = "files";
    public static final String BACKUP = "backup";
    public static final String LDIF_DIFF = "ldif-diff";
    public static final String[] REQUIRED_DIRECTORIES = new String[]{"config", "db", "lib"};
    private static Installation local;
    private static final Logger LOG;
    private File rootDirectory;
    private Status status;
    private Configuration configuration;
    private Configuration baseConfiguration;
    private BuildInformation buildInformation;

    public static void validateRootDirectory(File rootDirectory) throws IllegalArgumentException {
        Message failureReason = null;
        if (rootDirectory == null) {
            failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NULL.get();
        } else if (!rootDirectory.exists()) {
            failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NO_EXIST.get(Utils.getPath(rootDirectory));
        } else if (!rootDirectory.isDirectory()) {
            failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NOT_DIR.get(Utils.getPath(rootDirectory));
        } else {
            String[] children = rootDirectory.list();
            if (children != null) {
                HashSet<String> childrenSet = new HashSet<String>(Arrays.asList(children));
                for (String dir : REQUIRED_DIRECTORIES) {
                    if (childrenSet.contains(dir)) continue;
                    failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_NO_DIR.get(Utils.getPath(rootDirectory), dir);
                }
            } else {
                failureReason = QuickSetupMessages.INFO_ERROR_INSTALL_ROOT_DIR_EMPTY.get(Utils.getPath(rootDirectory));
            }
        }
        if (failureReason != null) {
            throw new IllegalArgumentException(failureReason.toString());
        }
    }

    public static Installation getLocal() {
        if (local == null) {
            String installRoot = System.getProperty("org.opends.quicksetup.Root");
            if (installRoot == null) {
                installRoot = Utils.getInstallPathFromClasspath();
            }
            local = new Installation(installRoot);
        }
        return local;
    }

    public Installation(String rootDirectory) {
        this(new File(rootDirectory));
    }

    public Installation(File rootDirectory) {
        this.setRootDirectory(rootDirectory);
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        if (this.isValid()) {
            try {
                BuildInformation bi = this.getBuildInformation();
                LOG.log(Level.INFO, "build info for " + rootDirectory.getName() + ": " + bi);
            }
            catch (ApplicationException e) {
                LOG.log(Level.INFO, "error determining build information", e);
            }
        }
    }

    public boolean isValid() {
        boolean valid = true;
        try {
            Installation.validateRootDirectory(this.rootDirectory);
        }
        catch (IllegalArgumentException e) {
            valid = false;
        }
        return valid;
    }

    public String getInvalidityReason() {
        String reason = null;
        try {
            Installation.validateRootDirectory(this.rootDirectory);
        }
        catch (IllegalArgumentException e) {
            reason = e.getLocalizedMessage();
        }
        return reason;
    }

    public Configuration getCurrentConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration(this, this.getCurrentConfigurationFile());
        }
        return this.configuration;
    }

    public Configuration getBaseConfiguration() throws ApplicationException {
        if (this.baseConfiguration == null) {
            this.baseConfiguration = new Configuration(this, this.getBaseConfigurationFile());
        }
        return this.baseConfiguration;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status(this);
        }
        return this.status;
    }

    public File getLibrariesDirectory() {
        return new File(this.getRootDirectory(), LIBRARIES_PATH_RELATIVE);
    }

    public File getSchemaConcatFile() {
        return new File(this.getConfigurationUpgradeDirectory(), "schema.ldif.current");
    }

    public File getBaseSchemaFile() throws ApplicationException {
        return new File(this.getConfigurationUpgradeDirectory(), "schema.ldif." + this.getSvnRev().toString());
    }

    public File getBaseConfigurationFile() throws ApplicationException {
        return new File(this.getConfigurationUpgradeDirectory(), BASE_CONFIG_FILE_PREFIX + this.getSvnRev().toString());
    }

    public Integer getSvnRev() throws ApplicationException {
        BuildInformation bi = this.getBuildInformation();
        return bi.getRevisionNumber();
    }

    public File getCurrentConfigurationFile() {
        return new File(this.getConfigurationDirectory(), CURRENT_CONFIG_FILE_NAME);
    }

    public File getBinariesDirectory() {
        File binPath = Utils.isWindows() ? new File(this.getRootDirectory(), WINDOWS_BINARIES_PATH_RELATIVE) : new File(this.getRootDirectory(), UNIX_BINARIES_PATH_RELATIVE);
        return binPath;
    }

    public File getDatabasesDirectory() {
        return new File(this.getRootDirectory(), DATABASES_PATH_RELATIVE);
    }

    public File getBackupDirectory() {
        return new File(this.getRootDirectory(), BACKUPS_PATH_RELATIVE);
    }

    public File getConfigurationDirectory() {
        return new File(this.getRootDirectory(), CONFIG_PATH_RELATIVE);
    }

    public File getLogsDirectory() {
        return new File(this.getRootDirectory(), LOGS_PATH_RELATIVE);
    }

    public File getLocksDirectory() {
        return new File(this.getRootDirectory(), LOCKS_PATH_RELATIVE);
    }

    public File getTemporaryDirectory() {
        return new File(this.getRootDirectory(), TMP_PATH_RELATIVE);
    }

    public File getHistoryDirectory() {
        return new File(this.getRootDirectory(), HISTORY_PATH_RELATIVE);
    }

    public File createHistoryBackupDirectory() throws IOException {
        File backupDirectory = new File(this.getHistoryDirectory(), Long.toString(System.currentTimeMillis()));
        if (backupDirectory.exists()) {
            backupDirectory.delete();
        }
        if (!backupDirectory.mkdirs()) {
            throw new IOException("failed to create history backup directory");
        }
        return backupDirectory;
    }

    public File getHistoryLogFile() {
        return new File(this.getHistoryDirectory(), HISTORY_LOG_FILE_NAME);
    }

    public File getConfigurationUpgradeDirectory() {
        return new File(this.getConfigurationDirectory(), "upgrade");
    }

    public File getTemporaryUpgradeDirectory() {
        return new File(this.getTemporaryDirectory(), "upgrade");
    }

    public File getCommandFile(String command) {
        File commandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), command + ".bat") : new File(this.getBinariesDirectory(), command);
        return commandFile;
    }

    public File getServerStartCommandFile() {
        File startCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_START_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_START_FILE_NAME);
        return startCommandFile;
    }

    public File getServerStopCommandFile() {
        File stopCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_STOP_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_STOP_FILE_NAME);
        return stopCommandFile;
    }

    public File getLdifDirectory() {
        return new File(this.getRootDirectory(), LDIFS_PATH_RELATIVE);
    }

    public File getQuicksetupJarFile() {
        return new File(this.getLibrariesDirectory(), "quicksetup.jar");
    }

    public File getOpenDSJarFile() {
        return new File(this.getLibrariesDirectory(), "OpenDS.jar");
    }

    public File getUninstallBatFile() {
        return new File(this.getRootDirectory(), WINDOWS_UNINSTALL_FILE_NAME);
    }

    public File getStatusPanelCommandFile() {
        File statusPanelCommandFile = Utils.isWindows() ? new File(this.getBinariesDirectory(), WINDOWS_STATUSPANEL_FILE_NAME) : new File(this.getBinariesDirectory(), UNIX_STATUSPANEL_FILE_NAME);
        return statusPanelCommandFile;
    }

    public BuildInformation getBuildInformation() throws ApplicationException {
        return this.getBuildInformation(true);
    }

    public BuildInformation getBuildInformation(boolean useCachedVersion) throws ApplicationException {
        if (this.buildInformation == null || !useCachedVersion) {
            FutureTask<BuildInformation> ft = new FutureTask<BuildInformation>(new Callable<BuildInformation>(){

                @Override
                public BuildInformation call() throws ApplicationException {
                    return BuildInformation.create(Installation.this);
                }
            });
            new Thread(ft).start();
            try {
                this.buildInformation = ft.get();
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "interrupted trying to get build information", e);
            }
            catch (ExecutionException e) {
                throw (ApplicationException)e.getCause();
            }
        }
        return this.buildInformation;
    }

    public String toString() {
        return Utils.getPath(this.rootDirectory);
    }

    static {
        LOG = Logger.getLogger(Installation.class.getName());
    }
}

