/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.quicksetup.CliApplicationHelper;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.StaticUtils;

public class CliUserInteraction
extends CliApplicationHelper
implements UserInteraction {
    private PrintStream out;
    private PrintStream err;
    private InputStream in;

    public CliUserInteraction() {
        this.out = System.out;
        this.err = System.err;
        this.in = System.in;
    }

    public CliUserInteraction(PrintStream out, PrintStream err, InputStream in) {
        this.out = out;
        this.err = err;
        this.in = in;
    }

    public Object confirm(Message summary, Message details, Message title, UserInteraction.MessageType type, Message[] options, Message def) {
        return this.confirm(summary, details, null, title, type, options, def, null);
    }

    public Object confirm(Message summary, Message details, Message fineDetails, Message title, UserInteraction.MessageType type, Message[] options, Message def, Message viewDetailsOption) {
        ArrayList<String> sOptions = new ArrayList<String>();
        int defInt = -1;
        for (int i = 0; i < options.length; ++i) {
            sOptions.add(this.createOption(i + 1, options[i].toString()));
            if (!options[i].equals(def)) continue;
            defInt = i + 1;
        }
        if (fineDetails != null) {
            sOptions.add(this.createOption(options.length + 1, viewDetailsOption != null ? viewDetailsOption.toString() : "View Details"));
        }
        this.println(String.valueOf(summary));
        this.println();
        this.println(String.valueOf(details));
        Message returnValue = null;
        while (returnValue == null) {
            this.println();
            for (String o : sOptions) {
                this.println(o);
            }
            System.out.print(Message.raw("%s%n[%s]:", "Enter a number or press Enter to accept the default", Integer.toString(defInt)));
            System.out.flush();
            String response = this.readLine(this.in, this.err);
            int respInt = -1;
            if (response.equals("")) {
                respInt = defInt;
            } else {
                try {
                    respInt = Integer.parseInt(response);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (fineDetails != null && respInt == options.length + 1) {
                this.println(String.valueOf(fineDetails));
                continue;
            }
            if (respInt > 0 && respInt <= options.length) {
                returnValue = options[respInt - 1];
                continue;
            }
            this.println("Illegal response " + response);
        }
        return returnValue;
    }

    public String createUnorderedList(List list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (Object o : list) {
                sb.append("\u2022 ");
                sb.append(o.toString());
                sb.append(Constants.LINE_SEPARATOR);
            }
        }
        return sb.toString();
    }

    private String createOption(int index, String option) {
        return Integer.toString(index) + ". " + option;
    }

    private void println() {
        this.out.println();
    }

    private void println(String text) {
        text = Utils.convertHtmlBreakToLineSeparator(text);
        text = Utils.stripHtml(text);
        text = StaticUtils.wrapText(text, Utils.getCommandLineMaxLineWidth());
        this.out.println(text);
    }
}

