/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ServerLoader;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.BuildInformation;
import org.opends.quicksetup.CliUserInteraction;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.HistoricalLog;
import org.opends.quicksetup.HistoricalRecord;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ProgressUpdateListenerDelegate;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.event.ProgressNotifier;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;

public abstract class Application
implements ProgressNotifier,
Runnable {
    private static final Logger LOG = Logger.getLogger(Application.class.getName());
    protected CurrentInstallStatus installStatus;
    private UserData userData;
    private Installation installation;
    private ServerController serverController;
    private ApplicationTrustManager trustManager;
    protected ProgressMessageFormatter formatter;
    protected ProgressUpdateListenerDelegate listenerDelegate;

    public static GuiApplication create() throws RuntimeException {
        GuiApplication app;
        String appClassName = System.getProperty("org.opends.quicksetup.Application.class");
        if (appClassName != null) {
            Class<?> appClass = null;
            try {
                appClass = Class.forName(appClassName);
                app = (GuiApplication)appClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.INFO, "error creating quicksetup application", e);
                String msg = "Application class " + appClass + " not found";
                throw new RuntimeException(msg, e);
            }
            catch (IllegalAccessException e) {
                LOG.log(Level.INFO, "error creating quicksetup application", e);
                String msg = "Could not access class " + appClass;
                throw new RuntimeException(msg, e);
            }
            catch (InstantiationException e) {
                LOG.log(Level.INFO, "error creating quicksetup application", e);
                String msg = "Error instantiating class " + appClass;
                throw new RuntimeException(msg, e);
            }
            catch (ClassCastException e) {
                String msg = "The class indicated by the system property 'org.opends.quicksetup.Application.class' must  must be of type Application";
                throw new RuntimeException(msg, e);
            }
        } else {
            String msg = "System property 'org.opends.quicksetup.Application.class' must specify class quicksetup application";
            throw new RuntimeException(msg);
        }
        return app;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public UserData createUserData() {
        return new UserData();
    }

    public void addProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.addProgressUpdateListener(l);
    }

    public void removeProgressUpdateListener(ProgressUpdateListener l) {
        this.listenerDelegate.removeProgressUpdateListener(l);
    }

    public Installation getInstallation() {
        String installPath;
        if (this.installation == null && (installPath = this.getInstallationPath()) != null) {
            this.installation = new Installation(installPath);
        }
        return this.installation;
    }

    public void setInstallation(Installation installation) {
        this.installation = installation;
    }

    public ServerController getServerController() {
        if (this.serverController == null) {
            this.serverController = new ServerController(this);
        }
        return this.serverController;
    }

    public UserData getUserData() {
        if (this.userData == null) {
            this.userData = this.createUserData();
        }
        return this.userData;
    }

    public void notifyListenersDone(Integer ratioWhenCompleted) {
        this.notifyListeners(ratioWhenCompleted, this.getSummary(this.getCurrentProgressStep()), this.getFormattedDoneWithLineBreak());
    }

    public void notifyListeners(Integer ratio, Message currentPhaseSummary, Message newLogDetail) {
        this.listenerDelegate.notifyListeners(this.getCurrentProgressStep(), ratio, currentPhaseSummary, newLogDetail);
    }

    public void notifyListeners(Integer ratio, Message currentPhaseSummary) {
        this.notifyListeners(ratio, this.getSummary(this.getCurrentProgressStep()), this.formatter.getFormattedWithPoints(currentPhaseSummary));
    }

    public void setProgressMessageFormatter(ProgressMessageFormatter formatter) {
        this.formatter = formatter;
        this.listenerDelegate = new ProgressUpdateListenerDelegate(formatter);
    }

    public ProgressMessageFormatter getProgressMessageFormatter() {
        return this.formatter;
    }

    protected Message getFormattedSummary(Message text) {
        return this.formatter.getFormattedSummary(text);
    }

    protected Message getFormattedErrorWithLineBreak() {
        return new MessageBuilder(this.formatter.getFormattedError()).append(this.formatter.getLineBreak()).toMessage();
    }

    protected Message getFormattedError(Message text) {
        return this.formatter.getFormattedError(text, false);
    }

    protected Message getFormattedErrorWithLineBreak(Message m, boolean b) {
        return new MessageBuilder(this.formatter.getFormattedError(m, b)).append(this.formatter.getLineBreak()).toMessage();
    }

    protected Message getFormattedErrorWithLineBreak(Throwable t, boolean b) {
        return new MessageBuilder(this.formatter.getFormattedError(t, b)).append(this.formatter.getLineBreak()).toMessage();
    }

    public Message getFormattedWarning(Message text) {
        return this.formatter.getFormattedWarning(text, false);
    }

    protected Message getFormattedSuccess(Message text) {
        return this.formatter.getFormattedSuccess(text);
    }

    public Message getFormattedLogError(Message text) {
        return this.formatter.getFormattedLogError(text);
    }

    public Message getFormattedLog(Message text) {
        return this.formatter.getFormattedLog(text);
    }

    public Message getFormattedDone() {
        return Message.raw(this.formatter.getFormattedDone(), new Object[0]);
    }

    public Message getFormattedDoneWithLineBreak() {
        return new MessageBuilder(this.formatter.getFormattedDone()).append(this.formatter.getLineBreak()).toMessage();
    }

    public Message getFormattedWithPoints(Message text) {
        return this.formatter.getFormattedWithPoints(text);
    }

    public Message getFormattedProgress(Message text) {
        return this.formatter.getFormattedProgress(text);
    }

    public Message getFormattedProgressWithLineBreak(Message text) {
        return new MessageBuilder(this.formatter.getFormattedProgress(text)).append(this.getLineBreak()).toMessage();
    }

    protected Message getFormattedError(Throwable t, boolean applyMargin) {
        return this.formatter.getFormattedError(t, applyMargin);
    }

    protected Message getFormattedError(Message m, boolean applyMargin) {
        return this.formatter.getFormattedError(m, applyMargin);
    }

    public Message getLineBreak() {
        return this.formatter.getLineBreak();
    }

    protected Message getTaskSeparator() {
        return this.formatter.getTaskSeparator();
    }

    public void notifyListeners(Message newLogDetail) {
        Integer ratio = this.getRatio(this.getCurrentProgressStep());
        Message currentPhaseSummary = this.getSummary(this.getCurrentProgressStep());
        this.notifyListeners(ratio, currentPhaseSummary, newLogDetail);
    }

    public abstract String getInstallationPath();

    public abstract ProgressStep getCurrentProgressStep();

    public abstract Integer getRatio(ProgressStep var1);

    public abstract Message getSummary(ProgressStep var1);

    public void setCurrentInstallStatus(CurrentInstallStatus installStatus) {
        this.installStatus = installStatus;
    }

    public abstract boolean isFinished();

    protected ApplicationTrustManager getTrustManager() {
        if (this.trustManager == null) {
            this.trustManager = new ApplicationTrustManager(null);
        }
        return this.trustManager;
    }

    public abstract boolean isCancellable();

    public abstract void cancel();

    public UserInteraction userInteraction() {
        CliUserInteraction ui = null;
        if (!this.getUserData().isQuiet()) {
            ui = new CliUserInteraction();
        }
        return ui;
    }

    protected void notifyListenersOfLog() {
        File logFile = QuickSetupLog.getLogFile();
        if (logFile != null) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath()));
            mb.append(this.formatter.getLineBreak());
            this.notifyListeners(mb.toMessage());
        }
    }

    protected Long writeInitialHistoricalRecord(BuildInformation fromVersion, BuildInformation toVersion) throws ApplicationException {
        Long id;
        try {
            HistoricalLog log = new HistoricalLog(this.getInstallation().getHistoryLogFile());
            id = log.append(fromVersion, toVersion, HistoricalRecord.Status.STARTED, "log file '" + QuickSetupLog.getLogFile().getPath() + "'");
        }
        catch (IOException e) {
            Message msg = QuickSetupMessages.INFO_ERROR_LOGGING_OPERATION.get();
            throw ApplicationException.createFileSystemException(msg, e);
        }
        return id;
    }

    protected void writeHistoricalRecord(Long id, BuildInformation from, BuildInformation to, HistoricalRecord.Status status, String note) throws ApplicationException {
        try {
            HistoricalLog log = new HistoricalLog(this.getInstallation().getHistoryLogFile());
            log.append(id, from, to, status, note);
        }
        catch (IOException e) {
            Message msg = QuickSetupMessages.INFO_ERROR_LOGGING_OPERATION.get();
            throw ApplicationException.createFileSystemException(msg, e);
        }
    }

    protected String getStringRepresentation(TopologyCacheException e) {
        return Utils.getStringRepresentation(e);
    }

    protected InitialLdapContext getRemoteConnection(ServerDescriptor server, String dn, String pwd, ApplicationTrustManager trustManager) throws ApplicationException {
        Map<ADSContext.ServerProperty, Object> adsProperties = server.getAdsProperties();
        ServerLoader loader = new ServerLoader(adsProperties, dn, pwd, trustManager);
        InitialLdapContext ctx = null;
        try {
            ctx = loader.createContext();
        }
        catch (NamingException ne) {
            Message errorMessage = QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(server.getHostPort(true), ne.toString(true));
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, errorMessage, ne);
        }
        return ctx;
    }

    protected abstract class ApplicationPrintStream
    extends PrintStream {
        private boolean isFirstLine;

        protected abstract Message formatString(String var1);

        public ApplicationPrintStream() {
            super(new ByteArrayOutputStream(), true);
            this.isFirstLine = true;
        }

        public void println(String msg) {
            MessageBuilder mb = new MessageBuilder();
            if (this.isFirstLine) {
                mb.append(this.formatString(msg));
            } else {
                mb.append(Application.this.formatter.getLineBreak());
                mb.append(this.formatString(msg));
            }
            Application.this.notifyListeners(mb.toMessage());
            this.isFirstLine = false;
        }

        public void write(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException("b is null");
            }
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("len + off are bigger than the length of the byte array");
            }
            this.println(new String(b, off, len));
        }
    }

    protected class OutputPrintStream
    extends ApplicationPrintStream {
        protected Message formatString(String s) {
            return Application.this.getFormattedLog(Message.raw(s, new Object[0]));
        }
    }

    protected class ErrorPrintStream
    extends ApplicationPrintStream {
        protected Message formatString(String s) {
            return Application.this.getFormattedLogError(Message.raw(s, new Object[0]));
        }
    }
}

