/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.uninstaller.UninstallCliHelper;
import org.opends.guitools.uninstaller.UninstallData;
import org.opends.guitools.uninstaller.UninstallProgressStep;
import org.opends.guitools.uninstaller.UninstallUserData;
import org.opends.guitools.uninstaller.UninstallerArgumentParser;
import org.opends.guitools.uninstaller.ui.ConfirmUninstallPanel;
import org.opends.guitools.uninstaller.ui.LoginDialog;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.ApplicationReturnCode;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.FinishedPanel;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.ProgressDialog;
import org.opends.quicksetup.ui.ProgressPanel;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.MultimasterDomainCfgClient;
import org.opends.server.admin.std.client.MultimasterSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.ConfigureWindowsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uninstaller
extends GuiApplication
implements CliApplication {
    private ProgressStep status = UninstallProgressStep.NOT_STARTED;
    private boolean runStarted;
    private boolean errorOnRemoteOccurred;
    private HashMap<ProgressStep, Integer> hmRatio = new HashMap();
    private HashMap<ProgressStep, Message> hmSummary = new HashMap();
    private ApplicationException ue;
    private Boolean isWindowsServiceEnabled;
    private UninstallCliHelper cliHelper = new UninstallCliHelper();
    private static final Logger LOG = Logger.getLogger(Uninstaller.class.getName());
    private LoginDialog loginDialog;
    private ProgressDialog startProgressDlg;
    private MessageBuilder startProgressDetails = new MessageBuilder();
    private UninstallData conf;
    private String replicationServerHostPort;

    public Uninstaller() {
        DirectoryServer.bootstrapClient();
        try {
            ClassLoaderProvider.getInstance().enable();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error enabling admin framework class loader: " + t, t);
        }
        ClassPropertyDefinition.setAllowClassValidation(false);
        AttributeTypePropertyDefinition.setCheckSchema(false);
    }

    @Override
    public Message getFrameTitle() {
        return AdminToolMessages.INFO_FRAME_UNINSTALL_TITLE.get();
    }

    @Override
    public UserData createUserData() {
        return new UninstallUserData();
    }

    @Override
    public WizardStep getFirstWizardStep() {
        return Step.CONFIRM_UNINSTALL;
    }

    @Override
    public WizardStep getNextWizardStep(WizardStep step) {
        Step nextStep = null;
        if (step != null && step.equals(Step.CONFIRM_UNINSTALL)) {
            nextStep = Step.PROGRESS;
        } else if (Step.PROGRESS.equals(step)) {
            nextStep = Step.FINISHED;
        }
        return nextStep;
    }

    @Override
    public WizardStep getPreviousWizardStep(WizardStep step) {
        Step prevStep = null;
        if (step != null && step.equals(Step.PROGRESS)) {
            prevStep = Step.CONFIRM_UNINSTALL;
        } else if (Step.FINISHED.equals(step)) {
            prevStep = Step.PROGRESS;
        }
        return prevStep;
    }

    @Override
    public WizardStep getFinishedStep() {
        return Step.FINISHED;
    }

    @Override
    public boolean finishOnLeft() {
        return false;
    }

    @Override
    public boolean canGoBack(WizardStep step) {
        return false;
    }

    @Override
    public boolean canGoForward(WizardStep step) {
        return false;
    }

    @Override
    public boolean canFinish(WizardStep step) {
        return step == Step.CONFIRM_UNINSTALL;
    }

    @Override
    public boolean canQuit(WizardStep step) {
        return step == Step.CONFIRM_UNINSTALL;
    }

    @Override
    public void nextClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on next from progress step");
        }
        if (cStep == Step.REVIEW) {
            throw new IllegalStateException("Cannot click on next from review step");
        }
        if (cStep == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on next from finished step");
        }
    }

    @Override
    public void closeClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            if (this.isFinished() || qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_CLOSE_UNINSTALL_MSG.get(), AdminToolMessages.INFO_CONFIRM_CLOSE_UNINSTALL_TITLE.get())) {
                qs.quit();
            }
        } else if (cStep == Step.FINISHED) {
            qs.quit();
        } else {
            throw new IllegalStateException("Close only can be clicked on PROGRESS step");
        }
    }

    private void updateUserUninstallDataForConfirmUninstallPanel(QuickSetup qs) throws UserDataException {
        UninstallUserData uud = this.getUninstallUserData();
        uud.setRemoveLibrariesAndTools((Boolean)qs.getFieldValue(FieldName.REMOVE_LIBRARIES_AND_TOOLS));
        uud.setRemoveDatabases((Boolean)qs.getFieldValue(FieldName.REMOVE_DATABASES));
        uud.setRemoveConfigurationAndSchema((Boolean)qs.getFieldValue(FieldName.REMOVE_CONFIGURATION_AND_SCHEMA));
        uud.setRemoveBackups((Boolean)qs.getFieldValue(FieldName.REMOVE_BACKUPS));
        uud.setRemoveLDIFs((Boolean)qs.getFieldValue(FieldName.REMOVE_LDIFS));
        uud.setRemoveLogs((Boolean)qs.getFieldValue(FieldName.REMOVE_LOGS));
        uud.setUpdateRemoteReplication(false);
        HashSet<String> dbs = new HashSet<String>();
        Set s = (Set)qs.getFieldValue(FieldName.EXTERNAL_DB_DIRECTORIES);
        for (Object v : s) {
            dbs.add((String)v);
        }
        HashSet<String> logs = new HashSet<String>();
        s = (Set)qs.getFieldValue(FieldName.EXTERNAL_LOG_FILES);
        for (Object v : s) {
            logs.add((String)v);
        }
        uud.setExternalDbsToRemove(dbs);
        uud.setExternalLogsToRemove(logs);
        if (!(dbs.size() != 0 || logs.size() != 0 || uud.getRemoveLibrariesAndTools() || uud.getRemoveDatabases() || uud.getRemoveConfigurationAndSchema() || uud.getRemoveBackups() || uud.getRemoveLDIFs() || uud.getRemoveLogs())) {
            throw new UserDataException(Step.CONFIRM_UNINSTALL, AdminToolMessages.INFO_NOTHING_SELECTED_TO_UNINSTALL.get());
        }
    }

    @Override
    public void quitClicked(WizardStep step, QuickSetup qs) {
        if (step == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on quit from progress step");
        }
        if (step == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on quit from finished step");
        }
        qs.quit();
    }

    @Override
    public Message getCloseButtonToolTip() {
        return AdminToolMessages.INFO_CLOSE_BUTTON_UNINSTALL_TOOLTIP.get();
    }

    @Override
    public Message getFinishButtonToolTip() {
        return AdminToolMessages.INFO_FINISH_BUTTON_UNINSTALL_TOOLTIP.get();
    }

    @Override
    public Message getFinishButtonLabel() {
        return AdminToolMessages.INFO_FINISH_BUTTON_UNINSTALL_LABEL.get();
    }

    @Override
    public void previousClicked(WizardStep cStep, QuickSetup qs) {
        if (cStep == Step.PROGRESS) {
            throw new IllegalStateException("Cannot click on previous from progress step");
        }
        if (cStep == Step.FINISHED) {
            throw new IllegalStateException("Cannot click on previous from finished step");
        }
    }

    @Override
    public void notifyListeners(Integer ratio, Message currentPhaseSummary, final Message newLogDetail) {
        if (this.runStarted) {
            super.notifyListeners(ratio, currentPhaseSummary, newLogDetail);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (Uninstaller.this.startProgressDlg != null && newLogDetail != null) {
                        Uninstaller.this.startProgressDetails.append(newLogDetail);
                        Uninstaller.this.startProgressDlg.setDetails(Uninstaller.this.startProgressDetails.toMessage());
                    }
                }
            });
        }
    }

    @Override
    public boolean finishClicked(WizardStep cStep, final QuickSetup qs) {
        if (cStep == Step.CONFIRM_UNINSTALL) {
            BackgroundTask worker = new BackgroundTask(){

                public Object processBackgroundTask() throws UserDataException {
                    try {
                        Uninstaller.this.updateUserUninstallDataForConfirmUninstallPanel(qs);
                        return new UninstallData(Installation.getLocal());
                    }
                    catch (UserDataException uude) {
                        throw uude;
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Error processing task: " + t, t);
                        throw new UserDataException(Step.CONFIRM_UNINSTALL, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
                    }
                }

                public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
                    qs.getDialog().workerFinished();
                    if (throwable != null) {
                        if (throwable instanceof UserDataException) {
                            qs.displayError(Message.raw(throwable.getLocalizedMessage(), new Object[0]), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        } else {
                            LOG.log(Level.WARNING, "Error processing task: " + throwable, throwable);
                            qs.displayError(Message.raw(throwable.toString(), new Object[0]), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                    } else {
                        Uninstaller.this.conf = (UninstallData)returnValue;
                        if (Uninstaller.this.conf.isADS() && Uninstaller.this.conf.isReplicationServer()) {
                            if (Uninstaller.this.conf.isServerRunning()) {
                                if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_REPLICATION_SERVER_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_REPLICATION_SERVER_RUNNING_TITLE.get())) {
                                    Uninstaller.this.askForAuthenticationAndLaunch(qs);
                                } else if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_TITLE.get())) {
                                    Uninstaller.this.getUserData().setStopServer(true);
                                    qs.launch();
                                    qs.setCurrentStep(Uninstaller.this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
                                } else {
                                    Uninstaller.this.getUserData().setStopServer(false);
                                }
                            } else if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_REPLICATION_SERVER_NOT_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_REPLICATION_SERVER_NOT_RUNNING_TITLE.get())) {
                                boolean startWorked = Uninstaller.this.startServer(qs.getDialog().getFrame());
                                if (startWorked) {
                                    Uninstaller.this.askForAuthenticationAndLaunch(qs);
                                } else {
                                    Uninstaller.this.getUserData().setStopServer(false);
                                    if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_NOT_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_NOT_RUNNING_TITLE.get())) {
                                        qs.launch();
                                        qs.setCurrentStep(Uninstaller.this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
                                    }
                                }
                            } else {
                                Uninstaller.this.getUserData().setStopServer(false);
                                if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_NOT_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_NOT_RUNNING_TITLE.get())) {
                                    qs.launch();
                                    qs.setCurrentStep(Uninstaller.this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
                                }
                            }
                        } else if (!Uninstaller.this.conf.isServerRunning()) {
                            Uninstaller.this.getUserData().setStopServer(false);
                            if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_NOT_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_NOT_RUNNING_TITLE.get())) {
                                qs.launch();
                                qs.setCurrentStep(Uninstaller.this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
                            }
                        } else if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_TITLE.get())) {
                            Uninstaller.this.getUserData().setStopServer(true);
                            qs.launch();
                            qs.setCurrentStep(Uninstaller.this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
                        } else {
                            Uninstaller.this.getUserData().setStopServer(false);
                        }
                    }
                }
            };
            qs.getDialog().workerStarted();
            worker.startBackgroundTask();
        }
        return false;
    }

    @Override
    public void updateUserData(WizardStep step, QuickSetup qs) {
    }

    @Override
    public void setWizardDialogState(QuickSetupDialog dlg, UserData userData, WizardStep step) {
        if (step == Step.CONFIRM_UNINSTALL) {
            dlg.setDefaultButton(ButtonName.FINISH);
            dlg.setFocusOnButton(ButtonName.FINISH);
        } else if (step == Step.PROGRESS || step == Step.FINISHED) {
            dlg.setDefaultButton(ButtonName.CLOSE);
            dlg.setFocusOnButton(ButtonName.CLOSE);
            dlg.setButtonEnabled(ButtonName.CLOSE, false);
        }
    }

    @Override
    public UserData createUserData(Launcher launcher) throws UserDataException {
        return this.cliHelper.createUserData((UninstallerArgumentParser)launcher.getArgumentParser(), launcher.getArguments());
    }

    @Override
    public String getInstallationPath() {
        return Utils.getInstallPathFromClasspath();
    }

    @Override
    public ApplicationException getRunError() {
        return this.ue;
    }

    private void initMaps() {
        Message successMsg;
        this.hmSummary.put(UninstallProgressStep.NOT_STARTED, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_UNINSTALL_NOT_STARTED.get()));
        this.hmSummary.put(UninstallProgressStep.STOPPING_SERVER, this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STOPPING.get()));
        this.hmSummary.put(UninstallProgressStep.UNCONFIGURING_REPLICATION, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_UNCONFIGURING_REPLICATION.get()));
        this.hmSummary.put(UninstallProgressStep.DISABLING_WINDOWS_SERVICE, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_DISABLING_WINDOWS_SERVICE.get()));
        this.hmSummary.put(UninstallProgressStep.DELETING_EXTERNAL_DATABASE_FILES, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_DELETING_EXTERNAL_DB_FILES.get()));
        this.hmSummary.put(UninstallProgressStep.DELETING_EXTERNAL_LOG_FILES, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_DELETING_EXTERNAL_LOG_FILES.get()));
        this.hmSummary.put(UninstallProgressStep.REMOVING_EXTERNAL_REFERENCES, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_DELETING_EXTERNAL_REFERENCES.get()));
        this.hmSummary.put(UninstallProgressStep.DELETING_INSTALLATION_FILES, this.getFormattedSummary(AdminToolMessages.INFO_SUMMARY_DELETING_INSTALLATION_FILES.get()));
        Installation installation = this.getInstallation();
        String libPath = Utils.getPath(installation.getLibrariesDirectory());
        if (Utils.isCli()) {
            if (this.getUninstallUserData().getRemoveLibrariesAndTools()) {
                String arg = Utils.isWindows() ? installation.getUninstallBatFile() + this.getLineBreak().toString() + this.getTab() + libPath : libPath;
                successMsg = AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_SUCCESSFULLY_REMOVE_JARFILES_CLI.get(arg);
            } else {
                successMsg = AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_SUCCESSFULLY_CLI.get();
            }
        } else {
            successMsg = this.getUninstallUserData().getRemoveLibrariesAndTools() ? AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_SUCCESSFULLY_REMOVE_JARFILES.get(libPath) : AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_SUCCESSFULLY.get();
        }
        this.hmSummary.put(UninstallProgressStep.FINISHED_SUCCESSFULLY, this.getFormattedSuccess(successMsg));
        Message nonCriticalMsg = Utils.isCli() ? AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_WITH_ERROR_ON_REMOTE.get() : AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_WITH_ERROR_ON_REMOTE_CLI.get();
        this.hmSummary.put(UninstallProgressStep.FINISHED_WITH_ERROR_ON_REMOTE, this.getFormattedWarning(nonCriticalMsg));
        this.hmSummary.put(UninstallProgressStep.FINISHED_WITH_ERROR, this.getFormattedError(AdminToolMessages.INFO_SUMMARY_UNINSTALL_FINISHED_WITH_ERROR.get()));
        HashMap<UninstallProgressStep, Integer> hmTime = new HashMap<UninstallProgressStep, Integer>();
        hmTime.put(UninstallProgressStep.UNCONFIGURING_REPLICATION, 5);
        hmTime.put(UninstallProgressStep.STOPPING_SERVER, 15);
        hmTime.put(UninstallProgressStep.DISABLING_WINDOWS_SERVICE, 5);
        hmTime.put(UninstallProgressStep.DELETING_EXTERNAL_DATABASE_FILES, 30);
        hmTime.put(UninstallProgressStep.DELETING_EXTERNAL_LOG_FILES, 5);
        hmTime.put(UninstallProgressStep.REMOVING_EXTERNAL_REFERENCES, 5);
        hmTime.put(UninstallProgressStep.DELETING_INSTALLATION_FILES, 10);
        int totalTime = 0;
        ArrayList<UninstallProgressStep> steps = new ArrayList<UninstallProgressStep>();
        if (this.getUninstallUserData().getUpdateRemoteReplication()) {
            totalTime += ((Integer)hmTime.get(UninstallProgressStep.UNCONFIGURING_REPLICATION)).intValue();
            steps.add(UninstallProgressStep.UNCONFIGURING_REPLICATION);
        }
        if (this.getUserData().getStopServer()) {
            totalTime += ((Integer)hmTime.get(UninstallProgressStep.STOPPING_SERVER)).intValue();
            steps.add(UninstallProgressStep.STOPPING_SERVER);
        }
        if (this.isWindowsServiceEnabled()) {
            totalTime += ((Integer)hmTime.get(UninstallProgressStep.DISABLING_WINDOWS_SERVICE)).intValue();
            steps.add(UninstallProgressStep.DISABLING_WINDOWS_SERVICE);
        }
        totalTime += ((Integer)hmTime.get(UninstallProgressStep.DELETING_INSTALLATION_FILES)).intValue();
        steps.add(UninstallProgressStep.DELETING_INSTALLATION_FILES);
        if (this.getUninstallUserData().getExternalDbsToRemove().size() > 0) {
            totalTime += ((Integer)hmTime.get(UninstallProgressStep.DELETING_EXTERNAL_DATABASE_FILES)).intValue();
            steps.add(UninstallProgressStep.DELETING_EXTERNAL_DATABASE_FILES);
        }
        if (this.getUninstallUserData().getExternalLogsToRemove().size() > 0) {
            totalTime += ((Integer)hmTime.get(UninstallProgressStep.DELETING_EXTERNAL_LOG_FILES)).intValue();
            steps.add(UninstallProgressStep.DELETING_EXTERNAL_LOG_FILES);
        }
        int cumulatedTime = 0;
        for (UninstallProgressStep s : steps) {
            Integer statusTime = (Integer)hmTime.get(s);
            this.hmRatio.put(s, 100 * cumulatedTime / totalTime);
            if (statusTime == null) continue;
            cumulatedTime += statusTime.intValue();
        }
        this.hmRatio.put(UninstallProgressStep.FINISHED_SUCCESSFULLY, 100);
        this.hmRatio.put(UninstallProgressStep.FINISHED_WITH_ERROR_ON_REMOTE, 100);
        this.hmRatio.put(UninstallProgressStep.FINISHED_WITH_ERROR, 100);
    }

    @Override
    public void run() {
        this.runStarted = true;
        this.initMaps();
        PrintStream origErr = System.err;
        PrintStream origOut = System.out;
        try {
            UninstallUserData userData;
            boolean somethingToDelete;
            Set<String> logsToDelete;
            Set<String> dbsToDelete;
            Application.ErrorPrintStream err = new Application.ErrorPrintStream(this);
            Application.OutputPrintStream out = new Application.OutputPrintStream(this);
            if (!Utils.isCli()) {
                System.setErr(err);
                System.setOut(out);
            }
            boolean displaySeparator = false;
            if (this.getUninstallUserData().getUpdateRemoteReplication()) {
                this.status = UninstallProgressStep.UNCONFIGURING_REPLICATION;
                this.removeRemoteServerReferences();
                displaySeparator = true;
            }
            if (this.getUserData().getStopServer()) {
                this.status = UninstallProgressStep.STOPPING_SERVER;
                if (displaySeparator) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                new ServerController(this).stopServer();
                displaySeparator = true;
            }
            if (this.isWindowsServiceEnabled()) {
                this.status = UninstallProgressStep.DISABLING_WINDOWS_SERVICE;
                if (displaySeparator) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.disableWindowsService();
                displaySeparator = true;
            }
            if ((dbsToDelete = this.getUninstallUserData().getExternalDbsToRemove()).size() > 0) {
                this.status = UninstallProgressStep.DELETING_EXTERNAL_DATABASE_FILES;
                if (displaySeparator) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.deleteExternalDatabaseFiles(dbsToDelete);
                displaySeparator = true;
            }
            if ((logsToDelete = this.getUninstallUserData().getExternalLogsToRemove()).size() > 0) {
                this.status = UninstallProgressStep.DELETING_EXTERNAL_LOG_FILES;
                if (displaySeparator) {
                    this.notifyListeners(this.getTaskSeparator());
                }
                this.deleteExternalLogFiles(logsToDelete);
                displaySeparator = true;
            }
            boolean bl = somethingToDelete = (userData = this.getUninstallUserData()).getRemoveBackups() || userData.getRemoveConfigurationAndSchema() || userData.getRemoveDatabases() || userData.getRemoveLDIFs() || userData.getRemoveLibrariesAndTools() || userData.getRemoveLogs();
            if (displaySeparator && somethingToDelete) {
                this.notifyListeners(this.getTaskSeparator());
            }
            if (somethingToDelete) {
                this.status = UninstallProgressStep.DELETING_INSTALLATION_FILES;
                this.deleteInstallationFiles(this.getRatio(this.status), this.getRatio(UninstallProgressStep.FINISHED_SUCCESSFULLY));
            }
            this.status = this.errorOnRemoteOccurred ? UninstallProgressStep.FINISHED_WITH_ERROR_ON_REMOTE : UninstallProgressStep.FINISHED_SUCCESSFULLY;
            if (Utils.isCli()) {
                this.notifyListeners(new MessageBuilder(this.getLineBreak()).append(this.getLineBreak()).append(this.getSummary(this.status)).toMessage());
            } else {
                this.notifyListeners(null);
            }
        }
        catch (ApplicationException ex) {
            this.ue = ex;
            this.status = UninstallProgressStep.FINISHED_WITH_ERROR;
            Message msg = this.getFormattedError(ex, true);
            this.notifyListeners(msg);
        }
        catch (Throwable t) {
            this.ue = new ApplicationException(ApplicationReturnCode.ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
            this.status = UninstallProgressStep.FINISHED_WITH_ERROR;
            Message msg = this.getFormattedError(this.ue, true);
            this.notifyListeners(msg);
        }
        if (!Utils.isCli()) {
            System.setErr(origErr);
            System.setOut(origOut);
        }
    }

    @Override
    public ProgressStep getCurrentProgressStep() {
        return this.status;
    }

    @Override
    public Integer getRatio(ProgressStep step) {
        return this.hmRatio.get(step);
    }

    @Override
    public Message getSummary(ProgressStep step) {
        return this.hmSummary.get(step);
    }

    @Override
    public boolean isFinished() {
        return this.getCurrentProgressStep() == UninstallProgressStep.FINISHED_SUCCESSFULLY || this.getCurrentProgressStep() == UninstallProgressStep.FINISHED_WITH_ERROR || this.getCurrentProgressStep() == UninstallProgressStep.FINISHED_WITH_ERROR_ON_REMOTE;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void windowClosing(QuickSetupDialog dlg, WindowEvent evt) {
        if (dlg.getDisplayedStep() == Step.PROGRESS || dlg.getDisplayedStep() == Step.FINISHED) {
            dlg.notifyButtonEvent(ButtonName.CLOSE);
        } else {
            dlg.notifyButtonEvent(ButtonName.QUIT);
        }
    }

    @Override
    public ButtonName getInitialFocusButtonName() {
        return ButtonName.FINISH;
    }

    @Override
    public Set<? extends WizardStep> getWizardSteps() {
        HashSet<Step> setSteps = new HashSet<Step>();
        setSteps.add(Step.CONFIRM_UNINSTALL);
        setSteps.add(Step.PROGRESS);
        setSteps.add(Step.FINISHED);
        return Collections.unmodifiableSet(setSteps);
    }

    @Override
    public QuickSetupStepPanel createWizardStepPanel(WizardStep step) {
        QuickSetupStepPanel p = null;
        if (step == Step.CONFIRM_UNINSTALL) {
            p = new ConfirmUninstallPanel(this, this.installStatus);
        } else if (step == Step.PROGRESS) {
            p = new ProgressPanel(this);
        } else if (step == Step.FINISHED) {
            p = new FinishedPanel(this);
        }
        return p;
    }

    private void deleteExternalDatabaseFiles(Set<String> dbFiles) throws ApplicationException {
        this.notifyListeners(this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_PROGRESS_DELETING_EXTERNAL_DB_FILES.get()));
        for (String path : dbFiles) {
            this.deleteRecursively(new File(path));
        }
    }

    private void deleteExternalLogFiles(Set<String> logFiles) throws ApplicationException {
        this.notifyListeners(this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_PROGRESS_DELETING_EXTERNAL_LOG_FILES.get()));
        for (String path : logFiles) {
            this.deleteRecursively(new File(path));
        }
    }

    private void deleteInstallationFiles(int minRatio, int maxRatio) throws ApplicationException {
        this.notifyListeners(this.getFormattedProgressWithLineBreak(QuickSetupMessages.INFO_PROGRESS_DELETING_INSTALLATION_FILES.get()));
        File f = new File(Utils.getInstallPathFromClasspath());
        InstallationFilesToDeleteFilter filter = new InstallationFilesToDeleteFilter();
        File[] rootFiles = f.listFiles();
        if (rootFiles != null) {
            int totalRatio = 0;
            ArrayList<Integer> cumulatedRatio = new ArrayList<Integer>();
            for (int i = 0; i < rootFiles.length; ++i) {
                if (filter.accept(rootFiles[i])) {
                    Installation installation = this.getInstallation();
                    int relativeRatio = this.equalsOrDescendant(rootFiles[i], installation.getLibrariesDirectory()) ? 10 : (this.equalsOrDescendant(rootFiles[i], installation.getBinariesDirectory()) ? 5 : (this.equalsOrDescendant(rootFiles[i], installation.getConfigurationDirectory()) ? 5 : (this.equalsOrDescendant(rootFiles[i], installation.getBackupDirectory()) ? 20 : (this.equalsOrDescendant(rootFiles[i], installation.getLdifDirectory()) ? 20 : (this.equalsOrDescendant(rootFiles[i], installation.getDatabasesDirectory()) ? 50 : (this.equalsOrDescendant(rootFiles[i], installation.getLogsDirectory()) ? 30 : 2))))));
                    cumulatedRatio.add(totalRatio);
                    totalRatio += relativeRatio;
                    continue;
                }
                cumulatedRatio.add(totalRatio);
            }
            Iterator it = cumulatedRatio.iterator();
            for (int i = 0; i < rootFiles.length; ++i) {
                int beforeRatio = minRatio + (Integer)it.next() * (maxRatio - minRatio) / totalRatio;
                this.hmRatio.put(UninstallProgressStep.DELETING_INSTALLATION_FILES, beforeRatio);
                this.deleteRecursively(rootFiles[i], filter);
            }
            this.hmRatio.put(UninstallProgressStep.DELETING_INSTALLATION_FILES, maxRatio);
        }
    }

    private void deleteRecursively(File file) throws ApplicationException {
        this.deleteRecursively(file, null);
    }

    private void deleteRecursively(File file, FileFilter filter) throws ApplicationException {
        if (file.exists()) {
            if (file.isFile()) {
                if (filter != null) {
                    if (filter.accept(file)) {
                        this.delete(file);
                    }
                } else {
                    this.delete(file);
                }
            } else {
                File[] children = file.listFiles();
                if (children != null) {
                    for (int i = 0; i < children.length; ++i) {
                        this.deleteRecursively(children[i], filter);
                    }
                }
                if (filter != null) {
                    if (filter.accept(file)) {
                        this.delete(file);
                    }
                } else {
                    this.delete(file);
                }
            }
        } else {
            this.notifyListeners(this.getFormattedWarning(QuickSetupMessages.INFO_PROGRESS_DELETING_FILE_DOES_NOT_EXIST.get(file.toString())));
        }
    }

    private void delete(File file) throws ApplicationException {
        boolean isFile = file.isFile();
        if (isFile) {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_DELETING_FILE.get(file.getAbsolutePath())));
        } else {
            this.notifyListeners(this.getFormattedWithPoints(QuickSetupMessages.INFO_PROGRESS_DELETING_DIRECTORY.get(file.getAbsolutePath())));
        }
        boolean delete = false;
        int nTries = 5;
        for (int i = 0; i < nTries && !delete; ++i) {
            delete = file.delete();
            if (delete) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!delete) {
            Message errMsg = isFile ? QuickSetupMessages.INFO_ERROR_DELETING_FILE.get(file.getAbsolutePath()) : QuickSetupMessages.INFO_ERROR_DELETING_DIRECTORY.get(file.getAbsolutePath());
            throw new ApplicationException(ApplicationReturnCode.ReturnCode.FILE_SYSTEM_ACCESS_ERROR, errMsg, null);
        }
        this.notifyListeners(this.getFormattedDoneWithLineBreak());
    }

    private boolean equalsOrDescendant(File file, File directory) {
        return file.equals(directory) || Utils.isDescendant(file, directory);
    }

    private boolean isWindowsServiceEnabled() {
        if (this.isWindowsServiceEnabled == null) {
            this.isWindowsServiceEnabled = ConfigureWindowsService.serviceState(null, null) == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isWindowsServiceEnabled;
    }

    @Override
    protected ApplicationTrustManager getTrustManager() {
        return this.getUninstallUserData().getTrustManager();
    }

    protected void disableWindowsService() throws ApplicationException {
        this.notifyListeners(this.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_DISABLING_WINDOWS_SERVICE.get()));
        int code = ConfigureWindowsService.disableService(System.out, System.err);
        Message errorMessage = QuickSetupMessages.INFO_ERROR_DISABLING_WINDOWS_SERVICE.get(this.getInstallationPath());
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.WINDOWS_SERVICE_ERROR, errorMessage, null);
            }
        }
    }

    private UninstallUserData getUninstallUserData() {
        return (UninstallUserData)this.getUserData();
    }

    private boolean startServer(JFrame frame) {
        this.startProgressDetails = new MessageBuilder();
        this.startProgressDlg = new ProgressDialog(frame);
        this.startProgressDlg.setSummary(this.getFormattedSummary(QuickSetupMessages.INFO_SUMMARY_STARTING.get()));
        this.startProgressDlg.setDetails(Message.EMPTY);
        this.startProgressDlg.setCloseButtonEnabled(false);
        final Boolean[] returnValue = new Boolean[]{Boolean.FALSE};
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    new ServerController(Uninstaller.this).startServer();
                    final boolean isServerRunning = Installation.getLocal().getStatus().isServerRunning();
                    returnValue[0] = isServerRunning;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (isServerRunning) {
                                Uninstaller.this.startProgressDlg.setSummary(Uninstaller.this.getFormattedSuccess(QuickSetupMessages.INFO_SUMMARY_START_SUCCESS.get()));
                            } else {
                                Uninstaller.this.startProgressDlg.setSummary(Uninstaller.this.getFormattedError(QuickSetupMessages.INFO_SUMMARY_START_ERROR.get()));
                            }
                            Uninstaller.this.startProgressDlg.setCloseButtonEnabled(true);
                        }
                    });
                }
                catch (Throwable t) {
                    Message msg = Uninstaller.this.getFormattedError(t, true);
                    Uninstaller.this.notifyListeners(msg);
                }
            }
        });
        t.start();
        this.startProgressDlg.pack();
        Utilities.centerOnComponent(this.startProgressDlg, frame);
        this.startProgressDlg.setModal(true);
        this.startProgressDlg.setVisible(true);
        this.startProgressDlg = null;
        return returnValue[0];
    }

    private void askForAuthenticationAndLaunch(final QuickSetup qs) {
        if (this.loginDialog == null) {
            this.loginDialog = new LoginDialog(qs.getDialog().getFrame(), this.getTrustManager());
            this.loginDialog.pack();
        }
        Utilities.centerOnComponent(this.loginDialog, qs.getDialog().getFrame());
        this.loginDialog.setModal(true);
        this.loginDialog.setVisible(true);
        if (!this.loginDialog.isCancelled()) {
            this.getUninstallUserData().setAdminUID(this.loginDialog.getAdministratorUid());
            this.getUninstallUserData().setAdminPwd(this.loginDialog.getAdministratorPwd());
            this.getUninstallUserData().setReferencedHostName(this.loginDialog.getHostName());
            final InitialLdapContext ctx = this.loginDialog.getContext();
            try {
                this.getUninstallUserData().setLocalServerUrl((String)ctx.getEnvironment().get("java.naming.provider.url"));
            }
            catch (NamingException ne) {
                LOG.log(Level.WARNING, "Could not find local server: " + ne, ne);
                this.getUninstallUserData().setLocalServerUrl("ldap://localhost:389");
            }
            this.replicationServerHostPort = this.loginDialog.getHostName() + ":" + this.conf.getReplicationServerPort();
            BackgroundTask worker = new BackgroundTask(){

                public Object processBackgroundTask() throws TopologyCacheException {
                    ADSContext adsContext = new ADSContext(ctx);
                    TopologyCache cache = new TopologyCache(adsContext, Uninstaller.this.getTrustManager());
                    cache.reloadTopology();
                    return cache;
                }

                public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
                    qs.getDialog().workerFinished();
                    if (throwable != null) {
                        if (throwable instanceof TopologyCacheException) {
                            qs.displayError(Message.raw(Uninstaller.this.getStringRepresentation((TopologyCacheException)throwable), new Object[0]), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        } else {
                            qs.displayError(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                    } else {
                        TopologyCache cache = (TopologyCache)returnValue;
                        Uninstaller.this.handleTopologyCache(qs, cache);
                    }
                }
            };
            qs.getDialog().workerStarted();
            worker.startBackgroundTask();
        } else if (qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_TITLE.get())) {
            this.getUserData().setStopServer(true);
            qs.launch();
            qs.setCurrentStep(this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
        } else {
            this.getUserData().setStopServer(false);
        }
    }

    private void handleTopologyCache(QuickSetup qs, TopologyCache cache) {
        boolean stopProcessing = false;
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        Set<ServerDescriptor> servers = cache.getServers();
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        LinkedHashSet<String> exceptionMsgs = new LinkedHashSet<String>();
        for (TopologyCacheException e : exceptions) {
            if (stopProcessing) break;
            switch (e.getType()) {
                case NOT_GLOBAL_ADMINISTRATOR: {
                    Message errorMsg = QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get();
                    qs.displayError(errorMsg, QuickSetupMessages.INFO_ERROR_TITLE.get());
                    stopProcessing = true;
                    break;
                }
                case GENERIC_CREATING_CONNECTION: {
                    int p;
                    String h;
                    if (e.getCause() == null || !Utils.isCertificateException(e.getCause())) break;
                    ApplicationTrustManager.Cause cause = null;
                    if (e.getTrustManager() != null) {
                        cause = e.getTrustManager().getLastRefusedCause();
                    }
                    LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                    UserDataCertificateException.Type excType = cause == ApplicationTrustManager.Cause.NOT_TRUSTED ? UserDataCertificateException.Type.NOT_TRUSTED : (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH ? UserDataCertificateException.Type.HOST_NAME_MISMATCH : null);
                    if (excType == null) break;
                    try {
                        URI uri = new URI(e.getLdapUrl());
                        h = uri.getHost();
                        p = uri.getPort();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "Error parsing ldap url of TopologyCacheException.", t);
                        h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                        p = -1;
                    }
                    UserDataCertificateException exc = new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), e.getCause(), h, p, e.getTrustManager().getLastRefusedChain(), e.getTrustManager().getLastRefusedAuthType(), excType);
                    this.handleCertificateException(qs, exc, cache);
                    stopProcessing = true;
                }
            }
            exceptionMsgs.add(this.getStringRepresentation(e));
        }
        if (!stopProcessing && exceptionMsgs.size() > 0) {
            Message confirmationMsg = AdminToolMessages.ERR_READING_REGISTERED_SERVERS_CONFIRM_UPDATE_REMOTE.get(Utils.getStringFromCollection(exceptionMsgs, "n"));
            boolean bl = stopProcessing = !qs.displayConfirmation(confirmationMsg, QuickSetupMessages.INFO_CONFIRMATION_TITLE.get());
        }
        if (!stopProcessing) {
            boolean bl = stopProcessing = !qs.displayConfirmation(AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_MSG.get(), AdminToolMessages.INFO_CONFIRM_UNINSTALL_SERVER_RUNNING_TITLE.get());
        }
        if (!stopProcessing) {
            this.getUninstallUserData().setUpdateRemoteReplication(true);
            this.getUninstallUserData().setRemoteServers(cache.getServers());
            this.getUserData().setStopServer(true);
            qs.launch();
            qs.setCurrentStep(this.getNextWizardStep(Step.CONFIRM_UNINSTALL));
        }
    }

    private void handleCertificateException(final QuickSetup qs, UserDataCertificateException ce, final TopologyCache cache) {
        CertificateDialog dlg = new CertificateDialog(qs.getDialog().getFrame(), ce);
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.isAccepted()) {
            X509Certificate[] chain = ce.getChain();
            String authType = ce.getAuthType();
            String host = ce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                this.getTrustManager().acceptCertificate(chain, authType, host);
                BackgroundTask worker = new BackgroundTask(){

                    public Object processBackgroundTask() throws TopologyCacheException {
                        cache.reloadTopology();
                        return cache;
                    }

                    public void backgroundTaskCompleted(Object returnValue, Throwable throwable) {
                        qs.getDialog().workerFinished();
                        if (throwable != null) {
                            if (throwable instanceof TopologyCacheException) {
                                qs.displayError(Message.raw(Uninstaller.this.getStringRepresentation((TopologyCacheException)throwable), new Object[0]), QuickSetupMessages.INFO_ERROR_TITLE.get());
                            } else {
                                qs.displayError(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                            }
                        } else {
                            Uninstaller.this.handleTopologyCache(qs, cache);
                        }
                    }
                };
                qs.getDialog().workerStarted();
                worker.startBackgroundTask();
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
    }

    private void removeRemoteServerReferences() throws ApplicationException {
        Set<ServerDescriptor> servers = this.getUninstallUserData().getRemoteServers();
        Map<ADSContext.ServerProperty, Object> serverADSProperties = null;
        for (ServerDescriptor server : servers) {
            if (!this.isServerToUninstall(server)) continue;
            serverADSProperties = server.getAdsProperties();
            break;
        }
        if (serverADSProperties == null) {
            LOG.log(Level.WARNING, "The server ADS properties for the server to uninstall could not be found.");
        }
        for (ServerDescriptor server : servers) {
            if (server.getAdsProperties() == serverADSProperties) continue;
            this.removeReferences(server, serverADSProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReferences(ServerDescriptor server, Map<ADSContext.ServerProperty, Object> serverADSProperties) throws ApplicationException {
        Set replicationServers;
        boolean hasReferences = false;
        Object v = server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.IS_REPLICATION_SERVER);
        if (Boolean.TRUE.equals(v) && (replicationServers = (Set)server.getServerProperties().get((Object)ServerDescriptor.ServerProperty.EXTERNAL_REPLICATION_SERVERS)) != null) {
            for (Object o : replicationServers) {
                if (!this.replicationServerHostPort.equalsIgnoreCase((String)o)) continue;
                hasReferences = true;
                break;
            }
        }
        if (!hasReferences) {
            for (ReplicaDescriptor replica : server.getReplicas()) {
                if (replica.isReplicated()) {
                    for (String o : replica.getReplicationServers()) {
                        if (!this.replicationServerHostPort.equalsIgnoreCase(o)) continue;
                        hasReferences = true;
                        break;
                    }
                }
                if (!hasReferences) continue;
                break;
            }
        }
        if (hasReferences) {
            LOG.log(Level.INFO, "Updating references in: " + server.getHostPort(true));
            this.notifyListeners(this.getFormattedWithPoints(AdminToolMessages.INFO_PROGRESS_REMOVING_REFERENCES.get(server.getHostPort(true))));
            InitialContext ctx = null;
            try {
                String dn = ADSContext.getAdministratorDN(this.getUninstallUserData().getAdminUID());
                String pwd = this.getUninstallUserData().getAdminPwd();
                ctx = this.getRemoteConnection(server, dn, pwd, this.getTrustManager());
                this.removeReferences((InitialLdapContext)ctx, server.getHostPort(true), serverADSProperties);
                this.notifyListeners(this.getFormattedDoneWithLineBreak());
            }
            catch (ApplicationException ae) {
                this.errorOnRemoteOccurred = true;
                LOG.log(Level.INFO, "Error updating replication references in: " + server.getHostPort(true), ae);
                if (this.getUninstallUserData().isForceOnError()) {
                    throw ae;
                }
                Message html = this.getFormattedError(ae, true);
                this.notifyListeners(html);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }

    private void removeReferences(InitialLdapContext ctx, String serverDisplay, Map<ADSContext.ServerProperty, Object> serverADSProperties) throws ApplicationException {
        block15: {
            try {
                String[] domainNames;
                ReplicationServerCfgClient replicationServer;
                SortedSet<String> replServers;
                ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
                RootCfgClient root = mCtx.getRootConfiguration();
                MultimasterSynchronizationProviderCfgClient sync = (MultimasterSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
                if (sync.hasReplicationServer() && (replServers = (replicationServer = sync.getReplicationServer()).getReplicationServer()) != null) {
                    String replServer = null;
                    for (String o : replServers) {
                        if (!this.replicationServerHostPort.equalsIgnoreCase(o)) continue;
                        replServer = o;
                        break;
                    }
                    if (replServer != null) {
                        LOG.log(Level.INFO, "Updating references in replication server on " + serverDisplay + ".");
                        replServers.remove(replServer);
                        if (replServers.size() > 0) {
                            replicationServer.setReplicationServer(replServers);
                            replicationServer.commit();
                        } else {
                            sync.removeReplicationServer();
                            sync.commit();
                        }
                    }
                }
                if ((domainNames = sync.listMultimasterDomains()) != null) {
                    for (int i = 0; i < domainNames.length; ++i) {
                        MultimasterDomainCfgClient domain = sync.getMultimasterDomain(domainNames[i]);
                        SortedSet<String> replServers2 = domain.getReplicationServer();
                        if (replServers2 == null) continue;
                        String replServer = null;
                        for (String o : replServers2) {
                            if (!this.replicationServerHostPort.equalsIgnoreCase(o)) continue;
                            replServer = o;
                            break;
                        }
                        if (replServer == null) continue;
                        LOG.log(Level.INFO, "Updating references in domain " + domain.getReplicationDN() + " on " + serverDisplay + ".");
                        replServers2.remove(replServer);
                        if (replServers2.size() > 0) {
                            domain.setReplicationServer(replServers2);
                            domain.commit();
                            continue;
                        }
                        sync.removeMultimasterDomain(domainNames[i]);
                        sync.commit();
                    }
                }
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + serverDisplay + ".", monfe);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error removing references in replication server on " + serverDisplay + ": " + t, t);
                Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
            }
            ADSContext adsContext = new ADSContext(ctx);
            try {
                if (adsContext.hasAdminData() && serverADSProperties != null) {
                    adsContext.unregisterServer(serverADSProperties);
                }
            }
            catch (ADSContextException ace) {
                if (ace.getError() == ADSContextException.ErrorType.NOT_YET_REGISTERED) break block15;
                throw new ApplicationException(ApplicationReturnCode.ReturnCode.CONFIGURATION_ERROR, QuickSetupMessages.INFO_REMOTE_ADS_EXCEPTION.get(serverDisplay, ace.toString()), ace);
            }
        }
    }

    private boolean isServerToUninstall(ServerDescriptor server) {
        boolean isServerToUninstall = false;
        String path = (String)server.getAdsProperties().get((Object)ADSContext.ServerProperty.INSTANCE_PATH);
        if (path == null) {
            try {
                String usedUrl = this.getUninstallUserData().getLocalServerUrl();
                boolean isSecure = usedUrl.toLowerCase().startsWith("ldaps");
                URI uri = new URI(usedUrl);
                int port = uri.getPort();
                ServerDescriptor.ServerProperty property = isSecure ? ServerDescriptor.ServerProperty.LDAPS_PORT : ServerDescriptor.ServerProperty.LDAP_PORT;
                ArrayList ports = (ArrayList)server.getServerProperties().get((Object)property);
                isServerToUninstall = ports.contains(port);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Failing checking the port: " + t, t);
            }
        } else {
            File f = new File(path);
            isServerToUninstall = f.equals(Installation.getLocal().getRootDirectory());
        }
        if (isServerToUninstall) {
            String hostName = server.getHostName();
            boolean hostNameEquals = false;
            try {
                InetAddress localAddress = InetAddress.getLocalHost();
                InetAddress[] addresses = InetAddress.getAllByName(hostName);
                for (int i = 0; i < addresses.length && !hostNameEquals; ++i) {
                    hostNameEquals = localAddress.equals(addresses[i]);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Failing checking host names: " + t, t);
            }
            isServerToUninstall = hostNameEquals;
        }
        return isServerToUninstall;
    }

    class InstallationFilesToDeleteFilter
    implements FileFilter {
        Installation installation;
        File quicksetupFile;
        File openDSFile;
        File librariesFile;
        File activationFile;
        File aspectRuntimeFile;
        File uninstallBatFile;
        File installationPath;

        InstallationFilesToDeleteFilter() {
            this.installation = Uninstaller.this.getInstallation();
            this.quicksetupFile = this.installation.getQuicksetupJarFile();
            this.openDSFile = this.installation.getOpenDSJarFile();
            this.librariesFile = this.installation.getLibrariesDirectory();
            this.activationFile = new File(this.librariesFile, "activation.jar");
            this.aspectRuntimeFile = new File(this.librariesFile, "aspectjrt.jar");
            this.uninstallBatFile = this.installation.getUninstallBatFile();
            this.installationPath = this.installation.getRootDirectory();
        }

        public boolean accept(File file) {
            boolean accept;
            UninstallUserData userData = Uninstaller.this.getUninstallUserData();
            boolean[] uData = new boolean[]{userData.getRemoveLibrariesAndTools(), userData.getRemoveLibrariesAndTools(), userData.getRemoveDatabases(), userData.getRemoveLogs(), userData.getRemoveConfigurationAndSchema(), userData.getRemoveBackups(), userData.getRemoveLDIFs()};
            Installation installation = Uninstaller.this.getInstallation();
            File[] parentFiles = new File[]{installation.getLibrariesDirectory(), installation.getBinariesDirectory(), installation.getDatabasesDirectory(), installation.getLogsDirectory(), installation.getConfigurationDirectory(), installation.getBackupDirectory(), installation.getLdifDirectory()};
            boolean bl = accept = !this.installationPath.equals(file) && !Uninstaller.this.equalsOrDescendant(file, this.librariesFile) && !this.quicksetupFile.equals(file) && !this.openDSFile.equals(file);
            if (accept && Utils.isWindows() && Utils.isCli()) {
                accept = !this.uninstallBatFile.equals(file);
            }
            for (int i = 0; i < uData.length && accept; accept &= uData[i] || !Uninstaller.this.equalsOrDescendant(file, parentFiles[i]), ++i) {
            }
            LOG.log(Level.INFO, "accept for :" + file + " is: " + accept);
            return accept;
        }
    }
}

