/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.statuspanel.ConfigFromFile;
import org.opends.guitools.uninstaller.UninstallData;
import org.opends.guitools.uninstaller.UninstallProgressStep;
import org.opends.guitools.uninstaller.UninstallUserData;
import org.opends.guitools.uninstaller.UninstallerArgumentParser;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.CliApplicationHelper;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UninstallCliHelper
extends CliApplicationHelper {
    private static final Logger LOG = Logger.getLogger(UninstallCliHelper.class.getName());
    private UninstallerArgumentParser parser;

    UninstallCliHelper() {
    }

    public UninstallUserData createUserData(UninstallerArgumentParser args, String[] rawArguments) throws UserDataException {
        boolean somethingSpecifiedToDelete;
        Set<String> outsideLogs;
        Set<String> outsideDbs;
        this.parser = args;
        UninstallUserData userData = new UninstallUserData();
        boolean isCancelled = false;
        try {
            args.parseArguments(rawArguments);
        }
        catch (ArgumentException ae) {
            throw new UserDataException(null, ae.getMessageObject());
        }
        boolean isInteractive = args.isInteractive();
        boolean isQuiet = args.isQuiet();
        userData.setQuiet(isQuiet);
        userData.setForceOnError(args.isForceOnError());
        userData.setTrustManager(args.getTrustManager());
        MessageBuilder buf = new MessageBuilder();
        int v = args.validateGlobalOptions(buf);
        if (v != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            throw new UserDataException(null, buf.toMessage());
        }
        Configuration config = Installation.getLocal().getCurrentConfiguration();
        try {
            outsideDbs = config.getOutsideDbs();
        }
        catch (IOException ioe) {
            outsideDbs = Collections.emptySet();
            LOG.log(Level.INFO, "error determining outside databases", ioe);
        }
        try {
            outsideLogs = config.getOutsideLogs();
        }
        catch (IOException ioe) {
            outsideLogs = Collections.emptySet();
            LOG.log(Level.INFO, "error determining outside logs", ioe);
        }
        boolean bl = somethingSpecifiedToDelete = args.removeAll() || args.removeBackupFiles() || args.removeDatabases() || args.removeLDIFFiles() || args.removeConfigurationFiles() || args.removeLogFiles() || args.removeServerLibraries();
        if (somethingSpecifiedToDelete) {
            userData.setRemoveBackups(args.removeAll() || args.removeBackupFiles());
            userData.setRemoveConfigurationAndSchema(args.removeAll() || args.removeConfigurationFiles());
            userData.setRemoveDatabases(args.removeAll() || args.removeDatabases());
            userData.setRemoveLDIFs(args.removeAll() || args.removeLDIFFiles());
            userData.setRemoveLibrariesAndTools(args.removeAll() || args.removeServerLibraries());
            userData.setRemoveLogs(args.removeAll() || args.removeLogFiles());
            userData.setExternalDbsToRemove(outsideDbs);
            userData.setExternalLogsToRemove(outsideLogs);
        } else {
            if (!isInteractive) {
                throw new UserDataException(null, AdminToolMessages.ERR_CLI_UNINSTALL_NOTHING_TO_BE_UNINSTALLED_NON_INTERACTIVE.get());
            }
            isCancelled = this.askWhatToDelete(userData, outsideDbs, outsideLogs);
        }
        String adminUid = args.getAdministratorUID();
        if (adminUid == null && !args.isInteractive()) {
            adminUid = args.getDefaultAdministratorUID();
        }
        userData.setAdminUID(adminUid);
        userData.setAdminPwd(args.getBindPassword());
        String referencedHostName = args.getReferencedHostName();
        if (referencedHostName == null && !args.isInteractive()) {
            referencedHostName = args.getDefaultReferencedHostName();
        }
        userData.setReferencedHostName(referencedHostName);
        if (!isCancelled) {
            isCancelled = this.checkServerState(userData, isInteractive);
        }
        if (isCancelled && !userData.isForceOnError()) {
            userData = null;
        }
        return userData;
    }

    private boolean askWhatToDelete(UninstallUserData userData, Set<String> outsideDbs, Set<String> outsideLogs) {
        boolean cancelled = false;
        Message[] options = new Message[]{Message.raw("1", new Object[0]), Message.raw("2", new Object[0]), Message.raw("3", new Object[0])};
        Message answer = this.promptConfirm(AdminToolMessages.INFO_CLI_UNINSTALL_WHAT_TO_DELETE.get(), options[0], options);
        if (options[2].toString().equals(answer.toString())) {
            cancelled = true;
        } else if (options[0].toString().equals(answer.toString())) {
            userData.setRemoveBackups(true);
            userData.setRemoveConfigurationAndSchema(true);
            userData.setRemoveDatabases(true);
            userData.setRemoveLDIFs(true);
            userData.setRemoveLibrariesAndTools(true);
            userData.setRemoveLogs(true);
            userData.setExternalDbsToRemove(outsideDbs);
            userData.setExternalLogsToRemove(outsideLogs);
        } else {
            boolean somethingSelected = false;
            while (!somethingSelected) {
                int i;
                Message[] keys = new Message[]{AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_LIBRARIES_BINARIES.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_DATABASES.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_LOGS.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_CONFIGURATION_SCHEMA.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_BACKUPS.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_LDIFS.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_OUTSIDEDBS.get(Utils.getStringFromCollection(outsideDbs, Constants.LINE_SEPARATOR)), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_OUTSIDELOGS.get(Utils.getStringFromCollection(outsideLogs, Constants.LINE_SEPARATOR))};
                Message[] validValues = new Message[]{AdminToolMessages.INFO_CLI_YES_LONG.get(), AdminToolMessages.INFO_CLI_NO_LONG.get(), AdminToolMessages.INFO_CLI_YES_SHORT.get(), AdminToolMessages.INFO_CLI_NO_SHORT.get()};
                boolean[] answers = new boolean[keys.length];
                for (i = 0; i < keys.length; ++i) {
                    boolean ignore;
                    boolean bl = ignore = i == 6 && outsideDbs.size() == 0 || i == 7 && outsideLogs.size() == 0;
                    if (!ignore) {
                        Message msg = keys[i];
                        answer = this.promptConfirm(msg, AdminToolMessages.INFO_CLI_YES_LONG.get(), validValues);
                        answers[i] = AdminToolMessages.INFO_CLI_YES_LONG.get().toString().equalsIgnoreCase(answer.toString()) || AdminToolMessages.INFO_CLI_YES_SHORT.get().toString().equalsIgnoreCase(answer.toString());
                        continue;
                    }
                    answers[i] = false;
                }
                block12: for (i = 0; i < answers.length; ++i) {
                    switch (i) {
                        case 0: {
                            userData.setRemoveLibrariesAndTools(answers[i]);
                            continue block12;
                        }
                        case 1: {
                            userData.setRemoveDatabases(answers[i]);
                            continue block12;
                        }
                        case 2: {
                            userData.setRemoveLogs(answers[i]);
                            continue block12;
                        }
                        case 3: {
                            userData.setRemoveConfigurationAndSchema(answers[i]);
                            continue block12;
                        }
                        case 4: {
                            userData.setRemoveBackups(answers[i]);
                            continue block12;
                        }
                        case 5: {
                            userData.setRemoveLDIFs(answers[i]);
                            continue block12;
                        }
                        case 6: {
                            if (!answers[i]) continue block12;
                            userData.setExternalDbsToRemove(outsideDbs);
                            continue block12;
                        }
                        case 7: {
                            if (!answers[i]) continue block12;
                            userData.setExternalLogsToRemove(outsideLogs);
                        }
                    }
                }
                if (!(userData.getExternalDbsToRemove().size() != 0 || userData.getExternalLogsToRemove().size() != 0 || userData.getRemoveLibrariesAndTools() || userData.getRemoveDatabases() || userData.getRemoveConfigurationAndSchema() || userData.getRemoveBackups() || userData.getRemoveLDIFs() || userData.getRemoveLogs())) {
                    somethingSelected = false;
                    this.printLineBreak();
                    this.printErrorMessage(AdminToolMessages.ERR_CLI_UNINSTALL_NOTHING_TO_BE_UNINSTALLED.get());
                    continue;
                }
                somethingSelected = true;
            }
        }
        return cancelled;
    }

    private boolean checkServerState(UninstallUserData userData, boolean interactive) throws UserDataException {
        boolean cancelled = false;
        UninstallData conf = null;
        try {
            conf = new UninstallData(Installation.getLocal());
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error processing task: " + t, t);
            throw new UserDataException(Step.CONFIRM_UNINSTALL, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
        }
        if (conf.isADS() && conf.isReplicationServer()) {
            if (conf.isServerRunning()) {
                if (interactive) {
                    if (this.confirmToUpdateRemote()) {
                        boolean bl = cancelled = !this.askForAuthenticationIfNeeded(userData);
                        if (cancelled) {
                            cancelled = !this.confirmToStopServer();
                        } else {
                            boolean bl2 = cancelled = !this.updateUserUninstallDataWithRemoteServers(userData, interactive);
                            if (cancelled) {
                                cancelled = !this.confirmToStopServer();
                            }
                        }
                    } else {
                        cancelled = !this.confirmToStopServer();
                    }
                } else {
                    cancelled = !this.updateUserUninstallDataWithRemoteServers(userData, interactive);
                }
            } else if (interactive) {
                if (this.confirmToUpdateRemoteAndStart()) {
                    boolean startWorked = this.startServer(userData.isQuiet());
                    if (startWorked) {
                        boolean bl = cancelled = !this.askForAuthenticationIfNeeded(userData);
                        if (cancelled) {
                            cancelled = !this.confirmToStopServer();
                        } else {
                            boolean bl3 = cancelled = !this.updateUserUninstallDataWithRemoteServers(userData, interactive);
                            if (cancelled) {
                                cancelled = !this.confirmToStopServer();
                            }
                        }
                    } else {
                        userData.setStopServer(false);
                        if (interactive) {
                            cancelled = !this.confirmDeleteFiles();
                        }
                    }
                } else {
                    cancelled = !this.confirmToStopServer();
                }
            } else {
                boolean startWorked = this.startServer(userData.isQuiet());
                if (startWorked) {
                    userData.setStopServer(true);
                    cancelled = !this.updateUserUninstallDataWithRemoteServers(userData, interactive);
                } else {
                    cancelled = !userData.isForceOnError();
                    userData.setStopServer(false);
                }
            }
        } else if (conf.isServerRunning()) {
            if (interactive) {
                boolean bl = cancelled = !this.confirmToStopServer();
            }
            if (!cancelled) {
                userData.setStopServer(Installation.getLocal().getStatus().isServerRunning());
            }
        } else {
            userData.setStopServer(false);
            if (interactive) {
                cancelled = !this.confirmDeleteFiles();
            }
        }
        return cancelled;
    }

    private boolean confirmToStopServer() {
        return this.confirm(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_STOP.get());
    }

    private boolean confirmDeleteFiles() {
        return this.confirm(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_DELETE_FILES.get());
    }

    private boolean confirm(Message msg) {
        boolean confirm = true;
        Message[] validValues = new Message[]{AdminToolMessages.INFO_CLI_YES_SHORT.get(), AdminToolMessages.INFO_CLI_NO_SHORT.get(), AdminToolMessages.INFO_CLI_YES_LONG.get(), AdminToolMessages.INFO_CLI_NO_LONG.get()};
        Message answer = this.promptConfirm(msg, validValues[2], validValues);
        if (AdminToolMessages.INFO_CLI_NO_SHORT.get().toString().equalsIgnoreCase(answer.toString()) || AdminToolMessages.INFO_CLI_NO_LONG.get().toString().equalsIgnoreCase(answer.toString())) {
            confirm = false;
        }
        return confirm;
    }

    private boolean confirmToUpdateRemote() {
        return this.confirm(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_UPDATE_REMOTE.get());
    }

    private boolean confirmToUpdateRemoteAndStart() {
        return this.confirm(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_UPDATE_REMOTE_AND_START.get());
    }

    private boolean promptToProvideAuthenticationAgain() {
        return this.confirm(AdminToolMessages.INFO_UNINSTALL_CONFIRM_PROVIDE_AUTHENTICATION_AGAIN.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean askForAuthenticationIfNeeded(UninstallUserData userData) {
        boolean accepted = true;
        String uid = userData.getAdminUID();
        String pwd = userData.getAdminPwd();
        boolean couldConnect = false;
        ConfigFromFile conf = new ConfigFromFile();
        conf.readConfiguration();
        String ldapUrl = conf.getLDAPURL();
        String startTlsUrl = conf.getStartTLSURL();
        String ldapsUrl = conf.getLDAPSURL();
        while (!couldConnect && accepted) {
            while (uid == null) {
                uid = this.askForAdministratorUID();
            }
            while (pwd == null) {
                pwd = this.askForAdministratorPwd();
            }
            userData.setAdminUID(uid);
            userData.setAdminPwd(pwd);
            InitialContext ctx = null;
            String usedUrl = null;
            try {
                String dn = ADSContext.getAdministratorDN(uid);
                if (ldapsUrl != null && (this.parser.useSSL() || !this.parser.startTLS())) {
                    usedUrl = ldapsUrl;
                    ctx = Utils.createLdapsContext(ldapsUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, userData.getTrustManager());
                } else if (startTlsUrl != null && (!this.parser.useSSL() || this.parser.startTLS())) {
                    usedUrl = startTlsUrl;
                    ctx = Utils.createStartTLSContext(startTlsUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, userData.getTrustManager(), null);
                } else if (ldapUrl != null && !this.parser.useSSL() && !this.parser.startTLS()) {
                    usedUrl = ldapUrl;
                    ctx = Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
                } else {
                    LOG.log(Level.WARNING, "Error retrieving a valid LDAP URL in conf file");
                    this.printErrorMessage(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                }
                if (usedUrl == null) continue;
                userData.setLocalServerUrl(usedUrl);
                couldConnect = true;
            }
            catch (NamingException ne) {
                LOG.log(Level.WARNING, "Error connecting to server: " + ne, ne);
                if (Utils.isCertificateException(ne)) {
                    accepted = this.promptForCertificateConfirmation(ne, userData.getTrustManager(), usedUrl);
                    continue;
                }
                uid = null;
                pwd = null;
                this.printLineBreak();
                this.printErrorMessage(Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), ne));
                accepted = this.promptToProvideAuthenticationAgain();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error connecting to server: " + t, t);
                uid = null;
                pwd = null;
                this.printErrorMessage(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
                accepted = this.promptToProvideAuthenticationAgain();
            }
            finally {
                if (ctx == null) continue;
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Error closing connection: " + t, t);
                }
            }
        }
        if (accepted) {
            String referencedHostName = userData.getReferencedHostName();
            while (referencedHostName == null) {
                referencedHostName = this.askForReferencedHostName(userData.getHostName());
            }
            userData.setReferencedHostName(referencedHostName);
        }
        userData.setUpdateRemoteReplication(accepted);
        return accepted;
    }

    private String askForAdministratorUID() {
        return this.promptForString(AdminToolMessages.INFO_UNINSTALL_CLI_ADMINISTRATOR_UID_PROMPT.get(), "admin");
    }

    private String askForAdministratorPwd() {
        return this.promptForPassword(AdminToolMessages.INFO_UNINSTALL_CLI_ADMINISTRATOR_PWD_PROMPT.get());
    }

    private String askForReferencedHostName(String defaultHostName) {
        return this.promptForString(AdminToolMessages.INFO_UNINSTALL_CLI_REFERENCED_HOSTNAME_PROMPT.get(), defaultHostName);
    }

    private boolean startServer(boolean supressOutput) {
        boolean serverStarted;
        block5: {
            serverStarted = false;
            Application application = new Application(){

                public String getInstallationPath() {
                    return Installation.getLocal().getRootDirectory().getAbsolutePath();
                }

                public ProgressStep getCurrentProgressStep() {
                    return UninstallProgressStep.NOT_STARTED;
                }

                public Integer getRatio(ProgressStep step) {
                    return 0;
                }

                public Message getSummary(ProgressStep step) {
                    return null;
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isCancellable() {
                    return false;
                }

                public void cancel() {
                }

                public void run() {
                }
            };
            application.setProgressMessageFormatter(new PlainTextProgressMessageFormatter());
            if (!supressOutput) {
                application.addProgressUpdateListener(new ProgressUpdateListener(){

                    public void progressUpdate(ProgressUpdateEvent ev) {
                        System.out.print(ev.getNewLogs().toString());
                        System.out.flush();
                    }
                });
            }
            ServerController controller = new ServerController(application, Installation.getLocal());
            try {
                if (!supressOutput) {
                    this.printLineBreak();
                }
                controller.startServer(supressOutput);
                if (!supressOutput) {
                    this.printLineBreak();
                }
                serverStarted = Installation.getLocal().getStatus().isServerRunning();
            }
            catch (ApplicationException ae) {
                if (supressOutput) break block5;
                this.printErrorMessage(ae.getMessage());
            }
        }
        return serverStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateUserUninstallDataWithRemoteServers(UninstallUserData userData, boolean interactive) {
        boolean accepted = false;
        InitialContext ctx = null;
        try {
            ConfigFromFile conf = new ConfigFromFile();
            conf.readConfiguration();
            String ldapUrl = conf.getLDAPURL();
            String startTlsUrl = conf.getStartTLSURL();
            String ldapsUrl = conf.getLDAPSURL();
            String adminUid = userData.getAdminUID();
            String pwd = userData.getAdminPwd();
            String dn = ADSContext.getAdministratorDN(adminUid);
            if (ldapsUrl != null && (this.parser.useSSL() || !this.parser.startTLS())) {
                ctx = Utils.createLdapsContext(ldapsUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, userData.getTrustManager());
            } else if (startTlsUrl != null && (!this.parser.useSSL() || this.parser.startTLS())) {
                ctx = Utils.createStartTLSContext(startTlsUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null, userData.getTrustManager(), null);
            } else if (ldapUrl != null && !this.parser.useSSL() && !this.parser.startTLS()) {
                ctx = Utils.createLdapContext(ldapUrl, dn, pwd, Utils.getDefaultLDAPTimeout(), null);
            } else {
                LOG.log(Level.WARNING, "Error retrieving a valid LDAP URL in conf file");
                this.printErrorMessage(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
            }
            ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
            TopologyCache cache = new TopologyCache(adsContext, userData.getTrustManager());
            cache.reloadTopology();
            accepted = this.handleTopologyCache(cache, interactive, userData);
            userData.setRemoteServers(cache.getServers());
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "Error connecting to server: " + ne, ne);
            if (Utils.isCertificateException(ne)) {
                this.printLineBreak();
                this.printErrorMessage(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE.get(ne.getMessage()));
            } else {
                this.printLineBreak();
                this.printErrorMessage(Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), ne));
            }
        }
        catch (TopologyCacheException te) {
            LOG.log(Level.WARNING, "Error connecting to server: " + te, te);
            this.printErrorMessage(Utils.getStringRepresentation(te));
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error connecting to server: " + t, t);
            this.printErrorMessage(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Error closing connection: " + t, t);
                }
            }
        }
        userData.setUpdateRemoteReplication(accepted);
        return accepted;
    }

    private boolean handleTopologyCache(TopologyCache cache, boolean interactive, UninstallUserData userData) {
        boolean returnValue;
        boolean stopProcessing = false;
        boolean reloadTopologyCache = false;
        ApplicationTrustManager trustManager = userData.getTrustManager();
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        Set<ServerDescriptor> servers = cache.getServers();
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        LinkedHashSet<String> exceptionMsgs = new LinkedHashSet<String>();
        block5: for (TopologyCacheException e : exceptions) {
            if (stopProcessing) break;
            switch (e.getType()) {
                case NOT_GLOBAL_ADMINISTRATOR: {
                    this.printErrorMessage(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                    stopProcessing = true;
                    continue block5;
                }
                case GENERIC_CREATING_CONNECTION: {
                    if (e.getCause() != null && Utils.isCertificateException(e.getCause())) {
                        if (interactive) {
                            if (this.promptForCertificateConfirmation(e.getCause(), trustManager, e.getLdapUrl())) {
                                stopProcessing = true;
                                reloadTopologyCache = true;
                                continue block5;
                            }
                            stopProcessing = true;
                            continue block5;
                        }
                        stopProcessing = true;
                        String url = e.getLdapUrl();
                        int index = url.indexOf("//");
                        String hostPort = url.substring(index + 2);
                        this.printErrorMessage(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(hostPort, e.getCause().getMessage()));
                        continue block5;
                    }
                    exceptionMsgs.add(Utils.getStringRepresentation(e));
                    continue block5;
                }
            }
            exceptionMsgs.add(Utils.getStringRepresentation(e));
        }
        if (interactive) {
            returnValue = !stopProcessing && exceptionMsgs.size() > 0 ? this.confirm(AdminToolMessages.ERR_READING_REGISTERED_SERVERS_CONFIRM_UPDATE_REMOTE.get(Utils.getStringFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR))) : (reloadTopologyCache ? this.updateUserUninstallDataWithRemoteServers(userData, interactive) : !stopProcessing);
        } else if (exceptionMsgs.size() > 0) {
            this.printErrorMessage(Utils.getStringFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR));
            returnValue = false;
        } else {
            returnValue = true;
        }
        return returnValue;
    }
}

