/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.opends.guitools.statuspanel.BaseDNDescriptor;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.ui.SortableTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabasesTableModel
extends AbstractTableModel
implements SortableTableModel,
Comparator<BaseDNDescriptor> {
    private static final long serialVersionUID = -5650762484071136983L;
    private HashSet<BaseDNDescriptor> data = new HashSet();
    private ArrayList<BaseDNDescriptor> dataArray = new ArrayList();
    private final Message[] COLUMN_NAMES = new Message[]{AdminToolMessages.INFO_BASEDN_COLUMN.get(), AdminToolMessages.INFO_BACKENDID_COLUMN.get(), AdminToolMessages.INFO_NUMBER_ENTRIES_COLUMN.get(), AdminToolMessages.INFO_REPLICATED_COLUMN.get(), AdminToolMessages.INFO_MISSING_CHANGES_COLUMN.get(), AdminToolMessages.INFO_AGE_OF_OLDEST_MISSING_CHANGE_COLUMN.get()};
    private int sortColumn = 0;
    private boolean sortAscending = true;
    private boolean displayReplicationInformation;

    public DatabasesTableModel(boolean displayReplicationInformation) {
        this.displayReplicationInformation = displayReplicationInformation;
    }

    public void setData(Set<BaseDNDescriptor> newData) {
        if (!((Object)newData).equals(this.data)) {
            this.data.clear();
            this.data.addAll(newData);
            this.dataArray.clear();
            TreeSet<BaseDNDescriptor> sortedSet = new TreeSet<BaseDNDescriptor>(this);
            sortedSet.addAll(this.data);
            this.dataArray.addAll(sortedSet);
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.dataArray.clear();
        TreeSet<BaseDNDescriptor> sortedSet = new TreeSet<BaseDNDescriptor>(this);
        sortedSet.addAll(this.data);
        this.dataArray.addAll(sortedSet);
        this.fireTableDataChanged();
    }

    @Override
    public int compare(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        int result = 0;
        if (this.sortColumn == 0) {
            result = this.compareDns(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        }
        if (this.sortColumn == 1) {
            result = this.compareBackendIDs(desc1, desc2);
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 2) {
            result = this.compareEntries(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 3) {
            result = this.compareRepl(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 4) {
            result = this.compareMissingChanges(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            }
        } else if (this.sortColumn == 5) {
            result = this.compareAgeOfOldestMissingChange(desc1, desc2);
            if (result == 0) {
                result = this.compareBackendIDs(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareDns(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareEntries(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareRepl(desc1, desc2);
            }
            if (result == 0) {
                result = this.compareMissingChanges(desc1, desc2);
            }
        }
        if (!this.sortAscending) {
            result = -result;
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return this.displayReplicationInformation ? 6 : 4;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object v;
        BaseDNDescriptor desc = this.dataArray.get(row);
        if (col == 0) {
            v = desc.getDn();
        } else if (col == 1) {
            v = desc.getDatabase().getBackendID();
        } else if (col == 2) {
            v = this.getValueForEntries(desc);
        } else if (col == 3) {
            v = this.getStringForReplState(desc);
        } else if (col == 4) {
            v = this.getValueForMissingChanges(desc);
        } else if (col == 5) {
            v = this.getValueForOldestMissingChange(desc);
        } else {
            throw new IllegalArgumentException("Invalid col number: " + col);
        }
        return v;
    }

    @Override
    public String getColumnName(int col) {
        return this.COLUMN_NAMES[col].toString();
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    private int compareBackendIDs(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return desc1.getDatabase().getBackendID().compareTo(desc2.getDatabase().getBackendID());
    }

    private int compareEntries(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        int n1 = desc1.getDatabase().getEntries();
        int n2 = desc2.getDatabase().getEntries();
        return this.compareIntegers(n1, n2);
    }

    private int compareIntegers(int n1, int n2) {
        if (n1 == n2) {
            return 0;
        }
        if (n1 > n2) {
            return 1;
        }
        return -1;
    }

    private int compareDns(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return desc1.getDn().compareTo(desc2.getDn());
    }

    private int compareRepl(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return String.valueOf((Object)desc1.getType()).compareTo(String.valueOf((Object)desc2.getType()));
    }

    private int compareMissingChanges(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return this.compareIntegers(desc1.getMissingChanges(), desc2.getMissingChanges());
    }

    private int compareAgeOfOldestMissingChange(BaseDNDescriptor desc1, BaseDNDescriptor desc2) {
        return this.compareIntegers(desc1.getAgeOfOldestMissingChange(), desc2.getAgeOfOldestMissingChange());
    }

    private Object getValueForEntries(BaseDNDescriptor rep) {
        int nEntries = rep.getDatabase().getEntries();
        Comparable<Integer> v = rep.getDatabase().getBaseDns().size() > 1 && nEntries >= 0 ? AdminToolMessages.INFO_NUMBER_ENTRIES_MULTIPLE_SUFFIXES_IN_DB.get(String.valueOf(nEntries), rep.getDatabase().getBackendID()) : new Integer(nEntries);
        return v;
    }

    private Object getValueForMissingChanges(BaseDNDescriptor rep) {
        Comparable v = rep.getType() == BaseDNDescriptor.Type.REPLICATED ? new Integer(rep.getMissingChanges()) : AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get();
        return v;
    }

    private Object getValueForOldestMissingChange(BaseDNDescriptor rep) {
        Object v;
        if (rep.getType() == BaseDNDescriptor.Type.REPLICATED) {
            int age = rep.getAgeOfOldestMissingChange();
            if (age >= 0) {
                int remainingSeconds = age % 60;
                int minutes = age / 60;
                int remainingMinutes = minutes % 60;
                int hours = minutes / 60;
                String sMinutes = remainingMinutes >= 10 ? String.valueOf(remainingMinutes) : "0" + remainingMinutes;
                String sSeconds = remainingSeconds >= 10 ? String.valueOf(remainingSeconds) : "0" + remainingSeconds;
                String sHours = hours >= 10 ? String.valueOf(hours) : "0" + hours;
                v = sHours + ":" + sMinutes + ":" + sSeconds;
            } else {
                v = new Integer(age);
            }
        } else {
            v = AdminToolMessages.INFO_NOT_APPLICABLE_LABEL.get();
        }
        return v;
    }

    private Message getStringForReplState(BaseDNDescriptor rep) {
        Message s = rep.getType() == BaseDNDescriptor.Type.REPLICATED ? AdminToolMessages.INFO_SUFFIX_REPLICATED_LABEL.get() : AdminToolMessages.INFO_SUFFIX_NOT_REPLICATED_LABEL.get();
        return s;
    }
}

