/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLoader
extends Thread {
    private Map<ADSContext.ServerProperty, Object> serverProperties;
    private boolean isOver;
    private boolean isInterrupted;
    private String lastLdapUrl;
    private TopologyCacheException lastException;
    private ServerDescriptor serverDescriptor;
    private ApplicationTrustManager trustManager;
    private String dn;
    private String pwd;
    private static final Logger LOG = Logger.getLogger(ServerLoader.class.getName());

    public ServerLoader(Map<ADSContext.ServerProperty, Object> serverProperties, String dn, String pwd, ApplicationTrustManager trustManager) {
        this.serverProperties = serverProperties;
        this.dn = dn;
        this.pwd = pwd;
        this.trustManager = trustManager;
    }

    public ServerDescriptor getServerDescriptor() {
        if (this.serverDescriptor == null) {
            this.serverDescriptor = ServerDescriptor.createStandalone(this.serverProperties);
        }
        this.serverDescriptor.setLastException(this.lastException);
        return this.serverDescriptor;
    }

    public TopologyCacheException getLastException() {
        return this.lastException;
    }

    @Override
    public void interrupt() {
        if (!this.isOver) {
            this.isInterrupted = true;
            String ldapUrl = this.getLdapsUrl(this.serverProperties);
            if (ldapUrl == null) {
                ldapUrl = this.getStartTlsLdapUrl(this.serverProperties);
            }
            if (ldapUrl == null) {
                ldapUrl = this.getLdapUrl(this.serverProperties);
            }
            this.lastException = new TopologyCacheException(TopologyCacheException.Type.TIMEOUT, null, this.trustManager, ldapUrl);
            LOG.log(Level.WARNING, "Timeout reading server: " + ldapUrl);
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastException = null;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createContext();
            this.serverDescriptor = ServerDescriptor.createStandalone(ctx);
            this.serverDescriptor.setAdsProperties(this.serverProperties);
        }
        catch (NoPermissionException npe) {
            LOG.log(Level.WARNING, "Permissions error reading server: " + this.getLastLdapUrl(), npe);
            this.lastException = !this.isAdministratorDn() ? new TopologyCacheException(TopologyCacheException.Type.NOT_GLOBAL_ADMINISTRATOR, npe, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.NO_PERMISSIONS, npe, this.trustManager, this.getLastLdapUrl());
        }
        catch (AuthenticationException ae) {
            LOG.log(Level.WARNING, "Authentication exception: " + this.getLastLdapUrl(), ae);
            this.lastException = !this.isAdministratorDn() ? new TopologyCacheException(TopologyCacheException.Type.NOT_GLOBAL_ADMINISTRATOR, ae, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, ae, this.trustManager, this.getLastLdapUrl());
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "NamingException error reading server: " + this.getLastLdapUrl(), ne);
            this.lastException = ctx == null ? new TopologyCacheException(TopologyCacheException.Type.GENERIC_CREATING_CONNECTION, ne, this.trustManager, this.getLastLdapUrl()) : new TopologyCacheException(TopologyCacheException.Type.GENERIC_READING_SERVER, ne, this.trustManager, this.getLastLdapUrl());
        }
        catch (Throwable t) {
            if (!this.isInterrupted) {
                LOG.log(Level.WARNING, "Generic error reading server: " + this.getLastLdapUrl(), t);
                LOG.log(Level.WARNING, "server Properties: " + this.serverProperties);
                this.lastException = new TopologyCacheException(TopologyCacheException.Type.BUG, t);
            }
        }
        finally {
            this.isOver = true;
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    public InitialLdapContext createContext() throws NamingException {
        InitialLdapContext ctx = null;
        this.trustManager.resetLastRefusedItems();
        String host = (String)this.serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
        this.trustManager.setHost(host);
        this.lastLdapUrl = this.getLdapsUrl(this.serverProperties);
        if (this.lastLdapUrl == null) {
            this.lastLdapUrl = this.getStartTlsLdapUrl(this.serverProperties);
            if (this.lastLdapUrl == null) {
                this.lastLdapUrl = this.getLdapUrl(this.serverProperties);
                ctx = ConnectionUtils.createLdapContext(this.lastLdapUrl, this.dn, this.pwd, ConnectionUtils.getDefaultLDAPTimeout(), null);
            } else {
                ctx = ConnectionUtils.createStartTLSContext(this.lastLdapUrl, this.dn, this.pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, this.trustManager, null, null);
            }
        } else {
            ctx = ConnectionUtils.createLdapsContext(this.lastLdapUrl, this.dn, this.pwd, ConnectionUtils.getDefaultLDAPTimeout(), null, this.trustManager, null);
        }
        return ctx;
    }

    private String getLastLdapUrl() {
        return this.lastLdapUrl;
    }

    private String getLdapUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        boolean ldapEnabled;
        String ldapUrl = null;
        Object v = serverProperties.get((Object)ADSContext.ServerProperty.LDAP_ENABLED);
        boolean bl = ldapEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        if (ldapEnabled) {
            ldapUrl = "ldap://" + this.getHostNameForLdapUrl(serverProperties) + ":" + serverProperties.get((Object)ADSContext.ServerProperty.LDAP_PORT);
        }
        return ldapUrl;
    }

    private String getStartTlsLdapUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        boolean startTLSEnabled;
        String ldapUrl = null;
        Object v = serverProperties.get((Object)ADSContext.ServerProperty.LDAP_ENABLED);
        boolean ldapEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        v = serverProperties.get((Object)ADSContext.ServerProperty.STARTTLS_ENABLED);
        boolean bl = startTLSEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        if (ldapEnabled && startTLSEnabled) {
            ldapUrl = "ldap://" + this.getHostNameForLdapUrl(serverProperties) + ":" + serverProperties.get((Object)ADSContext.ServerProperty.LDAP_PORT);
        }
        return ldapUrl;
    }

    private String getLdapsUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        boolean ldapsEnabled;
        String ldapsUrl = null;
        Object v = serverProperties.get((Object)ADSContext.ServerProperty.LDAPS_ENABLED);
        boolean bl = ldapsEnabled = v != null && "true".equalsIgnoreCase(v.toString());
        if (ldapsEnabled) {
            ldapsUrl = "ldaps://" + this.getHostNameForLdapUrl(serverProperties) + ":" + serverProperties.get((Object)ADSContext.ServerProperty.LDAPS_PORT);
        }
        return ldapsUrl;
    }

    private String getHostNameForLdapUrl(Map<ADSContext.ServerProperty, Object> serverProperties) {
        String host = (String)serverProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
        return ConnectionUtils.getHostNameForLdapUrl(host);
    }

    private boolean isAdministratorDn() {
        boolean isAdministratorDn = false;
        try {
            LdapName theDn = new LdapName(this.dn);
            LdapName containerDn = new LdapName(ADSContext.getAdministratorContainerDN());
            isAdministratorDn = theDn.startsWith(containerDn);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error parsing authentication DNs.", t);
        }
        return isAdministratorDn;
    }
}

