/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.io.IOException;
import java.net.ConnectException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.opends.admin.ads.util.BlindHostnameVerifier;
import org.opends.admin.ads.util.BlindTrustManager;
import org.opends.admin.ads.util.TrustedSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtils {
    private static final int DEFAULT_LDAP_CONNECT_TIMEOUT = 10000;

    private ConnectionUtils() {
    }

    public static InitialLdapContext createLdapContext(String ldapURL, String dn, String pwd, int timeout, Hashtable<String, String> env) throws NamingException {
        env = env != null ? new Hashtable<String, String>(env) : new Hashtable();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        if (timeout >= 1) {
            env.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(timeout));
        }
        if (dn != null) {
            env.put("java.naming.security.principal", dn);
        }
        if (pwd != null) {
            env.put("java.naming.security.credentials", pwd);
        }
        final Object[] pair = new Object[]{null, null};
        final Hashtable<String, String> fEnv = env;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    pair[0] = new InitialLdapContext(fEnv, null);
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    pair[1] = t;
                }
            }
        });
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static InitialLdapContext createLdapsContext(String ldapsURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager, KeyManager keyManager) throws NamingException {
        env = env != null ? new Hashtable<String, String>(env) : new Hashtable();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapsURL);
        env.put("java.naming.ldap.factory.socket", TrustedSocketFactory.class.getName());
        if (dn != null) {
            env.put("java.naming.security.principal", dn);
        }
        if (pwd != null) {
            env.put("java.naming.security.credentials", pwd);
        }
        if (trustManager == null) {
            trustManager = new BlindTrustManager();
        }
        final Object[] pair = new Object[]{null, null};
        final Hashtable<String, String> fEnv = env;
        final TrustManager fTrustManager = trustManager;
        final KeyManager fKeyManage = keyManager;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    TrustedSocketFactory.setCurrentThreadTrustManager(fTrustManager, fKeyManage);
                    pair[0] = new InitialLdapContext(fEnv, null);
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (RuntimeException re) {
                    pair[1] = re;
                }
            }
        });
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static InitialLdapContext createStartTLSContext(String ldapURL, String dn, String pwd, int timeout, Hashtable<String, String> env, TrustManager trustManager, KeyManager keyManager, HostnameVerifier verifier) throws NamingException {
        if (trustManager == null) {
            trustManager = new BlindTrustManager();
        }
        if (verifier == null) {
            verifier = new BlindHostnameVerifier();
        }
        env = env != null ? new Hashtable<String, String>(env) : new Hashtable();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        env.put("java.naming.security.authentication", "none");
        final Object[] pair = new Object[]{null, null};
        final Hashtable<String, String> fEnv = env;
        final String fDn = dn;
        final String fPwd = pwd;
        final TrustManager fTrustManager = trustManager;
        final KeyManager fKeyManager = keyManager;
        final HostnameVerifier fVerifier = verifier;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    InitialLdapContext result = new InitialLdapContext(fEnv, null);
                    StartTlsResponse tls = (StartTlsResponse)result.extendedOperation(new StartTlsRequest());
                    tls.setHostnameVerifier(fVerifier);
                    try {
                        tls.negotiate(new TrustedSocketFactory(fTrustManager, fKeyManager));
                    }
                    catch (IOException x) {
                        CommunicationException xx = new CommunicationException("Failed to negotiate Start TLS operation");
                        xx.initCause(x);
                        result.close();
                        throw xx;
                    }
                    if (fDn != null) {
                        result.addToEnvironment("java.naming.security.authentication", "simple");
                        result.addToEnvironment("java.naming.security.principal", fDn);
                        if (fPwd != null) {
                            result.addToEnvironment("java.naming.security.credentials", fPwd);
                        }
                        result.reconnect(null);
                    }
                    pair[0] = result;
                }
                catch (NamingException ne) {
                    pair[1] = ne;
                }
                catch (RuntimeException re) {
                    pair[1] = re;
                }
            }
        });
        return ConnectionUtils.getInitialLdapContext(t, pair, timeout);
    }

    public static boolean canConnectAsAdministrativeUser(String ldapUrl, String dn, String pwd) {
        boolean canConnectAsAdministrativeUser = false;
        try {
            InitialLdapContext ctx = ConnectionUtils.createLdapContext(ldapUrl, dn, pwd, ConnectionUtils.getDefaultLDAPTimeout(), null);
            SearchControls searchControls = new SearchControls();
            searchControls.setCountLimit(1L);
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[]{"dn"});
            ctx.search("cn=config", "objectclass=*", searchControls);
            canConnectAsAdministrativeUser = true;
        }
        catch (NamingException ne) {
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unexpected throwable.", t);
        }
        return canConnectAsAdministrativeUser;
    }

    private static InitialLdapContext getInitialLdapContext(Thread t, Object[] pair, int timeout) throws NamingException {
        try {
            if (timeout > 0) {
                t.start();
                t.join(timeout);
            } else {
                t.run();
            }
        }
        catch (InterruptedException x) {
            // empty catch block
        }
        boolean throwException = false;
        if (timeout > 0 && t.isAlive()) {
            t.interrupt();
            try {
                t.join(2000L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
            throwException = true;
        }
        if (pair[0] == null && pair[1] == null) {
            throwException = true;
        }
        if (throwException) {
            ConnectException x = new ConnectException("Connection timed out");
            CommunicationException xx = new CommunicationException("Connection timed out");
            xx.initCause(x);
            throw xx;
        }
        if (pair[1] != null) {
            if (pair[1] instanceof NamingException) {
                throw (NamingException)pair[1];
            }
            if (pair[1] instanceof RuntimeException) {
                throw (RuntimeException)pair[1];
            }
            if (pair[1] instanceof Throwable) {
                throw new IllegalStateException("Unexpected throwable occurred", (Throwable)pair[1]);
            }
        }
        return (InitialLdapContext)pair[0];
    }

    public static int getDefaultLDAPTimeout() {
        return 10000;
    }

    public static String getHostNameForLdapUrl(String host) {
        if (host != null && host.indexOf(":") != -1) {
            if (!(host = host.trim()).startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        return host;
    }

    public static boolean isCertificateException(Throwable t) {
        boolean returnValue = false;
        while (!returnValue && t != null) {
            returnValue = t instanceof SSLHandshakeException || t instanceof GeneralSecurityException;
            t = t.getCause();
        }
        return returnValue;
    }

    public static String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        Attribute attr;
        String v = null;
        Attributes attrs = entry.getAttributes();
        if (attrs != null && (attr = attrs.get(attrName)) != null && attr.size() > 0) {
            Object o = attr.get();
            v = o instanceof String ? (String)o : String.valueOf(o);
        }
        return v;
    }

    public static Set<String> getValues(SearchResult entry, String attrName) throws NamingException {
        Attribute attr;
        HashSet<String> values = new HashSet<String>();
        Attributes attrs = entry.getAttributes();
        if (attrs != null && (attr = attrs.get(attrName)) != null) {
            for (int i = 0; i < attr.size(); ++i) {
                values.add((String)attr.get(i));
            }
        }
        return values;
    }
}

