/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ApplicationTrustManager
implements X509TrustManager {
    private static final Logger LOG = Logger.getLogger(ApplicationTrustManager.class.getName());
    private X509TrustManager sunJSSEX509TrustManager;
    private String lastRefusedAuthType;
    private X509Certificate[] lastRefusedChain;
    private Cause lastRefusedCause = null;
    private ArrayList<X509Certificate[]> acceptedChains = new ArrayList();
    private ArrayList<String> acceptedAuthTypes = new ArrayList();
    private ArrayList<String> acceptedHosts = new ArrayList();
    private String host;

    public ApplicationTrustManager(KeyStore keystore) {
        TrustManagerFactory tmf = null;
        String algo = "SunX509";
        String provider = "SunJSSE";
        try {
            tmf = TrustManagerFactory.getInstance(algo, provider);
            tmf.init(keystore);
            this.sunJSSEX509TrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.WARNING, "Error with the algorithm", e);
        }
        catch (NoSuchProviderException e) {
            LOG.log(Level.WARNING, "Error with the provider", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.WARNING, "Error with the keystore", e);
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean explicitlyAccepted = false;
        try {
            if (this.sunJSSEX509TrustManager != null) {
                try {
                    this.sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
                }
                catch (CertificateException ce) {
                    this.verifyAcceptedCertificates(chain, authType);
                    explicitlyAccepted = true;
                }
            } else {
                this.verifyAcceptedCertificates(chain, authType);
                explicitlyAccepted = true;
            }
        }
        catch (CertificateException ce) {
            this.lastRefusedChain = chain;
            this.lastRefusedAuthType = authType;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            throw ce;
        }
        if (!explicitlyAccepted) {
            try {
                this.verifyHostName(chain, authType);
            }
            catch (CertificateException ce) {
                this.lastRefusedChain = chain;
                this.lastRefusedAuthType = authType;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                throw ce;
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean explicitlyAccepted = false;
        try {
            if (this.sunJSSEX509TrustManager != null) {
                try {
                    this.sunJSSEX509TrustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException ce) {
                    this.verifyAcceptedCertificates(chain, authType);
                    explicitlyAccepted = true;
                }
            } else {
                this.verifyAcceptedCertificates(chain, authType);
                explicitlyAccepted = true;
            }
        }
        catch (CertificateException ce) {
            this.lastRefusedChain = chain;
            this.lastRefusedAuthType = authType;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            throw ce;
        }
        if (!explicitlyAccepted) {
            try {
                this.verifyHostName(chain, authType);
            }
            catch (CertificateException ce) {
                this.lastRefusedChain = chain;
                this.lastRefusedAuthType = authType;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                throw ce;
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.sunJSSEX509TrustManager != null) {
            return this.sunJSSEX509TrustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }

    public void acceptCertificate(X509Certificate[] chain, String authType, String host) {
        this.acceptedChains.add(chain);
        this.acceptedAuthTypes.add(authType);
        this.acceptedHosts.add(host);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void resetLastRefusedItems() {
        this.lastRefusedAuthType = null;
        this.lastRefusedChain = null;
        this.lastRefusedCause = null;
    }

    public ApplicationTrustManager createCopy() {
        ApplicationTrustManager copy = new ApplicationTrustManager(null);
        copy.lastRefusedAuthType = this.lastRefusedAuthType;
        copy.lastRefusedChain = this.lastRefusedChain;
        copy.lastRefusedCause = this.lastRefusedCause;
        copy.acceptedChains.addAll(this.acceptedChains);
        copy.acceptedAuthTypes.addAll(this.acceptedAuthTypes);
        copy.acceptedHosts.addAll(this.acceptedHosts);
        copy.host = this.host;
        return copy;
    }

    private void verifyAcceptedCertificates(X509Certificate[] chain, String authType) throws CertificateException {
        boolean found = false;
        for (int i = 0; i < this.acceptedChains.size() && !found; ++i) {
            if (!authType.equals(this.acceptedAuthTypes.get(i))) continue;
            X509Certificate[] current = this.acceptedChains.get(i);
            found = current.length == chain.length;
            for (int j = 0; j < chain.length && found; ++j) {
                found = chain[j].equals(current[j]);
            }
        }
        if (!found) {
            throw new CertificateException("Certificate not in list of accepted certificates");
        }
    }

    private void verifyHostName(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.host != null) {
            boolean matches = false;
            try {
                LdapName dn = new LdapName(chain[0].getSubjectX500Principal().getName());
                Rdn rdn = dn.getRdn(0);
                String value = rdn.getValue().toString();
                matches = this.host.equalsIgnoreCase(value);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error parsing subject dn: " + chain[0].getSubjectX500Principal(), t);
            }
            if (!matches) {
                throw new CertificateException("Hostname mismatch between host name " + this.host + " and subject DN: " + chain[0].getSubjectX500Principal());
            }
        }
    }

    public String getLastRefusedAuthType() {
        return this.lastRefusedAuthType;
    }

    public Cause getLastRefusedCause() {
        return this.lastRefusedCause;
    }

    public X509Certificate[] getLastRefusedChain() {
        return this.lastRefusedChain;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        NOT_TRUSTED,
        HOST_NAME_MISMATCH;

    }
}

