/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ConnectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDescriptor {
    private Map<ADSContext.ServerProperty, Object> adsProperties = new HashMap<ADSContext.ServerProperty, Object>();
    private Set<ReplicaDescriptor> replicas = new HashSet<ReplicaDescriptor>();
    private Map<ServerProperty, Object> serverProperties = new HashMap<ServerProperty, Object>();
    private TopologyCacheException lastException;
    private static final Logger LOG = Logger.getLogger(ServerDescriptor.class.getName());

    private ServerDescriptor() {
    }

    public Set<ReplicaDescriptor> getReplicas() {
        HashSet<ReplicaDescriptor> copy = new HashSet<ReplicaDescriptor>();
        copy.addAll(this.replicas);
        return copy;
    }

    public void setReplicas(Set<ReplicaDescriptor> replicas) {
        this.replicas.clear();
        this.replicas.addAll(replicas);
    }

    public Map<ADSContext.ServerProperty, Object> getAdsProperties() {
        return this.adsProperties;
    }

    public Map<ServerProperty, Object> getServerProperties() {
        return this.serverProperties;
    }

    public boolean isRegistered() {
        return !this.adsProperties.isEmpty();
    }

    public void setAdsProperties(Map<ADSContext.ServerProperty, Object> adsProperties) {
        this.adsProperties = adsProperties;
    }

    public String getHostName() {
        String host = (String)this.serverProperties.get((Object)ServerProperty.HOST_NAME);
        if (host == null) {
            host = (String)this.adsProperties.get((Object)ADSContext.ServerProperty.HOST_NAME);
        }
        return host;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getHostPort(boolean securePreferred) {
        String host = this.getHostName();
        int port = -1;
        if (!this.serverProperties.isEmpty()) {
            int i;
            ArrayList s = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_ENABLED);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAP_PORT);
            if (s != null) {
                for (i = 0; i < s.size(); ++i) {
                    if (!Boolean.TRUE.equals(s.get(i))) continue;
                    port = (Integer)p.get(i);
                    break;
                }
            }
            if (!securePreferred) return host + ":" + port;
            s = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAPS_ENABLED);
            p = (ArrayList)this.serverProperties.get((Object)ServerProperty.LDAPS_PORT);
            if (s == null) return host + ":" + port;
            for (i = 0; i < s.size(); ++i) {
                if (!Boolean.TRUE.equals(s.get(i))) continue;
                port = (Integer)p.get(i);
                return host + ":" + port;
            }
            return host + ":" + port;
        }
        Object v = this.adsProperties.get((Object)ADSContext.ServerProperty.LDAPS_ENABLED);
        boolean secure = securePreferred && "true".equalsIgnoreCase(String.valueOf(v));
        try {
            if (secure) {
                port = Integer.parseInt((String)this.adsProperties.get((Object)ADSContext.ServerProperty.LDAPS_PORT));
                return host + ":" + port;
            }
            port = Integer.parseInt((String)this.adsProperties.get((Object)ADSContext.ServerProperty.LDAP_PORT));
            return host + ":" + port;
        }
        catch (Throwable t) {
            // empty catch block
        }
        return host + ":" + port;
    }

    public String getId() {
        StringBuilder buf = new StringBuilder();
        if (this.serverProperties.size() > 0) {
            buf.append(this.serverProperties.get((Object)ServerProperty.HOST_NAME));
            ServerProperty[] props = new ServerProperty[]{ServerProperty.LDAP_PORT, ServerProperty.LDAPS_PORT, ServerProperty.LDAP_ENABLED, ServerProperty.LDAPS_ENABLED};
            for (int i = 0; i < props.length; ++i) {
                ArrayList s = (ArrayList)this.serverProperties.get((Object)props[i]);
                for (Object o : s) {
                    buf.append(":" + o);
                }
            }
        } else {
            ADSContext.ServerProperty[] props = new ADSContext.ServerProperty[]{ADSContext.ServerProperty.HOST_NAME, ADSContext.ServerProperty.LDAP_PORT, ADSContext.ServerProperty.LDAPS_PORT, ADSContext.ServerProperty.LDAP_ENABLED, ADSContext.ServerProperty.LDAPS_ENABLED};
            for (int i = 0; i < props.length; ++i) {
                if (i != 0) {
                    buf.append(":");
                }
                buf.append(this.adsProperties.get((Object)props[i]));
            }
        }
        return buf.toString();
    }

    public TopologyCacheException getLastException() {
        return this.lastException;
    }

    public void setLastException(TopologyCacheException lastException) {
        this.lastException = lastException;
    }

    public void updateAdsPropertiesWithServerProperties() {
        this.adsProperties.put(ADSContext.ServerProperty.HOST_NAME, this.getHostName());
        ServerProperty[][] sProps = new ServerProperty[][]{{ServerProperty.LDAP_ENABLED, ServerProperty.LDAP_PORT}, {ServerProperty.LDAPS_ENABLED, ServerProperty.LDAPS_PORT}, {ServerProperty.JMX_ENABLED, ServerProperty.JMX_PORT}, {ServerProperty.JMXS_ENABLED, ServerProperty.JMXS_PORT}};
        ADSContext.ServerProperty[][] adsProps = new ADSContext.ServerProperty[][]{{ADSContext.ServerProperty.LDAP_ENABLED, ADSContext.ServerProperty.LDAP_PORT}, {ADSContext.ServerProperty.LDAPS_ENABLED, ADSContext.ServerProperty.LDAPS_PORT}, {ADSContext.ServerProperty.JMX_ENABLED, ADSContext.ServerProperty.JMX_PORT}, {ADSContext.ServerProperty.JMXS_ENABLED, ADSContext.ServerProperty.JMXS_PORT}};
        for (int i = 0; i < sProps.length; ++i) {
            ArrayList s = (ArrayList)this.serverProperties.get((Object)sProps[i][0]);
            ArrayList p = (ArrayList)this.serverProperties.get((Object)sProps[i][1]);
            if (s == null) continue;
            int port = -1;
            int j = 0;
            while (j < s.size()) {
                if (Boolean.TRUE.equals(s.get(j))) {
                    port = (Integer)p.get(j);
                    break;
                }
                ++i;
            }
            if (port == -1) {
                this.adsProperties.put(adsProps[i][0], "false");
                if (p.size() > 0) {
                    port = (Integer)p.iterator().next();
                }
            } else {
                this.adsProperties.put(adsProps[i][0], "true");
            }
            this.adsProperties.put(adsProps[i][1], String.valueOf(port));
        }
    }

    public static ServerDescriptor createStandalone(Map<ADSContext.ServerProperty, Object> adsProperties) {
        ServerDescriptor desc = new ServerDescriptor();
        desc.setAdsProperties(adsProperties);
        return desc;
    }

    public static ServerDescriptor createStandalone(InitialLdapContext ctx) throws NamingException {
        ServerDescriptor desc = new ServerDescriptor();
        ServerDescriptor.updateLdapConfiguration(desc, ctx);
        ServerDescriptor.updateJmxConfiguration(desc, ctx);
        ServerDescriptor.updateReplicas(desc, ctx);
        ServerDescriptor.updateReplication(desc, ctx);
        String s = (String)ctx.getEnvironment().get("java.naming.provider.url");
        try {
            URI ldapURL = new URI(s);
            desc.serverProperties.put(ServerProperty.HOST_NAME, ldapURL.getHost());
        }
        catch (URISyntaxException use) {
            LOG.log(Level.WARNING, "Error parsing ldap URL " + s, use);
        }
        return desc;
    }

    private static void updateLdapConfiguration(ServerDescriptor desc, InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-connection-handler-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "objectclass"});
        String filter = "(objectclass=ds-cfg-ldap-connection-handler)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        ArrayList<Integer> ldapPorts = new ArrayList<Integer>();
        ArrayList<Integer> ldapsPorts = new ArrayList<Integer>();
        ArrayList<Boolean> ldapEnabled = new ArrayList<Boolean>();
        ArrayList<Boolean> ldapsEnabled = new ArrayList<Boolean>();
        desc.serverProperties.put(ServerProperty.LDAP_PORT, ldapPorts);
        desc.serverProperties.put(ServerProperty.LDAPS_PORT, ldapsPorts);
        desc.serverProperties.put(ServerProperty.LDAP_ENABLED, ldapEnabled);
        desc.serverProperties.put(ServerProperty.LDAPS_ENABLED, ldapsEnabled);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            String port = ServerDescriptor.getFirstValue(sr, "ds-cfg-listen-port");
            boolean isSecure = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-use-ssl"));
            boolean enabled = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-connection-handler-enabled"));
            if (isSecure) {
                ldapsPorts.add(new Integer(port));
                ldapsEnabled.add(enabled);
                continue;
            }
            ldapPorts.add(new Integer(port));
            ldapEnabled.add(enabled);
        }
    }

    private static void updateJmxConfiguration(ServerDescriptor desc, InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-connection-handler-enabled", "ds-cfg-listen-address", "ds-cfg-listen-port", "ds-cfg-use-ssl", "objectclass"});
        String filter = "(objectclass=ds-cfg-jmx-connection-handler)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        ArrayList<Integer> jmxPorts = new ArrayList<Integer>();
        ArrayList<Integer> jmxsPorts = new ArrayList<Integer>();
        ArrayList<Boolean> jmxEnabled = new ArrayList<Boolean>();
        ArrayList<Boolean> jmxsEnabled = new ArrayList<Boolean>();
        desc.serverProperties.put(ServerProperty.JMX_PORT, jmxPorts);
        desc.serverProperties.put(ServerProperty.JMXS_PORT, jmxsPorts);
        desc.serverProperties.put(ServerProperty.JMX_ENABLED, jmxEnabled);
        desc.serverProperties.put(ServerProperty.JMXS_ENABLED, jmxsEnabled);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            String port = ServerDescriptor.getFirstValue(sr, "ds-cfg-listen-port");
            boolean isSecure = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-use-ssl"));
            boolean enabled = "true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-connection-handler-enabled"));
            if (isSecure) {
                jmxsPorts.add(new Integer(port));
                jmxsEnabled.add(enabled);
                continue;
            }
            jmxPorts.add(new Integer(port));
            jmxEnabled.add(enabled);
        }
    }

    private static void updateReplicas(ServerDescriptor desc, InitialLdapContext ctx) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-backend-base-dn", "ds-cfg-backend-id"});
        String filter = "(objectclass=ds-cfg-backend)";
        LdapName jndiName = new LdapName("cn=config");
        NamingEnumeration<SearchResult> databases = ctx.search((Name)jndiName, filter, ctls);
        while (databases.hasMore()) {
            SearchResult sr = databases.next();
            String id = ServerDescriptor.getFirstValue(sr, "ds-cfg-backend-id");
            if (ServerDescriptor.isConfigBackend(id)) continue;
            Set<String> baseDns = ServerDescriptor.getValues(sr, "ds-cfg-backend-base-dn");
            int nEntries = ServerDescriptor.getEntryCount(ctx, id);
            Set<ReplicaDescriptor> replicas = desc.getReplicas();
            for (String baseDn : baseDns) {
                SuffixDescriptor suffix = new SuffixDescriptor();
                suffix.setDN(baseDn);
                ReplicaDescriptor replica = new ReplicaDescriptor();
                replica.setServer(desc);
                replicas.add(replica);
                HashSet<ReplicaDescriptor> r = new HashSet<ReplicaDescriptor>();
                r.add(replica);
                suffix.setReplicas(r);
                replica.setSuffix(suffix);
                if (baseDns.size() == 1) {
                    replica.setEntries(nEntries);
                    continue;
                }
                replica.setEntries(-1);
            }
            desc.setReplicas(replicas);
        }
    }

    private static void updateReplication(ServerDescriptor desc, InitialLdapContext ctx) throws NamingException {
        SearchResult sr;
        NamingEnumeration<SearchResult> syncProviders;
        boolean replicationEnabled = false;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"ds-cfg-synchronization-provider-enabled"});
        String filter = "(objectclass=ds-cfg-synchronization-provider)";
        LdapName jndiName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        try {
            syncProviders = ctx.search((Name)jndiName, filter, ctls);
            while (syncProviders.hasMore()) {
                sr = syncProviders.next();
                if (!"true".equalsIgnoreCase(ServerDescriptor.getFirstValue(sr, "ds-cfg-synchronization-provider-enabled"))) continue;
                replicationEnabled = true;
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
        desc.serverProperties.put(ServerProperty.IS_REPLICATION_ENABLED, replicationEnabled ? Boolean.TRUE : Boolean.FALSE);
        ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{"ds-cfg-replication-dn", "ds-cfg-replication-server", "ds-cfg-directory-server-id"});
        filter = "(objectclass=ds-cfg-replication-domain-config)";
        jndiName = new LdapName("cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        try {
            syncProviders = ctx.search((Name)jndiName, filter, ctls);
            while (syncProviders.hasMore()) {
                sr = syncProviders.next();
                int id = Integer.parseInt(ServerDescriptor.getFirstValue(sr, "ds-cfg-directory-server-id"));
                Set<String> replicationServers = ServerDescriptor.getValues(sr, "ds-cfg-replication-server");
                Set<String> dns = ServerDescriptor.getValues(sr, "ds-cfg-replication-dn");
                for (String dn : dns) {
                    for (ReplicaDescriptor replica : desc.getReplicas()) {
                        if (!ServerDescriptor.areDnsEqual(replica.getSuffix().getDN(), dn)) continue;
                        replica.setReplicationId(id);
                        replica.setReplicationServers(replicationServers);
                    }
                }
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
        ctls = new SearchControls();
        ctls.setSearchScope(0);
        ctls.setReturningAttributes(new String[]{"ds-cfg-replication-server-port", "ds-cfg-replication-server", "ds-cfg-replication-server-id"});
        filter = "(objectclass=ds-cfg-replication-server-config)";
        jndiName = new LdapName("cn=Replication Server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config");
        desc.serverProperties.put(ServerProperty.IS_REPLICATION_SERVER, Boolean.FALSE);
        try {
            NamingEnumeration<SearchResult> entries = ctx.search((Name)jndiName, filter, ctls);
            while (entries.hasMore()) {
                sr = entries.next();
                desc.serverProperties.put(ServerProperty.IS_REPLICATION_SERVER, Boolean.TRUE);
                String v = ServerDescriptor.getFirstValue(sr, "ds-cfg-replication-server-port");
                desc.serverProperties.put(ServerProperty.REPLICATION_SERVER_PORT, Integer.parseInt(v));
                v = ServerDescriptor.getFirstValue(sr, "ds-cfg-replication-server-id");
                desc.serverProperties.put(ServerProperty.REPLICATION_SERVER_ID, Integer.parseInt(v));
                Set<String> values = ServerDescriptor.getValues(sr, "ds-cfg-replication-server");
                desc.serverProperties.put(ServerProperty.EXTERNAL_REPLICATION_SERVERS, values);
            }
        }
        catch (NameNotFoundException nse) {
            // empty catch block
        }
    }

    private static int getEntryCount(InitialLdapContext ctx, String backendID) throws NamingException {
        int nEntries = -1;
        String v = null;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        ctls.setReturningAttributes(new String[]{"ds-backend-entry-count"});
        String filter = "(ds-backend-id=" + backendID + ")";
        LdapName jndiName = new LdapName("cn=monitor");
        NamingEnumeration<SearchResult> listeners = ctx.search((Name)jndiName, filter, ctls);
        while (listeners.hasMore()) {
            SearchResult sr = listeners.next();
            v = ServerDescriptor.getFirstValue(sr, "ds-backend-entry-count");
        }
        try {
            nEntries = Integer.parseInt(v);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return nEntries;
    }

    private static String getFirstValue(SearchResult entry, String attrName) throws NamingException {
        return ConnectionUtils.getFirstValue(entry, attrName);
    }

    private static Set<String> getValues(SearchResult entry, String attrName) throws NamingException {
        return ConnectionUtils.getValues(entry, attrName);
    }

    private static boolean isConfigBackend(String id) {
        return "tasks".equalsIgnoreCase(id) || "schema".equalsIgnoreCase(id) || "config".equalsIgnoreCase(id) || "monitor".equalsIgnoreCase(id) || "backup".equalsIgnoreCase(id);
    }

    private static boolean areDnsEqual(String dn1, String dn2) {
        boolean areDnsEqual = false;
        try {
            LdapName name1 = new LdapName(dn1);
            LdapName name2 = new LdapName(dn2);
            areDnsEqual = name1.equals(name2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return areDnsEqual;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerProperty {
        HOST_NAME,
        LDAP_PORT,
        LDAPS_PORT,
        LDAP_ENABLED,
        LDAPS_ENABLED,
        JMX_PORT,
        JMXS_PORT,
        JMX_ENABLED,
        JMXS_ENABLED,
        REPLICATION_SERVER_PORT,
        IS_REPLICATION_SERVER,
        IS_REPLICATION_ENABLED,
        EXTERNAL_REPLICATION_SERVERS,
        REPLICATION_SERVER_ID;

    }
}

