/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads;

import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.client.JEBackendCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.JEBackendCfgDefn;
import org.opends.server.types.DN;

public class ADSContextHelper {
    public void removeAdministrationSuffix(InitialLdapContext ctx, String backendName) throws ADSContextException {
        try {
            SortedSet<DN> suffixes;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            BackendCfgClient backend = null;
            try {
                backend = root.getBackend(backendName);
            }
            catch (ManagedObjectNotFoundException monfe) {
                // empty catch block
            }
            if (backend != null && (suffixes = backend.getBackendBaseDN()) != null && suffixes.remove(DN.decode(ADSContext.getAdministrationSuffixDN()))) {
                if (suffixes.size() > 0) {
                    backend.setBackendBaseDN(suffixes);
                    backend.commit();
                } else {
                    root.removeBackend(backendName);
                }
            }
        }
        catch (Throwable t) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, t);
        }
    }

    public void createAdministrationSuffix(InitialLdapContext ctx, String backendName, String dbDirectory, String importTempDirectory) throws ADSContextException {
        try {
            SortedSet<DN> suffixes;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            JEBackendCfgClient backend = null;
            try {
                backend = (JEBackendCfgClient)root.getBackend(backendName);
            }
            catch (ManagedObjectNotFoundException e) {
            }
            catch (ClassCastException cce) {
                throw new ADSContextException(ADSContextException.ErrorType.UNEXPECTED_ADS_BACKEND_TYPE, (Throwable)cce);
            }
            if (backend == null) {
                JEBackendCfgDefn provider = JEBackendCfgDefn.getInstance();
                backend = root.createBackend(provider, backendName, null);
                backend.setBackendEnabled(true);
                backend.setBackendId(backendName);
                backend.setBackendDirectory(dbDirectory);
                backend.setBackendImportTempDirectory(importTempDirectory);
                backend.setBackendWritabilityMode(BackendCfgDefn.BackendWritabilityMode.ENABLED);
            }
            if ((suffixes = backend.getBackendBaseDN()) == null) {
                suffixes = new TreeSet<DN>();
            }
            suffixes.add(DN.decode(ADSContext.getAdministrationSuffixDN()));
            backend.setBackendBaseDN(suffixes);
            backend.commit();
        }
        catch (Throwable t) {
            throw new ADSContextException(ADSContextException.ErrorType.ERROR_UNEXPECTED, t);
        }
    }
}

